/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.stubs.ConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.KotlinConstantExpressionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantExpressionStubImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0011\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "debugName", "", "<init>", "(Ljava/lang/String;)V", "shouldCreateStub", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "createStub", "psi", "parentStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream;", "Companion"})
public final class KtConstantExpressionElementType
extends KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KtConstantExpressionElementType(@NonNls @NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(debugName, KtConstantExpression.class, KotlinConstantExpressionStub.class);
    }

    @Override
    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = node.getTreeParent();
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent2 = aSTNode;
        if (!Intrinsics.areEqual((Object)parent2.getElementType(), KtStubElementTypes.VALUE_ARGUMENT)) {
            return false;
        }
        return super.shouldCreateStub(node);
    }

    @Override
    @NotNull
    public KotlinConstantExpressionStub createStub(@NotNull KtConstantExpression psi, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        IElementType iElementType = psi.getNode().getElementType();
        KtConstantExpressionElementType ktConstantExpressionElementType = iElementType instanceof KtConstantExpressionElementType ? (KtConstantExpressionElementType)iElementType : null;
        if (ktConstantExpressionElementType == null) {
            throw new IllegalStateException("Stub element type is expected for constant");
        }
        KtConstantExpressionElementType elementType = ktConstantExpressionElementType;
        String string2 = psi.getText();
        if (string2 == null) {
            string2 = "";
        }
        String value2 = string2;
        ConstantValueKind constantValueKind = KtConstantExpressionElementType.Companion.constantElementTypeToKind(elementType);
        StringRef stringRef = StringRef.fromString(value2);
        Intrinsics.checkNotNullExpressionValue((Object)stringRef, (String)"fromString(...)");
        return new KotlinConstantExpressionStubImpl(parentStub, elementType, constantValueKind, stringRef);
    }

    @Override
    public void serialize(@NotNull KotlinConstantExpressionStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeInt(stub.kind().ordinal());
        dataStream.writeName(stub.value());
    }

    @Override
    @NotNull
    public KotlinConstantExpressionStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        int kindOrdinal = dataStream.readInt();
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            stringRef = StringRef.fromString("");
        }
        StringRef value2 = stringRef;
        ConstantValueKind valueKind = ConstantValueKind.values()[kindOrdinal];
        KtConstantExpressionElementType ktConstantExpressionElementType = Companion.kindToConstantElementType(valueKind);
        Intrinsics.checkNotNull((Object)value2);
        return new KotlinConstantExpressionStubImpl(parentStub, ktConstantExpressionElementType, valueKind, value2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType$Companion;", "", "<init>", "()V", "kindToConstantElementType", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "kind", "Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;", "constantElementTypeToKind", "elementType", "psi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KtConstantExpressionElementType kindToConstantElementType(@NotNull ConstantValueKind kind) {
            KtConstantExpressionElementType ktConstantExpressionElementType;
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    ktConstantExpressionElementType = KtStubElementTypes.NULL;
                    break;
                }
                case 2: {
                    ktConstantExpressionElementType = KtStubElementTypes.BOOLEAN_CONSTANT;
                    break;
                }
                case 3: {
                    ktConstantExpressionElementType = KtStubElementTypes.FLOAT_CONSTANT;
                    break;
                }
                case 4: {
                    ktConstantExpressionElementType = KtStubElementTypes.CHARACTER_CONSTANT;
                    break;
                }
                case 5: {
                    ktConstantExpressionElementType = KtStubElementTypes.INTEGER_CONSTANT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtConstantExpressionElementType ktConstantExpressionElementType2 = ktConstantExpressionElementType;
            Intrinsics.checkNotNull((Object)ktConstantExpressionElementType2);
            return ktConstantExpressionElementType2;
        }

        private final ConstantValueKind constantElementTypeToKind(KtConstantExpressionElementType elementType) {
            ConstantValueKind constantValueKind;
            KtConstantExpressionElementType ktConstantExpressionElementType = elementType;
            if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.NULL)) {
                constantValueKind = ConstantValueKind.NULL;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.BOOLEAN_CONSTANT)) {
                constantValueKind = ConstantValueKind.BOOLEAN_CONSTANT;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.INTEGER_CONSTANT)) {
                constantValueKind = ConstantValueKind.INTEGER_CONSTANT;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.FLOAT_CONSTANT)) {
                constantValueKind = ConstantValueKind.FLOAT_CONSTANT;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.CHARACTER_CONSTANT)) {
                constantValueKind = ConstantValueKind.CHARACTER_CONSTANT;
            } else {
                throw new IllegalStateException("Unknown constant node type: " + elementType);
            }
            return constantValueKind;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=50)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConstantValueKind.values().length];
                try {
                    nArray[ConstantValueKind.NULL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.BOOLEAN_CONSTANT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.FLOAT_CONSTANT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.CHARACTER_CONSTANT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValueKind.INTEGER_CONSTANT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

