/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.terminal.spi.SystemStream;

public interface TerminalProvider {
    public String name();

    public Terminal sysTerminal(String var1, String var2, boolean var3, Charset var4, boolean var5, Terminal.SignalHandler var6, boolean var7, SystemStream var8) throws IOException;

    public Terminal newTerminal(String var1, String var2, InputStream var3, OutputStream var4, Charset var5, Terminal.SignalHandler var6, boolean var7, Attributes var8, Size var9) throws IOException;

    public boolean isSystemStream(SystemStream var1);

    public static TerminalProvider load(String name2) throws IOException {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((is = cl.getResourceAsStream("META-INF/services/org/jline/terminal/provider/" + name2)) != null) {
            Properties props = new Properties();
            try {
                props.load(is);
                String className2 = props.getProperty("class");
                if (className2 == null) {
                    throw new IOException("No class defined in terminal provider file " + name2);
                }
                Class<?> clazz = cl.loadClass(className2);
                return (TerminalProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IOException("Unable to load terminal provider " + name2, e);
            }
        }
        throw new IOException("Unable to find terminal provider " + name2);
    }
}

