/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/MoveTemporaryVariableDeclarationToAssignment;", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "hasChanges", "", "varUsedInBlocks", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Ljava/util/HashSet;", "varAssignedInBlocks", "blockParents", "varWithoutInitDeclarations", "varBeforeAssignmentUsages", "removedVarDeclarations", "apply", "analyze", "", "removeNonParentBlocks", "block", "parents", "Ljava/util/LinkedHashSet;", "calculateLCA", "blocks", "", "perform", "js.translator"})
public final class MoveTemporaryVariableDeclarationToAssignment {
    @NotNull
    private final JsBlock body;
    private boolean hasChanges;
    @NotNull
    private final HashMap<JsName, HashSet<JsBlock>> varUsedInBlocks;
    @NotNull
    private final HashMap<JsName, HashSet<JsBlock>> varAssignedInBlocks;
    @NotNull
    private final HashMap<JsBlock, JsBlock> blockParents;
    @NotNull
    private final HashSet<JsName> varWithoutInitDeclarations;
    @NotNull
    private final HashSet<JsName> varBeforeAssignmentUsages;
    @NotNull
    private final HashSet<JsName> removedVarDeclarations;

    public MoveTemporaryVariableDeclarationToAssignment(@NotNull JsBlock body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this.body = body2;
        this.varUsedInBlocks = new HashMap();
        this.varAssignedInBlocks = new HashMap();
        this.blockParents = new HashMap();
        this.varWithoutInitDeclarations = new HashSet();
        this.varBeforeAssignmentUsages = new HashSet();
        this.removedVarDeclarations = new HashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        if (!this.removedVarDeclarations.isEmpty()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.hasChanges;
    }

    private final void analyze() {
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(this){
            private final List<JsBlock> blockStack;
            final /* synthetic */ MoveTemporaryVariableDeclarationToAssignment this$0;
            {
                this.this$0 = $receiver;
                this.blockStack = new ArrayList<E>();
            }

            private final JsBlock getCurrentBlock() {
                return (JsBlock)CollectionsKt.last(this.blockStack);
            }

            public void visitBlock(JsBlock x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (!((Collection)this.blockStack).isEmpty()) {
                    ((Map)MoveTemporaryVariableDeclarationToAssignment.access$getBlockParents$p(this.this$0)).put(x, this.getCurrentBlock());
                }
                ((Collection)this.blockStack).add(x);
                super.visitBlock(x);
                CollectionsKt.removeLast(this.blockStack);
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x.getInitExpression() == null && MetadataProperties.getSynthetic(x)) {
                    ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0)).add(x.getName());
                }
                super.visit(x);
            }

            public void visitVars(JsVars x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (MetadataProperties.getSynthetic(x)) {
                    Iterator<JsVars.JsVar> iterator2 = x.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                    Iterator<JsVars.JsVar> iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        JsVars.JsVar variable2 = iterator3.next();
                        if (variable2.getInitExpression() != null) continue;
                        ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0)).add(variable2.getName());
                    }
                }
                super.visitVars(x);
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                JsName name2 = nameRef.getName();
                if (name2 != null && MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0).contains(name2)) {
                    boolean hasAssignment;
                    block7: {
                        boolean bl;
                        Object object;
                        Object $this$getOrPut$iv = MoveTemporaryVariableDeclarationToAssignment.access$getVarUsedInBlocks$p(this.this$0);
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(name2);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            HashSet<E> answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(name2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        $this$getOrPut$iv = (Collection)object;
                        $this$getOrPut$iv.add(this.getCurrentBlock());
                        HashSet hashSet = (HashSet)MoveTemporaryVariableDeclarationToAssignment.access$getVarAssignedInBlocks$p(this.this$0).get(name2);
                        Set assignments = hashSet != null ? (Set)hashSet : SetsKt.emptySet();
                        Iterable $this$any$iv = this.blockStack;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                JsBlock it = (JsBlock)element$iv;
                                boolean bl3 = false;
                                if (!assignments.contains(it)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = hasAssignment = false;
                        }
                    }
                    if (!hasAssignment) {
                        ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getVarBeforeAssignmentUsages$p(this.this$0)).add(name2);
                    }
                }
                super.visitNameRef(nameRef);
            }

            public void visitExpressionStatement(JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    JsName name2 = (JsName)assignment.component1();
                    if (MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0).contains(name2)) {
                        Object object;
                        Map $this$getOrPut$iv = MoveTemporaryVariableDeclarationToAssignment.access$getVarAssignedInBlocks$p(this.this$0);
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(name2);
                        if (value$iv == null) {
                            boolean bl = false;
                            HashSet<E> answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(name2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        Collection collection = (Collection)object;
                        collection.add(this.getCurrentBlock());
                    }
                }
                super.visitExpressionStatement(x);
            }
        };
        visitor2.accept((JsNode)this.body);
    }

    private final void removeNonParentBlocks(JsBlock block, LinkedHashSet<JsBlock> parents2) {
        JsBlock blockParent = block;
        while (blockParent != null) {
            Iterator parentIter;
            if (!parents2.contains(blockParent)) {
                blockParent = this.blockParents.get(blockParent);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(parents2.iterator(), (String)"iterator(...)");
            while (parentIter.hasNext()) {
                if (!Intrinsics.areEqual(parentIter.next(), (Object)blockParent)) {
                    parentIter.remove();
                    continue;
                }
                return;
            }
        }
    }

    private final JsBlock calculateLCA(Set<? extends JsBlock> blocks) {
        if (!(!((Collection)blocks).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        LinkedHashSet<JsBlock> parents2 = new LinkedHashSet<JsBlock>();
        JsBlock firstBlockParent = (JsBlock)CollectionsKt.first((Iterable)blocks);
        while (firstBlockParent != null) {
            ((Collection)parents2).add(firstBlockParent);
            firstBlockParent = this.blockParents.get(firstBlockParent);
        }
        for (JsBlock block : SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)blocks), (int)1)) {
            this.removeNonParentBlocks(block, parents2);
        }
        if (!(!((Collection)parents2).isEmpty())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        return (JsBlock)CollectionsKt.first((Iterable)parents2);
    }

    private final void perform() {
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(this){
            final /* synthetic */ MoveTemporaryVariableDeclarationToAssignment this$0;
            {
                this.this$0 = $receiver;
            }

            private final boolean canRemoveDeclarationWithoutInit(JsName name2) {
                if (!MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0).contains(name2) || MoveTemporaryVariableDeclarationToAssignment.access$getVarBeforeAssignmentUsages$p(this.this$0).contains(name2)) {
                    return false;
                }
                HashSet hashSet = (HashSet)MoveTemporaryVariableDeclarationToAssignment.access$getVarAssignedInBlocks$p(this.this$0).get(name2);
                if (hashSet == null) {
                    return false;
                }
                HashSet assignedInBlocks = hashSet;
                HashSet hashSet2 = (HashSet)MoveTemporaryVariableDeclarationToAssignment.access$getVarUsedInBlocks$p(this.this$0).get(name2);
                Set usedInBlocks = hashSet2 != null ? (Set)hashSet2 : SetsKt.emptySet();
                JsBlock lcaBlock = MoveTemporaryVariableDeclarationToAssignment.access$calculateLCA(this.this$0, SetsKt.plus((Set)usedInBlocks, (Iterable)assignedInBlocks));
                return assignedInBlocks.contains(lcaBlock);
            }

            public void endVisit(JsVars.JsVar x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsName jsName = x.getName();
                Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                if (this.canRemoveDeclarationWithoutInit(jsName)) {
                    ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getRemovedVarDeclarations$p(this.this$0)).add(x.getName());
                    ctx.removeMe();
                    MoveTemporaryVariableDeclarationToAssignment.access$setHasChanges$p(this.this$0, true);
                } else {
                    super.endVisit(x, ctx);
                }
            }

            public void endVisit(JsVars x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (x.isEmpty()) {
                    ctx.removeMe();
                    MoveTemporaryVariableDeclarationToAssignment.access$setHasChanges$p(this.this$0, true);
                } else {
                    super.endVisit(x, ctx);
                }
            }

            public void endVisit(JsExpressionStatement x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    JsName name2 = (JsName)assignment.component1();
                    JsExpression initExpr = (JsExpression)assignment.component2();
                    if (MoveTemporaryVariableDeclarationToAssignment.access$getRemovedVarDeclarations$p(this.this$0).remove(name2)) {
                        JsVars jsVars;
                        JsVars.JsVar jsVar;
                        JsVars.JsVar $this$endVisit_u24lambda_u240 = jsVar = new JsVars.JsVar(name2, initExpr);
                        boolean bl = false;
                        MetadataProperties.setSynthetic($this$endVisit_u24lambda_u240, true);
                        JsVars.JsVar varDeclarationWithInit = jsVar;
                        JsVars $this$endVisit_u24lambda_u241 = jsVars = new JsVars(varDeclarationWithInit);
                        boolean bl2 = false;
                        MetadataProperties.setSynthetic($this$endVisit_u24lambda_u241, true);
                        JsVars vars = jsVars;
                        ctx.replaceMe((JsNode)vars);
                    }
                    this.accept((JsNode)initExpr);
                } else {
                    super.endVisit(x, ctx);
                }
            }
        };
        visitor2.accept((JsNode)this.body);
    }

    public static final /* synthetic */ HashMap access$getBlockParents$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.blockParents;
    }

    public static final /* synthetic */ HashSet access$getVarWithoutInitDeclarations$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varWithoutInitDeclarations;
    }

    public static final /* synthetic */ HashMap access$getVarUsedInBlocks$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varUsedInBlocks;
    }

    public static final /* synthetic */ HashMap access$getVarAssignedInBlocks$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varAssignedInBlocks;
    }

    public static final /* synthetic */ HashSet access$getVarBeforeAssignmentUsages$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varBeforeAssignmentUsages;
    }

    public static final /* synthetic */ JsBlock access$calculateLCA(MoveTemporaryVariableDeclarationToAssignment $this, Set blocks) {
        return $this.calculateLCA(blocks);
    }

    public static final /* synthetic */ HashSet access$getRemovedVarDeclarations$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.removedVarDeclarations;
    }

    public static final /* synthetic */ void access$setHasChanges$p(MoveTemporaryVariableDeclarationToAssignment $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

