/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.proxy.reflection;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KTypeProxy;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/ReflectionProxy;", "Lkotlin/reflect/KType;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;)V", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "getCallInterceptor", "()Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "classifier", "Lkotlin/reflect/KClassifier;", "getClassifier", "()Lkotlin/reflect/KClassifier;", "arguments", "", "Lkotlin/reflect/KTypeProjection;", "getArguments", "()Ljava/util/List;", "isMarkedNullable", "", "()Z", "annotations", "", "getAnnotations", "equals", "other", "", "hashCode", "", "toString", "", "ir.interpreter"})
public final class KTypeProxy
implements KType,
ReflectionProxy {
    @NotNull
    private final KTypeState state;
    @NotNull
    private final CallInterceptor callInterceptor;

    public KTypeProxy(@NotNull KTypeState state, @NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        this.state = state;
        this.callInterceptor = callInterceptor;
    }

    @Override
    @NotNull
    public KTypeState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public CallInterceptor getCallInterceptor() {
        return this.callInterceptor;
    }

    @Nullable
    public KClassifier getClassifier() {
        return this.getState().getClassifier(this.getCallInterceptor());
    }

    @NotNull
    public List<KTypeProjection> getArguments() {
        return this.getState().getArguments(this.getCallInterceptor());
    }

    public boolean isMarkedNullable() {
        return IrTypePredicatesKt.isMarkedNullable(this.getState().getIrType());
    }

    @NotNull
    public List<Annotation> getAnnotations() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KTypeProxy)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getState(), (Object)((KTypeProxy)other).getState());
    }

    @Override
    public int hashCode() {
        return this.getState().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getState().toString();
    }
}

