/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.SecondaryCtorLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "transformConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateStubsBody", "", "delegate", "factory", "generateFactoryBody", "stub", "generateInitBody", "ThisUsageReplaceTransformer", "backend.js"})
public final class SecondaryConstructorLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public SecondaryConstructorLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.context.getEs6mode()) {
            return null;
        }
        if (declaration instanceof IrConstructor && !((IrConstructor)declaration).isPrimary()) {
            IrClass irClass = IrUtilsKt.getParentAsClass(declaration);
            if (this.context.getInlineClassesUtils().isClassInlineLike(irClass)) {
                return null;
            }
            return this.transformConstructor((IrConstructor)declaration, irClass);
        }
        return null;
    }

    private final List<IrSimpleFunction> transformConstructor(IrConstructor constructor2, IrClass irClass) {
        IrSimpleFunction delegate2 = SecondaryCtorLoweringKt.access$buildConstructorDelegate(this.context, constructor2, irClass);
        IrSimpleFunction factory2 = SecondaryCtorLoweringKt.access$buildConstructorFactory(this.context, constructor2, irClass);
        this.generateStubsBody(constructor2, irClass, delegate2, factory2);
        Object[] objectArray = new IrSimpleFunction[]{delegate2, factory2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void generateStubsBody(IrConstructor constructor2, IrClass irClass, IrSimpleFunction delegate2, IrSimpleFunction factory2) {
        this.generateInitBody(constructor2, irClass, delegate2);
        this.generateFactoryBody(constructor2, irClass, factory2, delegate2);
    }

    private final void generateFactoryBody(IrConstructor constructor2, IrClass irClass, IrSimpleFunction stub, IrSimpleFunction delegate2) {
        stub.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(irClass, this, delegate2, stub, constructor2){
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ SecondaryConstructorLowering this$0;
            final /* synthetic */ IrSimpleFunction $delegate;
            final /* synthetic */ IrSimpleFunction $stub;
            final /* synthetic */ IrConstructor $constructor;
            {
                this.$irClass = $irClass;
                this.this$0 = $receiver;
                this.$delegate = $delegate;
                this.$stub = $stub;
                this.$constructor = $constructor;
                super(1);
            }

            public final void invoke(IrBlockBody $this$createBlockBody) {
                int i;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                IrSimpleType type2 = IrUtilsKt.getDefaultType(this.$irClass);
                IrSimpleFunctionSymbol createFunctionIntrinsic = this.this$0.getContext().getIntrinsics().getJsObjectCreateSymbol();
                IrCall irCreateCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, createFunctionIntrinsic, type2, CollectionsKt.listOf((Object)type2), null, null, 24, null);
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.$delegate.getSymbol(), type2, null, null, null, 28, null);
                Object object = this.$stub;
                IrElementBase irElementBase = this.$constructor;
                IrCall call2 = irCall;
                boolean bl = false;
                int n = object.getTypeParameters().size();
                for (i = 0; i < n; ++i) {
                    call2.putTypeArgument(i, SecondaryCtorLoweringKt.access$toIrType(object.getTypeParameters().get(i)));
                }
                n = ((IrFunction)object).getValueParameters().size();
                for (i = 0; i < n; ++i) {
                    call2.putValueArgument(i, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, ((IrFunction)object).getValueParameters().get(i).getSymbol(), null, 2, null));
                }
                call2.putValueArgument(((IrFunction)irElementBase).getValueParameters().size(), irCreateCall);
                IrCall irDelegateCall = irCall;
                if (IrUtilsKt.isSubclassOf(this.$irClass, (IrClass)this.this$0.getContext().getIrBuiltIns().getThrowableClass().getOwner())) {
                    IrVariable tmp = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, irDelegateCall.getType(), this.$stub, null, false, false, false, irDelegateCall, null, 188, null);
                    ((Collection)$this$createBlockBody.getStatements()).add(tmp);
                    object = $this$createBlockBody.getStatements();
                    irElementBase = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getCaptureStack(), null, null, null, null, 30, null);
                    SecondaryConstructorLowering secondaryConstructorLowering = this.this$0;
                    IrSimpleFunction irSimpleFunction = this.$stub;
                    IrElementBase call3 = irElementBase;
                    boolean bl2 = false;
                    ((IrMemberAccessExpression)call3).putValueArgument(0, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, tmp.getSymbol(), null, 2, null));
                    ((IrMemberAccessExpression)call3).putValueArgument(1, new IrRawFunctionReferenceImpl(-1, -1, secondaryConstructorLowering.getContext().getIrBuiltIns().getAnyType(), irSimpleFunction.getSymbol()));
                    object.add(irElementBase);
                    ((Collection)$this$createBlockBody.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn(this.$stub.getSymbol(), JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, tmp.getSymbol(), null, 2, null), this.this$0.getContext().getIrBuiltIns().getNothingType()));
                } else {
                    IrReturnImpl irReturn = JsIrBuilder.INSTANCE.buildReturn(this.$stub.getSymbol(), irDelegateCall, this.this$0.getContext().getIrBuiltIns().getNothingType());
                    ((Collection)$this$createBlockBody.getStatements()).add(irReturn);
                }
            }
        })));
    }

    private final void generateInitBody(IrConstructor constructor2, IrClass irClass, IrSimpleFunction delegate2) {
        IrValueParameter thisParam = (IrValueParameter)CollectionsKt.last(delegate2.getValueParameters());
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameter oldThisReceiver = irValueParameter;
        IrBody constructorBody = constructor2.getBody();
        List oldValueParameters = CollectionsKt.plus((Collection)constructor2.getValueParameters(), (Object)oldThisReceiver);
        if (constructorBody != null) {
            delegate2.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(constructorBody, delegate2, thisParam, this, constructor2, (List<? extends IrValueParameter>)oldValueParameters){
                final /* synthetic */ IrBody $constructorBody;
                final /* synthetic */ IrSimpleFunction $delegate;
                final /* synthetic */ IrValueParameter $thisParam;
                final /* synthetic */ SecondaryConstructorLowering this$0;
                final /* synthetic */ IrConstructor $constructor;
                final /* synthetic */ List<IrValueParameter> $oldValueParameters;
                {
                    this.$constructorBody = $constructorBody;
                    this.$delegate = $delegate;
                    this.$thisParam = $thisParam;
                    this.this$0 = $receiver;
                    this.$constructor = $constructor;
                    this.$oldValueParameters = $oldValueParameters;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(IrBlockBody $this$createBlockBody) {
                    Map map;
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    void p1;
                    DeepCopyTypeRemapper typeRemapper$iv$iv;
                    void $this$deepCopyWithSymbols$iv$iv;
                    void $this$deepCopyWithSymbols_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                    Iterable<E> iterable = $this$createBlockBody.getStatements();
                    IrElement irElement = this.$constructorBody;
                    IrDeclarationParent initialParent$iv = this.$delegate;
                    boolean $i$f$deepCopyWithSymbols = false;
                    Iterator<T> iterator2 = $this$deepCopyWithSymbols_u24default$iv;
                    DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    boolean $i$f$deepCopyWithSymbols2 = false;
                    IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                    TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    IrElement irElement2 = $this$deepCopyWithSymbols$iv$iv;
                    boolean bl = false;
                    typeRemapper = typeRemapper;
                    SymbolRemapper p0 = deepCopySymbolRemapper;
                    IrElement irElement3 = PatchDeclarationParentsKt.patchDeclarationParents(irElement2.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
                    if (irElement3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBody");
                    }
                    IrElement irElement4 = (IrBody)irElement3;
                    Intrinsics.checkNotNull((Object)irElement4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrStatementContainer");
                    CollectionsKt.addAll((Collection)iterable, (Iterable)((IrStatementContainer)irElement4).getStatements());
                    ((Collection)$this$createBlockBody.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn(this.$delegate.getSymbol(), JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, this.$thisParam.getSymbol(), null, 2, null), this.this$0.getContext().getIrBuiltIns().getNothingType()));
                    iterable = CollectionsKt.zip((Iterable)this.$oldValueParameters, (Iterable)this.$delegate.getValueParameters());
                    IrFunctionSymbol irFunctionSymbol = this.$delegate.getSymbol();
                    IrConstructorSymbol irConstructorSymbol = this.$constructor.getSymbol();
                    irElement2 = $this$createBlockBody;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    initialParent$iv = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv;
                        Pair pair = (Pair)element$iv$iv;
                        boolean bl2 = false;
                        IrValueParameter old = (IrValueParameter)pair.component1();
                        IrValueParameter irValueParameter = (IrValueParameter)pair.component2();
                        pair = TuplesKt.to((Object)old.getSymbol(), (Object)irValueParameter.getSymbol());
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    Map map3 = map = destination$iv$iv;
                    IrFunctionSymbol irFunctionSymbol2 = irFunctionSymbol;
                    IrConstructorSymbol irConstructorSymbol2 = irConstructorSymbol;
                    IrElementTransformerVoidKt.transformChildrenVoid(irElement2, new ThisUsageReplaceTransformer(irConstructorSymbol2, irFunctionSymbol2, map3));
                }
            })));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering$ThisUsageReplaceTransformer;", "Lorg/jetbrains/kotlin/backend/common/ir/ValueRemapper;", "constructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "symbolMapping", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Ljava/util/Map;)V", "getConstructor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "newThisSymbol", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "backend.js"})
    private static final class ThisUsageReplaceTransformer
    extends ValueRemapper {
        @NotNull
        private final IrConstructorSymbol constructor;
        @NotNull
        private final IrFunctionSymbol function;
        @NotNull
        private final IrValueSymbol newThisSymbol;

        public ThisUsageReplaceTransformer(@NotNull IrConstructorSymbol constructor2, @NotNull IrFunctionSymbol function2, @NotNull Map<IrValueSymbol, ? extends IrValueSymbol> symbolMapping) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter(symbolMapping, (String)"symbolMapping");
            super(symbolMapping);
            this.constructor = constructor2;
            this.function = function2;
            this.newThisSymbol = (IrValueSymbol)CollectionsKt.last((Iterable)symbolMapping.values());
        }

        @NotNull
        public final IrConstructorSymbol getConstructor() {
            return this.constructor;
        }

        @NotNull
        public final IrFunctionSymbol getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            return !Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.constructor) ? expression2 : (IrReturn)new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.function, new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.newThisSymbol.getOwner().getType(), this.newThisSymbol, null, 16, null));
        }
    }
}

