/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.AbstractValueUsageLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.AutoboxingTransformerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0014\u0010\u0011\u001a\u00020\f*\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0014J\u0014\u0010\u0013\u001a\u00020\f*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001c\u0010\u0016\u001a\u00020\f*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J4\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u001eH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/AutoboxingTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/AbstractValueUsageLowering;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "replaceTypesInsideInlinedFunctionBlock", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;Z)V", "processingReturnStack", "", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "useReturnableExpressionAsType", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expectedType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitReturn", "expression", "useAsResult", "enclosing", "useAsReturnValue", "returnTarget", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnTargetSymbol;", "useExpressionAsType", "actualType", "buildSafeCall", "arg", "resultType", "call", "Lkotlin/Function1;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nAutoboxingTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoboxingTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/AutoboxingTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class AutoboxingTransformer
extends AbstractValueUsageLowering {
    @NotNull
    private List<IrReturn> processingReturnStack;

    public AutoboxingTransformer(@NotNull JsCommonBackendContext context2, boolean replaceTypesInsideInlinedFunctionBlock) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, replaceTypesInsideInlinedFunctionBlock);
        this.processingReturnStack = new ArrayList();
    }

    public /* synthetic */ AutoboxingTransformer(JsCommonBackendContext jsCommonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(jsCommonBackendContext, bl);
    }

    private final IrExpression useReturnableExpressionAsType(IrExpression $this$useReturnableExpressionAsType, IrType expectedType) {
        IrType expressionType2 = this.getActualType($this$useReturnableExpressionAsType);
        if (IrTypePredicatesKt.isUnit(expressionType2) && IrTypePredicatesKt.isUnit(expectedType)) {
            return $this$useReturnableExpressionAsType;
        }
        return this.useExpressionAsType($this$useReturnableExpressionAsType, expressionType2, expectedType);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        UtilsKt.push(this.processingReturnStack, expression2);
        IrExpression res2 = super.visitReturn(expression2);
        UtilsKt.pop(this.processingReturnStack);
        return res2;
    }

    @Override
    @NotNull
    protected IrExpression useAsResult(@NotNull IrExpression $this$useAsResult, @NotNull IrExpression enclosing) {
        Intrinsics.checkNotNullParameter((Object)$this$useAsResult, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enclosing, (String)"enclosing");
        IrReturn irReturn = (IrReturn)CollectionsKt.lastOrNull(this.processingReturnStack);
        if (Intrinsics.areEqual((Object)(irReturn != null ? irReturn.getValue() : null), (Object)enclosing) && enclosing instanceof IrReturnableBlock) {
            return this.useReturnableExpressionAsType($this$useAsResult, enclosing.getType());
        }
        return this.useAs($this$useAsResult, enclosing.getType());
    }

    @Override
    @NotNull
    protected IrExpression useAsReturnValue(@NotNull IrExpression $this$useAsReturnValue, @NotNull IrReturnTargetSymbol returnTarget) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$useAsReturnValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)returnTarget, (String)"returnTarget");
        IrReturnTargetSymbol irReturnTargetSymbol = returnTarget;
        if (irReturnTargetSymbol instanceof IrSimpleFunctionSymbol) {
            irExpression = this.useReturnableExpressionAsType($this$useAsReturnValue, ((IrSimpleFunction)((IrSimpleFunctionSymbol)returnTarget).getOwner()).getReturnType());
        } else if (irReturnTargetSymbol instanceof IrConstructorSymbol) {
            irExpression = this.useReturnableExpressionAsType($this$useAsReturnValue, this.getIrBuiltIns().getUnitType());
        } else if (irReturnTargetSymbol instanceof IrReturnableBlockSymbol) {
            irExpression = this.useReturnableExpressionAsType($this$useAsReturnValue, ((IrReturnableBlock)((IrReturnableBlockSymbol)returnTarget).getOwner()).getType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression useExpressionAsType(@NotNull IrExpression $this$useExpressionAsType, @NotNull IrType actualType, @NotNull IrType expectedType) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$useExpressionAsType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        if (IrTypePredicatesKt.isNothing(IrTypesKt.makeNotNull(actualType))) {
            return $this$useExpressionAsType;
        }
        if (IrTypePredicatesKt.isUnit(actualType) && (!IrTypePredicatesKt.isUnit(expectedType) || $this$useExpressionAsType instanceof IrCall) && !AutoboxingTransformerKt.access$isGetUnit($this$useExpressionAsType, this.getIrBuiltIns())) {
            IrGetObjectValueImpl unitValue = JsIrBuilder.INSTANCE.buildGetObjectValue(actualType, this.getContext().getIrBuiltIns().getUnitClass());
            Object[] objectArray = new IrExpression[]{$this$useExpressionAsType, unitValue};
            return JsIrBuilder.INSTANCE.buildComposite(actualType, CollectionsKt.listOf((Object[])objectArray));
        }
        if (IrTypePredicatesKt.isUnit(expectedType)) {
            return $this$useExpressionAsType;
        }
        IrClass actualInlinedClass = this.getIcUtils().getInlinedClass(actualType);
        IrClass expectedInlinedClass = this.getIcUtils().getInlinedClass(expectedType);
        if (actualType instanceof IrDynamicType && IrTypePredicatesKt.isChar(IrTypesKt.makeNotNull(expectedType)) || IrTypePredicatesKt.isChar(IrTypesKt.makeNotNull(actualType)) && expectedType instanceof IrDynamicType) {
            return $this$useExpressionAsType;
        }
        if (actualInlinedClass == null && expectedInlinedClass == null) {
            return $this$useExpressionAsType;
        }
        if (actualInlinedClass != null && expectedInlinedClass == null) {
            irSimpleFunctionSymbol = this.getIcUtils().getBoxIntrinsic();
        } else if (actualInlinedClass == null && expectedInlinedClass != null) {
            irSimpleFunctionSymbol = this.getIcUtils().getUnboxIntrinsic();
        } else {
            return $this$useExpressionAsType;
        }
        IrSimpleFunctionSymbol function2 = irSimpleFunctionSymbol;
        return this.buildSafeCall($this$useExpressionAsType, actualType, expectedType, (Function1<? super IrExpression, ? extends IrExpression>)((Function1)new Function1<IrExpression, IrExpression>(function2, expectedType, actualType){
            final /* synthetic */ IrSimpleFunctionSymbol $function;
            final /* synthetic */ IrType $expectedType;
            final /* synthetic */ IrType $actualType;
            {
                this.$function = $function;
                this.$expectedType = $expectedType;
                this.$actualType = $actualType;
                super(1);
            }

            public final IrExpression invoke(IrExpression arg) {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                Object object = new IrType[]{this.$actualType, this.$expectedType};
                Object it = object = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.$function, this.$expectedType, CollectionsKt.listOf((Object[])object), null, null, 24, null);
                boolean bl = false;
                ((IrMemberAccessExpression)it).putValueArgument(0, arg);
                return (IrExpression)object;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildSafeCall(IrExpression arg, IrType actualType, IrType resultType2, Function1<? super IrExpression, ? extends IrExpression> call2) {
        void $this$buildSafeCall_u24lambda_u241_u24lambda_u240;
        Object[] objectArray;
        if (!IrTypeUtilsKt.isNullable(actualType) || !IrTypeUtilsKt.isNullable(resultType2)) {
            return (IrExpression)call2.invoke((Object)arg);
        }
        JsIrBuilder $this$buildSafeCall_u24lambda_u241 = JsIrBuilder.INSTANCE;
        boolean bl = false;
        IrVariable tmp = JsIrBuilder.buildVar$default($this$buildSafeCall_u24lambda_u241, actualType, null, null, false, false, false, arg, null, 188, null);
        Object[] objectArray2 = objectArray = JsIrBuilder.buildCall$default($this$buildSafeCall_u24lambda_u241, this.getIrBuiltIns().getEqeqSymbol(), null, null, null, null, 30, null);
        IrType irType = resultType2;
        JsIrBuilder jsIrBuilder = $this$buildSafeCall_u24lambda_u241;
        boolean bl2 = false;
        $this$buildSafeCall_u24lambda_u241_u24lambda_u240.putValueArgument(0, JsIrBuilder.buildGetValue$default($this$buildSafeCall_u24lambda_u241, tmp.getSymbol(), null, 2, null));
        $this$buildSafeCall_u24lambda_u241_u24lambda_u240.putValueArgument(1, $this$buildSafeCall_u24lambda_u241.buildNull(this.getIrBuiltIns().getNothingNType()));
        Unit unit2 = Unit.INSTANCE;
        IrWhen nullCheck = JsIrBuilder.buildIfElse$default(jsIrBuilder, irType, (IrExpression)objectArray, $this$buildSafeCall_u24lambda_u241.buildNull(this.getIrBuiltIns().getNothingNType()), (IrExpression)call2.invoke((Object)JsIrBuilder.buildGetValue$default($this$buildSafeCall_u24lambda_u241, tmp.getSymbol(), null, 2, null)), 0, 0, 0, 0, 240, null);
        objectArray = new IrElement[]{tmp, nullCheck};
        return $this$buildSafeCall_u24lambda_u241.buildBlock(resultType2, CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getSYNTHETIC_NOT_AUTOBOXED_CHECK())) {
            IrCall irCall;
            IrCall $this$visitCall_u24lambda_u242 = irCall = expression2;
            boolean bl = false;
            this.transformChildrenVoid($this$visitCall_u24lambda_u242);
            irExpression = irCall;
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }
}

