/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.StageController;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/WholeWorldStageController;", "Lorg/jetbrains/kotlin/ir/declarations/StageController;", "<init>", "()V", "currentStage", "", "getCurrentStage", "()I", "setCurrentStage", "(I)V", "currentDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getCurrentDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "setCurrentDeclaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "index", "restrictTo", "T", "declaration", "fn", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withInitialIr", "block", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "parentSignature", "backend.js"})
public final class WholeWorldStageController
extends StageController {
    private int currentStage;
    @Nullable
    private IrDeclaration currentDeclaration;
    private int index;

    public WholeWorldStageController() {
        super(0, 1, null);
    }

    @Override
    public int getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(int n) {
        this.currentStage = n;
    }

    @Override
    @Nullable
    public IrDeclaration getCurrentDeclaration() {
        return this.currentDeclaration;
    }

    public void setCurrentDeclaration(@Nullable IrDeclaration irDeclaration2) {
        this.currentDeclaration = irDeclaration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T restrictTo(@NotNull IrDeclaration declaration, @NotNull Function0<? extends T> fn) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        IrDeclaration previousCurrentDeclaration = this.getCurrentDeclaration();
        int previousIndex = this.index;
        this.setCurrentDeclaration(declaration);
        this.index = 0;
        try {
            object = fn.invoke();
        }
        finally {
            this.setCurrentDeclaration(previousCurrentDeclaration);
            this.index = previousIndex;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withInitialIr(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int oldStage = this.getCurrentStage();
        this.setCurrentStage(0);
        IrDeclaration oldCurrentDeclaration = this.getCurrentDeclaration();
        this.setCurrentDeclaration(null);
        try {
            object = block.invoke();
        }
        finally {
            this.setCurrentStage(oldStage);
            this.setCurrentDeclaration(oldCurrentDeclaration);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public IdSignature createSignature(@NotNull IdSignature parentSignature) {
        Intrinsics.checkNotNullParameter((Object)parentSignature, (String)"parentSignature");
        int n = this.index;
        this.index = n + 1;
        return new IdSignature.LoweredDeclarationSignature(parentSignature, this.getCurrentStage(), n);
    }
}

