/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirErrorFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirErrorPropertyBuilder;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallKind;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.NoCompanionObject;
import org.jetbrains.kotlin.fir.resolve.calls.PropertyAsOperator;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.Unsupported;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerConstantOperatorScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirErrorFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirErrorPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\\\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u0018\u0010\u001c\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0010*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010 \u001a\u00020\u001a*\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0016\u0010\"\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateFactory;", "", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "baseSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;)V", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "createCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "givenExtensionReceiverOptions", "", "objectsByName", "", "isFromOriginalTypeInPresenceOfSmartCast", "isRegularClassWithoutCompanion", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "unwrapIntegerOperatorSymbolIfNeeded", "isCandidateFromCompanionObjectTypeScope", "useSiteSession", "createErrorCandidate", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "createErrorFunctionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirErrorFunctionSymbol;", "createErrorPropertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirErrorPropertySymbol;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nCandidateFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CandidateFactory.kt\norg/jetbrains/kotlin/fir/resolve/calls/CandidateFactory\n+ 2 FirErrorFunctionBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirErrorFunctionBuilderKt\n+ 3 FirErrorPropertyBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirErrorPropertyBuilderKt\n*L\n1#1,245:1\n68#2:246\n71#3:247\n*S KotlinDebug\n*F\n+ 1 CandidateFactory.kt\norg/jetbrains/kotlin/fir/resolve/calls/CandidateFactory\n*L\n174#1:246\n186#1:247\n*E\n"})
public final class CandidateFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolutionContext context;
    @NotNull
    private final ConstraintStorage baseSystem;

    private CandidateFactory(ResolutionContext context2, ConstraintStorage baseSystem) {
        this.context = context2;
        this.baseSystem = baseSystem;
    }

    @NotNull
    public final ResolutionContext getContext() {
        return this.context;
    }

    public CandidateFactory(@NotNull ResolutionContext context2, @NotNull CallInfo callInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        this(context2, CandidateFactory.Companion.buildBaseSystem(context2, callInfo));
    }

    @NotNull
    public final Candidate createCandidate(@NotNull CallInfo callInfo, @NotNull FirBasedSymbol<?> symbol2, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable FirScope scope2, @Nullable FirExpression dispatchReceiver, @NotNull List<? extends FirExpression> givenExtensionReceiverOptions, boolean objectsByName, boolean isFromOriginalTypeInPresenceOfSmartCast) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)((Object)explicitReceiverKind), (String)"explicitReceiverKind");
        Intrinsics.checkNotNullParameter(givenExtensionReceiverOptions, (String)"givenExtensionReceiverOptions");
        FirBasedSymbol<?> symbol3 = this.unwrapIntegerOperatorSymbolIfNeeded(symbol2, callInfo);
        InferenceComponents.ConstraintSystemFactory constraintSystemFactory = this.context.getInferenceComponents().getConstraintSystemFactory();
        switch (WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()]) {
            case 1: {
                bl = this.isCandidateFromCompanionObjectTypeScope((FirExpression)CollectionsKt.singleOrNull(givenExtensionReceiverOptions), callInfo.getSession());
                break;
            }
            case 2: {
                bl = this.isCandidateFromCompanionObjectTypeScope(dispatchReceiver, callInfo.getSession());
                break;
            }
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Candidate result2 = new Candidate(symbol3, dispatchReceiver, givenExtensionReceiverOptions, explicitReceiverKind, constraintSystemFactory, this.baseSystem, callInfo, scope2, bl, isFromOriginalTypeInPresenceOfSmartCast, this.context.getBodyResolveContext().getInferenceSession());
        FirElement callSite = callInfo.getCallSite();
        if (callSite instanceof FirCallableReferenceAccess) {
            if (symbol3 instanceof FirValueParameterSymbol || symbol3 instanceof FirPropertySymbol && ((FirPropertySymbol)symbol3).isLocal() || symbol3 instanceof FirBackingFieldSymbol) {
                result2.addDiagnostic(new Unsupported("References to variables aren't supported yet", ((FirCallableReferenceAccess)callSite).getCalleeReference().getSource()));
            } else if (symbol3 instanceof FirEnumEntrySymbol) {
                result2.addDiagnostic(new Unsupported("References to enum entries aren't supported", ((FirCallableReferenceAccess)callSite).getCalleeReference().getSource()));
            }
        } else if (objectsByName && this.isRegularClassWithoutCompanion(symbol3, callInfo.getSession())) {
            result2.addDiagnostic(NoCompanionObject.INSTANCE);
        }
        if (callInfo.getOrigin() == FirFunctionCallOrigin.Operator) {
            FirPropertySymbol propertySymbol;
            FirBasedSymbol<?> firBasedSymbol;
            FirPropertySymbol firPropertySymbol = symbol3 instanceof FirPropertySymbol ? (FirPropertySymbol)symbol3 : (callInfo.getCandidateForCommonInvokeReceiver() != null ? ((firBasedSymbol = callInfo.getCandidateForCommonInvokeReceiver().getSymbol()) instanceof FirPropertySymbol ? (FirPropertySymbol)firBasedSymbol : null) : (propertySymbol = null));
            if (propertySymbol != null) {
                result2.addDiagnostic(new PropertyAsOperator(propertySymbol));
            }
        }
        if (symbol3 instanceof FirPropertySymbol && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.context.getSession()).supportsFeature(LanguageFeature.PrioritizedEnumEntries)) {
            FirRegularClass containingClass;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)symbol3);
            FirRegularClass firRegularClass = containingClass = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClass(coneClassLikeLookupTag, this.context.getSession()) : null;
            if (containingClass != null && UtilsKt.isEnumEntries((FirVariable)((FirPropertySymbol)symbol3).getFir(), containingClass)) {
                result2.addDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
            }
        }
        return result2;
    }

    public static /* synthetic */ Candidate createCandidate$default(CandidateFactory candidateFactory, CallInfo callInfo, FirBasedSymbol firBasedSymbol, ExplicitReceiverKind explicitReceiverKind, FirScope firScope, FirExpression firExpression2, List list2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            firExpression2 = null;
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        return candidateFactory.createCandidate(callInfo, firBasedSymbol, explicitReceiverKind, firScope, firExpression2, list2, bl, bl2);
    }

    private final boolean isRegularClassWithoutCompanion(FirBasedSymbol<?> $this$isRegularClassWithoutCompanion, FirSession session2) {
        FirClassLikeSymbol firClassLikeSymbol = $this$isRegularClassWithoutCompanion instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)$this$isRegularClassWithoutCompanion : null;
        if (firClassLikeSymbol == null || (firClassLikeSymbol = DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, session2)) == null) {
            return false;
        }
        FirClassLikeSymbol referencedClass = firClassLikeSymbol;
        return ((FirClassSymbol)referencedClass).getClassKind() != ClassKind.OBJECT && ((FirRegularClassSymbol)referencedClass).getCompanionObjectSymbol() == null;
    }

    private final FirBasedSymbol<?> unwrapIntegerOperatorSymbolIfNeeded(FirBasedSymbol<?> $this$unwrapIntegerOperatorSymbolIfNeeded, CallInfo callInfo) {
        if (!($this$unwrapIntegerOperatorSymbolIfNeeded instanceof FirNamedFunctionSymbol)) {
            return $this$unwrapIntegerOperatorSymbolIfNeeded;
        }
        if (((FirSimpleFunction)((FirNamedFunctionSymbol)$this$unwrapIntegerOperatorSymbolIfNeeded).getFir()).getValueParameters().isEmpty()) {
            return $this$unwrapIntegerOperatorSymbolIfNeeded;
        }
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirIntegerConstantOperatorScopeKt.getOriginalForWrappedIntegerOperator((FirSimpleFunction)((FirNamedFunctionSymbol)$this$unwrapIntegerOperatorSymbolIfNeeded).getFir());
        if (firNamedFunctionSymbol == null) {
            return $this$unwrapIntegerOperatorSymbolIfNeeded;
        }
        FirNamedFunctionSymbol original = firNamedFunctionSymbol;
        FirExpression firExpression2 = (FirExpression)CollectionsKt.firstOrNull(callInfo.getArguments());
        return (firExpression2 != null ? ResolveUtilsKt.isIntegerLiteralOrOperatorCall(firExpression2) : false) ? (FirNamedFunctionSymbol)$this$unwrapIntegerOperatorSymbolIfNeeded : original;
    }

    private final boolean isCandidateFromCompanionObjectTypeScope(FirExpression $this$isCandidateFromCompanionObjectTypeScope, FirSession useSiteSession) {
        FirClassLikeSymbol companion;
        FirResolvedQualifier firResolvedQualifier = $this$isCandidateFromCompanionObjectTypeScope instanceof FirResolvedQualifier ? (FirResolvedQualifier)$this$isCandidateFromCompanionObjectTypeScope : null;
        if (firResolvedQualifier == null) {
            return false;
        }
        FirResolvedQualifier resolvedQualifier = firResolvedQualifier;
        ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$isCandidateFromCompanionObjectTypeScope));
        if (classId == null) {
            return false;
        }
        ClassId originClassOfCandidate = classId;
        Object object = resolvedQualifier.getSymbol();
        FirClassLikeSymbol firClassLikeSymbol = companion = object != null && (object = DeclarationUtilsKt.fullyExpandedClass(object, useSiteSession)) != null && (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) != null ? ((FirRegularClass)object).getCompanionObjectSymbol() : null;
        return Intrinsics.areEqual((Object)(firClassLikeSymbol != null ? firClassLikeSymbol.getClassId() : null), (Object)originClassOfCandidate);
    }

    @NotNull
    public final Candidate createErrorCandidate(@NotNull CallInfo callInfo, @NotNull ConeDiagnostic diagnostic) {
        FirCallableSymbol firCallableSymbol;
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        CallKind callKind = callInfo.getCallKind();
        if (callKind instanceof CallKind.VariableAccess) {
            firCallableSymbol = this.createErrorPropertySymbol(diagnostic);
        } else if (callKind instanceof CallKind.Function || callKind instanceof CallKind.DelegatingConstructorCall || callKind instanceof CallKind.CallableReference) {
            firCallableSymbol = this.createErrorFunctionSymbol(diagnostic);
        } else {
            if (callKind instanceof CallKind.SyntheticSelect) {
                throw new IllegalStateException();
            }
            if (callKind instanceof CallKind.SyntheticIdForCallableReferencesResolution) {
                throw new IllegalStateException();
            }
            if (callKind instanceof CallKind.CustomForIde) {
                throw new IllegalStateException();
            }
            throw new NoWhenBranchMatchedException();
        }
        FirBasedSymbol symbol2 = firCallableSymbol;
        return new Candidate(symbol2, null, CollectionsKt.emptyList(), ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, this.context.getInferenceComponents().getConstraintSystemFactory(), this.baseSystem, callInfo, null, false, false, this.context.getBodyResolveContext().getInferenceSession(), 768, null);
    }

    private final FirErrorFunctionSymbol createErrorFunctionSymbol(ConeDiagnostic diagnostic) {
        FirErrorFunctionBuilder firErrorFunctionBuilder;
        FirErrorFunctionSymbol firErrorFunctionSymbol;
        FirErrorFunctionSymbol it = firErrorFunctionSymbol = new FirErrorFunctionSymbol();
        boolean bl = false;
        boolean $i$f$buildErrorFunction = false;
        FirErrorFunctionBuilder $this$createErrorFunctionSymbol_u24lambda_u241_u24lambda_u240 = firErrorFunctionBuilder = new FirErrorFunctionBuilder();
        boolean bl2 = false;
        $this$createErrorFunctionSymbol_u24lambda_u241_u24lambda_u240.setModuleData(FirModuleDataKt.getModuleData(this.context.getSession()));
        $this$createErrorFunctionSymbol_u24lambda_u241_u24lambda_u240.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        $this$createErrorFunctionSymbol_u24lambda_u241_u24lambda_u240.setOrigin(FirDeclarationOrigin.Synthetic.Error.INSTANCE);
        $this$createErrorFunctionSymbol_u24lambda_u241_u24lambda_u240.setDiagnostic(diagnostic);
        $this$createErrorFunctionSymbol_u24lambda_u241_u24lambda_u240.setSymbol(it);
        firErrorFunctionBuilder.build();
        return firErrorFunctionSymbol;
    }

    private final FirErrorPropertySymbol createErrorPropertySymbol(ConeDiagnostic diagnostic) {
        FirErrorPropertyBuilder firErrorPropertyBuilder;
        FirErrorPropertySymbol firErrorPropertySymbol;
        FirErrorPropertySymbol it = firErrorPropertySymbol = new FirErrorPropertySymbol(diagnostic);
        boolean bl = false;
        boolean $i$f$buildErrorProperty = false;
        FirErrorPropertyBuilder $this$createErrorPropertySymbol_u24lambda_u243_u24lambda_u242 = firErrorPropertyBuilder = new FirErrorPropertyBuilder();
        boolean bl2 = false;
        $this$createErrorPropertySymbol_u24lambda_u243_u24lambda_u242.setModuleData(FirModuleDataKt.getModuleData(this.context.getSession()));
        $this$createErrorPropertySymbol_u24lambda_u243_u24lambda_u242.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        $this$createErrorPropertySymbol_u24lambda_u243_u24lambda_u242.setOrigin(FirDeclarationOrigin.Synthetic.Error.INSTANCE);
        $this$createErrorPropertySymbol_u24lambda_u243_u24lambda_u242.setName(FirErrorPropertySymbol.Companion.getNAME());
        $this$createErrorPropertySymbol_u24lambda_u243_u24lambda_u242.setDiagnostic(diagnostic);
        $this$createErrorPropertySymbol_u24lambda_u243_u24lambda_u242.setSymbol(it);
        firErrorPropertyBuilder.build();
        return firErrorPropertySymbol;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateFactory$Companion;", "", "<init>", "()V", "buildBaseSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nCandidateFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CandidateFactory.kt\norg/jetbrains/kotlin/fir/resolve/calls/CandidateFactory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1853#2,2:246\n*S KotlinDebug\n*F\n+ 1 CandidateFactory.kt\norg/jetbrains/kotlin/fir/resolve/calls/CandidateFactory$Companion\n*L\n38#1:246,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ConstraintStorage buildBaseSystem(ResolutionContext context2, CallInfo callInfo) {
            NewConstraintSystemImpl system2 = context2.getInferenceComponents().createConstraintSystem();
            Iterable $this$forEach$iv = callInfo.getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                CandidateFactoryKt.addSubsystemFromExpression(system2, it);
            }
            return system2.asReadOnlyStorage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

