/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirMissingDependencyClassProxy;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithSingleCandidate;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00012\u00020\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1853#2,2:109\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n*L\n41#1:109,2\n*E\n"})
public final class FirMissingDependencyClassChecker
extends FirExpressionChecker<FirQualifiedAccessExpression>
implements FirMissingDependencyClassProxy {
    @NotNull
    public static final FirMissingDependencyClassChecker INSTANCE = new FirMissingDependencyClassChecker();

    private FirMissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference) && !(((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic() instanceof ConeDiagnosticWithSingleCandidate)) {
            return;
        }
        Set missingTypes = new LinkedHashSet();
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        this.considerType(FirTypeUtilsKt.getConeType(symbol2.getResolvedReturnTypeRef()), missingTypes, context2);
        Object object2 = symbol2.getResolvedReceiverTypeRef();
        if (object2 != null && (object2 = FirTypeUtilsKt.getConeType((FirTypeRef)object2)) != null) {
            Object it = object2;
            boolean bl = false;
            INSTANCE.considerType((ConeKotlinType)it, missingTypes, context2);
        }
        if ((object = symbol2 instanceof FirFunctionSymbol ? (FirFunctionSymbol)symbol2 : null) != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl = false;
                INSTANCE.considerType(FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()), missingTypes, context2);
            }
        }
        this.reportMissingTypes(expression2.getSource(), missingTypes, context2, reporter, false);
    }
}

