/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00192\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0014J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "<init>", "()V", "isWholeReflectionApiAvailable", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "report", "", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isAllowedKClassMember", "name", "Lorg/jetbrains/kotlin/name/Name;", "check", "expression", "isAllowedReflectionApi", "containingClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isReflectionSource", "Companion", "checkers"})
@SourceDebugExtension(value={"SMAP\nAbstractFirReflectionApiCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFirReflectionApiCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1618#2,3:92\n1618#2,3:95\n1618#2,3:98\n*S KotlinDebug\n*F\n+ 1 AbstractFirReflectionApiCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker\n*L\n80#1:92,3\n83#1:95,3\n86#1:98,3\n*E\n"})
public abstract class AbstractFirReflectionApiCallChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final ClassId K_CLASS;
    @NotNull
    private static final Name K_CLASS_SIMPLE_NAME;
    @NotNull
    private static final Name K_CLASS_IS_INSTANCE;
    @NotNull
    private static final Name K_CLASS_QUALIFIED_NAME;
    @NotNull
    private static final Set<ClassId> K_PROPERTY_CLASSES;
    @NotNull
    private static final Set<Name> ALLOWED_MEMBER_NAMES;
    @NotNull
    private static final Set<ClassId> ALLOWED_CLASSES;

    protected abstract boolean isWholeReflectionApiAvailable(@NotNull CheckerContext var1);

    protected abstract void report(@Nullable KtSourceElement var1, @NotNull CheckerContext var2, @NotNull DiagnosticReporter var3);

    protected boolean isAllowedKClassMember(@NotNull Name name2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Name name3 = name2;
        return Intrinsics.areEqual((Object)name3, (Object)K_CLASS_SIMPLE_NAME) || Intrinsics.areEqual((Object)name3, (Object)K_CLASS_IS_INSTANCE) ? true : (Intrinsics.areEqual((Object)name3, (Object)K_CLASS_QUALIFIED_NAME) ? context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass()) : false);
    }

    @Override
    public final void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ClassId containingClassId;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (this.isWholeReflectionApiAvailable(context2)) {
            return;
        }
        if (this.isReflectionSource(context2)) {
            return;
        }
        FirReference firReference = FirExpressionUtilKt.getCalleeReference(expression2);
        if (firReference == null || (firReference = FirReferenceUtilsKt.getResolved(firReference)) == null) {
            return;
        }
        FirReference resolvedReference = firReference;
        FirBasedSymbol<?> firBasedSymbol = ((FirResolvedNamedReference)resolvedReference).getResolvedSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol referencedSymbol = firCallableSymbol;
        Object object = expression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)expression2 : null;
        ClassId classId = object != null && (object = ((FirQualifiedAccessExpression)object).getDispatchReceiver()) != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? FirHelpersKt.fullyExpandedClassId((ConeKotlinType)object, context2.getSession()) : (containingClassId = null);
        if (containingClassId == null || !Intrinsics.areEqual((Object)containingClassId.getPackageFqName(), (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME)) {
            return;
        }
        if (!this.isAllowedReflectionApi(referencedSymbol.getName(), containingClassId, context2)) {
            KtSourceElement ktSourceElement = ((FirResolvedNamedReference)resolvedReference).getSource();
            if (ktSourceElement == null) {
                ktSourceElement = ((FirQualifiedAccessExpression)expression2).getSource();
            }
            this.report(ktSourceElement, context2, reporter);
        }
    }

    protected boolean isAllowedReflectionApi(@NotNull Name name2, @NotNull ClassId containingClassId, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)containingClassId, (String)"containingClassId");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return ALLOWED_MEMBER_NAMES.contains(name2) || Intrinsics.areEqual((Object)containingClassId, (Object)K_CLASS) && this.isAllowedKClassMember(name2, context2) || (Intrinsics.areEqual((Object)name2.asString(), (Object)"get") || Intrinsics.areEqual((Object)name2.asString(), (Object)"set")) && K_PROPERTY_CLASSES.contains(containingClassId) || ALLOWED_CLASSES.contains(containingClassId);
    }

    private final boolean isReflectionSource(CheckerContext context2) {
        FirFile containingFile = context2.getContainingFile();
        return containingFile != null && UtilsKt.getPackageFqName(containingFile).startsWith(StandardNames.KOTLIN_REFLECT_FQ_NAME);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        String p0;
        String it;
        Collection collection;
        Object item$iv;
        Object $this$mapTo$iv;
        Companion = new Companion(null);
        FqName fqName2 = StandardNames.FqNames.kClass.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
        K_CLASS = ClassId.Companion.topLevel(fqName2);
        Name name2 = Name.identifier("simpleName");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        K_CLASS_SIMPLE_NAME = name2;
        Name name3 = Name.identifier("isInstance");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        K_CLASS_IS_INSTANCE = name3;
        Name name4 = Name.identifier("qualifiedName");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        K_CLASS_QUALIFIED_NAME = name4;
        Object object = new FqNameUnsafe[]{StandardNames.FqNames.kProperty0, StandardNames.FqNames.kProperty1, StandardNames.FqNames.kProperty2, StandardNames.FqNames.kMutableProperty0, StandardNames.FqNames.kMutableProperty1, StandardNames.FqNames.kMutableProperty2};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            FqNameUnsafe fqNameUnsafe = (FqNameUnsafe)item$iv;
            collection = destination$iv;
            boolean bl = false;
            FqName fqName3 = ((FqNameUnsafe)((Object)it)).toSafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"toSafe(...)");
            collection.add(ClassId.Companion.topLevel(fqName3));
        }
        K_PROPERTY_CLASSES = (Set)destination$iv;
        $this$mapTo$iv = new String[]{"equals", "hashCode", "toString", "invoke", "name"};
        $this$mapTo$iv = CollectionsKt.listOf((Object[])$this$mapTo$iv);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            it = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(Name.identifier(p0));
        }
        ALLOWED_MEMBER_NAMES = (Set)destination$iv;
        $this$mapTo$iv = new String[]{"KType", "KTypeParameter", "KTypeProjection", "KTypeProjection.Companion", "KVariance"};
        $this$mapTo$iv = CollectionsKt.listOf((Object[])$this$mapTo$iv);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            p0 = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new ClassId(StandardNames.KOTLIN_REFLECT_FQ_NAME, new FqName(it), false));
        }
        ALLOWED_CLASSES = (Set)var1_1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker$Companion;", "", "<init>", "()V", "K_CLASS", "Lorg/jetbrains/kotlin/name/ClassId;", "K_CLASS_SIMPLE_NAME", "Lorg/jetbrains/kotlin/name/Name;", "K_CLASS_IS_INSTANCE", "K_CLASS_QUALIFIED_NAME", "K_PROPERTY_CLASSES", "", "ALLOWED_MEMBER_NAMES", "ALLOWED_CLASSES", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

