/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JB\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2 \u0010\u0013\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J*\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001c\u0010\u0018\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getDestructuredParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "reportConflicts", "declarationConflictingSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "container", "isPrimaryConstructor", "", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,136:1\n2622#2,3:137\n855#2,2:140\n1609#2:142\n1853#2:143\n1854#2:145\n1610#2:146\n1724#2,3:148\n1745#2,3:151\n1#3:144\n215#4:147\n216#4:154\n18#5:155\n19#5:159\n20#5,2:164\n372#6,3:156\n375#6,4:160\n*S KotlinDebug\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n*L\n55#1:137,3\n56#1:140,2\n58#1:142\n58#1:143\n58#1:145\n58#1:146\n85#1:148,3\n93#1:151,3\n58#1:144\n70#1:147\n70#1:154\n108#1:155\n108#1:159\n108#1:164,2\n108#1:156,3\n108#1:160,4\n*E\n"})
public final class FirConflictsDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsDeclarationChecker INSTANCE = new FirConflictsDeclarationChecker();

    private FirConflictsDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirFile) {
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            this.checkFile((FirFile)declaration, inspector, context2);
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else if (firDeclaration instanceof FirRegularClass) {
            KtSourceElement ktSourceElement = ((FirRegularClass)declaration).getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirRegularClass)declaration).getTypeParameters(), context2, reporter);
            }
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            FirConflictsHelpersKt.collectClassMembers(inspector, ((FirRegularClass)declaration).getSymbol());
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && declaration instanceof FirTypeParameterRefsOwner) {
                if (declaration instanceof FirFunction) {
                    List<FirVariable> destructuredParameters = this.getDestructuredParameters((FirFunction)declaration);
                    FirConflictsHelpersKt.checkForLocalRedeclarations(destructuredParameters, context2, reporter);
                }
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters(), context2, reporter);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirVariable> getDestructuredParameters(FirFunction function2) {
        void $this$mapNotNullTo$iv;
        Collection destination$iv;
        Iterable $this$filterTo$iv;
        boolean bl;
        block7: {
            Iterable $this$none$iv = function2.getValueParameters();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return function2.getValueParameters();
        }
        Iterable $i$f$none = function2.getValueParameters();
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            FirValueParameter it = (FirValueParameter)element$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
            destination$iv.add(element$iv);
        }
        Set destructuredParametersBoxes = (Set)destination$iv;
        FirBlock firBlock = function2.getBody();
        List list2 = firBlock != null ? firBlock.getStatements() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$filterTo$iv = list2;
        destination$iv = CollectionsKt.toMutableList((Collection)function2.getValueParameters());
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirVariable it$iv;
            FirVariable destructuredParameter;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl4 = false;
            FirStatement it = (FirStatement)element$iv;
            boolean bl5 = false;
            FirVariable firVariable = it instanceof FirVariable ? (FirVariable)it : null;
            if ((firVariable == null || (firVariable = FirConflictsHelpersKt.getDestructuredParameter(firVariable)) == null ? null : (destructuredParametersBoxes.contains(destructuredParameter = firVariable) ? (FirVariable)it : null)) == null) continue;
            it$iv = it$iv;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        return (List)destination$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final void reportConflicts(DiagnosticReporter reporter, CheckerContext context, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols, FirDeclaration container) {
        $this$forEach$iv = declarationConflictingSymbols;
        $i$f$forEach = false;
        var7_7 = $this$forEach$iv.entrySet().iterator();
        while (var7_7.hasNext()) {
            block17: {
                block15: {
                    block16: {
                        var9_9 = element$iv = var7_7.next();
                        $i$a$-forEach-FirConflictsDeclarationChecker$reportConflicts$1 = false;
                        conflictingDeclaration = var9_9.getKey();
                        symbols = var9_9.getValue();
                        v0 = conflictingDeclaration instanceof FirConstructorSymbol != false ? (FirConstructorSymbol)conflictingDeclaration : null;
                        typeAliasForConstructorSource = v0 != null && (v0 = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)v0)) != null ? v0.getSource() : null;
                        origin = conflictingDeclaration.getOrigin();
                        if (!(conflictingDeclaration instanceof FirCallableSymbol)) {
                            v1 = conflictingDeclaration.getSource();
                        } else if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
                            v1 = ((FirCallableSymbol)conflictingDeclaration).getSource();
                        } else {
                            if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Library.INSTANCE)) continue;
                            v1 = source = Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) != false ? typeAliasForConstructorSource : container.getSource();
                        }
                        if (symbols.isEmpty()) continue;
                        if (FirConflictsDeclarationChecker.INSTANCE.isPrimaryConstructor(conflictingDeclaration)) {
                            block14: {
                                $this$all$iv = (Iterable)symbols;
                                $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    v2 = true;
                                } else {
                                    for (T element$iv : $this$all$iv) {
                                        it = (FirBasedSymbol)element$iv;
                                        $i$a$-all-FirConflictsDeclarationChecker$reportConflicts$1$1 = false;
                                        if (FirConflictsDeclarationChecker.INSTANCE.isPrimaryConstructor(it)) continue;
                                        v2 = false;
                                        break block14;
                                    }
                                    v2 = true;
                                }
                            }
                            if (v2) continue;
                        }
                        if (!(conflictingDeclaration instanceof FirNamedFunctionSymbol) && !(conflictingDeclaration instanceof FirConstructorSymbol)) break block16;
                        v3 = FirErrors.INSTANCE.getCONFLICTING_OVERLOADS();
                        break block17;
                    }
                    if (!(conflictingDeclaration instanceof FirClassLikeSymbol) || FirHelpersKt.getContainingClassSymbol(conflictingDeclaration, context.getSession()) != null) ** GOTO lbl-1000
                    $this$any$iv = (Iterable)symbols;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (FirBasedSymbol)element$iv;
                            $i$a$-any-FirConflictsDeclarationChecker$reportConflicts$1$factory$1 = false;
                            if (!(it instanceof FirClassLikeSymbol)) continue;
                            v4 = true;
                            break block15;
                        }
                        v4 = false;
                    }
                }
                if (v4) {
                    v3 = FirErrors.INSTANCE.getPACKAGE_OR_CLASSIFIER_REDECLARATION();
                } else lbl-1000:
                // 2 sources

                {
                    v3 = FirErrors.INSTANCE.getREDECLARATION();
                }
            }
            factory = v3;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory, symbols, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final boolean isPrimaryConstructor(FirBasedSymbol<?> $this$isPrimaryConstructor) {
        return $this$isPrimaryConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isPrimaryConstructor).isPrimary() || Intrinsics.areEqual((Object)$this$isPrimaryConstructor.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(FirFile file2, FirDeclarationCollector<FirBasedSymbol<?>> inspector, CheckerContext context2) {
        Object object;
        Object object2;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context2.getSessionHolder().getScopeSession();
        FqName fqName2 = UtilsKt.getPackageFqName(file2);
        ScopeSessionKey<FqName, FirPackageMemberScope> key$iv = FirPackageMemberScopeKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            HashMap answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            FirPackageMemberScope answer$iv$iv = new FirPackageMemberScope(UtilsKt.getPackageFqName(file2), context2.getSessionHolder().getSession(), null, null, 12, null);
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        FirConflictsHelpersKt.collectTopLevel(inspector, file2, packageMemberScope);
    }
}

