/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\n\u001a\u00020\u000b*\u00060\u0005j\u0002`\u00042\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\r\u00a2\u0006\u0002\u0010\u000eJA\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\u0010*\u00060\u0005j\u0002`\u00042\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\r2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\r\u00a2\u0006\u0002\u0010\u0013J0\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\u0010*\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\u00102\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\rJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010*\b\u0012\u0004\u0012\u00020\u00170\u0010R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper;", "", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/diagnostics/Node;", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "<init>", "(Lcom/intellij/util/diff/FlyweightCapableTreeStructure;)V", "getTree", "()Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "hasChildrenInSet", "", "set", "", "(Lcom/intellij/lang/LighterASTNode;Ljava/util/Set;)Z", "getLeavesOrReachableChildren", "", "reachable", "unreachable", "(Lcom/intellij/lang/LighterASTNode;Ljava/util/Set;Ljava/util/Set;)Ljava/util/List;", "removeReachableElementsWithMeaninglessSiblings", "reachableElements", "mergeAdjacentTextRanges", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "frontend.common-psi"})
@SourceDebugExtension(value={"SMAP\nUnreachableCodeLightTreeHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnreachableCodeLightTreeHelper.kt\norg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n764#2:88\n855#2,2:89\n1787#2,3:91\n*S KotlinDebug\n*F\n+ 1 UnreachableCodeLightTreeHelper.kt\norg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper\n*L\n62#1:88\n62#1:89,2\n67#1:91,3\n*E\n"})
public final class UnreachableCodeLightTreeHelper {
    @NotNull
    private final FlyweightCapableTreeStructure<LighterASTNode> tree;

    public UnreachableCodeLightTreeHelper(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        this.tree = tree;
    }

    @NotNull
    public final FlyweightCapableTreeStructure<LighterASTNode> getTree() {
        return this.tree;
    }

    public final boolean hasChildrenInSet(@NotNull LighterASTNode $this$hasChildrenInSet, @NotNull Set<? extends LighterASTNode> set) {
        Intrinsics.checkNotNullParameter((Object)$this$hasChildrenInSet, (String)"<this>");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        LightTreePositioningStrategiesKt.traverseDescendants(this.tree, $this$hasChildrenInSet, (Function1<? super LighterASTNode, Boolean>)((Function1)new Function1<LighterASTNode, Boolean>(result2, $this$hasChildrenInSet, set){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ LighterASTNode $this_hasChildrenInSet;
            final /* synthetic */ Set<LighterASTNode> $set;
            {
                this.$result = $result;
                this.$this_hasChildrenInSet = $receiver;
                this.$set = $set;
                super(1);
            }

            public final Boolean invoke(LighterASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!this.$result.element && !Intrinsics.areEqual((Object)it, (Object)this.$this_hasChildrenInSet) && this.$set.contains(it)) {
                    this.$result.element = true;
                }
                return !this.$result.element;
            }
        }));
        return result2.element;
    }

    @NotNull
    public final List<LighterASTNode> getLeavesOrReachableChildren(@NotNull LighterASTNode $this$getLeavesOrReachableChildren, @NotNull Set<? extends LighterASTNode> reachable, @NotNull Set<? extends LighterASTNode> unreachable) {
        Intrinsics.checkNotNullParameter((Object)$this$getLeavesOrReachableChildren, (String)"<this>");
        Intrinsics.checkNotNullParameter(reachable, (String)"reachable");
        Intrinsics.checkNotNullParameter(unreachable, (String)"unreachable");
        List result2 = new ArrayList();
        LightTreePositioningStrategiesKt.traverseDescendants(this.tree, $this$getLeavesOrReachableChildren, (Function1<? super LighterASTNode, Boolean>)((Function1)new Function1<LighterASTNode, Boolean>(reachable, this, unreachable, (List<LighterASTNode>)result2){
            final /* synthetic */ Set<LighterASTNode> $reachable;
            final /* synthetic */ UnreachableCodeLightTreeHelper this$0;
            final /* synthetic */ Set<LighterASTNode> $unreachable;
            final /* synthetic */ List<LighterASTNode> $result;
            {
                this.$reachable = $reachable;
                this.this$0 = $receiver;
                this.$unreachable = $unreachable;
                this.$result = $result;
                super(1);
            }

            public final Boolean invoke(LighterASTNode element) {
                boolean bl;
                boolean isReachable2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                boolean bl2 = isReachable2 = this.$reachable.contains(element) && !this.this$0.hasChildrenInSet(element, this.$unreachable);
                if (isReachable2 || LightTreeUtilsKt.getChildren(element, this.this$0.getTree()).isEmpty()) {
                    this.$result.add(element);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LighterASTNode> removeReachableElementsWithMeaninglessSiblings(@NotNull List<? extends LighterASTNode> $this$removeReachableElementsWithMeaninglessSiblings, @NotNull Set<? extends LighterASTNode> reachableElements) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$removeReachableElementsWithMeaninglessSiblings, (String)"<this>");
        Intrinsics.checkNotNullParameter(reachableElements, (String)"reachableElements");
        Set childrenToRemove = new LinkedHashSet();
        Iterator<? extends LighterASTNode> iterator2 = $this$removeReachableElementsWithMeaninglessSiblings.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            LighterASTNode element = iterator2.next();
            if (!reachableElements.contains(element)) continue;
            childrenToRemove.add(element);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this$removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index2, -1);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this$removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index2, 1);
        }
        Iterable $this$filter$iv = $this$removeReachableElementsWithMeaninglessSiblings;
        boolean $i$f$filter = false;
        Iterable index2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl = false;
            if (!(!childrenToRemove.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> mergeAdjacentTextRanges(@NotNull List<? extends TextRange> $this$mergeAdjacentTextRanges) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$mergeAdjacentTextRanges, (String)"<this>");
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        Iterable iterable = $this$mergeAdjacentTextRanges;
        TextRange initial$iv = null;
        boolean $i$f$fold = false;
        TextRange accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            TextRange textRange;
            void elementRange;
            TextRange textRange2 = (TextRange)element$iv;
            TextRange currentTextRange = accumulator$iv;
            boolean bl = false;
            if (currentTextRange == null) {
                textRange = elementRange;
            } else if (currentTextRange.getEndOffset() == elementRange.getStartOffset()) {
                TextRange textRange3 = currentTextRange.union((TextRange)elementRange);
                Intrinsics.checkNotNull((Object)textRange3);
                textRange = textRange3;
            } else {
                result2.add(currentTextRange);
                textRange = elementRange;
            }
            accumulator$iv = textRange;
        }
        TextRange lastRange = accumulator$iv;
        if (lastRange != null) {
            result2.add(lastRange);
        }
        return result2;
    }

    private static final void removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless(List<? extends LighterASTNode> $this_removeReachableElementsWithMeaninglessSiblings, Set<LighterASTNode> childrenToRemove, int elementIndex, int direction) {
        int index2 = elementIndex + direction;
        if (!(0 <= index2 ? index2 < $this_removeReachableElementsWithMeaninglessSiblings.size() : false)) {
            return;
        }
        LighterASTNode element = $this_removeReachableElementsWithMeaninglessSiblings.get(index2);
        if (LightTreePositioningStrategyKt.isFiller(element) || Intrinsics.areEqual((Object)element.getTokenType(), (Object)KtTokens.COMMA)) {
            childrenToRemove.add(element);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this_removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index2, direction);
        }
    }
}

