/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.RequireKotlinConstants;
import org.jetbrains.kotlin.resolve.annotations.UtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J.\u0010\f\u001a\u00020\u0005*\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DeprecatedSinceKotlinAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkVersion", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parsedVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "name", "", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "lessOrNull", "", "a", "b", "frontend"})
@SourceDebugExtension(value={"SMAP\nDeprecatedSinceKotlinAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedSinceKotlinAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DeprecatedSinceKotlinAnnotationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class DeprecatedSinceKotlinAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final DeprecatedSinceKotlinAnnotationChecker INSTANCE = new DeprecatedSinceKotlinAnnotationChecker();

    private DeprecatedSinceKotlinAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor deprecatedSinceAnnotation = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(deprecatedSinceAnnotation.getSource());
        KtAnnotationEntry ktAnnotationEntry = psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry deprecatedSinceAnnotationPsi = ktAnnotationEntry;
        AnnotationDescriptor deprecatedAnnotation = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecated);
        KtTypeReference ktTypeReference = deprecatedSinceAnnotationPsi.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference deprecatedSinceAnnotationName = ktTypeReference;
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(descriptor2);
        boolean bl = fqName2 != null ? !FqNamesUtilKt.isSubpackageOf(fqName2, StandardNames.BUILT_INS_PACKAGE_FQ_NAME) : false;
        if (bl) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE.on(deprecatedSinceAnnotationName));
            return;
        }
        if (deprecatedAnnotation == null) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED.on(deprecatedSinceAnnotationName));
            return;
        }
        if (UtilsKt.argumentValue(deprecatedAnnotation, "level") != null) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL.on(deprecatedSinceAnnotationName));
            return;
        }
        if (deprecatedSinceAnnotation.getAllValueArguments().isEmpty()) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS.on(deprecatedSinceAnnotationName));
            return;
        }
        ApiVersion warningSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context2, deprecatedSinceAnnotationName, "warningSince");
        ApiVersion errorSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context2, deprecatedSinceAnnotationName, "errorSince");
        ApiVersion hiddenSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context2, deprecatedSinceAnnotationName, "hiddenSince");
        if (!(this.lessOrNull(warningSince, errorSince) && this.lessOrNull(errorSince, hiddenSince) && this.lessOrNull(warningSince, hiddenSince))) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS.on(deprecatedSinceAnnotationName));
            return;
        }
    }

    private final void checkVersion(AnnotationDescriptor $this$checkVersion, ApiVersion parsedVersion, String name2, DeclarationCheckerContext context2, PsiElement reportOn) {
        block4: {
            block5: {
                String argumentValue;
                ConstantValue<?> constantValue = UtilsKt.argumentValue($this$checkVersion, name2);
                StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
                String string2 = argumentValue = stringValue != null ? (String)stringValue.getValue() : null;
                if (argumentValue == null) break block4;
                if (parsedVersion == null) break block5;
                CharSequence charSequence = argumentValue;
                if (RequireKotlinConstants.INSTANCE.getVERSION_REGEX().matches(charSequence)) break block4;
            }
            BindingTrace bindingTrace = context2.getTrace();
            FqName fqName2 = $this$checkVersion.getFqName();
            if (fqName2 == null) {
                return;
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.ILLEGAL_KOTLIN_VERSION_STRING_VALUE.on(reportOn, fqName2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean lessOrNull(ApiVersion a, ApiVersion b) {
        if (a == null) return true;
        ApiVersion apiVersion = b;
        if (apiVersion == null) {
            return true;
        }
        if (a.compareTo(apiVersion) > 0) return false;
        return true;
    }

    private static final ApiVersion check$getCheckedSinceVersion(AnnotationDescriptor $this$check_u24getCheckedSinceVersion, DeclarationCheckerContext $context, KtTypeReference deprecatedSinceAnnotationName, String name2) {
        ApiVersion apiVersion;
        ApiVersion it = apiVersion = DeprecationUtilKt.getSinceVersion($this$check_u24getCheckedSinceVersion, name2);
        boolean bl = false;
        INSTANCE.checkVersion($this$check_u24getCheckedSinceVersion, it, name2, $context, deprecatedSinceAnnotationName);
        return apiVersion;
    }
}

