/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/CyclicAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "Checker", "frontend"})
public final class CyclicAnnotationsChecker
implements DeclarationChecker {
    @NotNull
    public static final CyclicAnnotationsChecker INSTANCE = new CyclicAnnotationsChecker();

    private CyclicAnnotationsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration instanceof KtClass && ((KtClass)declaration).isAnnotation() && descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ANNOTATION_CLASS)) {
            return;
        }
        KtPrimaryConstructor ktPrimaryConstructor = ((KtClass)declaration).getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ktPrimaryConstructor;
        ClassConstructorDescriptor classConstructorDescriptor = ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor primaryConstructorDescriptor = classConstructorDescriptor;
        Checker checker = new Checker((ClassDescriptor)descriptor2);
        Iterable iterable = primaryConstructor2.getValueParameters();
        List<ValueParameterDescriptor> list2 = primaryConstructorDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        for (Pair pair : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
            KtParameter parameter2 = (KtParameter)pair.component1();
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)pair.component2();
            ClassDescriptor classDescriptor2 = (ClassDescriptor)descriptor2;
            Intrinsics.checkNotNull((Object)parameterDescriptor);
            if (!checker.parameterHasCycle(classDescriptor2, parameterDescriptor)) continue;
            context2.getTrace().report(Errors.CYCLE_IN_ANNOTATION_PARAMETER.on(context2.getLanguageVersionSettings(), (KtParameter)((PsiElement)parameter2)));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/CyclicAnnotationsChecker$Checker;", "", "targetAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "getTargetAnnotation", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "visitedAnnotationDescriptors", "", "annotationDescriptorsWithCycle", "annotationHasCycle", "", "annotationDescriptor", "parameterHasCycle", "ownedAnnotation", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "typeHasCycle", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nCyclicAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CyclicAnnotationsChecker.kt\norg/jetbrains/kotlin/resolve/checkers/CyclicAnnotationsChecker$Checker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
    private static final class Checker {
        @NotNull
        private final ClassDescriptor targetAnnotation;
        @NotNull
        private final Set<ClassDescriptor> visitedAnnotationDescriptors;
        @NotNull
        private final Set<ClassDescriptor> annotationDescriptorsWithCycle;

        public Checker(@NotNull ClassDescriptor targetAnnotation) {
            Intrinsics.checkNotNullParameter((Object)targetAnnotation, (String)"targetAnnotation");
            this.targetAnnotation = targetAnnotation;
            Object[] objectArray = new ClassDescriptor[]{this.targetAnnotation};
            this.visitedAnnotationDescriptors = SetsKt.mutableSetOf((Object[])objectArray);
            objectArray = new ClassDescriptor[]{this.targetAnnotation};
            this.annotationDescriptorsWithCycle = SetsKt.mutableSetOf((Object[])objectArray);
        }

        @NotNull
        public final ClassDescriptor getTargetAnnotation() {
            return this.targetAnnotation;
        }

        public final boolean annotationHasCycle(@NotNull ClassDescriptor annotationDescriptor) {
            Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"annotationDescriptor");
            ClassConstructorDescriptor classConstructorDescriptor = annotationDescriptor.getUnsubstitutedPrimaryConstructor();
            if (classConstructorDescriptor == null) {
                return false;
            }
            ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
            for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
                Intrinsics.checkNotNull((Object)parameterDescriptor);
                if (!this.parameterHasCycle(annotationDescriptor, parameterDescriptor)) continue;
                return true;
            }
            return false;
        }

        public final boolean parameterHasCycle(@NotNull ClassDescriptor ownedAnnotation, @NotNull ValueParameterDescriptor parameterDescriptor) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)ownedAnnotation, (String)"ownedAnnotation");
            Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
            KotlinType kotlinType = parameterDescriptor.getReturnType();
            if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
                return false;
            }
            KotlinType returnType2 = kotlinType;
            if (ArgumentsUtilsKt.isVararg(parameterDescriptor) || SimpleClassicTypeSystemContext.INSTANCE.isArrayOrNullableArray(returnType2)) {
                bl = false;
            } else if (!((Collection)returnType2.getArguments()).isEmpty() && !ReflectionTypes.Companion.isKClassType(returnType2)) {
                for (TypeProjection argument2 : returnType2.getArguments()) {
                    if (argument2.isStarProjection() || !this.typeHasCycle(ownedAnnotation, argument2.getType().unwrap())) continue;
                    return true;
                }
                bl = false;
            } else {
                bl = this.typeHasCycle(ownedAnnotation, (UnwrappedType)returnType2);
            }
            return bl;
        }

        public final boolean typeHasCycle(@NotNull ClassDescriptor ownedAnnotation, @NotNull UnwrappedType type2) {
            ClassifierDescriptor classifierDescriptor;
            block7: {
                block6: {
                    ClassDescriptor classDescriptor2;
                    ClassDescriptor classDescriptor3;
                    Intrinsics.checkNotNullParameter((Object)ownedAnnotation, (String)"ownedAnnotation");
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor4 = classDescriptor3 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor3 == null) break block6;
                    ClassDescriptor it = classDescriptor2 = classDescriptor3;
                    boolean bl = false;
                    ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = it.getKind() == ClassKind.ANNOTATION_CLASS ? classDescriptor2 : null;
                    if (classifierDescriptor != null) break block7;
                }
                return false;
            }
            ClassifierDescriptor referencedAnnotationDescriptor = classifierDescriptor;
            if (!this.visitedAnnotationDescriptors.add((ClassDescriptor)referencedAnnotationDescriptor)) {
                boolean bl;
                boolean it = bl = this.annotationDescriptorsWithCycle.contains(referencedAnnotationDescriptor);
                boolean bl2 = false;
                if (it) {
                    ((Collection)this.annotationDescriptorsWithCycle).add(ownedAnnotation);
                }
                return bl;
            }
            if (Intrinsics.areEqual((Object)referencedAnnotationDescriptor, (Object)this.targetAnnotation)) {
                ((Collection)this.annotationDescriptorsWithCycle).add(ownedAnnotation);
                return true;
            }
            return this.annotationHasCycle((ClassDescriptor)referencedAnnotationDescriptor);
        }
    }
}

