/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.native;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.konan.serialization.ObjCFunctionNameMangleComputer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.native.FirNativeKotlinManglerKt;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.native.interop.ObjCMethodInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/backend/native/FirObjCFunctionNameMangleComputer;", "Lorg/jetbrains/kotlin/backend/konan/serialization/ObjCFunctionNameMangleComputer;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getObjCMethodInfo", "Lorg/jetbrains/kotlin/native/interop/ObjCMethodInfo;", "getExtensionReceiverClassName", "Lorg/jetbrains/kotlin/name/Name;", "isObjCConstructor", "", "isPropertyAccessor", "hasObjCMethodAnnotation", "hasObjCFactoryAnnotation", "isObjCClassMethod", "getValueParameterName", "valueParameter", "native"})
@SourceDebugExtension(value={"SMAP\nFirNativeKotlinMangler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeKotlinMangler.kt\norg/jetbrains/kotlin/fir/backend/native/FirObjCFunctionNameMangleComputer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
final class FirObjCFunctionNameMangleComputer
extends ObjCFunctionNameMangleComputer<FirValueParameter> {
    @NotNull
    private final FirFunction function;
    @NotNull
    private final FirSession session;

    public FirObjCFunctionNameMangleComputer(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.function = function2;
        this.session = this.function.getModuleData().getSession();
    }

    @Override
    @Nullable
    public ObjCMethodInfo getObjCMethodInfo() {
        ScopeSession scopeSession = new ScopeSession();
        FirFunction firFunction = FirObjCInteropKt.getInitMethodIfObjCConstructor(this.function, this.session, scopeSession);
        return firFunction != null ? FirObjCInteropKt.getObjCMethodInfoFromOverriddenFunctions(firFunction, this.session, scopeSession) : null;
    }

    @Override
    @Nullable
    public Name getExtensionReceiverClassName() {
        Name name2;
        Object object = this.function.getReceiverParameter();
        if (object != null && (object = FirNativeKotlinManglerKt.access$getTypeName((FirReceiverParameter)object, this.session)) != null) {
            Object p0 = object;
            boolean bl = false;
            name2 = Name.identifier((String)p0);
        } else {
            name2 = null;
        }
        return name2;
    }

    @Override
    public boolean isObjCConstructor() {
        return this.function instanceof FirConstructor && FirObjCInteropKt.isObjCConstructor((FirConstructor)this.function, this.session);
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.function instanceof FirPropertyAccessor;
    }

    @Override
    public boolean hasObjCMethodAnnotation() {
        return FirObjCInteropKt.hasObjCMethodAnnotation(this.function, this.session);
    }

    @Override
    public boolean hasObjCFactoryAnnotation() {
        return FirObjCInteropKt.hasObjCFactoryAnnotation(this.function, this.session);
    }

    @Override
    public boolean isObjCClassMethod() {
        return FirObjCInteropKt.isObjCClassMethod(this.function, this.session);
    }

    @Override
    @NotNull
    public Name getValueParameterName(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return valueParameter2.getName();
    }
}

