/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016JN\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J<\u0010\u001d\u001a\u00020\u0007*\u00020\f2\u0006\u0010\b\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "memberSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "declarationToReport", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "objCAnnotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "swiftAnnotations", "inheritsRefinedAnnotations", "Lkotlin/Pair;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasRefinedAnnotations", "reportIncompatibleOverride", "annotations", "notRefinedSupers", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCRefinementOverridesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1601#2,9:123\n1853#2:132\n1854#2:134\n1610#2:135\n1#3:133\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker\n*L\n112#1:123,9\n112#1:132\n112#1:134\n112#1:135\n112#1:133\n*E\n"})
public final class FirNativeObjCRefinementOverridesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCRefinementOverridesChecker INSTANCE = new FirNativeObjCRefinementOverridesChecker();

    private FirNativeObjCRefinementOverridesChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration, context2);
        FirContainingNamesAwareScopeKt.processAllFunctions(firTypeScope, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(firTypeScope, declaration, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(FirNamedFunctionSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                if (!ClassMembersKt.isIntersectionOverride(symbol2)) {
                    return;
                }
                FirNativeObjCRefinementOverridesChecker.INSTANCE.check(this.$firTypeScope, symbol2, this.$declaration, this.$context, this.$reporter, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
        }));
        FirContainingNamesAwareScopeKt.processAllProperties(firTypeScope, (Function1)new Function1<FirVariableSymbol<?>, Unit>(firTypeScope, declaration, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(FirVariableSymbol<?> symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                if (!ClassMembersKt.isIntersectionOverride((FirCallableSymbol)symbol2)) {
                    return;
                }
                FirNativeObjCRefinementOverridesChecker.INSTANCE.check(this.$firTypeScope, (FirCallableSymbol)symbol2, this.$declaration, this.$context, this.$reporter, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
        });
    }

    public final void check(@NotNull FirTypeScope firTypeScope, @NotNull FirCallableSymbol<?> memberSymbol, @NotNull FirDeclaration declarationToReport, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull List<? extends FirAnnotation> objCAnnotations, @NotNull List<? extends FirAnnotation> swiftAnnotations) {
        Intrinsics.checkNotNullParameter((Object)firTypeScope, (String)"firTypeScope");
        Intrinsics.checkNotNullParameter(memberSymbol, (String)"memberSymbol");
        Intrinsics.checkNotNullParameter((Object)declarationToReport, (String)"declarationToReport");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(objCAnnotations, (String)"objCAnnotations");
        Intrinsics.checkNotNullParameter(swiftAnnotations, (String)"swiftAnnotations");
        List<FirCallableSymbol<?>> overriddenMemberSymbols = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, memberSymbol);
        if (overriddenMemberSymbols.isEmpty()) {
            return;
        }
        boolean isHiddenFromObjC = !((Collection)objCAnnotations).isEmpty();
        boolean isRefinedInSwift = !((Collection)swiftAnnotations).isEmpty();
        List supersNotHiddenFromObjC = new ArrayList();
        List supersNotRefinedInSwift = new ArrayList();
        for (FirCallableSymbol<?> symbol2 : overriddenMemberSymbols) {
            Pair<Boolean, Boolean> pair = this.inheritsRefinedAnnotations(symbol2, context2.getSession(), firTypeScope);
            boolean superIsHiddenFromObjC = (Boolean)pair.component1();
            boolean superIsRefinedInSwift = (Boolean)pair.component2();
            if (superIsHiddenFromObjC) {
                isHiddenFromObjC = true;
            } else {
                supersNotHiddenFromObjC.add(symbol2);
            }
            if (superIsRefinedInSwift) {
                isRefinedInSwift = true;
                continue;
            }
            supersNotRefinedInSwift.add(symbol2);
        }
        if (isHiddenFromObjC && !((Collection)supersNotHiddenFromObjC).isEmpty()) {
            this.reportIncompatibleOverride(reporter, declarationToReport, objCAnnotations, supersNotHiddenFromObjC, context2);
        }
        if (isRefinedInSwift && !((Collection)supersNotRefinedInSwift).isEmpty()) {
            this.reportIncompatibleOverride(reporter, declarationToReport, swiftAnnotations, supersNotRefinedInSwift, context2);
        }
    }

    private final Pair<Boolean, Boolean> inheritsRefinedAnnotations(FirCallableSymbol<?> $this$inheritsRefinedAnnotations, FirSession session2, FirTypeScope firTypeScope) {
        Pair<Boolean, Boolean> pair = this.hasRefinedAnnotations($this$inheritsRefinedAnnotations, session2);
        boolean hasObjC = (Boolean)pair.component1();
        boolean hasSwift = (Boolean)pair.component2();
        if (hasObjC && hasSwift) {
            return TuplesKt.to((Object)true, (Object)true);
        }
        FirCallableSymbol firCallableSymbol = (FirCallableSymbol)CollectionsKt.firstOrNull(FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, $this$inheritsRefinedAnnotations));
        if (firCallableSymbol == null) {
            return TuplesKt.to((Object)hasObjC, (Object)hasSwift);
        }
        FirCallableSymbol overriddenMemberSymbol = firCallableSymbol;
        Pair<Boolean, Boolean> pair2 = this.inheritsRefinedAnnotations(overriddenMemberSymbol, session2, firTypeScope);
        boolean inheritsObjC = (Boolean)pair2.component1();
        boolean inheritsSwift = (Boolean)pair2.component2();
        return TuplesKt.to((Object)(hasObjC || inheritsObjC ? 1 : 0), (Object)(hasSwift || inheritsSwift ? 1 : 0));
    }

    private final Pair<Boolean, Boolean> hasRefinedAnnotations(FirCallableSymbol<?> $this$hasRefinedAnnotations, FirSession session2) {
        boolean hasObjC = false;
        boolean hasSwift = false;
        for (FirAnnotation annotation2 : $this$hasRefinedAnnotations.getResolvedAnnotationsWithClassIds()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation2, session2);
            List list2 = firClassLikeSymbol != null ? firClassLikeSymbol.getResolvedAnnotationsWithClassIds() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List metaAnnotations = list2;
            for (FirAnnotation metaAnnotation : metaAnnotations) {
                ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(metaAnnotation, session2);
                if (Intrinsics.areEqual((Object)classId, (Object)FirNativeObjCRefinementChecker.INSTANCE.getHidesFromObjCClassId())) {
                    hasObjC = true;
                    break;
                }
                if (!Intrinsics.areEqual((Object)classId, (Object)FirNativeObjCRefinementChecker.INSTANCE.getRefinesInSwiftClassId())) continue;
                hasSwift = true;
                break;
            }
            if (!hasObjC || !hasSwift) continue;
            return TuplesKt.to((Object)true, (Object)true);
        }
        return TuplesKt.to((Object)hasObjC, (Object)hasSwift);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportIncompatibleOverride(DiagnosticReporter $this$reportIncompatibleOverride, FirDeclaration declaration, List<? extends FirAnnotation> annotations2, List<? extends FirCallableSymbol<?>> notRefinedSupers, CheckerContext context2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = notRefinedSupers;
        boolean bl = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirRegularClassSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl22 = false;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(it);
            if ((coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List containingDeclarations = (List)destination$iv$iv;
        if (annotations2.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportIncompatibleOverride, (AbstractKtSourceElement)declaration.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE(), declaration.getSymbol(), (Object)containingDeclarations, (DiagnosticContext)context2, null, 32, null);
        } else {
            for (FirAnnotation firAnnotation : annotations2) {
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportIncompatibleOverride, (AbstractKtSourceElement)firAnnotation.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE(), declaration.getSymbol(), (Object)containingDeclarations, (DiagnosticContext)context2, null, 32, null);
            }
        }
    }
}

