/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u0003H\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasContextReceiver", "", "findContextReceiverListSource", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextReceiversDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextReceiversDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,70:1\n590#2,7:71\n*S KotlinDebug\n*F\n+ 1 FirContextReceiversDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeclarationChecker\n*L\n63#1:71,7\n*E\n"})
public final class FirContextReceiversDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirContextReceiversDeclarationChecker INSTANCE = new FirContextReceiversDeclarationChecker();

    private FirContextReceiversDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers)) {
            return;
        }
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!this.hasContextReceiver(declaration)) {
            return;
        }
        KtSourceElement ktSourceElement2 = declaration.getSource();
        if (ktSourceElement2 == null || (ktSourceElement2 = this.findContextReceiverListSource(ktSourceElement2)) == null) {
            return;
        }
        KtSourceElement source = ktSourceElement2;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.ContextReceivers), (Object)context2.getLanguageVersionSettings()), (DiagnosticContext)context2, null, 16, null);
    }

    private final boolean hasContextReceiver(FirDeclaration $this$hasContextReceiver) {
        FirDeclaration firDeclaration = $this$hasContextReceiver;
        List<FirContextReceiver> contextReceivers = firDeclaration instanceof FirCallableDeclaration ? ((FirCallableDeclaration)$this$hasContextReceiver).getContextReceivers() : (firDeclaration instanceof FirRegularClass ? ((FirRegularClass)$this$hasContextReceiver).getContextReceivers() : (firDeclaration instanceof FirScript ? ((FirScript)$this$hasContextReceiver).getContextReceivers() : CollectionsKt.emptyList()));
        return !((Collection)contextReceivers).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightSourceElement findContextReceiverListSource(KtSourceElement $this$findContextReceiverListSource) {
        void endOffset$iv;
        void $this$toKtLightSourceElement_u24default$iv;
        LighterASTNode contextReceiverList = null;
        int contextReceiverListOffset = $this$findContextReceiverListSource.getStartOffset();
        List<LighterASTNode> nodes = LightTreeUtilsKt.getChildren($this$findContextReceiverListSource.getLighterASTNode(), $this$findContextReceiverListSource.getTreeStructure());
        for (LighterASTNode lighterASTNode2 : nodes) {
            if (Intrinsics.areEqual((Object)lighterASTNode2.getTokenType(), (Object)KtNodeTypes.CONTEXT_RECEIVER_LIST)) {
                contextReceiverList = lighterASTNode2;
                break;
            }
            contextReceiverListOffset += lighterASTNode2.getEndOffset() - lighterASTNode2.getStartOffset();
        }
        if (contextReceiverList == null) {
            return null;
        }
        Iterator<LighterASTNode> iterator2 = contextReceiverList;
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$findContextReceiverListSource.getTreeStructure();
        int n = contextReceiverListOffset + contextReceiverList.getTextLength();
        KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
        boolean $i$f$toKtLightSourceElement = false;
        return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, contextReceiverListOffset, (int)endOffset$iv, flyweightCapableTreeStructure, kind$iv);
    }
}

