/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.extensions.ClassBuilderExtensionAdapterKt;
import org.jetbrains.kotlin.backend.jvm.extensions.ClassGenerator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.RecordComponentVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JG\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J>\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016JK\u0010\u001f\u001a\u00020 2\b\u0010\u001a\u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0010\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0016J,\u0010*\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010\u00122\b\u0010,\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J$\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010/\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020)H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGeneratorAdapter;", "Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGenerator;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "builder", "Lorg/jetbrains/kotlin/codegen/ClassBuilder;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/codegen/ClassBuilder;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getBuilder", "()Lorg/jetbrains/kotlin/codegen/ClassBuilder;", "defineClass", "", "version", "", "access", "name", "", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "newField", "Lorg/jetbrains/org/objectweb/asm/FieldVisitor;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "desc", "value", "", "newMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "exceptions", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "newRecordComponent", "Lorg/jetbrains/org/objectweb/asm/RecordComponentVisitor;", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "visible", "", "visitInnerClass", "outerName", "innerName", "visitEnclosingMethod", "owner", "visitSource", "debug", "done", "generateSmapCopyToAnnotation", "backend.jvm"})
final class ClassGeneratorAdapter
implements ClassGenerator {
    @Nullable
    private final IrClass irClass;
    @NotNull
    private final ClassBuilder builder;

    public ClassGeneratorAdapter(@Nullable IrClass irClass, @NotNull ClassBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        this.irClass = irClass;
        this.builder = builder2;
    }

    @Nullable
    public final IrClass getIrClass() {
        return this.irClass;
    }

    @NotNull
    public final ClassBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void defineClass(int version2, int access, @NotNull String name2, @Nullable String signature2, @NotNull String superName, @NotNull String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
        Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
        IrClass irClass = this.irClass;
        this.builder.defineClass(irClass != null ? JvmIrUtilsKt.getPsiElement(irClass) : null, version2, access, name2, signature2, superName, interfaces);
    }

    @Override
    @NotNull
    public FieldVisitor newField(@Nullable IrField declaration, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        FieldVisitor fieldVisitor = this.builder.newField(ClassBuilderExtensionAdapterKt.access$wrapToOrigin(declaration), access, name2, desc, signature2, value2);
        Intrinsics.checkNotNullExpressionValue((Object)fieldVisitor, (String)"newField(...)");
        return fieldVisitor;
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@Nullable IrFunction declaration, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        MethodVisitor methodVisitor = this.builder.newMethod(ClassBuilderExtensionAdapterKt.access$wrapToOrigin(declaration), access, name2, desc, signature2, exceptions);
        Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"newMethod(...)");
        return methodVisitor;
    }

    @Override
    @NotNull
    public RecordComponentVisitor newRecordComponent(@NotNull String name2, @NotNull String desc, @Nullable String signature2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        RecordComponentVisitor recordComponentVisitor = this.builder.newRecordComponent(name2, desc, signature2);
        Intrinsics.checkNotNullExpressionValue((Object)recordComponentVisitor, (String)"newRecordComponent(...)");
        return recordComponentVisitor;
    }

    @Override
    @NotNull
    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        AnnotationVisitor annotationVisitor = this.builder.newAnnotation(desc, visible);
        Intrinsics.checkNotNullExpressionValue((Object)annotationVisitor, (String)"newAnnotation(...)");
        return annotationVisitor;
    }

    @Override
    public void visitInnerClass(@NotNull String name2, @Nullable String outerName, @Nullable String innerName, int access) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.builder.visitInnerClass(name2, outerName, innerName, access);
    }

    @Override
    public void visitEnclosingMethod(@NotNull String owner, @Nullable String name2, @Nullable String desc) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.builder.visitOuterClass(owner, name2, desc);
    }

    @Override
    public void visitSource(@NotNull String name2, @Nullable String debug) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.builder.visitSource(name2, debug);
    }

    @Override
    public void done(boolean generateSmapCopyToAnnotation) {
        this.builder.done(generateSmapCopyToAnnotation);
    }
}

