/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.output;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/output/SimpleOutputFile;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "sourceFiles", "", "Ljava/io/File;", "relativePath", "", "content", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getSourceFiles", "()Ljava/util/List;", "getRelativePath", "()Ljava/lang/String;", "asByteArray", "", "asText", "toString", "backend-common"})
public final class SimpleOutputFile
implements OutputFile {
    @NotNull
    private final List<File> sourceFiles;
    @NotNull
    private final String relativePath;
    @NotNull
    private final String content;

    public SimpleOutputFile(@NotNull List<? extends File> sourceFiles2, @NotNull String relativePath, @NotNull String content2) {
        Intrinsics.checkNotNullParameter(sourceFiles2, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.sourceFiles = sourceFiles2;
        this.relativePath = relativePath;
        this.content = content2;
    }

    @Override
    @NotNull
    public List<File> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    @NotNull
    public byte[] asByteArray() {
        String string2 = this.content;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @Override
    @NotNull
    public String asText() {
        return this.content;
    }

    @NotNull
    public String toString() {
        return this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ')';
    }
}

