/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.ActualDeclarationsCollector;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualLinkCollector;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectTopLevelClassesCollector;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector;", "", "mainFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependentFragments", "", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/List;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;)V", "collect", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector$Result;", "collectActualDeclarations", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "matchAllExpectDeclarations", "", "destination", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "classActualizationInfo", "Result", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n1853#2,2:370\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector\n*L\n77#1:370,2\n*E\n"})
public final class ExpectActualCollector {
    @NotNull
    private final IrModuleFragment mainFragment;
    @NotNull
    private final List<IrModuleFragment> dependentFragments;
    @NotNull
    private final IrTypeSystemContext typeSystemContext;
    @NotNull
    private final IrDiagnosticReporter diagnosticsReporter;
    @Nullable
    private final ExpectActualTracker expectActualTracker;

    public ExpectActualCollector(@NotNull IrModuleFragment mainFragment, @NotNull List<? extends IrModuleFragment> dependentFragments, @NotNull IrTypeSystemContext typeSystemContext2, @NotNull IrDiagnosticReporter diagnosticsReporter, @Nullable ExpectActualTracker expectActualTracker) {
        Intrinsics.checkNotNullParameter((Object)mainFragment, (String)"mainFragment");
        Intrinsics.checkNotNullParameter(dependentFragments, (String)"dependentFragments");
        Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        this.mainFragment = mainFragment;
        this.dependentFragments = dependentFragments;
        this.typeSystemContext = typeSystemContext2;
        this.diagnosticsReporter = diagnosticsReporter;
        this.expectActualTracker = expectActualTracker;
    }

    @NotNull
    public final Result collect() {
        Map result2 = new LinkedHashMap();
        ClassActualizationInfo actualDeclarations = this.collectActualDeclarations();
        this.matchAllExpectDeclarations(result2, actualDeclarations);
        return new Result(result2, actualDeclarations);
    }

    private final ClassActualizationInfo collectActualDeclarations() {
        Map<ClassId, IrClassSymbol> expectTopLevelClasses = ExpectTopLevelClassesCollector.Companion.collect(this.dependentFragments);
        List fragmentsWithActuals = CollectionsKt.plus((Collection)CollectionsKt.drop((Iterable)this.dependentFragments, (int)1), (Object)this.mainFragment);
        return ActualDeclarationsCollector.Companion.collectActualsFromFragments(fragmentsWithActuals, expectTopLevelClasses);
    }

    private final void matchAllExpectDeclarations(Map<IrSymbol, IrSymbol> destination, ClassActualizationInfo classActualizationInfo) {
        ExpectActualLinkCollector linkCollector = new ExpectActualLinkCollector();
        ExpectActualLinkCollector.MatchingContext linkCollectorContext = new ExpectActualLinkCollector.MatchingContext(this.typeSystemContext, destination, this.diagnosticsReporter, this.expectActualTracker, classActualizationInfo, null);
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl = false;
            linkCollector.visitModuleFragment(it, (Object)linkCollectorContext);
        }
        linkCollector.visitModuleFragment(this.mainFragment, (Object)linkCollectorContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector$Result;", "", "expectToActualMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;)V", "getExpectToActualMap", "()Ljava/util/Map;", "getClassActualizationInfo", "()Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.actualization"})
    public static final class Result {
        @NotNull
        private final Map<IrSymbol, IrSymbol> expectToActualMap;
        @NotNull
        private final ClassActualizationInfo classActualizationInfo;

        public Result(@NotNull Map<IrSymbol, IrSymbol> expectToActualMap, @NotNull ClassActualizationInfo classActualizationInfo) {
            Intrinsics.checkNotNullParameter(expectToActualMap, (String)"expectToActualMap");
            Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
            this.expectToActualMap = expectToActualMap;
            this.classActualizationInfo = classActualizationInfo;
        }

        @NotNull
        public final Map<IrSymbol, IrSymbol> getExpectToActualMap() {
            return this.expectToActualMap;
        }

        @NotNull
        public final ClassActualizationInfo getClassActualizationInfo() {
            return this.classActualizationInfo;
        }

        @NotNull
        public final Map<IrSymbol, IrSymbol> component1() {
            return this.expectToActualMap;
        }

        @NotNull
        public final ClassActualizationInfo component2() {
            return this.classActualizationInfo;
        }

        @NotNull
        public final Result copy(@NotNull Map<IrSymbol, IrSymbol> expectToActualMap, @NotNull ClassActualizationInfo classActualizationInfo) {
            Intrinsics.checkNotNullParameter(expectToActualMap, (String)"expectToActualMap");
            Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
            return new Result(expectToActualMap, classActualizationInfo);
        }

        public static /* synthetic */ Result copy$default(Result result2, Map map, ClassActualizationInfo classActualizationInfo, int n, Object object) {
            if ((n & 1) != 0) {
                map = result2.expectToActualMap;
            }
            if ((n & 2) != 0) {
                classActualizationInfo = result2.classActualizationInfo;
            }
            return result2.copy(map, classActualizationInfo);
        }

        @NotNull
        public String toString() {
            return "Result(expectToActualMap=" + this.expectToActualMap + ", classActualizationInfo=" + this.classActualizationInfo + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.expectToActualMap).hashCode();
            result2 = result2 * 31 + this.classActualizationInfo.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.expectToActualMap, result2.expectToActualMap)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.classActualizationInfo, (Object)result2.classActualizationInfo);
        }
    }
}

