/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CliJavaModuleUtilsKt;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRootBase;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootBase;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CliJavaModuleFinder;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u0001:\u0003BCDBg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J$\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J2\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002J\u0014\u0010,\u001a\u00020'2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0007J\u001e\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u000201\u0018\u0001002\u0006\u00102\u001a\u00020\fH\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\"2\u0006\u00102\u001a\u00020\fH\u0002J\u001a\u00104\u001a\u0004\u0018\u0001052\u0006\u00102\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0010H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\fH\u0002J$\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\b2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010?\u001a\u0004\u0018\u00010\f2\u0006\u00102\u001a\u00020\f2\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080AH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver;", "", "psiManager", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiManager;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "additionalModules", "", "", "contentRootToVirtualFile", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRootBase;", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "javaModuleFinder", "Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;", "requireStdlibModule", "", "outputDirectory", "javaFileManager", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "jdkRelease", "", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;ZLcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;Ljava/lang/Integer;)V", "javaModuleGraph", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "getJavaModuleGraph", "()Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "Ljava/lang/Integer;", "searchScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "addModularRoots", "", "modules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "result", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "computeRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "javaSourceRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "jvmClasspathRoots", "jvmModulePathRoots", "convertClasspathRoots", "contentRoots", "Lorg/jetbrains/kotlin/cli/common/config/ContentRoot;", "findSourceModuleInfo", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiJavaModule;", "root", "modularBinaryRoot", "modularSourceRoot", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "hasOutputDirectoryInClasspath", "readManifestAttributes", "Ljava/util/jar/Attributes;", "jarRoot", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "file", "tryLoadVersionSpecificModuleInfo", "manifest", "Lkotlin/Lazy;", "Companion", "RootWithPrefix", "RootsAndModules", "cli-base"})
@SourceDebugExtension(value={"SMAP\nClasspathRootsResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathRootsResolver.kt\norg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1747#2,3:315\n1045#2:332\n800#2,11:334\n766#2:345\n857#2,2:346\n1549#2:348\n1620#2,3:349\n1747#2,3:352\n3133#3,11:318\n3792#3:329\n4307#3,2:330\n1#4:333\n*S KotlinDebug\n*F\n+ 1 ClasspathRootsResolver.kt\norg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver\n*L\n116#1:315,3\n205#1:332\n225#1:334,11\n225#1:345\n225#1:346,2\n262#1:348\n262#1:349,3\n267#1:352,3\n147#1:318,11\n202#1:329\n202#1:330,2\n*E\n"})
public final class ClasspathRootsResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiManager psiManager;
    @Nullable
    private final MessageCollector messageCollector;
    @NotNull
    private final List<String> additionalModules;
    @NotNull
    private final Function1<JvmContentRootBase, VirtualFile> contentRootToVirtualFile;
    @NotNull
    private final CliJavaModuleFinder javaModuleFinder;
    private final boolean requireStdlibModule;
    @Nullable
    private final VirtualFile outputDirectory;
    @NotNull
    private final KotlinCliJavaFileManager javaFileManager;
    @Nullable
    private final Integer jdkRelease;
    @NotNull
    private final JavaModuleGraph javaModuleGraph;
    @NotNull
    private final GlobalSearchScope searchScope;
    @Deprecated
    @NotNull
    public static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";
    @Deprecated
    @NotNull
    public static final String IS_MULTI_RELEASE = "Multi-Release";

    public ClasspathRootsResolver(@NotNull PsiManager psiManager, @Nullable MessageCollector messageCollector, @NotNull List<String> additionalModules, @NotNull Function1<? super JvmContentRootBase, ? extends VirtualFile> contentRootToVirtualFile, @NotNull CliJavaModuleFinder javaModuleFinder, boolean requireStdlibModule, @Nullable VirtualFile outputDirectory, @NotNull KotlinCliJavaFileManager javaFileManager, @Nullable Integer jdkRelease) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        Intrinsics.checkNotNullParameter(additionalModules, (String)"additionalModules");
        Intrinsics.checkNotNullParameter(contentRootToVirtualFile, (String)"contentRootToVirtualFile");
        Intrinsics.checkNotNullParameter((Object)javaModuleFinder, (String)"javaModuleFinder");
        Intrinsics.checkNotNullParameter((Object)javaFileManager, (String)"javaFileManager");
        this.psiManager = psiManager;
        this.messageCollector = messageCollector;
        this.additionalModules = additionalModules;
        this.contentRootToVirtualFile = contentRootToVirtualFile;
        this.javaModuleFinder = javaModuleFinder;
        this.requireStdlibModule = requireStdlibModule;
        this.outputDirectory = outputDirectory;
        this.javaFileManager = javaFileManager;
        this.jdkRelease = jdkRelease;
        this.javaModuleGraph = new JavaModuleGraph(this.javaModuleFinder);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.psiManager.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        this.searchScope = globalSearchScope;
    }

    @NotNull
    public final JavaModuleGraph getJavaModuleGraph() {
        return this.javaModuleGraph;
    }

    @NotNull
    public final RootsAndModules convertClasspathRoots(@NotNull List<? extends ContentRoot> contentRoots) {
        Intrinsics.checkNotNullParameter(contentRoots, (String)"contentRoots");
        List javaSourceRoots = new ArrayList();
        List jvmClasspathRoots = new ArrayList();
        List jvmModulePathRoots = new ArrayList();
        for (ContentRoot contentRoot : contentRoots) {
            VirtualFile root2;
            if (!(contentRoot instanceof JvmContentRootBase) || (VirtualFile)this.contentRootToVirtualFile.invoke((Object)contentRoot) == null) continue;
            ContentRoot contentRoot2 = contentRoot;
            if (contentRoot2 instanceof JavaSourceRoot) {
                ((Collection)javaSourceRoots).add(new RootWithPrefix(root2, ((JavaSourceRoot)contentRoot).getPackagePrefix()));
                continue;
            }
            if (contentRoot2 instanceof JvmClasspathRootBase) {
                ((Collection)jvmClasspathRoots).add(root2);
                continue;
            }
            if (contentRoot2 instanceof JvmModulePathRoot) {
                ((Collection)jvmModulePathRoots).add(root2);
                continue;
            }
            throw new IllegalStateException(("Unknown root type: " + contentRoot).toString());
        }
        return this.computeRoots(javaSourceRoots, jvmClasspathRoots, jvmModulePathRoots);
    }

    /*
     * WARNING - void declaration
     */
    private final RootsAndModules computeRoots(List<RootWithPrefix> javaSourceRoots, List<? extends VirtualFile> jvmClasspathRoots, List<? extends VirtualFile> jvmModulePathRoots) {
        boolean bl;
        List modules2;
        List result2;
        block17: {
            result2 = new ArrayList();
            modules2 = new ArrayList();
            boolean hasOutputDirectoryInClasspath = CollectionsKt.contains((Iterable)jvmClasspathRoots, (Object)this.outputDirectory) || CollectionsKt.contains((Iterable)jvmModulePathRoots, (Object)this.outputDirectory);
            for (RootWithPrefix object : javaSourceRoots) {
                FqName fqName2;
                VirtualFile virtualFile2 = object.component1();
                String packagePrefix = object.component2();
                JavaModule.Explicit modularRoot = this.modularSourceRoot(virtualFile2, hasOutputDirectoryInClasspath);
                if (modularRoot != null) {
                    ((Collection)modules2).add(modularRoot);
                    continue;
                }
                Collection collection = result2;
                VirtualFile virtualFile3 = virtualFile2;
                JavaRoot.RootType rootType = JavaRoot.RootType.SOURCE;
                if (packagePrefix != null) {
                    Object object2;
                    void prefix;
                    JavaRoot.RootType rootType2 = rootType;
                    VirtualFile virtualFile4 = virtualFile3;
                    boolean bl2 = false;
                    if (FqNamesUtilKt.isValidJavaFqName((String)prefix)) {
                        object2 = new FqName((String)prefix);
                    } else {
                        Iterator iterator2;
                        Iterator it = iterator2 = null;
                        boolean bl3 = false;
                        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.STRONG_WARNING, "Invalid package prefix name is ignored: " + (String)prefix, null, 4, null);
                        object2 = iterator2;
                    }
                    FqName fqName3 = object2;
                    virtualFile3 = virtualFile4;
                    rootType = rootType2;
                    fqName2 = fqName3;
                } else {
                    fqName2 = null;
                }
                FqName fqName4 = fqName2;
                JavaRoot.RootType rootType3 = rootType;
                VirtualFile virtualFile5 = virtualFile3;
                collection.add(new JavaRoot(virtualFile5, rootType3, fqName4));
            }
            for (VirtualFile virtualFile6 : jvmClasspathRoots) {
                ((Collection)result2).add(new JavaRoot(virtualFile6, JavaRoot.RootType.BINARY, null, 4, null));
            }
            Iterable iterable = modules2;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    boolean bl3;
                    block16: {
                        JavaModule module2 = (JavaModule)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv2 = module2.getModuleRoots();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                JavaModule.Root it = (JavaModule.Root)element$iv2;
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)this.outputDirectory)) continue;
                                bl3 = true;
                                break block16;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean outputDirectoryAddedAsPartOfModule = bl;
        for (VirtualFile virtualFile7 : jvmModulePathRoots) {
            JavaModule module3;
            if (outputDirectoryAddedAsPartOfModule && Intrinsics.areEqual((Object)virtualFile7, (Object)this.outputDirectory) || (module3 = this.modularBinaryRoot(virtualFile7)) == null) continue;
            ((Collection)modules2).add(module3);
        }
        if (this.jdkRelease == null || this.jdkRelease >= 9) {
            this.addModularRoots(modules2, result2);
        } else {
            ((Collection)result2).add(new JavaRoot(this.javaModuleFinder.getNonModuleRoot().getFile(), JavaRoot.RootType.BINARY_SIG, null, 4, null));
        }
        return new RootsAndModules(result2, modules2);
    }

    private final Pair<VirtualFile, PsiJavaModule> findSourceModuleInfo(VirtualFile root2) {
        Object object;
        VirtualFile moduleInfoFile;
        block5: {
            VirtualFile virtualFile2 = root2.isDirectory() ? root2.findChild("module-info.java") : (Intrinsics.areEqual((Object)root2.getName(), (Object)"module-info.java") ? root2 : null);
            if (virtualFile2 == null) {
                return null;
            }
            moduleInfoFile = virtualFile2;
            PsiFile psiFile = this.psiManager.findFile(moduleInfoFile);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            PsiElement[] psiElementArray = psiFile2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$singleOrNull$iv = psiElementArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiJavaModule)) continue;
                if (found$iv) {
                    object = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : single$iv;
        }
        Object object2 = object;
        PsiJavaModule psiJavaModule = object2 instanceof PsiJavaModule ? (PsiJavaModule)object2 : null;
        if (psiJavaModule == null) {
            return null;
        }
        PsiJavaModule psiJavaModule2 = psiJavaModule;
        return TuplesKt.to((Object)moduleInfoFile, (Object)psiJavaModule2);
    }

    private final JavaModule.Explicit modularSourceRoot(VirtualFile root2, boolean hasOutputDirectoryInClasspath) {
        List list2;
        Pair<VirtualFile, PsiJavaModule> pair = this.findSourceModuleInfo(root2);
        if (pair == null) {
            return null;
        }
        Pair<VirtualFile, PsiJavaModule> pair2 = pair;
        VirtualFile moduleInfoFile = (VirtualFile)pair2.component1();
        PsiJavaModule psiJavaModule = (PsiJavaModule)pair2.component2();
        JavaModule.Root sourceRoot = new JavaModule.Root(root2, false, false, 4, null);
        if (hasOutputDirectoryInClasspath) {
            Object[] objectArray = new JavaModule.Root[2];
            objectArray[0] = sourceRoot;
            VirtualFile virtualFile2 = this.outputDirectory;
            Intrinsics.checkNotNull((Object)virtualFile2);
            objectArray[1] = new JavaModule.Root(virtualFile2, true, false, 4, null);
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.listOf((Object)sourceRoot);
        }
        List roots2 = list2;
        return new JavaModule.Explicit(JavaModuleInfo.Companion.create(psiJavaModule), roots2, moduleInfoFile, false, 8, null);
    }

    private final JavaModule modularBinaryRoot(VirtualFile root2) {
        VirtualFile moduleInfoFile;
        boolean isJar = Intrinsics.areEqual((Object)root2.getFileSystem().getProtocol(), (Object)"jar");
        Lazy manifest2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Attributes>(this, root2){
            final /* synthetic */ ClasspathRootsResolver this$0;
            final /* synthetic */ VirtualFile $root;
            {
                this.this$0 = $receiver;
                this.$root = $root;
                super(0);
            }

            @Nullable
            public final Attributes invoke() {
                return ClasspathRootsResolver.access$readManifestAttributes(this.this$0, this.$root);
            }
        }));
        VirtualFile virtualFile2 = root2.findChild("module-info.class");
        if (virtualFile2 == null) {
            virtualFile2 = isJar ? this.tryLoadVersionSpecificModuleInfo(root2, (Lazy<? extends Attributes>)manifest2) : null;
        }
        if ((moduleInfoFile = virtualFile2) != null) {
            JavaModuleInfo javaModuleInfo = JavaModuleInfo.Companion.read(moduleInfoFile, this.javaFileManager, this.searchScope);
            if (javaModuleInfo == null) {
                return null;
            }
            JavaModuleInfo moduleInfo2 = javaModuleInfo;
            return new JavaModule.Explicit(moduleInfo2, CollectionsKt.listOf((Object)new JavaModule.Root(root2, true, false, 4, null)), moduleInfoFile, false, 8, null);
        }
        if (isJar) {
            String automaticModuleName;
            List moduleRoot = CollectionsKt.listOf((Object)new JavaModule.Root(root2, true, false, 4, null));
            Attributes attributes2 = (Attributes)manifest2.getValue();
            String string2 = automaticModuleName = attributes2 != null ? attributes2.getValue(AUTOMATIC_MODULE_NAME) : null;
            if (automaticModuleName != null) {
                return new JavaModule.Automatic(automaticModuleName, moduleRoot);
            }
            File file2 = VfsUtilCore.virtualToIoFile(root2);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
            File originalFile = file2;
            String string3 = LightJavaModule.moduleName(FilesKt.getNameWithoutExtension((File)originalFile));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"moduleName(...)");
            String moduleName = string3;
            if (((CharSequence)moduleName).length() == 0) {
                VirtualFile virtualFile3 = VfsUtilCore.getVirtualFileForJar(root2);
                if (virtualFile3 == null) {
                    virtualFile3 = root2;
                }
                this.report(CompilerMessageSeverity.ERROR, "Cannot infer automatic module name for the file", virtualFile3);
                return null;
            }
            return new JavaModule.Automatic(moduleName, moduleRoot);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile tryLoadVersionSpecificModuleInfo(VirtualFile root2, Lazy<? extends Attributes> manifest2) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Boolean isMultiReleaseJar;
        VirtualFile virtualFile2 = root2.findChild("META-INF");
        if (virtualFile2 == null || (virtualFile2 = virtualFile2.findChild("versions")) == null) {
            return null;
        }
        VirtualFile versionsDir = virtualFile2;
        Object object = (Attributes)manifest2.getValue();
        Boolean bl = object != null && (object = ((Attributes)object).getValue(IS_MULTI_RELEASE)) != null ? Boolean.valueOf(StringsKt.equals((String)object, (String)"true", (boolean)true)) : (isMultiReleaseJar = null);
        if (!Intrinsics.areEqual(isMultiReleaseJar, (Object)true)) {
            return null;
        }
        VirtualFile[] virtualFileArray = versionsDir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            Integer version2 = StringsKt.toIntOrNull((String)string2);
            if (!(version2 != null && version2 >= 9)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List versions2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                it = (VirtualFile)b;
                Comparable comparable = Integer.valueOf(Integer.parseInt(string2));
                bl = false;
                String string3 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(Integer.parseInt(string3)));
            }
        });
        for (VirtualFile version3 : versions2) {
            VirtualFile file2;
            VirtualFile virtualFile3 = file2 = version3.findChild("module-info.class");
            if (virtualFile3 == null) continue;
            return virtualFile3;
        }
        return null;
    }

    private final Attributes readManifestAttributes(VirtualFile jarRoot) {
        Attributes attributes2;
        VirtualFile virtualFile2 = jarRoot.findChild("META-INF");
        VirtualFile manifestFile2 = virtualFile2 != null ? virtualFile2.findChild("MANIFEST.MF") : null;
        try {
            Attributes attributes3;
            Object object = manifestFile2;
            if (object != null && (object = ((VirtualFile)object).getInputStream()) != null) {
                Object p0 = object;
                boolean bl = false;
                attributes3 = new Manifest((InputStream)p0).getMainAttributes();
            } else {
                attributes3 = null;
            }
            attributes2 = attributes3;
        }
        catch (IOException e) {
            attributes2 = null;
        }
        return attributes2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addModularRoots(List<? extends JavaModule> modules2, List<JavaRoot> result2) {
        boolean bl;
        LinkedHashSet<String> allDependencies;
        JavaModule.Explicit sourceModule;
        block21: {
            List list2;
            void $this$filterTo$iv$iv;
            Iterator<Object> $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = modules2;
            boolean bl2 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JavaModule.Explicit)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean bl3 = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JavaModule p0 = (JavaModule)element$iv$iv;
                boolean bl22 = false;
                if (!p0.isSourceModule()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sourceModules = (List)destination$iv$iv;
            if (sourceModules.size() > 1) {
                for (JavaModule.Explicit explicit : sourceModules) {
                    this.report(CompilerMessageSeverity.ERROR, "Too many source module declarations found", explicit.getModuleInfoFile());
                }
                return;
            }
            for (JavaModule javaModule : modules2) {
                JavaModule existing = this.javaModuleFinder.findModule(javaModule.getName());
                if (existing == null) {
                    this.javaModuleFinder.addUserModule(javaModule);
                    continue;
                }
                if (Intrinsics.areEqual(javaModule.getModuleRoots(), existing.getModuleRoots())) continue;
                VirtualFile thisFile = ClasspathRootsResolver.addModularRoots$getRootFile(javaModule);
                VirtualFile existingFile = ClasspathRootsResolver.addModularRoots$getRootFile(existing);
                String string2 = existingFile == null ? "" : " at: " + existingFile.getPath();
                this.report(CompilerMessageSeverity.STRONG_WARNING, "The root is ignored because a module with the same name '" + javaModule.getName() + "' has been found earlier on the module path" + string2, thisFile);
            }
            if (SequencesKt.none(this.javaModuleFinder.getAllObservableModules())) {
                return;
            }
            sourceModule = (JavaModule.Explicit)CollectionsKt.singleOrNull((List)sourceModules);
            boolean bl4 = this.additionalModules.contains("ALL-MODULE-PATH");
            if (bl4 && sourceModule != null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "-Xadd-modules=ALL-MODULE-PATH can only be used when compiling the unnamed module", null, 4, null);
                return;
            }
            JavaModule.Explicit explicit = sourceModule;
            if (explicit != null) {
                list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)explicit.getName()), (Iterable)this.additionalModules);
            } else if (bl4) {
                Iterable $this$map$iv = modules2;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : iterable2) {
                    void p0;
                    JavaModule javaModule = (JavaModule)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl32 = false;
                    collection.add(p0.getName());
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = CollectionsKt.plus((Collection)CliJavaModuleUtilsKt.computeDefaultRootModules(this.javaModuleFinder), (Iterable)this.additionalModules);
            }
            List rootModules = list2;
            allDependencies = this.javaModuleGraph.getAllDependencies(rootModules);
            Iterable $this$any$iv = allDependencies;
            boolean bl5 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String moduleName = (String)element$iv;
                    boolean bl42 = false;
                    if (!(this.javaModuleFinder.findModule(moduleName) instanceof JavaModule.Automatic)) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        if (bl) {
            for (JavaModule javaModule : modules2) {
                if (!(javaModule instanceof JavaModule.Automatic)) continue;
                ((Collection)allDependencies).add(javaModule.getName());
            }
        }
        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.LOGGING, "Loading modules: " + allDependencies, null, 4, null);
        for (String string3 : allDependencies) {
            Intrinsics.checkNotNull((Object)string3);
            JavaModule module5 = this.javaModuleFinder.findModule(string3);
            if (module5 == null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "Module " + string3 + " cannot be found in the module graph", null, 4, null);
                continue;
            }
            result2.addAll((Collection<JavaRoot>)CliJavaModuleUtilsKt.getJavaModuleRoots(module5));
        }
        if (this.requireStdlibModule && sourceModule != null && !this.javaModuleGraph.reads(sourceModule.getName(), "kotlin.stdlib")) {
            this.report(CompilerMessageSeverity.ERROR, "The Kotlin standard library is not found in the module graph. Please ensure you have the 'requires kotlin.stdlib' clause in your module definition", sourceModule.getModuleInfoFile());
        }
    }

    private final void report(CompilerMessageSeverity severity, String message2, VirtualFile file2) {
        if (this.messageCollector == null) {
            throw new IllegalStateException((file2 != null ? file2.getPath() + ':' : "") + (Object)((Object)severity) + ": " + message2 + " (no MessageCollector configured)");
        }
        VirtualFile virtualFile2 = file2;
        this.messageCollector.report(severity, message2, virtualFile2 == null ? null : CompilerMessageLocation.Companion.create(MessageUtil.virtualFileToPath(virtualFile2)));
    }

    static /* synthetic */ void report$default(ClasspathRootsResolver classpathRootsResolver2, CompilerMessageSeverity compilerMessageSeverity, String string2, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 4) != 0) {
            virtualFile2 = null;
        }
        classpathRootsResolver2.report(compilerMessageSeverity, string2, virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile addModularRoots$getRootFile(JavaModule $this$addModularRoots_u24getRootFile) {
        VirtualFile virtualFile2;
        Object object = (JavaModule.Root)CollectionsKt.firstOrNull($this$addModularRoots_u24getRootFile.getModuleRoots());
        if (object != null && (object = ((JavaModule.Root)object).getFile()) != null) {
            Object it = object;
            boolean bl = false;
            virtualFile2 = VfsUtilCore.getVirtualFileForJar((VirtualFile)it);
            if (virtualFile2 == null) {
                void var1_1;
                virtualFile2 = var1_1;
            }
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    public static final /* synthetic */ Attributes access$readManifestAttributes(ClasspathRootsResolver $this, VirtualFile jarRoot) {
        return $this.readManifestAttributes(jarRoot);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$Companion;", "", "()V", "AUTOMATIC_MODULE_NAME", "", "IS_MULTI_RELEASE", "cli-base"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "", "root", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "packagePrefix", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getPackagePrefix", "()Ljava/lang/String;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "cli-base"})
    private static final class RootWithPrefix {
        @NotNull
        private final VirtualFile root;
        @Nullable
        private final String packagePrefix;

        public RootWithPrefix(@NotNull VirtualFile root2, @Nullable String packagePrefix) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            this.root = root2;
            this.packagePrefix = packagePrefix;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Nullable
        public final String getPackagePrefix() {
            return this.packagePrefix;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @Nullable
        public final String component2() {
            return this.packagePrefix;
        }

        @NotNull
        public final RootWithPrefix copy(@NotNull VirtualFile root2, @Nullable String packagePrefix) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            return new RootWithPrefix(root2, packagePrefix);
        }

        public static /* synthetic */ RootWithPrefix copy$default(RootWithPrefix rootWithPrefix, VirtualFile virtualFile2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = rootWithPrefix.root;
            }
            if ((n & 2) != 0) {
                string2 = rootWithPrefix.packagePrefix;
            }
            return rootWithPrefix.copy(virtualFile2, string2);
        }

        @NotNull
        public String toString() {
            return "RootWithPrefix(root=" + this.root + ", packagePrefix=" + this.packagePrefix + ')';
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + (this.packagePrefix == null ? 0 : this.packagePrefix.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootWithPrefix)) {
                return false;
            }
            RootWithPrefix rootWithPrefix = (RootWithPrefix)other;
            if (!Intrinsics.areEqual((Object)this.root, (Object)rootWithPrefix.root)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.packagePrefix, (Object)rootWithPrefix.packagePrefix);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "modules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "(Ljava/util/List;Ljava/util/List;)V", "getModules", "()Ljava/util/List;", "getRoots", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cli-base"})
    public static final class RootsAndModules {
        @NotNull
        private final List<JavaRoot> roots;
        @NotNull
        private final List<JavaModule> modules;

        public RootsAndModules(@NotNull List<JavaRoot> roots2, @NotNull List<? extends JavaModule> modules2) {
            Intrinsics.checkNotNullParameter(roots2, (String)"roots");
            Intrinsics.checkNotNullParameter(modules2, (String)"modules");
            this.roots = roots2;
            this.modules = modules2;
        }

        @NotNull
        public final List<JavaRoot> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> getModules() {
            return this.modules;
        }

        @NotNull
        public final List<JavaRoot> component1() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> component2() {
            return this.modules;
        }

        @NotNull
        public final RootsAndModules copy(@NotNull List<JavaRoot> roots2, @NotNull List<? extends JavaModule> modules2) {
            Intrinsics.checkNotNullParameter(roots2, (String)"roots");
            Intrinsics.checkNotNullParameter(modules2, (String)"modules");
            return new RootsAndModules(roots2, modules2);
        }

        public static /* synthetic */ RootsAndModules copy$default(RootsAndModules rootsAndModules, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = rootsAndModules.roots;
            }
            if ((n & 2) != 0) {
                list3 = rootsAndModules.modules;
            }
            return rootsAndModules.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "RootsAndModules(roots=" + this.roots + ", modules=" + this.modules + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.roots).hashCode();
            result2 = result2 * 31 + ((Object)this.modules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootsAndModules)) {
                return false;
            }
            RootsAndModules rootsAndModules = (RootsAndModules)other;
            if (!Intrinsics.areEqual(this.roots, rootsAndModules.roots)) {
                return false;
            }
            return Intrinsics.areEqual(this.modules, rootsAndModules.modules);
        }
    }
}

