/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactory;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirErrorReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStageRunner;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a0\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\"\u0010\u000f\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"createErrorReferenceWithErrorCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirErrorReferenceWithCandidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "resolutionContext", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "resolutionStageRunner", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStageRunner;", "createErrorReferenceWithExistingCandidate", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "createErrorCandidate", "fullyProcessCandidate", "", "resolve"})
public final class ErrorCandidateUtilsKt {
    @NotNull
    public static final FirErrorReferenceWithCandidate createErrorReferenceWithErrorCandidate(@NotNull CallInfo callInfo, @NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull ResolutionContext resolutionContext, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)resolutionContext, (String)"resolutionContext");
        Intrinsics.checkNotNullParameter((Object)resolutionStageRunner, (String)"resolutionStageRunner");
        return new FirErrorReferenceWithCandidate(source, callInfo.getName(), ErrorCandidateUtilsKt.createErrorCandidate(resolutionStageRunner, callInfo, resolutionContext, diagnostic), diagnostic);
    }

    @NotNull
    public static final FirErrorReferenceWithCandidate createErrorReferenceWithExistingCandidate(@NotNull Candidate candidate2, @NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull ResolutionContext resolutionContext, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)resolutionContext, (String)"resolutionContext");
        Intrinsics.checkNotNullParameter((Object)resolutionStageRunner, (String)"resolutionStageRunner");
        ErrorCandidateUtilsKt.fullyProcessCandidate(resolutionStageRunner, candidate2, resolutionContext);
        return new FirErrorReferenceWithCandidate(source, candidate2.getCallInfo().getName(), candidate2, diagnostic);
    }

    @NotNull
    public static final Candidate createErrorCandidate(@NotNull ResolutionStageRunner $this$createErrorCandidate, @NotNull CallInfo callInfo, @NotNull ResolutionContext resolutionContext, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$createErrorCandidate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        Intrinsics.checkNotNullParameter((Object)resolutionContext, (String)"resolutionContext");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Candidate candidate2 = new CandidateFactory(resolutionContext, callInfo).createErrorCandidate(callInfo, diagnostic);
        $this$createErrorCandidate.processCandidate(candidate2, resolutionContext, false);
        return candidate2;
    }

    public static final void fullyProcessCandidate(@NotNull ResolutionStageRunner $this$fullyProcessCandidate, @NotNull Candidate candidate2, @NotNull ResolutionContext resolutionContext) {
        Intrinsics.checkNotNullParameter((Object)$this$fullyProcessCandidate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)resolutionContext, (String)"resolutionContext");
        if (!CandidateKt.getFullyAnalyzed(candidate2)) {
            $this$fullyProcessCandidate.processCandidate(candidate2, resolutionContext, false);
        }
    }
}

