/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirGenerationKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.lightTree.converter.ConverterUtilKt;
import org.jetbrains.kotlin.fir.lightTree.fir.modifier.Modifier;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\fH\u00c6\u0003JC\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u000e\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "", "isVar", "", "entries", "", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "modifier", "Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/Modifier;", "(ZLjava/util/List;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/Modifier;)V", "getEntries", "()Ljava/util/List;", "getInitializer", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "()Z", "getModifier", "()Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/Modifier;", "getSource", "()Lorg/jetbrains/kotlin/KtSourceElement;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toFirDestructingDeclaration", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "toString", "", "light-tree2fir"})
public final class DestructuringDeclaration {
    private final boolean isVar;
    @NotNull
    private final List<FirVariable> entries;
    @NotNull
    private final FirExpression initializer;
    @NotNull
    private final KtSourceElement source;
    @NotNull
    private final Modifier modifier;

    public DestructuringDeclaration(boolean isVar, @NotNull List<? extends FirVariable> entries, @NotNull FirExpression initializer2, @NotNull KtSourceElement source2, @NotNull Modifier modifier) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        this.isVar = isVar;
        this.entries = entries;
        this.initializer = initializer2;
        this.source = source2;
        this.modifier = modifier;
    }

    public final boolean isVar() {
        return this.isVar;
    }

    @NotNull
    public final List<FirVariable> getEntries() {
        return this.entries;
    }

    @NotNull
    public final FirExpression getInitializer() {
        return this.initializer;
    }

    @NotNull
    public final KtSourceElement getSource() {
        return this.source;
    }

    @NotNull
    public final Modifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final FirExpression toFirDestructingDeclaration(@NotNull FirModuleData moduleData) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        FirProperty baseVariable2 = FirGenerationKt.generateTemporaryVariable$default(moduleData, this.source, SpecialNames.DESTRUCT, this.initializer, null, this.modifier.getAnnotations(), 16, null);
        return ConverterUtilKt.generateDestructuringBlock(moduleData, this, baseVariable2, true);
    }

    public final boolean component1() {
        return this.isVar;
    }

    @NotNull
    public final List<FirVariable> component2() {
        return this.entries;
    }

    @NotNull
    public final FirExpression component3() {
        return this.initializer;
    }

    @NotNull
    public final KtSourceElement component4() {
        return this.source;
    }

    @NotNull
    public final Modifier component5() {
        return this.modifier;
    }

    @NotNull
    public final DestructuringDeclaration copy(boolean isVar, @NotNull List<? extends FirVariable> entries, @NotNull FirExpression initializer2, @NotNull KtSourceElement source2, @NotNull Modifier modifier) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        return new DestructuringDeclaration(isVar, entries, initializer2, source2, modifier);
    }

    public static /* synthetic */ DestructuringDeclaration copy$default(DestructuringDeclaration destructuringDeclaration, boolean bl, List list2, FirExpression firExpression2, KtSourceElement ktSourceElement, Modifier modifier, int n, Object object) {
        if ((n & 1) != 0) {
            bl = destructuringDeclaration.isVar;
        }
        if ((n & 2) != 0) {
            list2 = destructuringDeclaration.entries;
        }
        if ((n & 4) != 0) {
            firExpression2 = destructuringDeclaration.initializer;
        }
        if ((n & 8) != 0) {
            ktSourceElement = destructuringDeclaration.source;
        }
        if ((n & 0x10) != 0) {
            modifier = destructuringDeclaration.modifier;
        }
        return destructuringDeclaration.copy(bl, list2, firExpression2, ktSourceElement, modifier);
    }

    @NotNull
    public String toString() {
        return "DestructuringDeclaration(isVar=" + this.isVar + ", entries=" + this.entries + ", initializer=" + this.initializer + ", source=" + this.source + ", modifier=" + this.modifier + ')';
    }

    public int hashCode() {
        int n = this.isVar ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + ((Object)this.entries).hashCode();
        result2 = result2 * 31 + this.initializer.hashCode();
        result2 = result2 * 31 + this.source.hashCode();
        result2 = result2 * 31 + this.modifier.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DestructuringDeclaration)) {
            return false;
        }
        DestructuringDeclaration destructuringDeclaration = (DestructuringDeclaration)other;
        if (this.isVar != destructuringDeclaration.isVar) {
            return false;
        }
        if (!Intrinsics.areEqual(this.entries, destructuringDeclaration.entries)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.initializer, (Object)destructuringDeclaration.initializer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.source, (Object)destructuringDeclaration.source)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.modifier, (Object)destructuringDeclaration.modifier);
    }
}

