/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ErrorTypesAreEqualToAnything;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00020\t\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0002\u00a8\u0006\f"}, d2={"asFlexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFlexible", "", "isNullabilityFlexible", "lowerIfFlexible", "Lorg/jetbrains/kotlin/types/SimpleType;", "singleBestRepresentative", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "upperIfFlexible", "descriptors"})
public final class FlexibleTypesKt {
    public static final boolean isFlexible(@NotNull KotlinType $this$isFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlexible, (String)"<this>");
        return $this$isFlexible.unwrap() instanceof FlexibleType;
    }

    @NotNull
    public static final FlexibleType asFlexibleType(@NotNull KotlinType $this$asFlexibleType) {
        Intrinsics.checkNotNullParameter((Object)$this$asFlexibleType, (String)"<this>");
        UnwrappedType unwrappedType = $this$asFlexibleType.unwrap();
        Intrinsics.checkNotNull((Object)unwrappedType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        return (FlexibleType)unwrappedType;
    }

    public static final boolean isNullabilityFlexible(@NotNull KotlinType $this$isNullabilityFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullabilityFlexible, (String)"<this>");
        UnwrappedType unwrappedType = $this$isNullabilityFlexible.unwrap();
        FlexibleType flexibleType = unwrappedType instanceof FlexibleType ? (FlexibleType)unwrappedType : null;
        if (flexibleType == null) {
            return false;
        }
        FlexibleType flexibility = flexibleType;
        return flexibility.getLowerBound().isMarkedNullable() != flexibility.getUpperBound().isMarkedNullable();
    }

    @Nullable
    public static final KotlinType singleBestRepresentative(@NotNull Collection<? extends KotlinType> $this$singleBestRepresentative) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter($this$singleBestRepresentative, (String)"<this>");
            if ($this$singleBestRepresentative.size() == 1) {
                return (KotlinType)CollectionsKt.first((Iterable)$this$singleBestRepresentative);
            }
            Iterable $this$firstOrNull$iv = $this$singleBestRepresentative;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    KotlinType candidate2 = (KotlinType)element$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = $this$singleBestRepresentative;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            KotlinType other = (KotlinType)element$iv2;
                            boolean bl3 = false;
                            if (Intrinsics.areEqual((Object)candidate2, (Object)other) || ErrorTypesAreEqualToAnything.INSTANCE.equalTypes(candidate2, other)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(@NotNull Collection<? extends TypeProjection> $this$singleBestRepresentative) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$singleBestRepresentative, (String)"<this>");
        if ($this$singleBestRepresentative.size() == 1) {
            return (TypeProjection)CollectionsKt.first((Iterable)$this$singleBestRepresentative);
        }
        Iterable $this$map$iv = $this$singleBestRepresentative;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProjectionKind());
        }
        Set projectionKinds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (projectionKinds.size() != 1) {
            return null;
        }
        Iterable $this$map$iv2 = $this$singleBestRepresentative;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getType());
        }
        KotlinType kotlinType = FlexibleTypesKt.singleBestRepresentative((List)destination$iv$iv2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType bestType = kotlinType;
        return new TypeProjectionImpl((Variance)((Object)CollectionsKt.single((Iterable)projectionKinds)), bestType);
    }

    @NotNull
    public static final SimpleType lowerIfFlexible(@NotNull KotlinType $this$lowerIfFlexible) {
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter((Object)$this$lowerIfFlexible, (String)"<this>");
        UnwrappedType $this$lowerIfFlexible_u24lambda_u244 = $this$lowerIfFlexible.unwrap();
        boolean bl = false;
        UnwrappedType unwrappedType = $this$lowerIfFlexible_u24lambda_u244;
        if (unwrappedType instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$this$lowerIfFlexible_u24lambda_u244).getLowerBound();
        } else if (unwrappedType instanceof SimpleType) {
            simpleType2 = (SimpleType)$this$lowerIfFlexible_u24lambda_u244;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }

    @NotNull
    public static final SimpleType upperIfFlexible(@NotNull KotlinType $this$upperIfFlexible) {
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter((Object)$this$upperIfFlexible, (String)"<this>");
        UnwrappedType $this$upperIfFlexible_u24lambda_u245 = $this$upperIfFlexible.unwrap();
        boolean bl = false;
        UnwrappedType unwrappedType = $this$upperIfFlexible_u24lambda_u245;
        if (unwrappedType instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$this$upperIfFlexible_u24lambda_u245).getUpperBound();
        } else if (unwrappedType instanceof SimpleType) {
            simpleType2 = (SimpleType)$this$upperIfFlexible_u24lambda_u245;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }
}

