/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrCompileTimeChecker;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t\u0012\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\u0014\u0010\u001f\u001a\u00020\u0016*\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\u0016*\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0014\u0010$\u001a\u00020\u0016*\u00020\u00162\u0006\u0010%\u001a\u00020!H\u0002J\f\u0010&\u001a\u00020'*\u00020'H\u0002J\u0014\u0010(\u001a\u00020\u0016*\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/IrConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "onWarning", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "transformAnnotations", "annotationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "convertToConstIfPossible", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "reportIfError", "original", "transformSingleArg", "expectedType", "transformVarArg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "warningIfError", "ir.interpreter"})
public final class IrConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final EvaluationMode mode;
    @NotNull
    private final Function2<IrElement, IrErrorExpression, Unit> onWarning;
    @NotNull
    private final Function2<IrElement, IrErrorExpression, Unit> onError;

    public IrConstTransformer(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull Function2<? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function2<? super IrElement, ? super IrErrorExpression, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.interpreter = interpreter2;
        this.irFile = irFile;
        this.mode = mode;
        this.onWarning = onWarning;
        this.onError = onError;
    }

    public /* synthetic */ IrConstTransformer(IrInterpreter irInterpreter, IrFile irFile, EvaluationMode evaluationMode, Function2 function2, Function2 function22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = 2.INSTANCE;
        }
        this(irInterpreter, irFile, evaluationMode, (Function2<? super IrElement, ? super IrErrorExpression, Unit>)function2, (Function2<? super IrElement, ? super IrErrorExpression, Unit>)function22);
    }

    private final IrExpression warningIfError(IrExpression $this$warningIfError, IrExpression original) {
        if ($this$warningIfError instanceof IrErrorExpression) {
            this.onWarning.invoke((Object)original, (Object)$this$warningIfError);
            return original;
        }
        return $this$warningIfError;
    }

    private final IrExpression reportIfError(IrExpression $this$reportIfError, IrExpression original) {
        if ($this$reportIfError instanceof IrErrorExpression) {
            this.onError.invoke((Object)original, (Object)$this$reportIfError);
            return WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()] == 1 ? (IrExpression)IrConstImpl.Companion.constNull($this$reportIfError.getStartOffset(), $this$reportIfError.getEndOffset(), $this$reportIfError.getType()) : original;
        }
        return $this$reportIfError;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (((Boolean)expression2.accept(new IrCompileTimeChecker(null, this.mode, 1, null), null)).booleanValue()) {
            return this.warningIfError(this.interpreter.interpret(expression2, this.irFile), expression2);
        }
        return super.visitCall(expression2);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration) {
        boolean isConst;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        IrExpressionBody initializer2 = declaration.getInitializer();
        IrElementBase irElementBase = initializer2;
        if (irElementBase == null || (irElementBase = ((IrExpressionBody)irElementBase).getExpression()) == null) {
            return declaration;
        }
        IrElementBase expression2 = irElementBase;
        if (expression2 instanceof IrConst) {
            return declaration;
        }
        Object object = declaration.getCorrespondingPropertySymbol();
        boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : (isConst = false);
        if (isConst && ((Boolean)expression2.accept(new IrCompileTimeChecker(declaration, this.mode), null)).booleanValue()) {
            IrExpression result2 = this.interpreter.interpret((IrExpression)expression2, this.irFile);
            initializer2.setExpression(this.reportIfError(result2, (IrExpression)expression2));
        }
        return super.visitField(declaration);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        return super.visitDeclaration(declaration);
    }

    private final void transformAnnotations(IrAnnotationContainer annotationContainer) {
        Iterable $this$forEach$iv = annotationContainer.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation2 = (IrConstructorCall)element$iv;
            boolean bl = false;
            this.transformAnnotation(annotation2);
        }
    }

    private final void transformAnnotation(IrConstructorCall annotation2) {
        int n = annotation2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression arg;
            if (annotation2.getValueArgument(i) == null) continue;
            if (arg instanceof IrVararg) {
                annotation2.putValueArgument(i, this.transformVarArg((IrVararg)arg));
                continue;
            }
            annotation2.putValueArgument(i, this.transformSingleArg(arg, ((IrConstructor)annotation2.getSymbol().getOwner()).getValueParameters().get(i).getType()));
        }
    }

    private final IrVararg transformVarArg(IrVararg $this$transformVarArg) {
        if ($this$transformVarArg.getElements().isEmpty()) {
            return $this$transformVarArg;
        }
        IrVarargImpl newIrVararg = new IrVarargImpl($this$transformVarArg.getStartOffset(), $this$transformVarArg.getEndOffset(), $this$transformVarArg.getType(), $this$transformVarArg.getVarargElementType());
        for (IrVarargElement element : $this$transformVarArg.getElements()) {
            IrVarargElement irVarargElement = element;
            if (irVarargElement instanceof IrExpression) {
                IrExpressionsKt.addElement(newIrVararg, this.transformSingleArg((IrExpression)element, $this$transformVarArg.getVarargElementType()));
                continue;
            }
            if (!(irVarargElement instanceof IrSpreadElement)) continue;
            IrExpression expression2 = ((IrSpreadElement)element).getExpression();
            if (expression2 instanceof IrVararg) {
                Iterable $this$forEach$iv = this.transformVarArg((IrVararg)expression2).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, it);
                }
                continue;
            }
            IrExpressionsKt.addElement(newIrVararg, this.transformSingleArg(expression2, $this$transformVarArg.getVarargElementType()));
        }
        return newIrVararg;
    }

    private final IrExpression transformSingleArg(IrExpression $this$transformSingleArg, IrType expectedType) {
        if (((Boolean)$this$transformSingleArg.accept(new IrCompileTimeChecker(null, this.mode, 1, null), null)).booleanValue()) {
            IrExpression irExpression = this.reportIfError(this.interpreter.interpret($this$transformSingleArg, this.irFile), $this$transformSingleArg);
            return this.convertToConstIfPossible(irExpression, expectedType);
        }
        if ($this$transformSingleArg instanceof IrConstructorCall) {
            this.transformAnnotation((IrConstructorCall)$this$transformSingleArg);
        }
        return $this$transformSingleArg;
    }

    private final IrExpression convertToConstIfPossible(IrExpression $this$convertToConstIfPossible, IrType type2) {
        IrExpression irExpression;
        if (!($this$convertToConstIfPossible instanceof IrConst) || type2 instanceof IrErrorType) {
            irExpression = $this$convertToConstIfPossible;
        } else if (IrTypePredicatesKt.isArray(type2)) {
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)type2).getArguments()));
            Intrinsics.checkNotNull((Object)irType);
            irExpression = this.convertToConstIfPossible($this$convertToConstIfPossible, irType);
        } else {
            irExpression = UtilsKt.isPrimitiveArray(type2) ? this.convertToConstIfPossible($this$convertToConstIfPossible, $this$convertToConstIfPossible.getType()) : (IrExpression)IrTreeBuildUtilsKt.toIrConst(((IrConst)$this$convertToConstIfPossible).getValue(), type2, $this$convertToConstIfPossible.getStartOffset(), $this$convertToConstIfPossible.getEndOffset());
        }
        return irExpression;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EvaluationMode.values().length];
            try {
                nArray[EvaluationMode.ONLY_INTRINSIC_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

