/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathChangesComputerKt;
import org.jetbrains.kotlin.incremental.classpathDiff.ProgramSymbolSet;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J4\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u000eJ(\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/ImpactAnalysis;", "", "()V", "computeImpactedSetInclusive", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet;", "changes", "allClasses", "", "Lorg/jetbrains/kotlin/incremental/classpathDiff/AccessibleClassSnapshot;", "findImpactedClassesInclusive", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classIds", "impactedClassesResolver", "Lkotlin/Function1;", "getClassIdToSubclassesMap", "", "incremental-compilation-impl"})
public final class ImpactAnalysis {
    @NotNull
    public static final ImpactAnalysis INSTANCE = new ImpactAnalysis();

    private ImpactAnalysis() {
    }

    @NotNull
    public final ProgramSymbolSet computeImpactedSetInclusive(@NotNull ProgramSymbolSet changes, @NotNull Iterable<? extends AccessibleClassSnapshot> allClasses) {
        Set<String> memberNames;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter(allClasses, (String)"allClasses");
        Map<ClassId, Set<ClassId>> classIdToSubclasses = this.getClassIdToSubclassesMap(allClasses);
        Function1 impactedClassesResolver2 = (Function1)new Function1<ClassId, Set<? extends ClassId>>(classIdToSubclasses){
            final /* synthetic */ Map<ClassId, Set<ClassId>> $classIdToSubclasses;
            {
                this.$classIdToSubclasses = $classIdToSubclasses;
                super(1);
            }

            @NotNull
            public final Set<ClassId> invoke(@NotNull ClassId classId) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                Set set = this.$classIdToSubclasses.get(classId);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }
        };
        ProgramSymbolSet.Collector $this$computeImpactedSetInclusive_u24lambda_u241 = new ProgramSymbolSet.Collector();
        boolean bl = false;
        $this$computeImpactedSetInclusive_u24lambda_u241.addClasses((Collection<ClassId>)INSTANCE.findImpactedClassesInclusive(changes.getClasses(), (Function1<? super ClassId, ? extends Set<ClassId>>)impactedClassesResolver2));
        for (Map.Entry<ClassId, Set<String>> entry : changes.getClassMembers().entrySet()) {
            ClassId classId = entry.getKey();
            memberNames = entry.getValue();
            Iterable $this$forEach$iv = INSTANCE.findImpactedClassesInclusive(SetsKt.setOf((Object)classId), (Function1<? super ClassId, ? extends Set<ClassId>>)impactedClassesResolver2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassId impactedClassId = (ClassId)element$iv;
                boolean bl2 = false;
                $this$computeImpactedSetInclusive_u24lambda_u241.addClassMembers(impactedClassId, (Collection<String>)memberNames);
            }
        }
        for (Map.Entry<Object, Set<String>> entry : changes.getPackageMembers().entrySet()) {
            FqName packageFqName = (FqName)entry.getKey();
            memberNames = entry.getValue();
            $this$computeImpactedSetInclusive_u24lambda_u241.addPackageMembers(packageFqName, (Collection<String>)memberNames);
        }
        return $this$computeImpactedSetInclusive_u24lambda_u241.getResult();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ClassId, Set<ClassId>> getClassIdToSubclassesMap(Iterable<? extends AccessibleClassSnapshot> allClasses) {
        void $this$associateByTo$iv$iv;
        Map map;
        void destination$iv;
        Object item$iv22;
        void $this$mapTo$iv;
        Iterable<? extends AccessibleClassSnapshot> iterable = allClasses;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv22 : $this$mapTo$iv) {
            void it;
            AccessibleClassSnapshot accessibleClassSnapshot = (AccessibleClassSnapshot)item$iv22;
            map = destination$iv;
            boolean bl = false;
            map.add(it.getClassId());
        }
        Set classIds = (Set)destination$iv;
        Iterable $this$associateBy$iv = classIds;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        item$iv22 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean bl = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ClassId classId = (ClassId)element$iv$iv;
            map = destination$iv$iv;
            boolean bl2 = false;
            map.put(JvmClassName.byClassId((ClassId)it), element$iv$iv);
        }
        Map classNameToClassId = destination$iv$iv;
        Function1 classNameToClassIdResolver2 = (Function1)new Function1<JvmClassName, ClassId>((Map<JvmClassName, ClassId>)classNameToClassId){
            final /* synthetic */ Map<JvmClassName, ClassId> $classNameToClassId;
            {
                this.$classNameToClassId = $classNameToClassId;
                super(1);
            }

            @Nullable
            public final ClassId invoke(@NotNull JvmClassName className2) {
                Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
                return this.$classNameToClassId.get(className2);
            }
        };
        Map classIdToSubclasses = new LinkedHashMap();
        Iterable<? extends AccessibleClassSnapshot> $this$forEach$iv = allClasses;
        boolean $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            AccessibleClassSnapshot classSnapshot = (AccessibleClassSnapshot)e;
            boolean bl3 = false;
            Iterable $this$forEach$iv2 = CollectionsKt.intersect((Iterable)ClasspathChangesComputerKt.getSupertypes(classSnapshot, (Function1<? super JvmClassName, ClassId>)classNameToClassIdResolver2), (Iterable)classIds);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                ClassId supertype2 = (ClassId)element$iv2;
                boolean bl2 = false;
                Map $this$getOrPut$iv = classIdToSubclasses;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(supertype2);
                if (value$iv == null) {
                    boolean bl32 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(supertype2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(classSnapshot.getClassId());
            }
        }
        return classIdToSubclasses;
    }

    @NotNull
    public final Set<ClassId> findImpactedClassesInclusive(@NotNull Set<ClassId> classIds, @NotNull Function1<? super ClassId, ? extends Set<ClassId>> impactedClassesResolver2) {
        Intrinsics.checkNotNullParameter(classIds, (String)"classIds");
        Intrinsics.checkNotNullParameter(impactedClassesResolver2, (String)"impactedClassesResolver");
        Set visitedAndToVisitClasses = CollectionsKt.toMutableSet((Iterable)classIds);
        ArrayDeque classesToVisit = new ArrayDeque(classIds);
        while (!((Collection)classesToVisit).isEmpty()) {
            ClassId classToVisit = (ClassId)classesToVisit.removeFirst();
            Intrinsics.checkNotNullExpressionValue((Object)classToVisit, (String)"classToVisit");
            Set nextClassesToVisit = SetsKt.minus((Set)((Set)impactedClassesResolver2.invoke((Object)classToVisit)), (Iterable)visitedAndToVisitClasses);
            visitedAndToVisitClasses.addAll(nextClassesToVisit);
            classesToVisit.addAll(nextClassesToVisit);
        }
        return visitedAndToVisitClasses;
    }
}

