/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteListIterator;

public final class ByteIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public static int unwrap(ByteIterator i, byte[] array2, int offset2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset2 < 0 || offset2 + max > array2.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            array2[offset2++] = i.nextByte();
        }
        return max - j - 1;
    }

    public static int unwrap(ByteIterator i, byte[] array2) {
        return ByteIterators.unwrap(i, array2, 0, array2.length);
    }

    public static class EmptyIterator
    implements ByteListIterator,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public byte nextByte() {
            throw new NoSuchElementException();
        }

        @Override
        public byte previousByte() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }
    }
}

