/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.codegen.AnnotationCodegenKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010*\u00020\u000bH\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols$JavaAnnotations;", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "generateDocumentedAnnotation", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateRepeatableAnnotation", "generateRetentionAnnotation", "generateTargetAnnotation", "loadAnnotationTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "targetEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "lower", "applicableTargetSet", "getValueArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "name", "Lorg/jetbrains/kotlin/name/Name;", "backend.jvm"})
final class AdditionalClassAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final JvmSymbols.JavaAnnotations symbols;

    public AdditionalClassAnnotationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.symbols = this.context.getIr().getSymbols().getJavaAnnotations();
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        if (!IrUtilsKt.isAnnotationClass(irClass2)) {
            return;
        }
        this.generateDocumentedAnnotation(irClass2);
        this.generateRetentionAnnotation(irClass2);
        this.generateTargetAnnotation(irClass2);
        this.generateRepeatableAnnotation(irClass2);
    }

    private final void generateDocumentedAnnotation(IrClass irClass2) {
        Object object;
        block3: {
            block2: {
                if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irClass2, StandardNames.FqNames.mustBeDocumented)) break block2;
                IrAnnotationContainer irAnnotationContainer = irClass2;
                object = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DOCUMENTED_ANNOTATION");
                if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, (FqName)object)) break block3;
            }
            return;
        }
        object = irClass2;
        object.setAnnotations(CollectionsKt.plus((Collection)object.getAnnotations(), (Object)IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getDocumentedConstructor().getReturnType(), this.symbols.getDocumentedConstructor().getSymbol(), 0, null, 32, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRetentionAnnotation(IrClass irClass2) {
        void $this$generateRetentionAnnotation_u24lambda_u2d1;
        KotlinRetention kotlinRetention;
        IrEnumEntry irEnumEntry;
        IrAnnotationContainer irAnnotationContainer = irClass2;
        FqName fqName2 = JvmAnnotationNames.RETENTION_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"RETENTION_ANNOTATION");
        if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) {
            return;
        }
        KotlinRetention kotlinRetentionPolicy = AnnotationCodegenKt.getAnnotationRetention(irClass2);
        Object object = kotlinRetentionPolicy;
        if (object == null) {
            irEnumEntry = null;
        } else {
            KotlinRetention it = kotlinRetention = object;
            boolean bl = false;
            irEnumEntry = this.symbols.getAnnotationRetentionMap().get((Object)it);
        }
        IrDeclarationBase irDeclarationBase = irEnumEntry;
        IrEnumEntry javaRetentionPolicy = irDeclarationBase == null ? this.symbols.getRpRuntime() : irDeclarationBase;
        irDeclarationBase = irClass2;
        kotlinRetention = object = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getRetentionConstructor().getReturnType(), this.symbols.getRetentionConstructor().getSymbol(), 0, null, 32, null);
        Collection collection = irDeclarationBase.getAnnotations();
        IrDeclarationBase irDeclarationBase2 = irDeclarationBase;
        boolean bl = false;
        $this$generateRetentionAnnotation_u24lambda_u2d1.putValueArgument(0, new IrGetEnumValueImpl(-1, -1, IrUtilsKt.getDefaultType(this.symbols.getRetentionPolicyEnum()), javaRetentionPolicy.getSymbol()));
        Unit unit2 = Unit.INSTANCE;
        irDeclarationBase2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)object));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTargetAnnotation(IrClass irClass2) {
        void $this$generateTargetAnnotation_u24lambda_u2d4;
        IrConstructorCallImpl irConstructorCallImpl;
        void $this$sortedBy$iv;
        Iterable $this$mapNotNullTo$iv;
        IrAnnotationContainer irAnnotationContainer = irClass2;
        FqName fqName2 = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"TARGET_ANNOTATION");
        if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) {
            return;
        }
        Map<KotlinTarget, IrEnumEntry> annotationTargetMap = this.symbols.getAnnotationTargetMap(this.context.getState().getTarget());
        Set<KotlinTarget> set = this.applicableTargetSet(irClass2);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> targets = set;
        Iterable iterable = targets;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        IrConstructorCallImpl $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry irEnumEntry;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinTarget it = (KotlinTarget)((Object)element$iv);
            boolean bl2 = false;
            IrEnumEntry irEnumEntry2 = annotationTargetMap.get((Object)it);
            if (irEnumEntry2 == null) continue;
            IrEnumEntry it$iv = irEnumEntry = irEnumEntry2;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List javaTargets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IrEnumEntry it = (IrEnumEntry)a;
                boolean bl = false;
                String string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.symbol.owner.name.asString()");
                it = (IrEnumEntry)b;
                Comparable comparable = (Comparable)((Object)ElementType.valueOf(string2));
                bl = false;
                string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.symbol.owner.name.asString()");
                ElementType elementType = ElementType.valueOf(string2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)elementType)));
            }
        });
        Object object = new IrType[]{IrUtilsKt.getDefaultType(this.symbols.getElementTypeEnum())};
        IrVarargImpl vararg = new IrVarargImpl(-1, -1, IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), (IrType[])object), IrUtilsKt.getDefaultType(this.symbols.getElementTypeEnum()));
        for (IrEnumEntry target : javaTargets) {
            vararg.getElements().add(new IrGetEnumValueImpl(-1, -1, IrUtilsKt.getDefaultType(this.symbols.getElementTypeEnum()), target.getSymbol()));
        }
        object = irClass2;
        $this$forEach$iv$iv = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getTargetConstructor().getReturnType(), this.symbols.getTargetConstructor().getSymbol(), 0, null, 32, null);
        Collection collection = object.getAnnotations();
        Object object2 = object;
        boolean bl = false;
        $this$generateTargetAnnotation_u24lambda_u2d4.putValueArgument(0, vararg);
        Unit unit2 = Unit.INSTANCE;
        object2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCallImpl));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRepeatableAnnotation(IrClass irClass2) {
        void $this$generateRepeatableAnnotation_u24lambda_u2d6;
        IrConstructorCallImpl irConstructorCallImpl;
        IrConstructorCallImpl irConstructorCallImpl2;
        IrConstructorCallImpl single$iv;
        block7: {
            block9: {
                block8: {
                    if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irClass2, StandardNames.FqNames.repeatable)) break block8;
                    IrAnnotationContainer irAnnotationContainer = irClass2;
                    FqName fqName2 = JvmAnnotationNames.REPEATABLE_ANNOTATION;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"REPEATABLE_ANNOTATION");
                    if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) break block9;
                }
                return;
            }
            Iterable $this$singleOrNull$iv = irClass2.getDeclarations();
            boolean $i$f$singleOrNull = false;
            single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrClass && Intrinsics.areEqual((Object)((IrClass)it).getName().asString(), (Object)"Container"))) continue;
                if (found$iv) {
                    irConstructorCallImpl2 = null;
                    break block7;
                }
                single$iv = (IrConstructorCallImpl)element$iv;
                found$iv = true;
            }
            irConstructorCallImpl2 = !found$iv ? null : single$iv;
        }
        IrClass irClass3 = (IrClass)((Object)irConstructorCallImpl2);
        if (irClass3 == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Repeatable annotation class should have a container generated: ", (Object)RenderIrElementKt.render(irClass2)).toString());
        }
        IrClass containerClass = irClass3;
        Object object = new IrType[]{IrUtilsKt.getDefaultType(containerClass)};
        IrClassReferenceImpl containerReference = new IrClassReferenceImpl(-1, -1, IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getKClassClass(), (IrType[])object), containerClass.getSymbol(), IrUtilsKt.getDefaultType(containerClass));
        object = irClass2;
        single$iv = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getRepeatableConstructor().getReturnType(), this.symbols.getRepeatableConstructor().getSymbol(), 0, null, 32, null);
        Collection collection = object.getAnnotations();
        Object object2 = object;
        boolean bl = false;
        $this$generateRepeatableAnnotation_u24lambda_u2d6.putValueArgument(0, containerReference);
        Unit unit2 = Unit.INSTANCE;
        object2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCallImpl));
    }

    private final IrExpression getValueArgument(IrConstructorCall $this$getValueArgument, Name name) {
        Object v0;
        block2: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)((IrConstructor)$this$getValueArgument.getSymbol().getOwner()).getValueParameters();
            for (Object t : iterable2) {
                IrValueParameter it = (IrValueParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IrValueParameter irValueParameter = v0;
        if (irValueParameter == null) {
            return null;
        }
        int index2 = irValueParameter.getIndex();
        return $this$getValueArgument.getValueArgument(index2);
    }

    private final Set<KotlinTarget> applicableTargetSet(IrClass $this$applicableTargetSet) {
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$applicableTargetSet, StandardNames.FqNames.target);
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall targetEntry = irConstructorCall;
        return this.loadAnnotationTargets(targetEntry);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KotlinTarget> loadAnnotationTargets(IrConstructorCall targetEntry) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        IrVararg irVararg;
        Object object = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(Target::allowedTargets.name)");
        IrExpression irExpression = this.getValueArgument(targetEntry, (Name)object);
        IrVararg irVararg2 = irVararg = irExpression instanceof IrVararg ? (IrVararg)irExpression : null;
        if (irVararg == null) {
            return null;
        }
        IrVararg valueArgument = irVararg;
        Iterable $this$filterIsInstance$iv = valueArgument.getElements();
        boolean $i$f$filterIsInstance = false;
        object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrGetEnumValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget kotlinTarget;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrGetEnumValue it = (IrGetEnumValue)element$iv$iv;
            boolean bl2 = false;
            String string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.symbol.owner.name.asString()");
            KotlinTarget kotlinTarget2 = KotlinTarget.Companion.valueOrNull(string2);
            if (kotlinTarget2 == null) continue;
            KotlinTarget it$iv$iv = kotlinTarget = kotlinTarget2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

