/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J)\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 H\u0002\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010&\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J;\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\"\u0018\u00010!0 H\u0002\u00a2\u0006\u0002\u0010.J \u0010/\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u00100\u001a\u00020(H\u0002J5\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\"\u0018\u00010!0 H\u0002\u00a2\u0006\u0002\u00104J\u001e\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\"0+2\u0006\u00108\u001a\u00020\u0013H\u0002J1\u00109\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 H\u0002\u00a2\u0006\u0002\u0010:J5\u0010;\u001a\u0002062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\"\u0018\u00010!0 H\u0002\u00a2\u0006\u0002\u0010<J\u0010\u0010=\u001a\u00020>2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020A2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "adaptAreEqualIntrinsic", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedValueDescriptor;", "adaptAreEqualIntrinsicForInt", "adaptAreEqualIntrinsicForLong", "adaptBoxingInstruction", "adaptCastInstruction", "castWithType", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Pair;", "Lorg/jetbrains/org/objectweb/asm/Type;", "adaptInstruction", "adaptInstructionsForBoxedValue", "adaptInstructionsForBoxedValues", "values", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;", "adaptJavaLangComparableCompareTo", "adaptJavaLangComparableCompareToForDouble", "adaptJavaLangComparableCompareToForFloat", "adaptJavaLangComparableCompareToForInt", "adaptJavaLangComparableCompareToForLong", "adaptLocalVariableTableForBoxedValues", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "buildVariablesRemapping", "", "fuseAreEqualWithBranch", "ifEqualOpcode", "", "ifNotEqualOpcode", "getValuesStoredOrLoadedToVariable", "", "localVariableNode", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Ljava/util/List;", "ifEqual1Else0", "ifneOpcode", "interpretPopInstructionsForBoxedValues", "interpreter", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter;", "(Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "isUnsafeToRemoveBoxingForConnectedValues", "", "usedValues", "unboxedType", "removeValuesClashingWithVariables", "(Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "removeValuesClashingWithVariablesPass", "(Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Z", "throwCannotAdaptInstruction", "", "transform", "internalClassName", "", "backend"})
public final class RedundantBoxingMethodTransformer
extends MethodTransformer {
    @NotNull
    private final GenerationState generationState;

    public RedundantBoxingMethodTransformer(@NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.generationState = generationState;
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode node) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        InsnList insnList = node.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"node.instructions");
        RedundantBoxingInterpreter interpreter = new RedundantBoxingInterpreter(insnList, this.generationState);
        Frame<V>[] frameArray = MethodTransformer.analyze(internalClassName, node, interpreter);
        Intrinsics.checkNotNullExpressionValue(frameArray, (String)"analyze(internalClassName, node, interpreter)");
        Frame<V>[] frames2 = frameArray;
        this.interpretPopInstructionsForBoxedValues(interpreter, node, frames2);
        RedundantBoxedValuesCollection valuesToOptimize = interpreter.getCandidatesBoxedValues();
        if (!valuesToOptimize.isEmpty()) {
            this.removeValuesClashingWithVariables(valuesToOptimize, node, frames2);
            this.adaptLocalVariableTableForBoxedValues(node, frames2);
            UtilKt.remapLocalVariables(node, this.buildVariablesRemapping(valuesToOptimize, node));
            this.adaptInstructionsForBoxedValues(node, valuesToOptimize);
        }
    }

    private final void interpretPopInstructionsForBoxedValues(RedundantBoxingInterpreter interpreter, MethodNode node, Frame<BasicValue>[] frames2) {
        int n = 0;
        int n2 = frames2.length + -1;
        if (n <= n2) {
            do {
                BasicValue top;
                Frame<BasicValue> frame;
                int i;
                AbstractInsnNode insn;
                if ((insn = node.instructions.get(i = n++)).getOpcode() != 87 && insn.getOpcode() != 88 || (frame = frames2[i]) == null) continue;
                Frame<BasicValue> frame2 = frame;
                Intrinsics.checkNotNull((Object)StackTransformationUtilsKt.top(frame2));
                Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                interpreter.processPopInstruction(insn, top);
                if (top.getSize() != 1 || insn.getOpcode() != 88) continue;
                BasicValue basicValue = StackTransformationUtilsKt.peek(frame2, 1);
                Intrinsics.checkNotNull((Object)basicValue);
                interpreter.processPopInstruction(insn, basicValue);
            } while (n <= n2);
        }
    }

    private final void removeValuesClashingWithVariables(RedundantBoxedValuesCollection values2, MethodNode node, Frame<BasicValue>[] frames2) {
        while (this.removeValuesClashingWithVariablesPass(values2, node, frames2)) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeValuesClashingWithVariablesPass(RedundantBoxedValuesCollection values2, MethodNode node, Frame<BasicValue>[] frames2) {
        boolean needToRepeat = false;
        for (LocalVariableNode localVariableNode : node.localVariables) {
            BoxedValueDescriptor firstBoxed;
            void $this$filterIsInstanceTo$iv$iv;
            if (Type.getType(localVariableNode.desc).getSort() != 10) continue;
            Intrinsics.checkNotNullExpressionValue((Object)localVariableNode, (String)"localVariableNode");
            List<BasicValue> variableValues = this.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2);
            Iterable $this$filterIsInstance$iv = variableValues;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof BoxedBasicValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List boxed = (List)destination$iv$iv;
            if (boxed.isEmpty() || !this.isUnsafeToRemoveBoxingForConnectedValues(variableValues, (firstBoxed = ((BoxedBasicValue)CollectionsKt.first((List)boxed)).getDescriptor()).getUnboxedType())) continue;
            for (BoxedBasicValue value2 : boxed) {
                BoxedValueDescriptor descriptor2 = value2.getDescriptor();
                if (!descriptor2.isSafeToRemove()) continue;
                values2.remove(descriptor2);
                needToRepeat = true;
            }
        }
        return needToRepeat;
    }

    private final boolean isUnsafeToRemoveBoxingForConnectedValues(List<? extends BasicValue> usedValues, Type unboxedType) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = usedValues;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BoxedValueDescriptor descriptor2;
                    BasicValue input = (BasicValue)element$iv;
                    boolean bl2 = false;
                    if (!(input == StrictBasicValue.UNINITIALIZED_VALUE ? false : (!(input instanceof BoxedBasicValue) ? true : !(descriptor2 = ((BoxedBasicValue)input).getDescriptor()).isSafeToRemove() || !Intrinsics.areEqual((Object)descriptor2.getUnboxedType(), (Object)unboxedType)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void adaptLocalVariableTableForBoxedValues(MethodNode node, Frame<BasicValue>[] frames2) {
        for (LocalVariableNode localVariableNode : node.localVariables) {
            if (Type.getType(localVariableNode.desc).getSort() != 10) continue;
            Intrinsics.checkNotNullExpressionValue((Object)localVariableNode, (String)"localVariableNode");
            for (BasicValue value2 : this.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2)) {
                BoxedValueDescriptor descriptor2;
                if (!(value2 instanceof BoxedBasicValue) || !(descriptor2 = ((BoxedBasicValue)value2).getDescriptor()).isSafeToRemove()) continue;
                localVariableNode.desc = descriptor2.getUnboxedType().getDescriptor();
            }
        }
    }

    private final List<BasicValue> getValuesStoredOrLoadedToVariable(LocalVariableNode localVariableNode, MethodNode node, Frame<BasicValue>[] frames2) {
        ArrayList<BasicValue> values2 = new ArrayList<BasicValue>();
        InsnList insnList = node.instructions;
        int localVariableStart = insnList.indexOf(localVariableNode.start);
        int localVariableEnd = insnList.indexOf(localVariableNode.end);
        Frame<BasicValue> frame = frames2[localVariableStart];
        if (frame != null) {
            Frame<BasicValue> frame2 = frame;
            boolean bl = false;
            boolean bl2 = false;
            Frame<BasicValue> frameForStartInsn = frame2;
            boolean bl3 = false;
            BasicValue basicValue = frameForStartInsn.getLocal(localVariableNode.index);
            if (basicValue != null) {
                BasicValue basicValue2 = basicValue;
                boolean bl4 = false;
                boolean bl5 = false;
                BasicValue localVarValue = basicValue2;
                boolean bl6 = false;
                values2.add(localVarValue);
            }
        }
        int n = localVariableStart;
        if (n < localVariableEnd) {
            do {
                Frame<BasicValue> frame3;
                int i;
                if ((i = n++) < 0 || i >= insnList.size() || (frame3 = frames2[i]) == null) continue;
                Frame<BasicValue> frame4 = frame3;
                AbstractInsnNode insn = insnList.get(i);
                if (insn.getOpcode() != 58 && insn.getOpcode() != 25) continue;
                if (insn == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                }
                if (((VarInsnNode)insn).var != localVariableNode.index) continue;
                if (insn.getOpcode() == 58) {
                    BasicValue basicValue = StackTransformationUtilsKt.top(frame4);
                    Intrinsics.checkNotNull((Object)basicValue);
                    values2.add(basicValue);
                    continue;
                }
                values2.add(frame4.getLocal(((VarInsnNode)insn).var));
            } while (n < localVariableEnd);
        }
        return values2;
    }

    private final int[] buildVariablesRemapping(RedundantBoxedValuesCollection values2, MethodNode node) {
        HashSet doubleSizedVars = new HashSet();
        for (BoxedValueDescriptor valueDescriptor : values2) {
            if (!valueDescriptor.isDoubleSize()) continue;
            doubleSizedVars.addAll(valueDescriptor.getVariablesIndexes());
        }
        MethodNode methodNode = node;
        methodNode.maxLocals += doubleSizedVars.size();
        int n = 0;
        int[] remapping = new int[node.maxLocals];
        int n2 = remapping.length + -1;
        if (n <= n2) {
            do {
                int i;
                remapping[i] = i = n++;
            } while (n <= n2);
        }
        for (Integer varIndex : doubleSizedVars) {
            int i;
            int n3;
            int n4 = varIndex + 1;
            if (n4 > (n3 = ArraysKt.getLastIndex((int[])remapping))) continue;
            do {
                i = n4++;
                int[] nArray = remapping;
                int n5 = i;
                int n6 = nArray[n5];
                nArray[n5] = n6 + 1;
            } while (i != n3);
        }
        return remapping;
    }

    private final void adaptInstructionsForBoxedValues(MethodNode node, RedundantBoxedValuesCollection values2) {
        for (BoxedValueDescriptor value2 : values2) {
            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
            this.adaptInstructionsForBoxedValue(node, value2);
        }
    }

    private final void adaptInstructionsForBoxedValue(MethodNode node, BoxedValueDescriptor value2) {
        this.adaptBoxingInstruction(node, value2);
        for (Pair<AbstractInsnNode, Type> cast : value2.getUnboxingWithCastInsns()) {
            this.adaptCastInstruction(node, value2, cast);
        }
        for (AbstractInsnNode insn : value2.getAssociatedInsns()) {
            this.adaptInstruction(node, insn, value2);
        }
    }

    private final void adaptBoxingInstruction(MethodNode node, BoxedValueDescriptor value2) {
        if (!value2.isFromProgressionIterator()) {
            node.instructions.remove(value2.getBoxingInsn());
        } else {
            ProgressionIteratorBasicValue progressionIteratorBasicValue = value2.getProgressionIterator();
            if (progressionIteratorBasicValue == null) {
                String string2 = "iterator should not be null because isFromProgressionIterator returns true";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ProgressionIteratorBasicValue iterator2 = progressionIteratorBasicValue;
            node.instructions.insertBefore(value2.getBoxingInsn(), new TypeInsnNode(192, iterator2.getType().getInternalName()));
            node.instructions.set(value2.getBoxingInsn(), new MethodInsnNode(182, iterator2.getType().getInternalName(), iterator2.getNextMethodName(), iterator2.getNextMethodDesc(), false));
        }
    }

    private final void adaptCastInstruction(MethodNode node, BoxedValueDescriptor value2, Pair<AbstractInsnNode, Type> castWithType) {
        AbstractInsnNode castInsn = castWithType.getFirst();
        MethodNode castInsnsListener = new MethodNode(524288);
        new InstructionAdapter(castInsnsListener).cast(value2.getUnboxedType(), castWithType.getSecond());
        AbstractInsnNode[] abstractInsnNodeArray = castInsnsListener.instructions.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray, (String)"castInsnsListener.instructions.toArray()");
        for (AbstractInsnNode insn : abstractInsnNodeArray) {
            node.instructions.insertBefore(castInsn, insn);
        }
        node.instructions.remove(castInsn);
    }

    private final void adaptInstruction(MethodNode node, AbstractInsnNode insn, BoxedValueDescriptor value2) {
        boolean isDoubleSize = value2.isDoubleSize();
        int n = insn.getOpcode();
        switch (n) {
            case 87: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, new InsnNode(88));
                break;
            }
            case 89: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, new InsnNode(92));
                break;
            }
            case 25: 
            case 58: {
                int storeOpcode = value2.getUnboxedType().getOpcode(insn.getOpcode() == 58 ? 54 : 21);
                node.instructions.set(insn, new VarInsnNode(storeOpcode, ((VarInsnNode)insn).var));
                break;
            }
            case 193: {
                node.instructions.insertBefore(insn, new InsnNode(isDoubleSize ? 88 : 87));
                node.instructions.set(insn, new InsnNode(4));
                break;
            }
            case 184: {
                if (BoxingInterpreterKt.isAreEqualIntrinsic(insn)) {
                    this.adaptAreEqualIntrinsic(node, insn, value2);
                    break;
                }
                if (BoxingInterpreterKt.isJavaLangComparableCompareTo(insn)) {
                    this.adaptJavaLangComparableCompareTo(node, insn, value2);
                    break;
                }
                if (BoxingInterpreterKt.isJavaLangClassBoxing(insn) || BoxingInterpreterKt.isJavaLangClassUnboxing(insn)) {
                    node.instructions.remove(insn);
                    break;
                }
                this.throwCannotAdaptInstruction(insn);
                throw null;
            }
            case 185: {
                if (BoxingInterpreterKt.isJavaLangComparableCompareTo(insn)) {
                    this.adaptJavaLangComparableCompareTo(node, insn, value2);
                    break;
                }
                this.throwCannotAdaptInstruction(insn);
                throw null;
            }
            case 182: 
            case 192: {
                node.instructions.remove(insn);
                break;
            }
            default: {
                this.throwCannotAdaptInstruction(insn);
                throw null;
            }
        }
    }

    private final Void throwCannotAdaptInstruction(AbstractInsnNode insn) {
        throw new AssertionError((Object)Intrinsics.stringPlus((String)"Cannot adapt instruction: ", (Object)InlineCodegenUtilsKt.getInsnText(insn)));
    }

    private final void adaptAreEqualIntrinsic(MethodNode node, AbstractInsnNode insn, BoxedValueDescriptor value2) {
        Type unboxedType = value2.getUnboxedType();
        int n = unboxedType.getSort();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.adaptAreEqualIntrinsicForInt(node, insn);
                break;
            }
            case 7: {
                this.adaptAreEqualIntrinsicForLong(node, insn);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected unboxed type kind: ", (Object)unboxedType));
            }
        }
    }

    private final void adaptAreEqualIntrinsicForInt(MethodNode node, AbstractInsnNode insn) {
        InsnList insnList = node.instructions;
        boolean bl = false;
        boolean bl2 = false;
        InsnList $this$adaptAreEqualIntrinsicForInt_u24lambda_u2d3 = insnList;
        boolean bl3 = false;
        AbstractInsnNode next = insn.getNext();
        if (next != null && (next.getOpcode() == 153 || next.getOpcode() == 154)) {
            this.fuseAreEqualWithBranch(node, insn, 160, 159);
            $this$adaptAreEqualIntrinsicForInt_u24lambda_u2d3.remove(insn);
            $this$adaptAreEqualIntrinsicForInt_u24lambda_u2d3.remove(next);
        } else {
            this.ifEqual1Else0(node, insn, 160);
            $this$adaptAreEqualIntrinsicForInt_u24lambda_u2d3.remove(insn);
        }
    }

    private final void adaptAreEqualIntrinsicForLong(MethodNode node, AbstractInsnNode insn) {
        InsnList insnList = node.instructions;
        boolean bl = false;
        boolean bl2 = false;
        InsnList $this$adaptAreEqualIntrinsicForLong_u24lambda_u2d4 = insnList;
        boolean bl3 = false;
        $this$adaptAreEqualIntrinsicForLong_u24lambda_u2d4.insertBefore(insn, new InsnNode(148));
        AbstractInsnNode next = insn.getNext();
        if (next != null && (next.getOpcode() == 153 || next.getOpcode() == 154)) {
            this.fuseAreEqualWithBranch(node, insn, 154, 153);
            $this$adaptAreEqualIntrinsicForLong_u24lambda_u2d4.remove(insn);
            $this$adaptAreEqualIntrinsicForLong_u24lambda_u2d4.remove(next);
        } else {
            this.ifEqual1Else0(node, insn, 154);
            $this$adaptAreEqualIntrinsicForLong_u24lambda_u2d4.remove(insn);
        }
    }

    private final void fuseAreEqualWithBranch(MethodNode node, AbstractInsnNode insn, int ifEqualOpcode, int ifNotEqualOpcode) {
        InsnList insnList = node.instructions;
        boolean bl = false;
        boolean bl2 = false;
        InsnList $this$fuseAreEqualWithBranch_u24lambda_u2d6 = insnList;
        boolean bl3 = false;
        AbstractInsnNode next = insn.getNext();
        boolean bl4 = next instanceof JumpInsnNode;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl6 = false;
            String string2 = Intrinsics.stringPlus((String)"JumpInsnNode expected: ", (Object)next);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (next == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        LabelNode nextLabel = ((JumpInsnNode)next).label;
        if (next.getOpcode() == 153) {
            $this$fuseAreEqualWithBranch_u24lambda_u2d6.insertBefore(insn, new JumpInsnNode(ifEqualOpcode, nextLabel));
        } else if (next.getOpcode() == 154) {
            $this$fuseAreEqualWithBranch_u24lambda_u2d6.insertBefore(insn, new JumpInsnNode(ifNotEqualOpcode, nextLabel));
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"IFEQ or IFNE expected: ", (Object)InlineCodegenUtilsKt.getInsnOpcodeText(next)));
        }
    }

    private final void ifEqual1Else0(MethodNode node, AbstractInsnNode insn, int ifneOpcode) {
        InsnList insnList = node.instructions;
        boolean bl = false;
        boolean bl2 = false;
        InsnList $this$ifEqual1Else0_u24lambda_u2d7 = insnList;
        boolean bl3 = false;
        LabelNode lNotEqual = new LabelNode(new Label());
        LabelNode lDone = new LabelNode(new Label());
        $this$ifEqual1Else0_u24lambda_u2d7.insertBefore(insn, new JumpInsnNode(ifneOpcode, lNotEqual));
        $this$ifEqual1Else0_u24lambda_u2d7.insertBefore(insn, new InsnNode(4));
        $this$ifEqual1Else0_u24lambda_u2d7.insertBefore(insn, new JumpInsnNode(167, lDone));
        $this$ifEqual1Else0_u24lambda_u2d7.insertBefore(insn, lNotEqual);
        $this$ifEqual1Else0_u24lambda_u2d7.insertBefore(insn, new InsnNode(3));
        $this$ifEqual1Else0_u24lambda_u2d7.insertBefore(insn, lDone);
    }

    private final void adaptJavaLangComparableCompareTo(MethodNode node, AbstractInsnNode insn, BoxedValueDescriptor value2) {
        Type unboxedType = value2.getUnboxedType();
        int n = unboxedType.getSort();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.adaptJavaLangComparableCompareToForInt(node, insn);
                break;
            }
            case 7: {
                this.adaptJavaLangComparableCompareToForLong(node, insn);
                break;
            }
            case 6: {
                this.adaptJavaLangComparableCompareToForFloat(node, insn);
                break;
            }
            case 8: {
                this.adaptJavaLangComparableCompareToForDouble(node, insn);
                break;
            }
            default: {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected unboxed type kind: ", (Object)unboxedType));
            }
        }
    }

    private final void adaptJavaLangComparableCompareToForInt(MethodNode node, AbstractInsnNode insn) {
        InsnList insnList = node.instructions;
        boolean bl = false;
        boolean bl2 = false;
        InsnList $this$adaptJavaLangComparableCompareToForInt_u24lambda_u2d8 = insnList;
        boolean bl3 = false;
        AbstractInsnNode next = insn.getNext();
        AbstractInsnNode abstractInsnNode = next;
        AbstractInsnNode next2 = abstractInsnNode == null ? null : abstractInsnNode.getNext();
        if (next != null && next2 != null && next.getOpcode() == 3 && next2.getOpcode() >= 159 && next2.getOpcode() <= 164) {
            $this$adaptJavaLangComparableCompareToForInt_u24lambda_u2d8.remove(insn);
            $this$adaptJavaLangComparableCompareToForInt_u24lambda_u2d8.remove(next);
        } else if (next != null && next.getOpcode() >= 153 && next.getOpcode() <= 158) {
            LabelNode nextLabel = ((JumpInsnNode)next).label;
            int ifCmpOpcode = ((JumpInsnNode)next).getOpcode() - 153 + 159;
            $this$adaptJavaLangComparableCompareToForInt_u24lambda_u2d8.insertBefore(insn, new JumpInsnNode(ifCmpOpcode, nextLabel));
            $this$adaptJavaLangComparableCompareToForInt_u24lambda_u2d8.remove(insn);
            $this$adaptJavaLangComparableCompareToForInt_u24lambda_u2d8.remove(next);
        } else {
            $this$adaptJavaLangComparableCompareToForInt_u24lambda_u2d8.set(insn, new MethodInsnNode(184, "kotlin/jvm/internal/Intrinsics", "compare", "(II)I", false));
        }
    }

    private final void adaptJavaLangComparableCompareToForLong(MethodNode node, AbstractInsnNode insn) {
        node.instructions.set(insn, new InsnNode(148));
    }

    private final void adaptJavaLangComparableCompareToForFloat(MethodNode node, AbstractInsnNode insn) {
        node.instructions.set(insn, new MethodInsnNode(184, "java/lang/Float", "compare", "(FF)I", false));
    }

    private final void adaptJavaLangComparableCompareToForDouble(MethodNode node, AbstractInsnNode insn) {
        node.instructions.set(insn, new MethodInsnNode(184, "java/lang/Double", "compare", "(DD)I", false));
    }
}

