/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0002J6\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020$H\u0002J\u0018\u0010'\u001a\u0004\u0018\u00010(*\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020)H\u0002J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\u0017*\u0004\u0018\u00010\u000bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "", "additionalCheckers", "", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Ljava/lang/Iterable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkAnnotationEntry", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetList;", "checkEntries", "entries", "", "checkExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkPropertyUseSiteTargetAnnotations", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkSuperTypeAnnotations", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkTypeReference", "reference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isSuperType", "", "shouldCheckReferenceItself", "checkWithoutLanguageFeature", "getDefaultUseSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getImplicitUseSiteTargetList", "Companion", "frontend"})
public final class AnnotationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Iterable<AdditionalAnnotationChecker> additionalCheckers;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private static final Name TARGET_ALLOWED_TARGETS;

    public AnnotationChecker(@NotNull Iterable<? extends AdditionalAnnotationChecker> additionalCheckers, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(additionalCheckers, (String)"additionalCheckers");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.additionalCheckers = additionalCheckers;
        this.languageVersionSettings = languageVersionSettings;
    }

    public final void check(@NotNull KtAnnotated annotated, @NotNull BindingTrace trace, @Nullable DeclarationDescriptor descriptor2) {
        Object it;
        Object it2;
        boolean bl;
        boolean bl2;
        List<KtTypeParameter> list2;
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        KtElement ktElement = annotated;
        Object object = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
        Companion.TargetList actualTargets = Companion.getActualTargetList(ktElement, descriptor2, (BindingContext)object);
        object = annotated.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"annotated.annotationEntries");
        this.checkEntries((List<? extends KtAnnotationEntry>)object, actualTargets, trace, annotated);
        if (annotated instanceof KtProperty) {
            this.checkPropertyUseSiteTargetAnnotations((KtProperty)annotated, trace);
        }
        if (annotated instanceof KtClassOrObject) {
            this.checkSuperTypeAnnotations((KtClassOrObject)annotated, trace);
        }
        if (annotated instanceof KtCallableDeclaration) {
            object = ((KtCallableDeclaration)annotated).getTypeReference();
            if (object != null) {
                list2 = object;
                bl2 = false;
                bl = false;
                it2 = list2;
                boolean bl3 = false;
                AnnotationChecker.check$default(this, (KtAnnotated)it2, trace, null, 4, null);
            }
            object = ((KtCallableDeclaration)annotated).getReceiverTypeReference();
            if (object != null) {
                list2 = object;
                bl2 = false;
                bl = false;
                it2 = list2;
                boolean bl4 = false;
                AnnotationChecker.check$default(this, (KtAnnotated)it2, trace, null, 4, null);
            }
        }
        if (annotated instanceof KtTypeAlias && (object = ((KtTypeAlias)annotated).getTypeReference()) != null) {
            list2 = object;
            bl2 = false;
            bl = false;
            it2 = list2;
            boolean bl5 = false;
            AnnotationChecker.check$default(this, (KtAnnotated)it2, trace, null, 4, null);
        }
        if (annotated instanceof KtTypeParameterListOwner && (annotated instanceof KtCallableDeclaration || this.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions))) {
            Object object2;
            boolean bl6;
            object = ((KtTypeParameterListOwner)annotated).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(object, (String)"annotated.typeParameters");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (KtTypeParameter)element$iv;
                bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                AnnotationChecker.check$default(this, (KtAnnotated)it2, trace, null, 4, null);
            }
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)annotated).getTypeParameters()) {
                object2 = typeParameter.getExtendsBound();
                if (object2 == null) continue;
                Object element$iv = object2;
                boolean bl7 = false;
                bl6 = false;
                it = element$iv;
                boolean bl8 = false;
                AnnotationChecker.checkTypeReference$default(this, (KtTypeReference)it, trace, false, true, annotated instanceof KtCallableDeclaration, 4, null);
            }
            object = ((KtTypeParameterListOwner)annotated).getTypeConstraints().iterator();
            while (object.hasNext()) {
                KtTypeConstraint typeConstraint = object.next();
                object2 = typeConstraint.getBoundTypeReference();
                if (object2 == null) continue;
                Object element$iv = object2;
                boolean bl9 = false;
                bl6 = false;
                it = element$iv;
                boolean bl10 = false;
                AnnotationChecker.checkTypeReference$default(this, (KtTypeReference)it, trace, false, true, false, 20, null);
            }
        }
        if (annotated instanceof KtTypeReference) {
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions)) {
                AnnotationChecker.checkTypeReference$default(this, (KtTypeReference)annotated, trace, false, false, false, 28, null);
            } else {
                Object typeConstraint = ((KtTypeReference)annotated).getTypeElement();
                Object object3 = object = typeConstraint == null ? null : typeConstraint.getTypeArgumentsAsTypes();
                if (object != null && (typeConstraint = CollectionsKt.filterNotNull((Iterable)((Iterable)object))) != null) {
                    Iterable $this$forEach$iv = (Iterable)typeConstraint;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (KtTypeReference)element$iv;
                        boolean bl11 = false;
                        AnnotationChecker.check$default(this, (KtAnnotated)it, trace, null, 4, null);
                    }
                }
            }
        }
        if (annotated instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)annotated).getValueParameters()) {
                KtTypeReference ktTypeReference;
                if (parameter.hasValOrVar()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                AnnotationChecker.check$default(this, parameter, trace, null, 4, null);
                if (!(annotated instanceof KtFunctionLiteral) || (ktTypeReference = parameter.getTypeReference()) == null) continue;
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl12 = false;
                boolean bl13 = false;
                it = ktTypeReference2;
                boolean bl14 = false;
                AnnotationChecker.check$default(this, (KtAnnotated)it, trace, null, 4, null);
            }
        }
    }

    public static /* synthetic */ void check$default(AnnotationChecker annotationChecker, KtAnnotated ktAnnotated, BindingTrace bindingTrace, DeclarationDescriptor declarationDescriptor, int n, Object object) {
        if ((n & 4) != 0) {
            declarationDescriptor = null;
        }
        annotationChecker.check(ktAnnotated, bindingTrace, declarationDescriptor);
    }

    public final void checkExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        List<KtAnnotationEntry> list2 = KtPsiUtilKt.getAnnotationEntries(expression2);
        KtElement ktElement = expression2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        AnnotationChecker.checkEntries$default(this, list2, Companion.getActualTargetList(ktElement, null, bindingContext), trace, null, 8, null);
        if (expression2 instanceof KtLambdaExpression) {
            for (KtParameter parameter : ((KtLambdaExpression)expression2).getValueParameters()) {
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                if (ktTypeReference == null) continue;
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl = false;
                boolean bl2 = false;
                KtTypeReference it = ktTypeReference2;
                boolean bl3 = false;
                AnnotationChecker.check$default(this, it, trace, null, 4, null);
            }
        }
    }

    private final void checkPropertyUseSiteTargetAnnotations(KtProperty property2, BindingTrace trace) {
        KtParameter ktParameter;
        boolean reportError2 = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitRepeatedUseSiteTargetAnnotations);
        Pair[] pairArray = new Pair[3];
        KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
        pairArray[0] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER), AnnotationChecker.checkPropertyUseSiteTargetAnnotations$getDescriptors(ktPropertyAccessor == null ? null : ktPropertyAccessor.getAnnotationEntries(), trace));
        ktPropertyAccessor = property2.getSetter();
        pairArray[1] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER), AnnotationChecker.checkPropertyUseSiteTargetAnnotations$getDescriptors(ktPropertyAccessor == null ? null : ktPropertyAccessor.getAnnotationEntries(), trace));
        ktPropertyAccessor = property2.getSetter();
        pairArray[2] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.SETTER_PARAMETER), AnnotationChecker.checkPropertyUseSiteTargetAnnotations$getDescriptors(ktPropertyAccessor == null ? null : ((ktParameter = ktPropertyAccessor.getParameter()) == null ? null : ktParameter.getAnnotationEntries()), trace));
        Map propertyAnnotations = MapsKt.mapOf((Pair[])pairArray);
        for (KtAnnotationEntry entry : property2.getAnnotationEntries()) {
            SimpleDiagnostic<KtAnnotationEntry> existingAnnotations;
            AnnotationDescriptor annotationDescriptor;
            AnnotationDescriptor descriptor2;
            Object object = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
            if (object == null || (object = DescriptorUtilsKt.getAnnotationClass(descriptor2 = (annotationDescriptor = object))) == null) continue;
            Object classDescriptor = object;
            Object object2 = entry.getUseSiteTarget();
            AnnotationUseSiteTarget annotationUseSiteTarget = object2 == null ? null : ((KtAnnotationUseSiteTarget)object2).getAnnotationUseSiteTarget();
            AnnotationUseSiteTarget useSiteTarget = annotationUseSiteTarget == null ? this.getDefaultUseSiteTarget(property2, descriptor2) : annotationUseSiteTarget;
            Map map = propertyAnnotations;
            boolean bl = false;
            object2 = (List)map.get((Object)useSiteTarget);
            if (object2 == null || !(existingAnnotations = object2).contains(classDescriptor) || DescriptorUtilsKt.isRepeatableAnnotation((Annotated)classDescriptor)) continue;
            if (reportError2) {
                object2 = Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)entry));
                Intrinsics.checkNotNullExpressionValue(object2, (String)"REPEATED_ANNOTATION.on(entry)");
                DiagnosticUtilsKt.reportDiagnosticOnce(trace, (Diagnostic)object2);
                continue;
            }
            trace.report(Errors.REPEATED_ANNOTATION_WARNING.on((KtAnnotationEntry)((PsiElement)entry)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSuperTypeAnnotations(KtClassOrObject annotated, BindingTrace trace) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = annotated.getSuperTypeListEntries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtTypeReference ktTypeReference;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv$iv;
            boolean bl2 = false;
            if (it.getTypeReference() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            KtTypeReference it$iv$iv = ktTypeReference;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (KtTypeReference superType : (List)destination$iv$iv) {
            Intrinsics.checkNotNullExpressionValue((Object)superType, (String)"superType");
            AnnotationChecker.checkTypeReference$default(this, superType, trace, true, false, false, 24, null);
        }
    }

    private final void checkTypeReference(KtTypeReference reference, BindingTrace trace, boolean isSuperType, boolean shouldCheckReferenceItself, boolean checkWithoutLanguageFeature) {
        KtElement ktElement;
        Object actualTargets;
        boolean shouldRunCheck;
        boolean bl = shouldRunCheck = isSuperType || shouldCheckReferenceItself;
        if (shouldRunCheck) {
            for (KtAnnotationEntry entry : reference.getAnnotationEntries()) {
                KtElement ktElement2 = reference;
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                actualTargets = Companion.getActualTargetList(ktElement2, null, bindingContext);
                if (entry.getUseSiteTarget() != null && isSuperType) {
                    boolean reportError2 = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitUseSiteTargetAnnotationsOnSuperTypes);
                    SimpleDiagnostic<KtAnnotationEntry> simpleDiagnostic = reportError2 ? Errors.ANNOTATION_ON_SUPERCLASS.on((KtAnnotationEntry)((PsiElement)entry)) : Errors.ANNOTATION_ON_SUPERCLASS_WARNING.on((KtAnnotationEntry)((PsiElement)entry));
                    Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"if (reportError) {\n                        Errors.ANNOTATION_ON_SUPERCLASS.on(entry)\n                    } else {\n                        Errors.ANNOTATION_ON_SUPERCLASS_WARNING.on(entry)\n                    }");
                    SimpleDiagnostic<KtAnnotationEntry> diagnostic = simpleDiagnostic;
                    trace.report(diagnostic);
                    continue;
                }
                if (!shouldRunCheck || !this.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions) && !checkWithoutLanguageFeature) continue;
                this.checkAnnotationEntry(entry, (Companion.TargetList)actualTargets, trace);
            }
        }
        Object object = actualTargets = (ktElement = reference.getTypeElement()) == null ? null : ktElement.getTypeArgumentsAsTypes();
        if (actualTargets == null) {
            return;
        }
        Object object2 = actualTargets;
        List<KtTypeReference> typeArguments2 = object2;
        for (KtTypeReference typeArgument : typeArguments2) {
            ktElement = typeArgument;
            if (ktElement == null) continue;
            KtElement ktElement3 = ktElement;
            boolean bl2 = false;
            boolean bl3 = false;
            KtElement it = ktElement3;
            boolean bl4 = false;
            AnnotationChecker.checkTypeReference$default(this, (KtTypeReference)it, trace, false, true, false, 20, null);
        }
    }

    static /* synthetic */ void checkTypeReference$default(AnnotationChecker annotationChecker, KtTypeReference ktTypeReference, BindingTrace bindingTrace, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        annotationChecker.checkTypeReference(ktTypeReference, bindingTrace, bl, bl2, bl3);
    }

    private final List<AnnotationUseSiteTarget> getImplicitUseSiteTargetList(KtAnnotated $this$getImplicitUseSiteTargetList) {
        KtAnnotated ktAnnotated = $this$getImplicitUseSiteTargetList;
        return ktAnnotated instanceof KtParameter ? (((KtParameter)$this$getImplicitUseSiteTargetList).getOwnerFunction() instanceof KtPrimaryConstructor ? Companion.UseSiteTargetsList.INSTANCE.getT_CONSTRUCTOR_PARAMETER() : CollectionsKt.emptyList()) : (ktAnnotated instanceof KtProperty ? (!((KtProperty)$this$getImplicitUseSiteTargetList).isLocal() ? Companion.UseSiteTargetsList.INSTANCE.getT_PROPERTY() : CollectionsKt.emptyList()) : (ktAnnotated instanceof KtPropertyAccessor ? (((KtPropertyAccessor)$this$getImplicitUseSiteTargetList).isGetter() ? CollectionsKt.listOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER)) : CollectionsKt.listOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER))) : CollectionsKt.emptyList()));
    }

    private final AnnotationUseSiteTarget getDefaultUseSiteTarget(KtAnnotated $this$getDefaultUseSiteTarget, AnnotationDescriptor descriptor2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getImplicitUseSiteTargetList($this$getDefaultUseSiteTarget);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationUseSiteTarget it = (AnnotationUseSiteTarget)((Object)element$iv);
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)Companion.applicableTargetSet(descriptor2), (Object)((Object)KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)it)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void checkEntries(List<? extends KtAnnotationEntry> entries, Companion.TargetList actualTargets, BindingTrace trace, KtAnnotated annotated) {
        if (entries.isEmpty()) {
            return;
        }
        var6_5 = false;
        entryTypesWithAnnotations = new HashMap<K, V>();
        for (KtAnnotationEntry entry : entries) {
            block12: {
                this.checkAnnotationEntry(entry, actualTargets, trace);
                var10_11 = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
                if (var10_11 == null) continue;
                var9_10 = var10_11;
                descriptor = var9_10;
                if (descriptor instanceof LazyAnnotationDescriptor) {
                    ((LazyAnnotationDescriptor)descriptor).forceResolveAllContents();
                }
                if ((var10_11 = DescriptorUtilsKt.getAnnotationClass(descriptor)) == null) continue;
                classDescriptor = var10_11;
                var12_14 = entry.getUseSiteTarget();
                var11_12 = var12_14 == null ? null : var12_14.getAnnotationUseSiteTarget();
                useSiteTarget = var11_12 == null ? this.getDefaultUseSiteTarget(annotated, descriptor) : var11_12;
                var12_14 = entryTypesWithAnnotations;
                key$iv = descriptor.getType();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    $i$a$-getOrPut-AnnotationChecker$checkEntries$existingTargetsForAnnotation$1 = false;
                    var17_20 = false;
                    answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    v0 /* !! */  = answer$iv;
                } else {
                    v0 /* !! */  = value$iv;
                }
                if ((existingTargetsForAnnotation = (List)v0 /* !! */ ).contains((Object)useSiteTarget)) ** GOTO lbl-1000
                $this$any$iv = existingTargetsForAnnotation;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (AnnotationUseSiteTarget)element$iv;
                        $i$a$-any-AnnotationChecker$checkEntries$duplicateAnnotation$1 = false;
                        if (!(it == null != (useSiteTarget == null))) continue;
                        v1 = true;
                        break block12;
                    }
                    v1 = false;
                }
            }
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = duplicateAnnotation = false;
            }
            if (duplicateAnnotation && !DescriptorUtilsKt.isRepeatableAnnotation((Annotated)classDescriptor)) {
                trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)entry)));
            }
            existingTargetsForAnnotation.add(useSiteTarget);
        }
        for (AdditionalAnnotationChecker checker : this.additionalCheckers) {
            checker.checkEntries(entries, actualTargets.getDefaultTargets(), trace);
        }
    }

    static /* synthetic */ void checkEntries$default(AnnotationChecker annotationChecker, List list2, Companion.TargetList targetList2, BindingTrace bindingTrace, KtAnnotated ktAnnotated, int n, Object object) {
        if ((n & 8) != 0) {
            ktAnnotated = null;
        }
        annotationChecker.checkEntries(list2, targetList2, bindingTrace, ktAnnotated);
    }

    private final void checkAnnotationEntry(KtAnnotationEntry entry, Companion.TargetList actualTargets, BindingTrace trace) {
        AnnotationUseSiteTarget useSiteTarget;
        Set applicableTargets = AnnotationChecker.Companion.applicableTargetSet(entry, trace);
        Object object = entry.getUseSiteTarget();
        AnnotationUseSiteTarget annotationUseSiteTarget = useSiteTarget = object == null ? null : object.getAnnotationUseSiteTarget();
        if (AnnotationChecker.checkAnnotationEntry$check(applicableTargets, useSiteTarget, actualTargets.getDefaultTargets()) || AnnotationChecker.checkAnnotationEntry$check(applicableTargets, useSiteTarget, actualTargets.getCanBeSubstituted()) || AnnotationChecker.checkAnnotationEntry$checkWithUseSiteTargets(useSiteTarget, actualTargets, applicableTargets)) {
            AnnotationChecker.checkAnnotationEntry$checkUselessFunctionLiteralAnnotation(applicableTargets, entry, trace);
            return;
        }
        if (useSiteTarget != null) {
            String string2;
            object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
            trace.report(Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)entry), object == null ? "unidentified target" : ((string2 = ((KotlinTarget)((Object)object)).getDescription()) == null ? "unidentified target" : string2), useSiteTarget.getRenderName()));
        } else {
            String string3;
            object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
            trace.report(Errors.WRONG_ANNOTATION_TARGET.on((KtAnnotationEntry)((PsiElement)entry), object == null ? "unidentified target" : ((string3 = ((KotlinTarget)((Object)object)).getDescription()) == null ? "unidentified target" : string3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ClassDescriptor> checkPropertyUseSiteTargetAnnotations$getDescriptors(List<? extends KtAnnotationEntry> $this$checkPropertyUseSiteTargetAnnotations_u24getDescriptors, BindingTrace $trace) {
        List list2;
        List list3;
        List<? extends KtAnnotationEntry> list4 = $this$checkPropertyUseSiteTargetAnnotations_u24getDescriptors;
        if (list4 == null) {
            list3 = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list4;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ClassDescriptor classDescriptor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                boolean bl2 = false;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)$trace.get(BindingContext.ANNOTATION, it);
                if ((annotationDescriptor == null ? null : DescriptorUtilsKt.getAnnotationClass(annotationDescriptor)) == null) continue;
                classDescriptor = classDescriptor;
                boolean bl3 = false;
                boolean bl4 = false;
                ClassDescriptor it$iv$iv = classDescriptor;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list3 = (List)destination$iv$iv;
        }
        List list5 = list3;
        if (list5 == null) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        } else {
            list2 = list5;
        }
        return list2;
    }

    private static final boolean checkAnnotationEntry$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget, List<? extends KotlinTarget> targets) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget) == it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void checkAnnotationEntry$checkUselessFunctionLiteralAnnotation(Set<? extends KotlinTarget> applicableTargets, KtAnnotationEntry $entry, BindingTrace $trace) {
        KtLambdaExpression ktLambdaExpression;
        KotlinRetention retention;
        KtAnnotatedExpression ktAnnotatedExpression;
        if (!applicableTargets.contains((Object)KotlinTarget.FUNCTION)) {
            return;
        }
        Object object = $entry.getParent();
        KtAnnotatedExpression ktAnnotatedExpression2 = ktAnnotatedExpression = object instanceof KtAnnotatedExpression ? (KtAnnotatedExpression)object : null;
        if (ktAnnotatedExpression == null) {
            return;
        }
        KtAnnotatedExpression annotatedExpression = ktAnnotatedExpression;
        Object object2 = (AnnotationDescriptor)$trace.get(BindingContext.ANNOTATION, $entry);
        if (object2 == null) {
            return;
        }
        object = object2;
        Object descriptor2 = object;
        KotlinRetention kotlinRetention = retention = (object2 = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)descriptor2)) == null ? null : DescriptorUtilsKt.getAnnotationRetention((Annotated)object2);
        if (retention == KotlinRetention.SOURCE) {
            return;
        }
        KtExpression ktExpression = annotatedExpression.getBaseExpression();
        KtLambdaExpression ktLambdaExpression2 = ktLambdaExpression = ktExpression instanceof KtLambdaExpression ? (KtLambdaExpression)ktExpression : null;
        if (ktLambdaExpression == null) {
            return;
        }
        KtLambdaExpression functionLiteralExpression = ktLambdaExpression;
        if (InlineUtil.isInlinedArgument(functionLiteralExpression.getFunctionLiteral(), $trace.getBindingContext(), false)) {
            $trace.report(Errors.NON_SOURCE_ANNOTATION_ON_INLINED_LAMBDA_EXPRESSION.on((KtAnnotationEntry)((PsiElement)$entry)));
        }
    }

    private static final boolean checkAnnotationEntry$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget, Companion.TargetList $actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl;
        block4: {
            if (useSiteTarget == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget);
            Iterable $this$any$iv = $actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Set<KotlinTarget> applicableTargetSet(@NotNull AnnotationDescriptor descriptor2) {
        return Companion.applicableTargetSet(descriptor2);
    }

    static {
        Name name = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"allowedTargets\")");
        TARGET_ALLOWED_TARGETS = name;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u000bJ\u0016\u0010\u001b\u001a\u00020\u001c*\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion;", "", "()V", "TARGET_ALLOWED_TARGETS", "Lorg/jetbrains/kotlin/name/Name;", "applicableTargetSet", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getActualTargetList", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetList;", "annotated", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDeclarationSiteActualTargetList", "", "loadAnnotationTargets", "targetEntryDescriptor", "hasBackingField", "", "TargetList", "TargetLists", "UseSiteTargetsList", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<KotlinTarget> applicableTargetSet(KtAnnotationEntry entry, BindingTrace trace) {
            Set<KotlinTarget> set;
            Object object = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
            if (object == null) {
                return KotlinTarget.Companion.getDEFAULT_TARGET_SET();
            }
            Object object2 = object;
            AnnotationDescriptor descriptor2 = object2;
            if (KotlinTypeKt.isError(descriptor2.getType())) {
                return KotlinTarget.Companion.getALL_TARGET_SET();
            }
            object = DescriptorUtilsKt.getAnnotationClass(descriptor2);
            if (object == null) {
                set = null;
            } else {
                Object object3 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object p0 = object3;
                boolean bl3 = false;
                set = this.applicableTargetSet((ClassDescriptor)p0);
            }
            object2 = set;
            return object2 == null ? KotlinTarget.Companion.getDEFAULT_TARGET_SET() : object2;
        }

        @JvmStatic
        @NotNull
        public final Set<KotlinTarget> applicableTargetSet(@NotNull AnnotationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Set<KotlinTarget> set = DescriptorUtilsKt.getAnnotationClass(descriptor2);
            if (set == null) {
                return SetsKt.emptySet();
            }
            Set<KotlinTarget> classDescriptor = set;
            return (set = this.applicableTargetSet((ClassDescriptor)((Object)classDescriptor))) == null ? KotlinTarget.Companion.getDEFAULT_TARGET_SET() : set;
        }

        @Nullable
        public final Set<KotlinTarget> applicableTargetSet(@NotNull ClassDescriptor classDescriptor) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
            AnnotationDescriptor annotationDescriptor = classDescriptor.getAnnotations().findAnnotation(StandardNames.FqNames.target);
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor targetEntryDescriptor = annotationDescriptor;
            return this.loadAnnotationTargets(targetEntryDescriptor);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Set<KotlinTarget> loadAnnotationTargets(@NotNull AnnotationDescriptor targetEntryDescriptor) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            ArrayValue arrayValue;
            Intrinsics.checkNotNullParameter((Object)targetEntryDescriptor, (String)"targetEntryDescriptor");
            ConstantValue<?> constantValue = targetEntryDescriptor.getAllValueArguments().get(TARGET_ALLOWED_TARGETS);
            ArrayValue arrayValue2 = arrayValue = constantValue instanceof ArrayValue ? (ArrayValue)constantValue : null;
            if (arrayValue == null) {
                return null;
            }
            ArrayValue valueArgument = arrayValue;
            Iterable $this$filterIsInstance$iv = (Iterable)valueArgument.getValue();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof EnumValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinTarget kotlinTarget;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                EnumValue it = (EnumValue)element$iv$iv;
                boolean bl2 = false;
                String string2 = it.getEnumEntryName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.enumEntryName.asString()");
                if (KotlinTarget.Companion.valueOrNull(string2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                KotlinTarget it$iv$iv = kotlinTarget;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public final List<KotlinTarget> getDeclarationSiteActualTargetList(@NotNull KtElement annotated, @Nullable ClassDescriptor descriptor2, @NotNull BindingContext context2) {
            Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return this.getActualTargetList(annotated, descriptor2, context2).getDefaultTargets();
        }

        private final boolean hasBackingField(DeclarationDescriptor $this$hasBackingField, BindingContext context2) {
            Boolean bl;
            PropertyDescriptor propertyDescriptor;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor = $this$hasBackingField instanceof PropertyDescriptor ? (PropertyDescriptor)$this$hasBackingField : null;
            if (propertyDescriptor == null) {
                bl = false;
            } else {
                PropertyDescriptor propertyDescriptor3 = propertyDescriptor;
                boolean bl2 = false;
                boolean bl3 = false;
                PropertyDescriptor it = propertyDescriptor3;
                boolean bl4 = false;
                Boolean bl5 = (Boolean)context2.get(BindingContext.BACKING_FIELD_REQUIRED, it);
                bl = bl5 == null ? Boolean.valueOf(false) : bl5;
            }
            Boolean bl6 = bl;
            return bl6;
        }

        @NotNull
        public final TargetList getActualTargetList(@NotNull KtElement annotated, @Nullable DeclarationDescriptor descriptor2, @NotNull BindingContext context2) {
            TargetList targetList2;
            Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            KtElement ktElement = annotated;
            if (ktElement instanceof KtClassOrObject) {
                TargetList targetList3;
                ClassDescriptor classDescriptor;
                ClassDescriptor classDescriptor2 = classDescriptor = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                if (classDescriptor == null) {
                    targetList3 = null;
                } else {
                    ClassDescriptor classDescriptor3 = classDescriptor;
                    boolean bl = false;
                    boolean bl2 = false;
                    ClassDescriptor it = classDescriptor3;
                    boolean bl3 = false;
                    targetList3 = new TargetList(KotlinTarget.Companion.classActualTargets(it), null, null, 6, null);
                }
                TargetList targetList4 = targetList3;
                targetList2 = targetList4 == null ? TargetLists.INSTANCE.getT_CLASSIFIER() : targetList4;
            } else if (ktElement instanceof KtDestructuringDeclarationEntry) {
                targetList2 = TargetLists.INSTANCE.getT_LOCAL_VARIABLE();
            } else if (ktElement instanceof KtProperty) {
                targetList2 = ((KtProperty)annotated).isLocal() ? TargetLists.INSTANCE.getT_LOCAL_VARIABLE() : (((KtProperty)annotated).isMember() ? TargetLists.INSTANCE.T_MEMBER_PROPERTY(this.hasBackingField(descriptor2, context2), ((KtProperty)annotated).hasDelegate()) : TargetLists.INSTANCE.T_TOP_LEVEL_PROPERTY(this.hasBackingField(descriptor2, context2), ((KtProperty)annotated).hasDelegate()));
            } else if (ktElement instanceof KtParameter) {
                KtDestructuringDeclaration destructuringDeclaration = ((KtParameter)annotated).getDestructuringDeclaration();
                targetList2 = destructuringDeclaration != null ? TargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : (((KtParameter)annotated).hasValOrVar() ? TargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : TargetLists.INSTANCE.getT_VALUE_PARAMETER_WITHOUT_VAL());
            } else {
                targetList2 = ktElement instanceof KtConstructor ? TargetLists.INSTANCE.getT_CONSTRUCTOR() : (ktElement instanceof KtFunction ? (ExpressionTypingUtils.isFunctionExpression(descriptor2) ? TargetLists.INSTANCE.getT_FUNCTION_EXPRESSION() : (((KtFunction)annotated).isLocal() ? TargetLists.INSTANCE.getT_LOCAL_FUNCTION() : (((KtFunction)annotated).getParent() instanceof KtClassOrObject || ((KtFunction)annotated).getParent() instanceof KtClassBody ? TargetLists.INSTANCE.getT_MEMBER_FUNCTION() : TargetLists.INSTANCE.getT_TOP_LEVEL_FUNCTION()))) : (ktElement instanceof KtTypeAlias ? TargetLists.INSTANCE.getT_TYPEALIAS() : (ktElement instanceof KtPropertyAccessor ? (((KtPropertyAccessor)annotated).isGetter() ? TargetLists.INSTANCE.getT_PROPERTY_GETTER() : TargetLists.INSTANCE.getT_PROPERTY_SETTER()) : (ktElement instanceof KtTypeReference ? TargetLists.INSTANCE.getT_TYPE_REFERENCE() : (ktElement instanceof KtFile ? TargetLists.INSTANCE.getT_FILE() : (ktElement instanceof KtTypeParameter ? TargetLists.INSTANCE.getT_TYPE_PARAMETER() : (ktElement instanceof KtTypeProjection ? (((KtTypeProjection)annotated).getProjectionKind() == KtProjectionKind.STAR ? TargetLists.INSTANCE.getT_STAR_PROJECTION() : TargetLists.INSTANCE.getT_TYPE_PROJECTION()) : (ktElement instanceof KtAnonymousInitializer ? TargetLists.INSTANCE.getT_INITIALIZER() : (ktElement instanceof KtDestructuringDeclaration ? TargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : (ktElement instanceof KtLambdaExpression ? TargetLists.INSTANCE.getT_FUNCTION_LITERAL() : (ktElement instanceof KtObjectLiteralExpression ? TargetLists.INSTANCE.getT_OBJECT_LITERAL() : (ktElement instanceof KtExpression ? TargetLists.INSTANCE.getT_EXPRESSION() : TargetLists.INSTANCE.getEMPTY()))))))))))));
            }
            return targetList2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001CB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205J\u0016\u00107\u001a\u00020\u00042\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205J<\u00108\u001a\u00020\u00042\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0:\"\u00020;2\u0019\b\u0002\u0010<\u001a\u0013\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=\u00a2\u0006\u0002\b@H\u0002\u00a2\u0006\u0002\u0010AJ\u001c\u0010B\u001a\u00020?*\u00020>2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetLists;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetList;", "getEMPTY", "()Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetList;", "T_CLASSIFIER", "getT_CLASSIFIER", "T_CONSTRUCTOR", "getT_CONSTRUCTOR", "T_DESTRUCTURING_DECLARATION", "getT_DESTRUCTURING_DECLARATION", "T_EXPRESSION", "getT_EXPRESSION", "T_FILE", "getT_FILE", "T_FUNCTION_EXPRESSION", "getT_FUNCTION_EXPRESSION", "T_FUNCTION_LITERAL", "getT_FUNCTION_LITERAL", "T_INITIALIZER", "getT_INITIALIZER", "T_LOCAL_FUNCTION", "getT_LOCAL_FUNCTION", "T_LOCAL_VARIABLE", "getT_LOCAL_VARIABLE", "T_MEMBER_FUNCTION", "getT_MEMBER_FUNCTION", "T_OBJECT_LITERAL", "getT_OBJECT_LITERAL", "T_PROPERTY_GETTER", "getT_PROPERTY_GETTER", "T_PROPERTY_SETTER", "getT_PROPERTY_SETTER", "T_STAR_PROJECTION", "getT_STAR_PROJECTION", "T_TOP_LEVEL_FUNCTION", "getT_TOP_LEVEL_FUNCTION", "T_TYPEALIAS", "getT_TYPEALIAS", "T_TYPE_PARAMETER", "getT_TYPE_PARAMETER", "T_TYPE_PROJECTION", "getT_TYPE_PROJECTION", "T_TYPE_REFERENCE", "getT_TYPE_REFERENCE", "T_VALUE_PARAMETER_WITHOUT_VAL", "getT_VALUE_PARAMETER_WITHOUT_VAL", "T_VALUE_PARAMETER_WITH_VAL", "getT_VALUE_PARAMETER_WITH_VAL", "T_MEMBER_PROPERTY", "backingField", "", "delegate", "T_TOP_LEVEL_PROPERTY", "targetList", "target", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "otherTargets", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetLists$TargetListBuilder;", "", "Lkotlin/ExtensionFunctionType;", "([Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetList;", "propertyTargets", "TargetListBuilder", "frontend"})
        public static final class TargetLists {
            @NotNull
            public static final TargetLists INSTANCE = new TargetLists();
            @NotNull
            private static final TargetList T_CLASSIFIER;
            @NotNull
            private static final TargetList T_TYPEALIAS;
            @NotNull
            private static final TargetList T_LOCAL_VARIABLE;
            @NotNull
            private static final TargetList T_DESTRUCTURING_DECLARATION;
            @NotNull
            private static final TargetList T_PROPERTY_GETTER;
            @NotNull
            private static final TargetList T_PROPERTY_SETTER;
            @NotNull
            private static final TargetList T_VALUE_PARAMETER_WITHOUT_VAL;
            @NotNull
            private static final TargetList T_VALUE_PARAMETER_WITH_VAL;
            @NotNull
            private static final TargetList T_FILE;
            @NotNull
            private static final TargetList T_CONSTRUCTOR;
            @NotNull
            private static final TargetList T_LOCAL_FUNCTION;
            @NotNull
            private static final TargetList T_MEMBER_FUNCTION;
            @NotNull
            private static final TargetList T_TOP_LEVEL_FUNCTION;
            @NotNull
            private static final TargetList T_EXPRESSION;
            @NotNull
            private static final TargetList T_FUNCTION_LITERAL;
            @NotNull
            private static final TargetList T_FUNCTION_EXPRESSION;
            @NotNull
            private static final TargetList T_OBJECT_LITERAL;
            @NotNull
            private static final TargetList T_TYPE_REFERENCE;
            @NotNull
            private static final TargetList T_TYPE_PARAMETER;
            @NotNull
            private static final TargetList T_STAR_PROJECTION;
            @NotNull
            private static final TargetList T_TYPE_PROJECTION;
            @NotNull
            private static final TargetList T_INITIALIZER;
            @NotNull
            private static final TargetList EMPTY;

            private TargetLists() {
            }

            @NotNull
            public final TargetList getT_CLASSIFIER() {
                return T_CLASSIFIER;
            }

            @NotNull
            public final TargetList getT_TYPEALIAS() {
                return T_TYPEALIAS;
            }

            @NotNull
            public final TargetList getT_LOCAL_VARIABLE() {
                return T_LOCAL_VARIABLE;
            }

            @NotNull
            public final TargetList getT_DESTRUCTURING_DECLARATION() {
                return T_DESTRUCTURING_DECLARATION;
            }

            private final void propertyTargets(TargetListBuilder $this$propertyTargets, boolean backingField2, boolean delegate2) {
                KotlinTarget[] kotlinTargetArray;
                if (backingField2) {
                    kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FIELD};
                    $this$propertyTargets.extraTargets(kotlinTargetArray);
                }
                if (delegate2) {
                    kotlinTargetArray = new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER, KotlinTarget.FIELD};
                    $this$propertyTargets.onlyWithUseSiteTarget(kotlinTargetArray);
                } else {
                    kotlinTargetArray = new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER};
                    $this$propertyTargets.onlyWithUseSiteTarget(kotlinTargetArray);
                }
            }

            @NotNull
            public final TargetList T_MEMBER_PROPERTY(boolean backingField2, boolean delegate2) {
                KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{backingField2 ? KotlinTarget.MEMBER_PROPERTY_WITH_BACKING_FIELD : (delegate2 ? KotlinTarget.MEMBER_PROPERTY_WITH_DELEGATE : KotlinTarget.MEMBER_PROPERTY_WITHOUT_FIELD_OR_DELEGATE), KotlinTarget.MEMBER_PROPERTY, KotlinTarget.PROPERTY};
                return this.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)new Function1<TargetListBuilder, Unit>(backingField2, delegate2){
                    final /* synthetic */ boolean $backingField;
                    final /* synthetic */ boolean $delegate;
                    {
                        this.$backingField = $backingField;
                        this.$delegate = $delegate;
                        super(1);
                    }

                    public final void invoke(@NotNull TargetListBuilder $this$targetList) {
                        Intrinsics.checkNotNullParameter((Object)$this$targetList, (String)"$this$targetList");
                        TargetLists.access$propertyTargets(TargetLists.INSTANCE, $this$targetList, this.$backingField, this.$delegate);
                    }
                }));
            }

            @NotNull
            public final TargetList T_TOP_LEVEL_PROPERTY(boolean backingField2, boolean delegate2) {
                KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{backingField2 ? KotlinTarget.TOP_LEVEL_PROPERTY_WITH_BACKING_FIELD : (delegate2 ? KotlinTarget.TOP_LEVEL_PROPERTY_WITH_DELEGATE : KotlinTarget.TOP_LEVEL_PROPERTY_WITHOUT_FIELD_OR_DELEGATE), KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.PROPERTY};
                return this.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)new Function1<TargetListBuilder, Unit>(backingField2, delegate2){
                    final /* synthetic */ boolean $backingField;
                    final /* synthetic */ boolean $delegate;
                    {
                        this.$backingField = $backingField;
                        this.$delegate = $delegate;
                        super(1);
                    }

                    public final void invoke(@NotNull TargetListBuilder $this$targetList) {
                        Intrinsics.checkNotNullParameter((Object)$this$targetList, (String)"$this$targetList");
                        TargetLists.access$propertyTargets(TargetLists.INSTANCE, $this$targetList, this.$backingField, this.$delegate);
                    }
                }));
            }

            @NotNull
            public final TargetList getT_PROPERTY_GETTER() {
                return T_PROPERTY_GETTER;
            }

            @NotNull
            public final TargetList getT_PROPERTY_SETTER() {
                return T_PROPERTY_SETTER;
            }

            @NotNull
            public final TargetList getT_VALUE_PARAMETER_WITHOUT_VAL() {
                return T_VALUE_PARAMETER_WITHOUT_VAL;
            }

            @NotNull
            public final TargetList getT_VALUE_PARAMETER_WITH_VAL() {
                return T_VALUE_PARAMETER_WITH_VAL;
            }

            @NotNull
            public final TargetList getT_FILE() {
                return T_FILE;
            }

            @NotNull
            public final TargetList getT_CONSTRUCTOR() {
                return T_CONSTRUCTOR;
            }

            @NotNull
            public final TargetList getT_LOCAL_FUNCTION() {
                return T_LOCAL_FUNCTION;
            }

            @NotNull
            public final TargetList getT_MEMBER_FUNCTION() {
                return T_MEMBER_FUNCTION;
            }

            @NotNull
            public final TargetList getT_TOP_LEVEL_FUNCTION() {
                return T_TOP_LEVEL_FUNCTION;
            }

            @NotNull
            public final TargetList getT_EXPRESSION() {
                return T_EXPRESSION;
            }

            @NotNull
            public final TargetList getT_FUNCTION_LITERAL() {
                return T_FUNCTION_LITERAL;
            }

            @NotNull
            public final TargetList getT_FUNCTION_EXPRESSION() {
                return T_FUNCTION_EXPRESSION;
            }

            @NotNull
            public final TargetList getT_OBJECT_LITERAL() {
                return T_OBJECT_LITERAL;
            }

            @NotNull
            public final TargetList getT_TYPE_REFERENCE() {
                return T_TYPE_REFERENCE;
            }

            @NotNull
            public final TargetList getT_TYPE_PARAMETER() {
                return T_TYPE_PARAMETER;
            }

            @NotNull
            public final TargetList getT_STAR_PROJECTION() {
                return T_STAR_PROJECTION;
            }

            @NotNull
            public final TargetList getT_TYPE_PROJECTION() {
                return T_TYPE_PROJECTION;
            }

            @NotNull
            public final TargetList getT_INITIALIZER() {
                return T_INITIALIZER;
            }

            private final TargetList targetList(KotlinTarget[] target, Function1<? super TargetListBuilder, Unit> otherTargets) {
                KotlinTarget[] kotlinTargetArray = new KotlinTarget[target.length];
                System.arraycopy(target, 0, kotlinTargetArray, 0, target.length);
                TargetListBuilder builder2 = new TargetListBuilder(kotlinTargetArray);
                otherTargets.invoke((Object)builder2);
                return builder2.build();
            }

            static /* synthetic */ TargetList targetList$default(TargetLists targetLists, KotlinTarget[] kotlinTargetArray, Function1 function1, int n, Object object) {
                if ((n & 2) != 0) {
                    function1 = targetList.1.INSTANCE;
                }
                return targetLists.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)function1);
            }

            @NotNull
            public final TargetList getEMPTY() {
                return EMPTY;
            }

            public static final /* synthetic */ void access$propertyTargets(TargetLists $this, TargetListBuilder $receiver, boolean backingField2, boolean delegate2) {
                $this.propertyTargets($receiver, backingField2, delegate2);
            }

            static {
                KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.CLASS};
                T_CLASSIFIER = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.TYPEALIAS};
                T_TYPEALIAS = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.LOCAL_VARIABLE};
                T_LOCAL_VARIABLE = INSTANCE.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)T_LOCAL_VARIABLE.1.INSTANCE));
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.DESTRUCTURING_DECLARATION};
                T_DESTRUCTURING_DECLARATION = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.PROPERTY_GETTER};
                T_PROPERTY_GETTER = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.PROPERTY_SETTER};
                T_PROPERTY_SETTER = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER};
                T_VALUE_PARAMETER_WITHOUT_VAL = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.PROPERTY, KotlinTarget.MEMBER_PROPERTY};
                T_VALUE_PARAMETER_WITH_VAL = INSTANCE.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)T_VALUE_PARAMETER_WITH_VAL.1.INSTANCE));
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FILE};
                T_FILE = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.CONSTRUCTOR};
                T_CONSTRUCTOR = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.LOCAL_FUNCTION, KotlinTarget.FUNCTION};
                T_LOCAL_FUNCTION = INSTANCE.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)T_LOCAL_FUNCTION.1.INSTANCE));
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.MEMBER_FUNCTION, KotlinTarget.FUNCTION};
                T_MEMBER_FUNCTION = INSTANCE.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)T_MEMBER_FUNCTION.1.INSTANCE));
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.FUNCTION};
                T_TOP_LEVEL_FUNCTION = INSTANCE.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)T_TOP_LEVEL_FUNCTION.1.INSTANCE));
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.EXPRESSION};
                T_EXPRESSION = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.LAMBDA_EXPRESSION, KotlinTarget.FUNCTION, KotlinTarget.EXPRESSION};
                T_FUNCTION_LITERAL = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.ANONYMOUS_FUNCTION, KotlinTarget.FUNCTION, KotlinTarget.EXPRESSION};
                T_FUNCTION_EXPRESSION = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.OBJECT_LITERAL, KotlinTarget.CLASS, KotlinTarget.EXPRESSION};
                T_OBJECT_LITERAL = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.TYPE};
                T_TYPE_REFERENCE = INSTANCE.targetList(kotlinTargetArray, (Function1<? super TargetListBuilder, Unit>)((Function1)T_TYPE_REFERENCE.1.INSTANCE));
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.TYPE_PARAMETER};
                T_TYPE_PARAMETER = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.STAR_PROJECTION};
                T_STAR_PROJECTION = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.TYPE_PROJECTION};
                T_TYPE_PROJECTION = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                kotlinTargetArray = new KotlinTarget[]{KotlinTarget.INITIALIZER};
                T_INITIALIZER = TargetLists.targetList$default(INSTANCE, kotlinTargetArray, null, 2, null);
                EMPTY = TargetLists.targetList$default(INSTANCE, new KotlinTarget[0], null, 2, null);
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetLists$TargetListBuilder;", "", "defaultTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "([Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;)V", "canBeSubstituted", "", "getDefaultTargets", "()[Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "[Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "onlyWithUseSiteTarget", "build", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetList;", "extraTargets", "", "targets", "frontend"})
            private static final class TargetListBuilder {
                @NotNull
                private final KotlinTarget[] defaultTargets;
                @NotNull
                private List<? extends KotlinTarget> canBeSubstituted;
                @NotNull
                private List<? extends KotlinTarget> onlyWithUseSiteTarget;

                public TargetListBuilder(KotlinTarget ... defaultTargets) {
                    Intrinsics.checkNotNullParameter((Object)defaultTargets, (String)"defaultTargets");
                    this.defaultTargets = defaultTargets;
                    boolean bl = false;
                    this.canBeSubstituted = CollectionsKt.emptyList();
                    bl = false;
                    this.onlyWithUseSiteTarget = CollectionsKt.emptyList();
                }

                @NotNull
                public final KotlinTarget[] getDefaultTargets() {
                    return this.defaultTargets;
                }

                public final void extraTargets(KotlinTarget ... targets) {
                    Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
                    this.canBeSubstituted = ArraysKt.toList((Object[])targets);
                }

                public final void onlyWithUseSiteTarget(KotlinTarget ... targets) {
                    Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
                    this.onlyWithUseSiteTarget = ArraysKt.toList((Object[])targets);
                }

                @NotNull
                public final TargetList build() {
                    return new TargetList(ArraysKt.toList((Object[])this.defaultTargets), this.canBeSubstituted, this.onlyWithUseSiteTarget);
                }
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$TargetList;", "", "defaultTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "canBeSubstituted", "onlyWithUseSiteTarget", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getCanBeSubstituted", "()Ljava/util/List;", "getDefaultTargets", "getOnlyWithUseSiteTarget", "frontend"})
        public static final class TargetList {
            @NotNull
            private final List<KotlinTarget> defaultTargets;
            @NotNull
            private final List<KotlinTarget> canBeSubstituted;
            @NotNull
            private final List<KotlinTarget> onlyWithUseSiteTarget;

            public TargetList(@NotNull List<? extends KotlinTarget> defaultTargets, @NotNull List<? extends KotlinTarget> canBeSubstituted, @NotNull List<? extends KotlinTarget> onlyWithUseSiteTarget) {
                Intrinsics.checkNotNullParameter(defaultTargets, (String)"defaultTargets");
                Intrinsics.checkNotNullParameter(canBeSubstituted, (String)"canBeSubstituted");
                Intrinsics.checkNotNullParameter(onlyWithUseSiteTarget, (String)"onlyWithUseSiteTarget");
                this.defaultTargets = defaultTargets;
                this.canBeSubstituted = canBeSubstituted;
                this.onlyWithUseSiteTarget = onlyWithUseSiteTarget;
            }

            public /* synthetic */ TargetList(List list2, List list3, List list4, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list3 = CollectionsKt.emptyList();
                }
                if ((n & 4) != 0) {
                    list4 = CollectionsKt.emptyList();
                }
                this(list2, list3, list4);
            }

            @NotNull
            public final List<KotlinTarget> getDefaultTargets() {
                return this.defaultTargets;
            }

            @NotNull
            public final List<KotlinTarget> getCanBeSubstituted() {
                return this.canBeSubstituted;
            }

            @NotNull
            public final List<KotlinTarget> getOnlyWithUseSiteTarget() {
                return this.onlyWithUseSiteTarget;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationChecker$Companion$UseSiteTargetsList;", "", "()V", "T_CONSTRUCTOR_PARAMETER", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "getT_CONSTRUCTOR_PARAMETER", "()Ljava/util/List;", "T_PROPERTY", "getT_PROPERTY", "frontend"})
        private static final class UseSiteTargetsList {
            @NotNull
            public static final UseSiteTargetsList INSTANCE = new UseSiteTargetsList();
            @NotNull
            private static final List<AnnotationUseSiteTarget> T_CONSTRUCTOR_PARAMETER;
            @NotNull
            private static final List<AnnotationUseSiteTarget> T_PROPERTY;

            private UseSiteTargetsList() {
            }

            @NotNull
            public final List<AnnotationUseSiteTarget> getT_CONSTRUCTOR_PARAMETER() {
                return T_CONSTRUCTOR_PARAMETER;
            }

            @NotNull
            public final List<AnnotationUseSiteTarget> getT_PROPERTY() {
                return T_PROPERTY;
            }

            static {
                AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER, AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD};
                T_CONSTRUCTOR_PARAMETER = CollectionsKt.listOf((Object[])annotationUseSiteTargetArray);
                annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD};
                T_PROPERTY = CollectionsKt.listOf((Object[])annotationUseSiteTargetArray);
            }
        }
    }
}

