/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\n\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0011\u001a\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010\u0018\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u0002\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030\r\u001a\u001a\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\r*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a&\u0010\u001d\u001a\u0004\u0018\u00010\u001e\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014\u001a\u001e\u0010 \u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0001\u001a(\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0001\u001a\u001a\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\r*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0010\u0010%\u001a\u0004\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030\r\u001a\u001e\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001e\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001a\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\r*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001a\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\r*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010(\u001a\u0004\u0018\u00010)*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010*\u001a\u0004\u0018\u00010\u0014*\u00020\u00102\u0006\u0010+\u001a\u00020\u0011\u001a\n\u0010,\u001a\u00020\u0002*\u00020\u0010\u001a\u0010\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u0010\u001a\u0010\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020.\u001a\u001a\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002000\r*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\"\u00101\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u00102\u001a\u00020\u001e\u001a\u001a\u00103\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\u001a\u00104\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\u001a\u00105\u001a\u00020\u0001*\u00020\u00102\u0006\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u000208\u001a(\u00105\u001a\u00020\u0001\"\u000e\b\u0000\u00109*\b\u0012\u0004\u0012\u0002H90:*\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H90:\u001a\n\u0010;\u001a\u00020\u0001*\u00020\u0010\u001a\n\u0010;\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010<\u001a\u00020\u0001*\u00020\u0010\u001a\u001a\u0010=\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a.\u0010>\u001a\u00020?*\u00020@2\b\u0010+\u001a\u0004\u0018\u00010\u00112\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020C0BH\u0086\b\u00f8\u0001\u0000\u001a\u001a\u0010D\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006E"}, d2={"isFakeElement", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "isFakePsiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "isTrailingLambdaOnNewLIne", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)Z", "allArgumentsMapped", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "createLookupLocation", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "filterArgsInParentheses", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getCall", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getCallWithAssert", "getCalleeExpressionIfAny", "getFirstArgumentExpression", "getFunctionResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getParameterForArgument", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueArgument", "getParentCall", "strict", "getParentResolvedCall", "getPropertyResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getReceiverExpression", "getResolvedCall", "getResolvedCallWithAssert", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getValueArgumentForExpression", "expression", "getValueArgumentListOrElement", "getValueArgumentsInParentheses", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "getVariableResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "hasTypeMismatchErrorOnParameter", "parameter", "hasUnmappedArguments", "hasUnmappedParameters", "hasUnresolvedArguments", "bindingContext", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isCallableReference", "isSafeCall", "noErrorsInValueArguments", "reportTrailingLambdaErrorOr", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "originalDiagnostic", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "usesDefaultArguments", "frontend"})
public final class CallUtilKt {
    public static final <D extends CallableDescriptor> boolean noErrorsInValueArguments(@NotNull ResolvedCall<D> $this$noErrorsInValueArguments) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$noErrorsInValueArguments, (String)"<this>");
            List<? extends ValueArgument> list2 = $this$noErrorsInValueArguments.getCall().getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"call.valueArguments");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)argument2);
                    if (!$this$noErrorsInValueArguments.getArgumentMapping(argument2).isError()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedArguments(@NotNull ResolvedCall<D> $this$hasUnmappedArguments) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$hasUnmappedArguments, (String)"<this>");
            List<? extends ValueArgument> list2 = $this$hasUnmappedArguments.getCall().getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"call.valueArguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)argument2);
                    if (!Intrinsics.areEqual((Object)$this$hasUnmappedArguments.getArgumentMapping(argument2), (Object)ArgumentUnmapped.INSTANCE)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedParameters(@NotNull ResolvedCall<D> $this$hasUnmappedParameters) {
        Intrinsics.checkNotNullParameter($this$hasUnmappedParameters, (String)"<this>");
        Object object = $this$hasUnmappedParameters.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(object, (String)"valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> parameterToArgumentMap = object;
        Set<ValueParameterDescriptor> set = parameterToArgumentMap.keySet();
        object = $this$hasUnmappedParameters.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resultingDescriptor.valueParameters");
        return !set.containsAll((Collection)object);
    }

    public static final <D extends CallableDescriptor> boolean allArgumentsMapped(@NotNull ResolvedCall<D> $this$allArgumentsMapped) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$allArgumentsMapped, (String)"<this>");
            List<? extends ValueArgument> list2 = $this$allArgumentsMapped.getCall().getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"call.valueArguments");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    if ($this$allArgumentsMapped.getArgumentMapping(argument2) instanceof ArgumentMatch) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasTypeMismatchErrorOnParameter(@NotNull ResolvedCall<D> $this$hasTypeMismatchErrorOnParameter, @NotNull ValueParameterDescriptor parameter) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$hasTypeMismatchErrorOnParameter, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            ResolvedValueArgument resolvedValueArgument = $this$hasTypeMismatchErrorOnParameter.getValueArguments().get(parameter);
            if (resolvedValueArgument == null) {
                return true;
            }
            List<ValueArgument> list2 = resolvedValueArgument.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"resolvedValueArgument.arguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    ArgumentMapping argumentMapping = $this$hasTypeMismatchErrorOnParameter.getArgumentMapping(argument2);
                    Intrinsics.checkNotNullExpressionValue((Object)argumentMapping, (String)"getArgumentMapping(argument)");
                    ArgumentMapping argumentMapping2 = argumentMapping;
                    if (!(argumentMapping2 instanceof ArgumentMatch && ((ArgumentMatch)argumentMapping2).getStatus() == ArgumentMatchStatus.TYPE_MISMATCH)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final <D extends CallableDescriptor> ValueParameterDescriptor getParameterForArgument(@NotNull ResolvedCall<D> $this$getParameterForArgument, @Nullable ValueArgument valueArgument) {
        ArgumentMapping argumentMapping;
        Intrinsics.checkNotNullParameter($this$getParameterForArgument, (String)"<this>");
        ValueArgument valueArgument2 = valueArgument;
        if (valueArgument2 == null) {
            argumentMapping = null;
        } else {
            ValueArgument valueArgument3 = valueArgument2;
            boolean bl = false;
            boolean bl2 = false;
            ValueArgument it = valueArgument3;
            boolean bl3 = false;
            argumentMapping = $this$getParameterForArgument.getArgumentMapping(it);
        }
        ArgumentMapping argumentMapping2 = argumentMapping;
        ArgumentMatch argumentMatch = argumentMapping2 instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping2 : null;
        return argumentMatch == null ? null : argumentMatch.getValueParameter();
    }

    public static final <D extends CallableDescriptor> boolean usesDefaultArguments(@NotNull ResolvedCall<D> $this$usesDefaultArguments) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$usesDefaultArguments, (String)"<this>");
        List<ResolvedValueArgument> list2 = $this$usesDefaultArguments.getValueArgumentsByIndex();
        if (list2 == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            block5: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedValueArgument it = (ResolvedValueArgument)element$iv;
                        boolean bl4 = false;
                        if (!(it instanceof DefaultValueArgument)) continue;
                        bl3 = true;
                        break block5;
                    }
                    bl3 = false;
                }
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    public static final <C extends ResolutionContext<C>> boolean hasUnresolvedArguments(@NotNull Call $this$hasUnresolvedArguments, @NotNull ResolutionContext<C> context2) {
        Intrinsics.checkNotNullParameter((Object)$this$hasUnresolvedArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Object object = context2.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace.bindingContext");
        BindingContext bindingContext = object;
        object = context2.statementFilter;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.statementFilter");
        return CallUtilKt.hasUnresolvedArguments($this$hasUnresolvedArguments, bindingContext, (StatementFilter)object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasUnresolvedArguments(@NotNull Call $this$hasUnresolvedArguments, @NotNull BindingContext bindingContext, @NotNull StatementFilter statementFilter) {
        boolean bl;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hasUnresolvedArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)statementFilter, (String)"statementFilter");
        List<? extends ValueArgument> list2 = $this$hasUnresolvedArguments.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"valueArguments");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueArgument valueArgument = (ValueArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            KtExpression ktExpression = it.getArgumentExpression();
            collection.add(ktExpression);
        }
        List arguments2 = (List)destination$iv$iv;
        Iterable $this$any$iv = arguments2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object = $this$any$iv.iterator();
        do {
            KotlinType expressionType;
            KotlinType kotlinType;
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            KtExpression argument2 = (KtExpression)element$iv;
            if (argument2 == null || ArgumentTypeResolver.isFunctionLiteralOrCallableReference(argument2, statementFilter)) {
                bl = false;
                continue;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(argument2, bindingContext);
            if (resolvedCall2 instanceof MutableResolvedCall) {
                if (!((MutableResolvedCall)resolvedCall2).hasInferredReturnType()) {
                    bl = false;
                    continue;
                }
            } else if (resolvedCall2 instanceof NewResolvedCallImpl && Intrinsics.areEqual((Object)((kotlinType = ((NewResolvedCallImpl)resolvedCall2).getResultingDescriptor().getReturnType()) == null ? null : Boolean.valueOf(KotlinTypeKt.isError(kotlinType))), (Object)true)) {
                bl = false;
                continue;
            }
            if ((expressionType = bindingContext.getType(argument2)) == null) return true;
            if (KotlinTypeKt.isError(expressionType)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull Call $this$getValueArgumentsInParentheses) {
        Intrinsics.checkNotNullParameter((Object)$this$getValueArgumentsInParentheses, (String)"<this>");
        List<? extends ValueArgument> list2 = $this$getValueArgumentsInParentheses.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull KtCallElement $this$getValueArgumentsInParentheses) {
        Intrinsics.checkNotNullParameter((Object)$this$getValueArgumentsInParentheses, (String)"<this>");
        List<? extends ValueArgument> list2 = $this$getValueArgumentsInParentheses.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final KtElement getValueArgumentListOrElement(@NotNull Call $this$getValueArgumentListOrElement) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)$this$getValueArgumentListOrElement, (String)"<this>");
        if ($this$getValueArgumentListOrElement instanceof CallTransformer.CallForImplicitInvoke) {
            Call call2 = ((CallTransformer.CallForImplicitInvoke)$this$getValueArgumentListOrElement).getOuterCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"outerCall");
            ktElement = CallUtilKt.getValueArgumentListOrElement(call2);
        } else {
            KtValueArgumentList ktValueArgumentList = $this$getValueArgumentListOrElement.getValueArgumentList();
            if (ktValueArgumentList == null) {
                KtElement ktElement2 = $this$getValueArgumentListOrElement.getCalleeExpression();
                if (ktElement2 == null) {
                    KtElement ktElement3 = $this$getValueArgumentListOrElement.getCallElement();
                    Intrinsics.checkNotNullExpressionValue((Object)ktElement3, (String)"callElement");
                    ktElement = ktElement3;
                } else {
                    ktElement = ktElement2;
                }
            } else {
                ktElement = ktValueArgumentList;
            }
        }
        return ktElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ValueArgument> filterArgsInParentheses(List<? extends ValueArgument> $this$filterArgsInParentheses) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterArgsInParentheses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueArgument it = (ValueArgument)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof KtLambdaArgument))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ValueArgument getValueArgumentForExpression(@NotNull Call $this$getValueArgumentForExpression, @NotNull KtExpression expression2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getValueArgumentForExpression, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            List<? extends ValueArgument> list2 = $this$getValueArgumentForExpression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"valueArguments");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ValueArgument it = (ValueArgument)element$iv;
                boolean bl = false;
                ValueArgument valueArgument = it;
                KtExpression ktExpression = valueArgument == null ? null : valueArgument.getArgumentExpression();
                if (!(ktExpression == null ? false : CallUtilKt.getValueArgumentForExpression$isParenthesizedExpression(ktExpression, expression2))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final KtExpression getCalleeExpressionIfAny(@Nullable KtElement $this$getCalleeExpressionIfAny) {
        KtElement element = $this$getCalleeExpressionIfAny instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$this$getCalleeExpressionIfAny) : $this$getCalleeExpressionIfAny;
        KtElement ktElement = element;
        return ktElement instanceof KtSimpleNameExpression ? (KtExpression)element : (ktElement instanceof KtCallElement ? ((KtCallElement)element).getCalleeExpression() : (ktElement instanceof KtQualifiedExpression ? CallUtilKt.getCalleeExpressionIfAny(((KtQualifiedExpression)element).getSelectorExpression()) : (ktElement instanceof KtOperationExpression ? (KtExpression)((KtOperationExpression)element).getOperationReference() : null)));
    }

    @Nullable
    public static final Call getCall(@NotNull KtElement $this$getCall, @NotNull BindingContext context2) {
        KtExpression reference;
        PsiElement psiElement;
        KtProperty subjectVariable;
        KtElement element;
        Intrinsics.checkNotNullParameter((Object)$this$getCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtElement ktElement = element = $this$getCall instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$this$getCall) : $this$getCall;
        if (element == null) {
            return null;
        }
        if (element instanceof KtCallElement && ((KtCallElement)element).getCalleeExpression() == null) {
            return null;
        }
        if (element instanceof KtWhenExpression && (subjectVariable = ((KtWhenExpression)element).getSubjectVariable()) != null) {
            return CallUtilKt.getCall(subjectVariable, context2);
        }
        PsiElement parent2 = element.getParent();
        PsiElement psiElement2 = parent2;
        KtExpression ktExpression = psiElement2 instanceof KtInstanceExpressionWithLabel ? (KtExpression)parent2 : (psiElement2 instanceof KtUserType ? (KtExpression)((psiElement = ((KtUserType)parent2).getParent().getParent()) instanceof KtConstructorCalleeExpression ? (KtConstructorCalleeExpression)psiElement : null) : (reference = CallUtilKt.getCalleeExpressionIfAny(element)));
        if (reference != null) {
            return (Call)context2.get(BindingContext.CALL, reference);
        }
        return (Call)context2.get(BindingContext.CALL, element);
    }

    @Nullable
    public static final Call getParentCall(@NotNull KtElement $this$getParentCall, @NotNull BindingContext context2, boolean strict) {
        KtElement ktElement;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getParentCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Class[] classArray = new Class[]{KtSimpleNameExpression.class, KtCallElement.class, KtBinaryExpression.class, KtUnaryExpression.class, KtArrayAccessExpression.class};
        Class[] callExpressionTypes = classArray;
        if (strict) {
            PsiElement psiElement = $this$getParentCall;
            object = new Class[callExpressionTypes.length];
            System.arraycopy(callExpressionTypes, 0, object, 0, callExpressionTypes.length);
            ktElement = (KtElement)PsiTreeUtil.getParentOfType(psiElement, object);
        } else {
            PsiElement psiElement = $this$getParentCall;
            object = new Class[callExpressionTypes.length];
            System.arraycopy(callExpressionTypes, 0, object, 0, callExpressionTypes.length);
            ktElement = (KtElement)PsiTreeUtil.getNonStrictParentOfType(psiElement, object);
        }
        KtElement parent2 = ktElement;
        object = parent2;
        return object == null ? null : CallUtilKt.getCall((KtElement)object, context2);
    }

    public static /* synthetic */ Call getParentCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentCall(ktElement, bindingContext, bl);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable Call $this$getResolvedCall, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return (ResolvedCall)context2.get(BindingContext.RESOLVED_CALL, $this$getResolvedCall);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable KtElement $this$getResolvedCall, @NotNull BindingContext context2) {
        Call call2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtElement ktElement = $this$getResolvedCall;
        return ktElement == null ? null : ((call2 = CallUtilKt.getCall(ktElement, context2)) == null ? null : CallUtilKt.getResolvedCall(call2, context2));
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getParentResolvedCall(@Nullable KtElement $this$getParentResolvedCall, @NotNull BindingContext context2, boolean strict) {
        Call call2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtElement ktElement = $this$getParentResolvedCall;
        return ktElement == null ? null : ((call2 = CallUtilKt.getParentCall(ktElement, context2, strict)) == null ? null : CallUtilKt.getResolvedCall(call2, context2));
    }

    public static /* synthetic */ ResolvedCall getParentResolvedCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentResolvedCall(ktElement, bindingContext, bl);
    }

    @NotNull
    public static final Call getCallWithAssert(@NotNull KtElement $this$getCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallWithAssert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Call $this$sure$iv = CallUtilKt.getCall($this$getCallWithAssert, context2);
        boolean $i$f$sure = false;
        Call call2 = $this$sure$iv;
        if (call2 == null) {
            String string2;
            boolean bl = false;
            String string3 = string2 = Intrinsics.stringPlus((String)"No call for ", (Object)PsiUtilsKt.getTextWithLocation($this$getCallWithAssert));
            throw new AssertionError((Object)string3);
        }
        return call2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull KtElement $this$getResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getResolvedCallWithAssert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ResolvedCall<? extends CallableDescriptor> $this$sure$iv = CallUtilKt.getResolvedCall($this$getResolvedCallWithAssert, context2);
        boolean $i$f$sure = false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $this$sure$iv;
        if (resolvedCall2 == null) {
            String string2;
            boolean bl = false;
            String string3 = string2 = Intrinsics.stringPlus((String)"No resolved call for ", (Object)PsiUtilsKt.getTextWithLocation($this$getResolvedCallWithAssert));
            throw new AssertionError((Object)string3);
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull Call $this$getResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getResolvedCallWithAssert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ResolvedCall<? extends CallableDescriptor> $this$sure$iv = CallUtilKt.getResolvedCall($this$getResolvedCallWithAssert, context2);
        boolean $i$f$sure = false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $this$sure$iv;
        if (resolvedCall2 == null) {
            String string2;
            boolean bl = false;
            KtElement ktElement = $this$getResolvedCallWithAssert.getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"this.callElement");
            String string3 = string2 = Intrinsics.stringPlus((String)"No resolved call for ", (Object)PsiUtilsKt.getTextWithLocation(ktElement));
            throw new AssertionError((Object)string3);
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends FunctionDescriptor> getFunctionResolvedCallWithAssert(@NotNull KtExpression $this$getFunctionResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionResolvedCallWithAssert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getFunctionResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof FunctionDescriptor;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"ResolvedCall for this expression must be ResolvedCall<? extends FunctionDescriptor>: ", (Object)PsiUtilsKt.getTextWithLocation($this$getFunctionResolvedCallWithAssert));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends PropertyDescriptor> getPropertyResolvedCallWithAssert(@NotNull KtExpression $this$getPropertyResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getPropertyResolvedCallWithAssert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getPropertyResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof PropertyDescriptor;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: ", (Object)PsiUtilsKt.getTextWithLocation($this$getPropertyResolvedCallWithAssert));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends VariableDescriptor> getVariableResolvedCallWithAssert(@NotNull KtExpression $this$getVariableResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariableResolvedCallWithAssert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getVariableResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: ", (Object)PsiUtilsKt.getTextWithLocation($this$getVariableResolvedCallWithAssert));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return resolvedCall2;
    }

    @Nullable
    public static final KotlinType getType(@NotNull KtExpression $this$getType, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinType type2 = context2.getType($this$getType);
        if (type2 != null) {
            return type2;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$getType, context2);
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor().getType();
        }
        return null;
    }

    public static final boolean isFakeElement(@NotNull KtElement $this$isFakeElement) {
        Intrinsics.checkNotNullParameter((Object)$this$isFakeElement, (String)"<this>");
        PsiFile file2 = $this$isFakeElement.getContainingFile();
        return file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null;
    }

    public static final boolean isFakePsiElement(@NotNull PsiElement $this$isFakePsiElement) {
        Intrinsics.checkNotNullParameter((Object)$this$isFakePsiElement, (String)"<this>");
        return $this$isFakePsiElement instanceof KtElement && CallUtilKt.isFakeElement((KtElement)$this$isFakePsiElement);
    }

    public static final boolean isSafeCall(@NotNull Call $this$isSafeCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isSafeCall, (String)"<this>");
        if ($this$isSafeCall instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)$this$isSafeCall).getOuterCall().isSemanticallyEquivalentToSafeCall()) {
            return true;
        }
        return $this$isSafeCall.isSemanticallyEquivalentToSafeCall();
    }

    public static final boolean isCallableReference(@NotNull Call $this$isCallableReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isCallableReference, (String)"<this>");
        KtElement ktElement = $this$isCallableReference.getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"callElement");
        KtElement callElement = ktElement;
        return CallUtilKt.isCallableReference(callElement);
    }

    public static final boolean isCallableReference(@NotNull KtElement $this$isCallableReference) {
        PsiElement psiElement;
        KtCallableReferenceExpression ktCallableReferenceExpression;
        Intrinsics.checkNotNullParameter((Object)$this$isCallableReference, (String)"<this>");
        return $this$isCallableReference instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)((ktCallableReferenceExpression = (psiElement = ((KtNameReferenceExpression)$this$isCallableReference).getParent()) instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null) == null ? null : ktCallableReferenceExpression.getCallableReference()), (Object)$this$isCallableReference);
    }

    @NotNull
    public static final KotlinLookupLocation createLookupLocation(@NotNull Call $this$createLookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$createLookupLocation, (String)"<this>");
        KtExpression calleeExpression = $this$createLookupLocation.getCalleeExpression();
        KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : $this$createLookupLocation.getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"if (calleeExpression != null && !calleeExpression.isFakeElement) calleeExpression\n        else callElement");
        KtElement element = ktElement;
        return new KotlinLookupLocation(element);
    }

    @Nullable
    public static final KotlinLookupLocation createLookupLocation(@NotNull KtExpression $this$createLookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$createLookupLocation, (String)"<this>");
        return !CallUtilKt.isFakeElement($this$createLookupLocation) ? new KotlinLookupLocation($this$createLookupLocation) : null;
    }

    @Nullable
    public static final KtExpression getFirstArgumentExpression(@NotNull ResolvedCall<?> $this$getFirstArgumentExpression) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter($this$getFirstArgumentExpression, (String)"<this>");
        List<ResolvedValueArgument> list2 = $this$getFirstArgumentExpression.getValueArgumentsByIndex();
        if (list2 == null) {
            ktExpression = null;
        } else {
            List<ResolvedValueArgument> list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List<ResolvedValueArgument> $this$getFirstArgumentExpression_u24lambda_u2d17 = list3;
            boolean bl3 = false;
            ktExpression = $this$getFirstArgumentExpression_u24lambda_u2d17.get(0).getArguments().get(0).getArgumentExpression();
        }
        return ktExpression;
    }

    @Nullable
    public static final KtExpression getReceiverExpression(@NotNull ResolvedCall<?> $this$getReceiverExpression) {
        KtExpression ktExpression;
        ExpressionReceiver expressionReceiver;
        KtExpression ktExpression2;
        Intrinsics.checkNotNullParameter($this$getReceiverExpression, (String)"<this>");
        ReceiverValue $this$safeAs$iv = $this$getReceiverExpression.getExtensionReceiver();
        boolean $i$f$safeAs = false;
        ReceiverValue receiverValue = $this$safeAs$iv;
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        KtExpression ktExpression3 = ktExpression2 = (expressionReceiver = (ExpressionReceiver)receiverValue) == null ? null : expressionReceiver.getExpression();
        if (ktExpression2 == null) {
            $this$safeAs$iv = $this$getReceiverExpression.getDispatchReceiver();
            $i$f$safeAs = false;
            ReceiverValue receiverValue2 = $this$safeAs$iv;
            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                receiverValue2 = null;
            }
            ktExpression = (expressionReceiver = (ExpressionReceiver)receiverValue2) == null ? null : expressionReceiver.getExpression();
        } else {
            ktExpression = ktExpression2;
        }
        return ktExpression;
    }

    public static final boolean isTrailingLambdaOnNewLIne(@NotNull KtLambdaExpression $this$isTrailingLambdaOnNewLIne) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrailingLambdaOnNewLIne, (String)"<this>");
        PsiElement psiElement = $this$isTrailingLambdaOnNewLIne.getParent();
        if (psiElement != null) {
            KtLambdaArgument ktLambdaArgument;
            PsiElement $this$safeAs$iv = psiElement;
            boolean $i$f$safeAs = false;
            PsiElement psiElement2 = $this$safeAs$iv;
            if (!(psiElement2 instanceof KtLambdaArgument)) {
                psiElement2 = null;
            }
            if ((ktLambdaArgument = (KtLambdaArgument)psiElement2) != null) {
                KtLambdaArgument ktLambdaArgument2 = ktLambdaArgument;
                boolean bl = false;
                boolean bl2 = false;
                KtLambdaArgument lambdaArgument = ktLambdaArgument2;
                boolean bl3 = false;
                for (PsiElement prevSibling = lambdaArgument.getPrevSibling(); prevSibling != null && !(prevSibling instanceof KtElement); prevSibling = prevSibling.getPrevSibling()) {
                    if (!(prevSibling instanceof PsiWhiteSpace) || !prevSibling.textContains('\n')) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final void reportTrailingLambdaErrorOr(@NotNull BindingTrace $this$reportTrailingLambdaErrorOr, @Nullable KtExpression expression2, @NotNull Function1<? super KtExpression, ? extends Diagnostic> originalDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$reportTrailingLambdaErrorOr, (String)"<this>");
        Intrinsics.checkNotNullParameter(originalDiagnostic, (String)"originalDiagnostic");
        boolean $i$f$reportTrailingLambdaErrorOr = false;
        KtExpression ktExpression = expression2;
        if (ktExpression != null) {
            KtExpression ktExpression2 = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtExpression expr = ktExpression2;
            boolean bl3 = false;
            if (expr instanceof KtLambdaExpression && CallUtilKt.isTrailingLambdaOnNewLIne((KtLambdaExpression)expr)) {
                $this$reportTrailingLambdaErrorOr.report(Errors.UNEXPECTED_TRAILING_LAMBDA_ON_A_NEW_LINE.on((KtLambdaExpression)expr));
            } else {
                $this$reportTrailingLambdaErrorOr.report((Diagnostic)originalDiagnostic.invoke((Object)expr));
            }
        }
    }

    private static final KtElement getValueArgumentForExpression$deparenthesizeStructurally(KtElement $this$getValueArgumentForExpression_u24deparenthesizeStructurally) {
        KtElement deparenthesized = $this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesizeOnce((KtExpression)$this$getValueArgumentForExpression_u24deparenthesizeStructurally) : $this$getValueArgumentForExpression_u24deparenthesizeStructurally;
        return !Intrinsics.areEqual((Object)deparenthesized, (Object)$this$getValueArgumentForExpression_u24deparenthesizeStructurally) ? deparenthesized : ($this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtLambdaExpression ? (KtElement)((KtLambdaExpression)$this$getValueArgumentForExpression_u24deparenthesizeStructurally).getFunctionLiteral() : ($this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtFunctionLiteral ? (KtElement)((KtFunctionLiteral)$this$getValueArgumentForExpression_u24deparenthesizeStructurally).getBodyExpression() : null));
    }

    private static final boolean getValueArgumentForExpression$isParenthesizedExpression(KtElement $this$getValueArgumentForExpression_u24isParenthesizedExpression, KtExpression $expression) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)$this$getValueArgumentForExpression_u24isParenthesizedExpression, (Function1)getValueArgumentForExpression.isParenthesizedExpression.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KtElement it = (KtElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)$expression)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ KtElement access$getValueArgumentForExpression$deparenthesizeStructurally(KtElement $receiver) {
        return CallUtilKt.getValueArgumentForExpression$deparenthesizeStructurally($receiver);
    }
}

