/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ExternalFunChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class ExternalFunChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof MemberDescriptor) || !((MemberDescriptor)descriptor2).isExternal()) {
            return;
        }
        BindingTrace trace = context2.getTrace();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            String target = declarationDescriptor instanceof PropertyDescriptor ? "property" : (declarationDescriptor instanceof ClassDescriptor ? "class" : "non-function declaration");
            trace.report(Errors.WRONG_MODIFIER_TARGET.on(declaration2, KtTokens.EXTERNAL_KEYWORD, target));
            return;
        }
        if (DescriptorUtils.isInterface(((FunctionDescriptor)descriptor2).getContainingDeclaration())) {
            trace.report(ErrorsJvm.EXTERNAL_DECLARATION_IN_INTERFACE.on((KtDeclaration)((PsiElement)declaration2)));
        } else if (((FunctionDescriptor)descriptor2).getModality() == Modality.ABSTRACT) {
            if (declaration2 instanceof KtPropertyAccessor) {
                trace.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((KtDeclaration)((PsiElement)((KtPropertyAccessor)declaration2).getProperty())));
            } else {
                trace.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((KtDeclaration)((PsiElement)declaration2)));
            }
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && declaration2 instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)declaration2).hasBody()) {
            trace.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_HAVE_BODY.on((KtDeclaration)((PsiElement)declaration2)));
        }
        if (InlineUtil.isInline(descriptor2)) {
            trace.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_INLINED.on((KtDeclaration)((PsiElement)declaration2)));
        }
    }
}

