/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.OverloadabilitySpecificityCallbacks;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureUtilsKt;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J$\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0002J\f\u0010 \u001a\u00020\u001b*\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "getTypeSpecificityComparator", "()Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkShadowedExtensionFunction", "extensionFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkShadowedExtensionProperty", "extensionProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getInvokeOperatorShadowingExtensionFunction", "extension", "member", "isExtensionFunctionShadowedByMemberFunction", "", "isSignatureNotLessSpecific", "extensionSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "memberSignature", "isPublic", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "frontend"})
public final class ShadowedExtensionChecker {
    @NotNull
    private final TypeSpecificityComparator typeSpecificityComparator;
    @NotNull
    private final DiagnosticSink trace;

    public ShadowedExtensionChecker(@NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull DiagnosticSink trace) {
        Intrinsics.checkNotNullParameter((Object)typeSpecificityComparator, (String)"typeSpecificityComparator");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.typeSpecificityComparator = typeSpecificityComparator;
        this.trace = trace;
    }

    @NotNull
    public final TypeSpecificityComparator getTypeSpecificityComparator() {
        return this.typeSpecificityComparator;
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    public final void checkDeclaration(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (declaration2.getName() == null) {
            return;
        }
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        if (AnnotationsForResolveUtilsKt.hasHidesMembersAnnotation((CallableDescriptor)descriptor2)) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableMemberDescriptor)descriptor2).getExtensionReceiverParameter();
        KotlinType kotlinType2 = kotlinType = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
        if (kotlinType == null) {
            return;
        }
        Annotated annotated = kotlinType;
        KotlinType extensionReceiverType = annotated;
        if (KotlinTypeKt.isError(extensionReceiverType)) {
            return;
        }
        if (extensionReceiverType.isMarkedNullable()) {
            return;
        }
        annotated = descriptor2;
        if (annotated instanceof FunctionDescriptor) {
            this.checkShadowedExtensionFunction(declaration2, (FunctionDescriptor)descriptor2, this.trace);
        } else if (annotated instanceof PropertyDescriptor) {
            this.checkShadowedExtensionProperty(declaration2, (PropertyDescriptor)descriptor2, this.trace);
        }
    }

    private final void checkShadowedExtensionFunction(KtDeclaration declaration2, FunctionDescriptor extensionFunction, DiagnosticSink trace) {
        KotlinType kotlinType;
        MemberScope memberScope2;
        Object object = extensionFunction.getExtensionReceiverParameter();
        MemberScope memberScope3 = object == null ? null : (memberScope2 = (kotlinType = object.getType()) == null ? null : kotlinType.getMemberScope());
        if (memberScope2 == null) {
            return;
        }
        MemberScope memberScope4 = memberScope2;
        object = extensionFunction.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensionFunction.name");
        Collection<? extends SimpleFunctionDescriptor> contributedFunctions = memberScope4.getContributedFunctions((Name)object, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : contributedFunctions) {
            if (!this.isPublic(simpleFunctionDescriptor) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, simpleFunctionDescriptor)) continue;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration2), simpleFunctionDescriptor));
            return;
        }
        Name name = extensionFunction.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"extensionFunction.name");
        ClassifierDescriptor nestedClass = memberScope4.getContributedClassifier(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        if (nestedClass instanceof ClassDescriptor && ((ClassDescriptor)nestedClass).isInner() && this.isPublic((DeclarationDescriptorWithVisibility)((Object)nestedClass))) {
            for (ClassConstructorDescriptor constructor2 : ((ClassDescriptor)nestedClass).getConstructors()) {
                Intrinsics.checkNotNullExpressionValue((Object)constructor2, (String)"constructor");
                if (!this.isPublic(constructor2) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, constructor2)) continue;
                trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_INNER_CLASS_CONSTRUCTOR.on((KtDeclaration)((PsiElement)declaration2), constructor2));
                return;
            }
        }
        Name name2 = extensionFunction.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"extensionFunction.name");
        Collection<? extends PropertyDescriptor> collection = memberScope4.getContributedVariables(name2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (PropertyDescriptor propertyDescriptor : collection) {
            FunctionDescriptor invokeOperator;
            if (!this.isPublic(propertyDescriptor) || (invokeOperator = this.getInvokeOperatorShadowingExtensionFunction(extensionFunction, propertyDescriptor)) == null) continue;
            trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_MEMBER_PROPERTY_WITH_INVOKE.on((KtDeclaration)((PsiElement)declaration2), propertyDescriptor, invokeOperator));
            return;
        }
    }

    private final boolean isPublic(DeclarationDescriptorWithVisibility $this$isPublic) {
        return Intrinsics.areEqual((Object)$this$isPublic.getVisibility().normalize(), (Object)DescriptorVisibilities.PUBLIC);
    }

    private final boolean isExtensionFunctionShadowedByMemberFunction(FunctionDescriptor extension, FunctionDescriptor member2) {
        if (extension.getValueParameters().size() != member2.getValueParameters().size()) {
            return false;
        }
        if (DescriptorUtilsKt.varargParameterPosition(extension) != DescriptorUtilsKt.varargParameterPosition(member2)) {
            return false;
        }
        if (extension.isOperator() && !member2.isOperator()) {
            return false;
        }
        if (extension.isInfix() && !member2.isInfix()) {
            return false;
        }
        FlatSignature<CallableDescriptor> extensionSignature = FlatSignatureUtilsKt.createForPossiblyShadowedExtension(FlatSignature.Companion, (CallableDescriptor)extension);
        FlatSignature<CallableDescriptor> memberSignature = FlatSignatureUtilsKt.createFromCallableDescriptor(FlatSignature.Companion, (CallableDescriptor)member2);
        return this.isSignatureNotLessSpecific(extensionSignature, memberSignature);
    }

    private final FunctionDescriptor getInvokeOperatorShadowingExtensionFunction(FunctionDescriptor extension, PropertyDescriptor member2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = member2.getType().getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv;
                boolean bl = false;
                if (!(this.isPublic(it) && it.isOperator() && this.isExtensionFunctionShadowedByMemberFunction(extension, it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isSignatureNotLessSpecific(FlatSignature<? extends FunctionDescriptor> extensionSignature, FlatSignature<? extends FunctionDescriptor> memberSignature) {
        return FlatSignatureKt.isSignatureNotLessSpecific(ConstraintSystemBuilderImpl.Companion.forSpecificity(), extensionSignature, memberSignature, OverloadabilitySpecificityCallbacks.INSTANCE, this.typeSpecificityComparator);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkShadowedExtensionProperty(KtDeclaration declaration2, PropertyDescriptor extensionProperty, DiagnosticSink trace) {
        Object v1;
        Object object;
        Object object2;
        block3: {
            void $this$firstOrNull$iv;
            KotlinType kotlinType;
            object2 = extensionProperty.getExtensionReceiverParameter();
            Object object3 = object2 == null ? null : (object = (kotlinType = object2.getType()) == null ? null : kotlinType.getMemberScope());
            if (object == null) {
                return;
            }
            MemberScope memberScope2 = object;
            object2 = extensionProperty.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extensionProperty.name");
            object2 = memberScope2.getContributedVariables((Name)object2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PropertyDescriptor it = (PropertyDescriptor)element$iv;
                boolean bl = false;
                if (!(this.isPublic(it) && !DescriptorUtilsKt.isExtension(it))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        object = v1;
        if (object != null) {
            object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object memberProperty = object2;
            boolean bl3 = false;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration2), (CallableMemberDescriptor)memberProperty));
        }
    }
}

