/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.SourceManager;
import org.jetbrains.kotlin.ir.SourceRangeInfo;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J5\u0010\f\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0005J5\u0010\f\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011J-\u0010\f\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager;", "Lorg/jetbrains/kotlin/ir/SourceManager;", "()V", "fileEntriesByIrFile", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager$PsiFileEntry;", "fileEntriesByKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFileByFileEntry", "createFileEntry", "ktFile", "findPsiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "E", "psiElementClass", "Lkotlin/reflect/KClass;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiElement;", "irFile", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiElement;", "getFileEntry", "Lorg/jetbrains/kotlin/ir/SourceManager$FileEntry;", "getKtFile", "fileEntry", "getOrCreateFileEntry", "putFileEntry", "", "PsiFileEntry", "ir.psi2ir"})
public final class PsiSourceManager
implements SourceManager {
    @NotNull
    private final HashMap<KtFile, PsiFileEntry> fileEntriesByKtFile = new HashMap();
    @NotNull
    private final HashMap<IrFile, PsiFileEntry> fileEntriesByIrFile = new HashMap();
    @NotNull
    private final HashMap<PsiFileEntry, KtFile> ktFileByFileEntry = new HashMap();

    private final PsiFileEntry createFileEntry(KtFile ktFile) {
        Object object = this.fileEntriesByKtFile;
        boolean bl = false;
        Map map = object;
        boolean bl2 = false;
        if (map.containsKey(ktFile)) {
            object = Intrinsics.stringPlus((String)"PsiFileEntry is already created for ", (Object)ktFile);
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        PsiFileEntry newEntry = new PsiFileEntry(ktFile);
        Map map2 = this.fileEntriesByKtFile;
        boolean bl3 = false;
        map2.put(ktFile, newEntry);
        map2 = this.ktFileByFileEntry;
        bl3 = false;
        map2.put(newEntry, ktFile);
        return newEntry;
    }

    public final void putFileEntry(@NotNull IrFile irFile, @NotNull PsiFileEntry fileEntry) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
        Map map = this.fileEntriesByIrFile;
        boolean bl = false;
        map.put(irFile, fileEntry);
    }

    @NotNull
    public final PsiFileEntry getOrCreateFileEntry(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Map map = this.fileEntriesByKtFile;
        boolean bl = false;
        Object object = map.get(ktFile);
        if (object == null) {
            boolean bl2 = false;
            object = this.createFileEntry(ktFile);
        }
        return (PsiFileEntry)object;
    }

    @Nullable
    public final KtFile getKtFile(@NotNull PsiFileEntry fileEntry) {
        Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
        return this.ktFileByFileEntry.get(fileEntry);
    }

    @Nullable
    public final KtFile getKtFile(@NotNull IrFile irFile) {
        KtFile ktFile;
        PsiFileEntry psiFileEntry;
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        SourceManager.FileEntry fileEntry = irFile.getFileEntry();
        PsiFileEntry psiFileEntry2 = psiFileEntry = fileEntry instanceof PsiFileEntry ? (PsiFileEntry)fileEntry : null;
        if (psiFileEntry == null) {
            ktFile = null;
        } else {
            fileEntry = psiFileEntry;
            boolean bl = false;
            boolean bl2 = false;
            SourceManager.FileEntry it = fileEntry;
            boolean bl3 = false;
            ktFile = this.ktFileByFileEntry.get(it);
        }
        return ktFile;
    }

    @Override
    @Nullable
    public SourceManager.FileEntry getFileEntry(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        PsiFileEntry psiFileEntry = this.fileEntriesByIrFile.get(irFile);
        return psiFileEntry == null ? irFile.getFileEntry() : (SourceManager.FileEntry)psiFileEntry;
    }

    @Nullable
    public final <E extends PsiElement> E findPsiElement(@NotNull IrElement irElement, @NotNull IrFile irFile, @NotNull KClass<E> psiElementClass) {
        PsiFileEntry psiFileEntry;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter(psiElementClass, (String)"psiElementClass");
        PsiFileEntry psiFileEntry2 = this.fileEntriesByIrFile.get(irFile);
        if (psiFileEntry2 == null) {
            return null;
        }
        PsiFileEntry psiFileEntry3 = psiFileEntry = psiFileEntry2;
        return psiFileEntry3.findPsiElement(irElement, psiElementClass);
    }

    @Nullable
    public final PsiElement findPsiElement(@NotNull IrElement irElement, @NotNull IrFile irFile) {
        PsiFileEntry psiFileEntry;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        PsiFileEntry psiFileEntry2 = this.fileEntriesByIrFile.get(irFile);
        if (psiFileEntry2 == null) {
            return null;
        }
        PsiFileEntry psiFileEntry3 = psiFileEntry = psiFileEntry2;
        return psiFileEntry3.findPsiElement(irElement);
    }

    @Nullable
    public final <E extends PsiElement> E findPsiElement(@NotNull IrElement irElement, @NotNull IrDeclaration irDeclaration2, @NotNull KClass<E> psiElementClass) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
        Intrinsics.checkNotNullParameter(psiElementClass, (String)"psiElementClass");
        IrFile irFile = IrUtilsKt.getFileOrNull(irDeclaration2);
        if (irFile == null) {
            return null;
        }
        IrFile irFile2 = irFile;
        return this.findPsiElement(irElement, irFile2, psiElementClass);
    }

    @Nullable
    public final PsiElement findPsiElement(@NotNull IrElement irElement, @NotNull IrDeclaration irDeclaration2) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
        IrFile irFile = IrUtilsKt.getFileOrNull(irDeclaration2);
        if (irFile == null) {
            return null;
        }
        IrFile irFile2 = irFile;
        return this.findPsiElement(irElement, irFile2);
    }

    @Nullable
    public final <E extends PsiElement> E findPsiElement(@NotNull IrDeclaration irDeclaration2, @NotNull KClass<E> psiElementClass) {
        Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
        Intrinsics.checkNotNullParameter(psiElementClass, (String)"psiElementClass");
        return this.findPsiElement((IrElement)irDeclaration2, irDeclaration2, psiElementClass);
    }

    @Nullable
    public final PsiElement findPsiElement(@NotNull IrDeclaration irDeclaration2) {
        Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
        return this.findPsiElement((IrElement)irDeclaration2, irDeclaration2);
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J-\u0010\u0013\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0016J\b\u0010#\u001a\u00020\u000fH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager$PsiFileEntry;", "Lorg/jetbrains/kotlin/ir/SourceManager$FileEntry;", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "fileViewProvider", "Lorg/jetbrains/kotlin/com/intellij/psi/FileViewProvider;", "Lorg/jetbrains/annotations/NotNull;", "lineStartOffsets", "", "maxOffset", "", "getMaxOffset", "()I", "name", "", "getName", "()Ljava/lang/String;", "psiFileName", "findPsiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "E", "psiElementClass", "Lkotlin/reflect/KClass;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiElement;", "getColumnNumber", "offset", "getLineNumber", "getRecognizableName", "getSourceRangeInfo", "Lorg/jetbrains/kotlin/ir/SourceRangeInfo;", "beginOffset", "endOffset", "toString", "ir.psi2ir"})
    public static final class PsiFileEntry
    implements SourceManager.FileEntry {
        @NotNull
        private final String psiFileName;
        private final int maxOffset;
        @NotNull
        private final int[] lineStartOffsets;
        @NotNull
        private final FileViewProvider fileViewProvider;

        public PsiFileEntry(@NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            UserDataHolder userDataHolder = psiFile.getVirtualFile();
            Object object = userDataHolder == null ? null : userDataHolder.getPath();
            Object object2 = object == null ? psiFile.getName() : object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"psiFile.virtualFile?.path ?: psiFile.name");
            this.psiFileName = object2;
            object2 = psiFile.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"psiFile.viewProvider");
            this.fileViewProvider = object2;
            userDataHolder = this.fileViewProvider.getDocument();
            if (userDataHolder == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"No document for ", (Object)psiFile));
            }
            Object document = object = userDataHolder;
            this.maxOffset = document.getTextLength();
            int n = 0;
            int n2 = document.getLineCount();
            int[] nArray = new int[n2];
            PsiFileEntry psiFileEntry = this;
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = document.getLineStartOffset(n3);
            }
            psiFileEntry.lineStartOffsets = nArray;
        }

        @Override
        public int getMaxOffset() {
            return this.maxOffset;
        }

        @Override
        public int getLineNumber(int offset2) {
            if (offset2 < 0) {
                return -1;
            }
            int index2 = ArraysKt.binarySearch$default((int[])this.lineStartOffsets, (int)offset2, (int)0, (int)0, (int)6, null);
            return index2 >= 0 ? index2 : -index2 - 2;
        }

        @Override
        public int getColumnNumber(int offset2) {
            if (offset2 < 0) {
                return -1;
            }
            int lineNumber = this.getLineNumber(offset2);
            return offset2 - this.lineStartOffsets[lineNumber];
        }

        @Override
        @NotNull
        public SourceRangeInfo getSourceRangeInfo(int beginOffset, int endOffset) {
            return new SourceRangeInfo(this.getRecognizableName(), beginOffset, this.getLineNumber(beginOffset), this.getColumnNumber(beginOffset), endOffset, this.getLineNumber(endOffset), this.getColumnNumber(endOffset));
        }

        private final String getRecognizableName() {
            return this.psiFileName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.getRecognizableName();
        }

        @NotNull
        public String toString() {
            return this.getRecognizableName();
        }

        @Nullable
        public final PsiElement findPsiElement(@NotNull IrElement irElement) {
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
            for (psiElement = this.fileViewProvider.findElementAt(irElement.getStartOffset()); psiElement != null; psiElement = psiElement.getParent()) {
                TextRange textRange = psiElement.getTextRange();
                Integer n = textRange == null ? null : Integer.valueOf(textRange.getEndOffset());
                if (n != null && irElement.getEndOffset() == n.intValue()) break;
            }
            return psiElement;
        }

        @Nullable
        public final <E extends PsiElement> E findPsiElement(@NotNull IrElement irElement, @NotNull KClass<E> psiElementClass) {
            E e;
            Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
            Intrinsics.checkNotNullParameter(psiElementClass, (String)"psiElementClass");
            PsiElement psiElement = this.findPsiElement(irElement);
            if (psiElement == null) {
                e = null;
            } else {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                e = (E)PsiTreeUtil.getParentOfType(it, JvmClassMappingKt.getJavaClass(psiElementClass), false);
            }
            return e;
        }
    }
}

