/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/EnumTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "entries", "", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;Lcom/intellij/psi/PsiElement;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getEntries", "()Ljava/util/List;", "createFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateStandardMethods", "", "generateValueOfFunction", "generateValuesFunction", "js.translator"})
public final class EnumTranslator
extends AbstractTranslator {
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final List<ClassDescriptor> entries;
    @NotNull
    private final PsiElement psi;

    public EnumTranslator(@NotNull TranslationContext context2, @NotNull ClassDescriptor descriptor2, @NotNull List<? extends ClassDescriptor> entries, @NotNull PsiElement psi) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        super(context2);
        this.descriptor = descriptor2;
        this.entries = entries;
        this.psi = psi;
    }

    @NotNull
    public final ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final List<ClassDescriptor> getEntries() {
        return this.entries;
    }

    public final void generateStandardMethods() {
        this.generateValuesFunction();
        this.generateValueOfFunction();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValuesFunction() {
        void $this$mapTo$iv$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), StandardNames.ENUM_VALUES);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionByName(descriptor.staticScope, StandardNames.ENUM_VALUES)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassDescriptor classDescriptor2 = (ClassDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsNode jsNode = new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)it), null), new JsExpression[0]).source(this.psi);
            collection.add(jsNode);
        }
        List values = (List)destination$iv$iv;
        JsBlock jsBlock = function2.getBody();
        Collection<JsStatement> collection = jsBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"function.body.statements");
        collection = collection;
        object = new JsReturn(new JsArrayLiteral(values).source(this.psi));
        boolean bl = false;
        boolean bl2 = false;
        Object $this$generateValuesFunction_u24lambda_u2d1 = object;
        boolean bl3 = false;
        ((SourceInfoAwareJsNode)$this$generateValuesFunction_u24lambda_u2d1).setSource(this.psi);
        bl = false;
        collection.add((JsStatement)object);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValueOfFunction() {
        boolean bl;
        JsSwitchMember jsSwitchMember;
        JsExpression $this$mapTo$iv$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), StandardNames.ENUM_VALUE_OF);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionByName(descriptor.staticScope, StandardNames.ENUM_VALUE_OF)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        HasMetadata hasMetadata = JsScope.declareTemporaryName("name");
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"declareTemporaryName(\"name\")");
        JsName nameParam = hasMetadata;
        hasMetadata = function2;
        Collection<JsParameter> collection = ((JsFunction)hasMetadata).getParameters();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"function.parameters");
        collection = collection;
        JsParameter jsParameter = new JsParameter(nameParam);
        boolean bl2 = false;
        collection.add(jsParameter);
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = (JsExpression[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void entry;
            Object item$iv$iv = iterator2.next();
            ClassDescriptor classDescriptor2 = (ClassDescriptor)item$iv$iv;
            JsExpression[] jsExpressionArray = destination$iv$iv;
            boolean bl3 = false;
            jsSwitchMember = new JsCase();
            boolean bl4 = false;
            bl = false;
            JsCase $this$generateValueOfFunction_u24lambda_u2d4_u24lambda_u2d3 = jsSwitchMember;
            boolean bl5 = false;
            $this$generateValueOfFunction_u24lambda_u2d4_u24lambda_u2d3.setCaseExpression(new JsStringLiteral(entry.getName().asString()).source(this.psi));
            JsCase jsCase = $this$generateValueOfFunction_u24lambda_u2d4_u24lambda_u2d3;
            Collection<JsStatement> collection2 = jsCase.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"statements");
            collection2 = collection2;
            JsReturn jsReturn = new JsReturn((JsExpression)new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)entry), null), new JsExpression[0]).source(this.psi));
            boolean bl6 = false;
            boolean bl7 = false;
            JsReturn $this$generateValueOfFunction_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = jsReturn;
            boolean bl8 = false;
            $this$generateValueOfFunction_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.setSource(this.psi);
            bl6 = false;
            collection2.add(jsReturn);
            $this$generateValueOfFunction_u24lambda_u2d4_u24lambda_u2d3.setSource(this.psi);
            JsSwitchMember jsSwitchMember2 = jsSwitchMember;
            jsExpressionArray.add(jsSwitchMember2);
        }
        List clauses = (List)destination$iv$iv;
        JsBinaryOperation message2 = new JsBinaryOperation(JsBinaryOperator.ADD, new JsStringLiteral("No enum constant " + DescriptorUtilsKt.getFqNameSafe(this.descriptor) + '.'), nameParam.makeRef());
        $this$mapTo$iv$iv = this.context().getReferenceToIntrinsic("throwISE");
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv, (String)"context().getReferenceToIntrinsic(Namer.THROW_ILLEGAL_STATE_EXCEPTION_FUN_NAME)");
        JsExpression throwFunction = $this$mapTo$iv$iv;
        destination$iv$iv = new JsExpression[]{message2};
        JsExpressionStatement throwStatement = new JsExpressionStatement((JsExpression)new JsInvocation(throwFunction, (JsExpression[])destination$iv$iv).source(this.psi));
        destination$iv$iv = clauses;
        boolean bl9 = false;
        if (!destination$iv$iv.isEmpty()) {
            SourceInfoAwareJsNode sourceInfoAwareJsNode = new JsDefault();
            boolean bl10 = false;
            boolean bl11 = false;
            JsDefault $this$generateValueOfFunction_u24lambda_u2d5 = sourceInfoAwareJsNode;
            boolean bl12 = false;
            jsSwitchMember = $this$generateValueOfFunction_u24lambda_u2d5;
            Collection<JsStatement> collection3 = jsSwitchMember.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"statements");
            collection3 = collection3;
            bl = false;
            collection3.add(throwStatement);
            $this$generateValueOfFunction_u24lambda_u2d5.setSource(this.psi);
            JsDefault defaultCase = sourceInfoAwareJsNode;
            sourceInfoAwareJsNode = function2.getBody();
            Collection<JsStatement> collection4 = ((JsBlock)sourceInfoAwareJsNode).getStatements();
            Intrinsics.checkNotNullExpressionValue(collection4, (String)"function.body.statements");
            collection4 = collection4;
            JsSwitch jsSwitch = new JsSwitch(nameParam.makeRef().source(this.psi), CollectionsKt.plus((Collection)clauses, (Object)defaultCase));
            boolean bl13 = false;
            boolean bl14 = false;
            JsSwitch $this$generateValueOfFunction_u24lambda_u2d6 = jsSwitch;
            boolean bl15 = false;
            $this$generateValueOfFunction_u24lambda_u2d6.setSource(this.psi);
            bl13 = false;
            collection4.add(jsSwitch);
        } else {
            JsBlock jsBlock = function2.getBody();
            Collection<JsStatement> collection5 = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection5, (String)"function.body.statements");
            collection5 = collection5;
            boolean bl16 = false;
            collection5.add(throwStatement);
        }
    }

    private final JsFunction createFunction(FunctionDescriptor functionDescriptor) {
        JsFunction jsFunction = this.context().getFunctionObject(functionDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"context().getFunctionObject(functionDescriptor)");
        JsFunction function2 = jsFunction;
        function2.setName(this.context().getInnerNameForDescriptor(functionDescriptor));
        function2.setSource(this.psi);
        this.context().addDeclarationStatement(function2.makeStmt());
        JsExpression jsExpression = this.context().getInnerReference(this.descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"context().getInnerReference(descriptor)");
        JsExpression classRef = jsExpression;
        JsNameRef jsNameRef = function2.getName().makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"function.name.makeRef()");
        JsNameRef functionRef = jsNameRef;
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(new JsNameRef(this.context().getNameForDescriptor(functionDescriptor), classRef), functionRef);
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"assignment(JsNameRef(context().getNameForDescriptor(functionDescriptor), classRef), functionRef)");
        JsBinaryOperation assignment = jsBinaryOperation;
        this.context().addDeclarationStatement(assignment.makeStmt());
        return function2;
    }
}

