/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineBodyTransformer;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\nH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010 \u001a\u00020\nH\u0002J,\u0010\"\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\b\u0010$\u001a\u00020%H\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\b\u0010'\u001a\u00020\u0010H\u0002J,\u0010(\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\"\u0010.\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J\f\u0010/\u001a\u00020\u0010*\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "name", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Ljava/lang/String;)V", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "className", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "functionWithBody", "innerFunction", "localVariables", "", "generateContinuationConstructor", "", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "globalCatchBlockIndex", "", "survivingLocalVars", "", "generateCoroutineBody", "", "blocks", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "generateCoroutineInstantiation", "generateCoroutineMetadata", "constructorName", "generateCoroutinePrototype", "generateDoResume", "coroutineBlocks", "isTailCall", "", "transform", "transformSimple", "assignToField", "fieldName", "value", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "assignToPrototype", "collectAdditionalLocalVariables", "js.translator"})
public final class CoroutineFunctionTransformer {
    @NotNull
    private final JsFunction function;
    @Nullable
    private final JsFunction innerFunction;
    @NotNull
    private final JsFunction functionWithBody;
    @NotNull
    private final JsBlock body;
    @NotNull
    private final Set<JsName> localVariables;
    @NotNull
    private final JsName className;

    public CoroutineFunctionTransformer(@NotNull JsFunction function2, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.function = function2;
        HasMetadata hasMetadata = this.innerFunction = FunctionUtilsKt.getInnerFunction(this.function);
        this.functionWithBody = hasMetadata == null ? this.function : hasMetadata;
        hasMetadata = this.functionWithBody.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"functionWithBody.body");
        this.body = hasMetadata;
        Set set = SetsKt.plus((Set)CollectUtilsKt.collectLocalVariables$default(this.function, false, 1, null), (Iterable)CollectUtilsKt.collectLocalVariables$default(this.functionWithBody, false, 1, null));
        Object object = this.functionWithBody.getParameters();
        Intrinsics.checkNotNullExpressionValue(object, (String)"functionWithBody.parameters");
        hasMetadata = ((JsParameter)CollectionsKt.last(object)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"functionWithBody.parameters.last().name");
        this.localVariables = CollectionsKt.toMutableSet((Iterable)SetsKt.minus((Set)set, (Object)hasMetadata));
        object = name;
        hasMetadata = JsScope.declareTemporaryName(Intrinsics.stringPlus((String)"Coroutine$", (Object)(object == null ? "anonymous" : object)));
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"declareTemporaryName(\"Coroutine\\$${name ?: \"anonymous\"}\")");
        this.className = hasMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsStatement> transform() {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.isTailCall() && !MetadataProperties.getForceStateMachine(this.function)) {
            this.transformSimple();
            return CollectionsKt.emptyList();
        }
        JsFunctionScope jsFunctionScope = this.function.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)jsFunctionScope, (String)"function.scope");
        CoroutineTransformationContext context2 = new CoroutineTransformationContext(jsFunctionScope, this.function);
        CoroutineBodyTransformer bodyTransformer = new CoroutineBodyTransformer(context2);
        bodyTransformer.preProcess(this.body);
        List<JsStatement> list2 = this.body.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"body.statements");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            it.accept(bodyTransformer);
        }
        List<CoroutineBlock> coroutineBlocks = bodyTransformer.postProcess();
        int globalCatchBlockIndex = coroutineBlocks.indexOf(context2.getGlobalCatchBlock());
        Iterable $this$forEach$iv2 = coroutineBlocks;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CoroutineBlock it = (CoroutineBlock)element$iv;
            boolean bl = false;
            this.collectAdditionalLocalVariables(it.getJsBlock());
        }
        Iterable<JsParameter> $i$f$forEach22 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue($i$f$forEach22, (String)"function.parameters");
        $i$f$forEach22 = $i$f$forEach22;
        Set<JsName> set = this.localVariables;
        List<CoroutineBlock> list3 = coroutineBlocks;
        boolean $i$f$map = false;
        void element$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)destination$iv$iv;
        Set<JsName> survivingLocalVars = CoroutinePassesKt.collectVariablesSurvivingBetweenBlocks(list3, set, CollectionsKt.toSet((Iterable)collection));
        Iterable $this$forEach$iv3 = coroutineBlocks;
        boolean $i$f$forEach3 = false;
        for (Object element$iv2 : $this$forEach$iv3) {
            CoroutineBlock it = (CoroutineBlock)element$iv2;
            boolean bl = false;
            CoroutinePassesKt.replaceLocalVariables(it.getJsBlock(), context2, survivingLocalVars);
        }
        boolean bl = false;
        List additionalStatements2 = new ArrayList();
        this.generateDoResume(coroutineBlocks, context2, additionalStatements2);
        this.generateContinuationConstructor(context2, additionalStatements2, globalCatchBlockIndex, survivingLocalVars);
        this.generateCoroutineInstantiation(context2);
        return additionalStatements2;
    }

    private final boolean isTailCall() {
        boolean bl = false;
        HashSet<JsExpression> suspendCalls = new HashSet<JsExpression>();
        this.body.accept(new RecursiveJsVisitor(suspendCalls){
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.$suspendCalls = $suspendCalls;
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof JsExpression && MetadataProperties.isSuspend((JsExpression)node)) {
                    Collection collection = this.$suspendCalls;
                    JsNode jsNode = node;
                    boolean bl = false;
                    collection.add(jsNode);
                }
                super.visitElement(node);
            }
        });
        if (suspendCalls.isEmpty()) {
            return true;
        }
        this.body.accept(new RecursiveJsVisitor(this, suspendCalls){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.this$0 = $receiver;
                this.$suspendCalls = $suspendCalls;
            }

            public void visitBlock(@NotNull JsBlock x) {
                List<JsStatement> list2;
                JsReturn jsReturn;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visitBlock(x);
                if (CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements().size() < 2) {
                    return;
                }
                Object object = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                Intrinsics.checkNotNullExpressionValue(object, (String)"body.statements");
                Object object2 = CollectionsKt.last(object);
                JsReturn jsReturn2 = jsReturn = object2 instanceof JsReturn ? (JsReturn)object2 : null;
                if (jsReturn == null) {
                    return;
                }
                JsReturn lastStatement = jsReturn;
                if (!CoroutinePassesKt.isStateMachineResult(lastStatement.getExpression())) {
                    return;
                }
                List<JsStatement> list3 = list2 = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"body.statements");
                object = list3.get(CollectionsKt.getLastIndex(list2) - 1);
                Object object3 = object2 = object instanceof JsExpressionStatement ? (JsExpressionStatement)object : null;
                if (object2 == null) {
                    return;
                }
                Object statementBeforeLast = object2;
                object = ((JsExpressionStatement)statementBeforeLast).getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"statementBeforeLast.expression");
                Pair<JsExpression, JsExpression> suspendExpression = object;
                if (this.$suspendCalls.contains(suspendExpression)) {
                    object = this.$suspendCalls;
                    boolean bl = false;
                    object.remove(suspendExpression);
                } else {
                    object = JsAstUtils.decomposeAssignment((JsExpression)suspendExpression);
                    if (object != null) {
                        list2 = object;
                        HashSet<JsExpression> hashSet = this.$suspendCalls;
                        boolean bl = false;
                        boolean bl2 = false;
                        List<JsStatement> $dstr$lhs$rhs = list2;
                        boolean bl3 = false;
                        JsExpression lhs = (JsExpression)$dstr$lhs$rhs.component1();
                        JsExpression rhs = (JsExpression)$dstr$lhs$rhs.component2();
                        if (hashSet.contains(rhs) && CoroutinePassesKt.isStateMachineResult(lhs)) {
                            Collection collection = hashSet;
                            boolean bl4 = false;
                            collection.remove(rhs);
                        }
                    }
                }
            }
        });
        return suspendCalls.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSimple() {
        void $this$transformSimple_u24lambda_u2d4;
        List<JsParameter> list2 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"function.parameters");
        JsParameter continuationParam = (JsParameter)CollectionsKt.last(list2);
        HasMetadata hasMetadata = JsScope.declareTemporaryName("$result");
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"declareTemporaryName(\"\\$result\")");
        JsName resultVar = hasMetadata;
        Intrinsics.checkNotNullExpressionValue((Object)continuationParam, (String)"continuationParam");
        CoroutinePassesKt.replaceSpecialReferencesInSimpleFunction(this.body, continuationParam, resultVar);
        hasMetadata = JsAstUtils.newVar(resultVar, null);
        boolean bl = false;
        boolean bl2 = false;
        HasMetadata hasMetadata2 = hasMetadata;
        int n = 0;
        List<JsStatement> list3 = this.body.getStatements();
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$transformSimple_u24lambda_u2d4, (String)"");
        MetadataProperties.setSynthetic((HasMetadata)$this$transformSimple_u24lambda_u2d4, true);
        Unit unit = Unit.INSTANCE;
        list3.add(n, (JsStatement)((Object)hasMetadata));
        new JsVisitorWithContextImpl(resultVar){
            final /* synthetic */ JsName $resultVar;
            {
                this.$resultVar = $resultVar;
            }

            public void endVisit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                if (MetadataProperties.isSuspend(jsExpression)) {
                    ctx.replaceMe((JsNode)JsAstUtils.assignment(JsAstUtils.pureFqn(this.$resultVar, null), x.getExpression()).source(x.getSource()).makeStmt());
                }
                super.endVisit(x, ctx);
            }
        }.accept((JsNode)this.body);
        new FunctionPostProcessor(this.functionWithBody).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateContinuationConstructor(CoroutineTransformationContext context2, List<JsStatement> statements2, int globalCatchBlockIndex, Set<? extends JsName> survivingLocalVars) {
        SourceInfoAwareJsNode sourceInfoAwareJsNode;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Object object2;
        JsName lastParameter;
        Object object3;
        Collection collection;
        Object object4;
        void $this$mapTo$iv$iv222;
        PsiElement psiElement = context2.getMetadata().getPsiElement();
        JsFunction constructor2 = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "Continuation");
        constructor2.setSource(psiElement);
        Object object5 = psiElement;
        Object object6 = object5 == null ? null : UtilsKt.getFinalElement((PsiElement)object5);
        constructor2.getBody().setSource(object6 instanceof LeafPsiElement ? (LeafPsiElement)object6 : null);
        constructor2.setName(this.className);
        if (context2.getMetadata().getHasReceiver()) {
            object6 = constructor2;
            object5 = ((JsFunction)object6).getParameters();
            Intrinsics.checkNotNullExpressionValue(object5, (String)"constructor.parameters");
            object5 = (Collection)object5;
            JsParameter jsParameter = new JsParameter(context2.getReceiverFieldName());
            boolean bl = false;
            object5.add((JsParameter)jsParameter);
        }
        object5 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(object5, (String)"function.parameters");
        Collection collection2 = (Collection)object5;
        object5 = this.innerFunction;
        object5 = object5 == null ? null : ((JsFunction)object5).getParameters();
        boolean bl = false;
        Object object7 = object5;
        if (object7 == null) {
            object7 = CollectionsKt.emptyList();
        }
        List parameters2 = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object7));
        object5 = constructor2;
        Object object8 = ((JsFunction)object5).getParameters();
        Intrinsics.checkNotNullExpressionValue(object8, (String)"constructor.parameters");
        object8 = (Collection)object8;
        Object $this$map$iv = parameters2;
        boolean $i$f$map232 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object9 = $this$mapTo$iv$iv222.iterator();
        while (object9.hasNext()) {
            Iterator it2;
            Object item$iv$iv = object9.next();
            object4 = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object3 = new JsParameter(((JsParameter)((Object)it2)).getName());
            collection.add(object3);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map232 = false;
        CollectionsKt.addAll(object8, (Iterable)$this$map$iv);
        object8 = (JsParameter)CollectionsKt.lastOrNull((List)parameters2);
        JsName jsName = lastParameter = object8 == null ? null : ((JsParameter)object8).getName();
        if (context2.getMetadata().getHasController()) {
            $this$map$iv = JsScope.declareTemporaryName("controller");
            $i$f$map232 = false;
            boolean $this$mapTo$iv$iv222 = false;
            Object $this$generateContinuationConstructor_u24lambda_u2d6 = $this$map$iv;
            boolean bl3 = false;
            Object object10 = object9 = constructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"constructor.parameters");
            object10.add(CollectionsKt.getLastIndex((List)object9), (JsParameter)new JsParameter((JsName)$this$generateContinuationConstructor_u24lambda_u2d6));
            object2 = $this$map$iv;
        } else {
            object2 = null;
        }
        JsName controllerName = object2;
        Intrinsics.checkNotNull((Object)lastParameter);
        JsNameRef $i$f$map232 = lastParameter.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map232, (String)"!!.makeRef()");
        JsNameRef interceptorRef = $i$f$map232;
        List<JsParameter> $this$mapTo$iv$iv222 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue($this$mapTo$iv$iv222, (String)"function.parameters");
        Iterable $this$map$iv2 = $this$mapTo$iv$iv222;
        boolean $i$f$map = false;
        Iterable bl3 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            object3 = jsParameter.getName();
            collection.add(object3);
        }
        Collection collection3 = (List)destination$iv$iv2;
        Object object11 = this.innerFunction;
        if (object11 == null) {
            object = null;
        } else {
            List<JsParameter> list2 = object11.getParameters();
            if (list2 == null) {
                object = null;
            } else {
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                $this$mapTo$iv$iv = list2;
                collection = collection3;
                boolean $i$f$map3 = false;
                void $i$f$mapTo222 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it3;
                    sourceInfoAwareJsNode = (JsParameter)item$iv$iv;
                    object3 = destination$iv$iv3;
                    boolean bl5 = false;
                    JsName jsName2 = it3.getName();
                    object3.add(jsName2);
                }
                object3 = (List)destination$iv$iv3;
                collection3 = collection;
                object = object3;
            }
        }
        object11 = object;
        boolean bl6 = false;
        Object object12 = object11;
        if (object12 == null) {
            object12 = CollectionsKt.emptyList();
        }
        Set parameterNames = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection3, (Iterable)((Iterable)object12)));
        object11 = constructor2.getBody().getStatements();
        bl6 = false;
        boolean bl7 = false;
        Object[] $this$generateContinuationConstructor_u24lambda_u2d9 = object11;
        boolean bl8 = false;
        object4 = context2.getMetadata().getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.metadata.baseClassRef.deepCopy()");
        SourceInfoAwareJsNode baseClass = object4;
        Intrinsics.checkNotNullExpressionValue((Object)$this$generateContinuationConstructor_u24lambda_u2d9, (String)"this");
        object4 = (Collection)$this$generateContinuationConstructor_u24lambda_u2d9;
        JsExpression[] jsExpressionArray = new JsExpression[]{new JsThisRef(), interceptorRef};
        JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)Namer.getFunctionCallRef((JsExpression)baseClass), jsExpressionArray).source(psiElement)).makeStmt();
        boolean item$iv$iv = false;
        object4.add(jsStatement);
        if (controllerName != null) {
            object4 = context2.getControllerFieldName();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.controllerFieldName");
            Iterator<? extends JsName> iterator2 = object4;
            object4 = controllerName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"controllerName.makeRef()");
            this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, (JsName)((Object)iterator2), (JsExpression)object4, psiElement);
        }
        this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, context2.getMetadata().getExceptionStateName(), new JsIntLiteral(globalCatchBlockIndex), psiElement);
        if (context2.getMetadata().getHasReceiver()) {
            object4 = context2.getReceiverFieldName();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.receiverFieldName");
            Object object13 = object4;
            object4 = context2.getReceiverFieldName().makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.receiverFieldName.makeRef()");
            this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, (JsName)object13, (JsExpression)object4, psiElement);
        }
        for (JsName jsName3 : survivingLocalVars) {
            sourceInfoAwareJsNode = !parameterNames.contains(jsName3) ? Namer.getUndefinedExpression() : (JsExpression)jsName3.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode, (String)"if (localVariable !in parameterNames) Namer.getUndefinedExpression() else localVariable.makeRef()");
            SourceInfoAwareJsNode value2 = sourceInfoAwareJsNode;
            this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, context2.getFieldName(jsName3), (JsExpression)value2, psiElement);
        }
        object11 = new JsStatement[2];
        object11[0] = constructor2.makeStmt();
        JsName jsName3 = constructor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"constructor.name");
        object11[1] = this.generateCoroutineMetadata(jsName3);
        Collection collection4 = CollectionsKt.listOf((Object[])object11);
        object11 = constructor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"constructor.name");
        statements2.addAll(0, CollectionsKt.plus((Collection)collection4, (Iterable)this.generateCoroutinePrototype((JsName)object11)));
    }

    private final List<JsStatement> generateCoroutinePrototype(JsName constructorName) {
        JsExpression jsExpression = JsAstUtils.prototypeOf(new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(JsNameRef(constructorName))");
        JsExpression prototype = jsExpression;
        Object object = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull((Object)object);
        JsInvocation jsInvocation = Namer.createObjectWithPrototypeFrom(((CoroutineMetadata)object).getBaseClassRef().deepCopy());
        Intrinsics.checkNotNullExpressionValue((Object)jsInvocation, (String)"createObjectWithPrototypeFrom(function.coroutineMetadata!!.baseClassRef.deepCopy())");
        JsInvocation baseClass = jsInvocation;
        object = JsAstUtils.assignment(prototype, baseClass);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assignment(prototype, baseClass)");
        Object assignPrototype = object;
        Object[] objectArray = JsAstUtils.assignment(new JsNameRef("constructor", prototype.deepCopy()), new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"assignment(JsNameRef(\"constructor\", prototype.deepCopy()), JsNameRef(constructorName))");
        Object[] assignConstructor = objectArray;
        objectArray = new JsStatement[2];
        JsStatement jsStatement = ((JsExpression)assignPrototype).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"assignPrototype.makeStmt()");
        objectArray[0] = jsStatement;
        jsStatement = assignConstructor.makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"assignConstructor.makeStmt()");
        objectArray[1] = jsStatement;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final JsStatement generateCoroutineMetadata(JsName constructorName) {
        Object object = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull((Object)object);
        JsExpression jsExpression = ((CoroutineMetadata)object).getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"function.coroutineMetadata!!.baseClassRef.deepCopy()");
        JsExpression baseClassRefRef = jsExpression;
        object = new JsObjectLiteral(true);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$generateCoroutineMetadata_u24lambda_u2d10 = object;
        boolean bl3 = false;
        Object object2 = $this$generateCoroutineMetadata_u24lambda_u2d10;
        Collection<JsPropertyInitializer> collection = ((JsObjectLiteral)object2).getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"propertyInitializers");
        collection = collection;
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("kind"), new JsNameRef("CLASS", (JsExpression)new JsNameRef("Kind", "Kotlin")));
        boolean bl4 = false;
        collection.add(jsPropertyInitializer);
        object2 = $this$generateCoroutineMetadata_u24lambda_u2d10;
        collection = ((JsObjectLiteral)object2).getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"propertyInitializers");
        jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("simpleName"), new JsNullLiteral());
        bl4 = false;
        collection.add(jsPropertyInitializer);
        object2 = $this$generateCoroutineMetadata_u24lambda_u2d10;
        collection = ((JsObjectLiteral)object2).getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"propertyInitializers");
        jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("interfaces"), new JsArrayLiteral(CollectionsKt.listOf((Object)baseClassRefRef)));
        bl4 = false;
        collection.add(jsPropertyInitializer);
        Object metadataObject = object;
        object = JsAstUtils.assignment(new JsNameRef("$metadata$", (JsExpression)constructorName.makeRef()), (JsExpression)metadataObject).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assignment(JsNameRef(Namer.METADATA, constructorName.makeRef()), metadataObject).makeStmt()");
        return object;
    }

    private final void generateDoResume(List<CoroutineBlock> coroutineBlocks, CoroutineTransformationContext context2, List<JsStatement> statements2) {
        JsFunction resumeFunction = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "resume function");
        PsiElement psi = context2.getMetadata().getPsiElement();
        resumeFunction.setSource(psi);
        Object object = psi;
        PsiElement psiElement = object == null ? null : UtilsKt.getFinalElement((PsiElement)object);
        resumeFunction.getBody().setSource(psiElement instanceof LeafPsiElement ? (LeafPsiElement)psiElement : null);
        List<JsStatement> coroutineBody = this.generateCoroutineBody(context2, coroutineBlocks);
        this.functionWithBody.getBody().getStatements().clear();
        object = resumeFunction.getBody().getStatements();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$generateDoResume_u24lambda_u2d11 = object;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$generateDoResume_u24lambda_u2d11, (String)"this");
        Collection collection = (Collection)$this$generateDoResume_u24lambda_u2d11;
        boolean bl4 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)coroutineBody);
        JsName resumeName = context2.getMetadata().getDoResumeName();
        List<JsStatement> list2 = statements2;
        bl2 = false;
        boolean bl5 = false;
        List<JsStatement> $this$generateDoResume_u24lambda_u2d12 = list2;
        boolean bl6 = false;
        this.assignToPrototype($this$generateDoResume_u24lambda_u2d12, resumeName, resumeFunction);
        new FunctionPostProcessor(resumeFunction).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCoroutineInstantiation(CoroutineTransformationContext context2) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = context2.getMetadata().getPsiElement();
        JsNew jsNew = new JsNew(this.className.makeRef());
        boolean bl = false;
        boolean bl2 = false;
        JsNew $this$generateCoroutineInstantiation_u24lambda_u2d132 = jsNew;
        boolean bl3 = false;
        $this$generateCoroutineInstantiation_u24lambda_u2d132.setSource(psiElement);
        JsNew instantiation = jsNew;
        if (context2.getMetadata().getHasReceiver()) {
            jsNew = instantiation;
            Collection<JsExpression> collection = jsNew.getArguments();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"instantiation.arguments");
            collection = collection;
            JsThisRef jsThisRef = new JsThisRef();
            boolean $this$generateCoroutineInstantiation_u24lambda_u2d132 = false;
            collection.add(jsThisRef);
        }
        Object object = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(object, (String)"function.parameters");
        Collection collection = (Collection)object;
        object = this.innerFunction;
        object = object == null ? null : ((JsFunction)object).getParameters();
        bl2 = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        List parameters2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object2));
        object = instantiation;
        Object object3 = ((JsExpression.JsExpressionHasArguments)object).getArguments();
        Intrinsics.checkNotNullExpressionValue(object3, (String)"instantiation.arguments");
        object3 = (Collection)object3;
        Object $this$map$iv = CollectionsKt.dropLast((List)parameters2, (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            JsNameRef jsNameRef = it.getName().makeRef();
            collection2.add(jsNameRef);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean bl5 = false;
        CollectionsKt.addAll(object3, (Iterable)$this$map$iv);
        object = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull((Object)object);
        if (((CoroutineMetadata)object).getHasController()) {
            object = instantiation;
            object3 = ((JsExpression.JsExpressionHasArguments)object).getArguments();
            Intrinsics.checkNotNullExpressionValue(object3, (String)"instantiation.arguments");
            object3 = (Collection)object3;
            $this$map$iv = new JsThisRef();
            bl5 = false;
            object3.add((JsExpression)$this$map$iv);
        }
        object = instantiation;
        object3 = ((JsExpression.JsExpressionHasArguments)object).getArguments();
        Intrinsics.checkNotNullExpressionValue(object3, (String)"instantiation.arguments");
        object3 = (Collection)object3;
        $this$map$iv = ((JsParameter)CollectionsKt.last((List)parameters2)).getName().makeRef();
        bl5 = false;
        object3.add((JsExpression)$this$map$iv);
        object3 = JsScope.declareTemporaryName("suspended");
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"declareTemporaryName(\"suspended\")");
        Object suspendedName = object3;
        object3 = this.functionWithBody;
        $this$map$iv = ((JsFunction)object3).getParameters();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, (String)"functionWithBody.parameters");
        $this$map$iv = (Collection)$this$map$iv;
        Object object4 = new JsParameter((JsName)suspendedName);
        boolean bl6 = false;
        $this$map$iv.add((JsParameter)object4);
        $this$map$iv = JsScope.declareTemporaryName("instance");
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"declareTemporaryName(\"instance\")");
        Object instanceName = $this$map$iv;
        $this$map$iv = this.functionWithBody.getBody();
        object4 = ((JsBlock)$this$map$iv).getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"functionWithBody.body.statements");
        object4 = (Collection)object4;
        Iterable<JsVars.JsVar> iterable2 = JsAstUtils.newVar((JsName)instanceName, instantiation);
        boolean bl7 = false;
        object4.add(iterable2);
        object4 = new JsExpression[]{new JsNullLiteral()};
        JsReturn invokeResume = new JsReturn((JsExpression)new JsInvocation((JsExpression)new JsNameRef(context2.getMetadata().getDoResumeName(), (JsExpression)((JsName)instanceName).makeRef()), (JsExpression[])object4).source(psiElement));
        object4 = this.functionWithBody.getBody();
        iterable2 = ((JsBlock)object4).getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"functionWithBody.body.statements");
        iterable2 = (Collection)iterable2;
        JsIf jsIf = new JsIf(((JsName)suspendedName).makeRef().source(psiElement), new JsReturn(((JsName)instanceName).makeRef().source(psiElement)), invokeResume);
        boolean bl8 = false;
        iterable2.add(jsIf);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> generateCoroutineBody(CoroutineTransformationContext context2, List<CoroutineBlock> blocks) {
        void $this$mapTo$iv$iv2;
        int indexOfGlobalCatch = blocks.indexOf(context2.getGlobalCatchBlock());
        JsNameRef stateRef = new JsNameRef(context2.getMetadata().getStateName(), (JsExpression)new JsThisRef());
        JsNameRef exceptionStateRef = new JsNameRef(context2.getMetadata().getExceptionStateName(), (JsExpression)new JsThisRef());
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(stateRef, new JsIntLiteral(indexOfGlobalCatch));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"equality(stateRef, JsIntLiteral(indexOfGlobalCatch))");
        JsBinaryOperation isFromGlobalCatch = jsBinaryOperation;
        JsCatch jsCatch = new JsCatch(this.functionWithBody.getScope(), "e");
        JsStatement[] jsStatementArray = new JsStatement[]{JsAstUtils.assignment(stateRef.deepCopy(), exceptionStateRef.deepCopy()).makeStmt(), JsAstUtils.assignment(new JsNameRef(context2.getMetadata().getExceptionName(), (JsExpression)new JsThisRef()), jsCatch.getParameter().getName().makeRef()).makeStmt()};
        JsBlock continueWithException = new JsBlock(jsStatementArray);
        JsStatement[] jsStatementArray2 = JsAstUtils.assignment(exceptionStateRef.deepCopy(), stateRef.deepCopy()).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatementArray2, (String)"assignment(exceptionStateRef.deepCopy(), stateRef.deepCopy()).makeStmt()");
        JsStatement[] adjustExceptionState = jsStatementArray2;
        jsStatementArray2 = new JsStatement[]{adjustExceptionState, new JsThrow(jsCatch.getParameter().getName().makeRef())};
        jsCatch.setBody(new JsBlock((JsStatement)new JsIf(isFromGlobalCatch, new JsBlock(jsStatementArray2), continueWithException)));
        JsNameRef throwResultRef = new JsNameRef(context2.getMetadata().getExceptionName(), (JsExpression)new JsThisRef());
        CoroutineBlock coroutineBlock = context2.getGlobalCatchBlock();
        Collection collection = coroutineBlock.getStatements();
        JsThrow jsThrow = new JsThrow(throwResultRef);
        boolean bl = false;
        collection.add(jsThrow);
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)blocks);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $dstr$index$block;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            int index2 = $dstr$index$block.component1();
            CoroutineBlock block = (CoroutineBlock)$dstr$index$block.component2();
            JsCase jsCase = new JsCase();
            boolean bl3 = false;
            boolean bl4 = false;
            JsCase $this$generateCoroutineBody_u24lambda_u2d16_u24lambda_u2d15 = jsCase;
            boolean bl5 = false;
            $this$generateCoroutineBody_u24lambda_u2d16_u24lambda_u2d15.setCaseExpression(new JsIntLiteral(index2));
            JsCase jsCase2 = $this$generateCoroutineBody_u24lambda_u2d16_u24lambda_u2d15;
            Collection<JsStatement> collection3 = jsCase2.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"statements");
            collection3 = collection3;
            Iterable iterable2 = block.getStatements();
            boolean bl6 = false;
            CollectionsKt.addAll(collection3, (Iterable)iterable2);
            JsCase jsCase3 = jsCase;
            collection2.add(jsCase3);
        }
        List cases = (List)destination$iv$iv;
        JsDefault $i$f$map22 = new JsDefault();
        boolean $this$mapTo$iv$iv2 = false;
        boolean bl7 = false;
        JsDefault $this$generateCoroutineBody_u24lambda_u2d17 = $i$f$map22;
        boolean bl8 = false;
        Object object = new JsStatement[]{JsAstUtils.assignment(stateRef, new JsIntLiteral(indexOfGlobalCatch)).makeStmt(), new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf((Object)new JsStringLiteral("State Machine Unreachable execution"))))};
        JsBlock block = new JsBlock((JsStatement[])object);
        object = $this$generateCoroutineBody_u24lambda_u2d17;
        Collection<JsStatement> collection4 = ((JsSwitchMember)object).getStatements();
        Intrinsics.checkNotNullExpressionValue(collection4, (String)"statements");
        collection4 = collection4;
        boolean bl9 = false;
        collection4.add(block);
        JsDefault defaultCase = $i$f$map22;
        JsSwitch switchStatement = new JsSwitch(stateRef.deepCopy(), CollectionsKt.plus((Collection)cases, (Object)defaultCase));
        JsDoWhile loop2 = new JsDoWhile(new JsBooleanLiteral(true), new JsTry(new JsBlock((JsStatement)switchStatement), jsCatch, null));
        return CollectionsKt.listOf((Object)loop2);
    }

    private final void collectAdditionalLocalVariables(JsBlock $this$collectAdditionalLocalVariables) {
        $this$collectAdditionalLocalVariables.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visit(x);
                CoroutineFunctionTransformer coroutineFunctionTransformer = this.this$0;
                Collection collection = CoroutineFunctionTransformer.access$getLocalVariables$p(coroutineFunctionTransformer);
                JsName jsName = x.getName();
                boolean bl = false;
                collection.add(jsName);
            }
        });
    }

    private final void assignToField(List<JsStatement> $this$assignToField, JsName fieldName, JsExpression value2, PsiElement psiElement) {
        Collection collection = $this$assignToField;
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), value2).source(psiElement).makeStmt();
        boolean bl = false;
        collection.add(jsStatement);
    }

    private final void assignToPrototype(List<JsStatement> $this$assignToPrototype, JsName fieldName, JsExpression value2) {
        Collection collection = $this$assignToPrototype;
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(fieldName, JsAstUtils.prototypeOf(this.className.makeRef())), value2).makeStmt();
        boolean bl = false;
        collection.add(jsStatement);
    }

    public static final /* synthetic */ JsBlock access$getBody$p(CoroutineFunctionTransformer $this) {
        return $this.body;
    }

    public static final /* synthetic */ Set access$getLocalVariables$p(CoroutineFunctionTransformer $this) {
        return $this.localVariables;
    }
}

