/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.BackingFieldSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.backend.js.utils.ParameterTypeBasedSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.Signature;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNameSignature;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u001b\u0010\u000b\u001a\u00020\u0001\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0007\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\r\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0010\u0010\u0010\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00120\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SYNTHETIC_LOOP_LABEL", "", "fieldSignature", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Signature;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "jsFunctionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "mapToKey", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class NameTablesKt {
    /*
     * WARNING - void declaration
     */
    private static final <T> String mapToKey(T declaration2) {
        String string2;
        JsManglerIr jsManglerIr = JsManglerIr.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JsManglerIr $this$mapToKey_u24lambda_u2d1 = jsManglerIr;
        boolean bl3 = false;
        if (declaration2 instanceof IrDeclaration) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.getHashedMangle(declaration2));
        } else if (declaration2 instanceof Signature) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.getHashMangle(((Signature)declaration2).toString()));
        } else {
            String string3;
            String string4 = "Key is not generated for ";
            Object object = declaration2;
            if (object == null) {
                string3 = null;
            } else {
                void it;
                T t = object;
                boolean bl4 = false;
                boolean bl5 = false;
                T t2 = t;
                String string5 = string4;
                boolean bl6 = false;
                String string6 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                string4 = string5;
                string3 = string6;
            }
            object = Intrinsics.stringPlus((String)string4, string3);
            boolean bl7 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return string2;
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, (String)"<this>");
        return Intrinsics.stringPlus((String)"Names: \n", (Object)CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$dump.getNames()), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.1.INSTANCE, (int)30, null));
    }

    @NotNull
    public static final Signature fieldSignature(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (IrUtilsKt.isEffectivelyExternal(field)) {
            String string2 = field.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name.identifier");
            return new StableNameSignature(string2);
        }
        return new BackingFieldSignature(field);
    }

    @NotNull
    public static final Signature jsFunctionSignature(@NotNull IrFunction declaration2, @Nullable JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        boolean bl = !IrFunctionKt.isStaticMethodOfClass(declaration2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = declaration2.getDispatchReceiverParameter() != null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        String string4 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"declaration.getJsNameOrKotlinName().asString()");
        String declarationName = string4;
        if (MiscKt.hasStableJsName(declaration2, context2)) {
            return new StableNameSignature(declarationName);
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        Object $this$ifNotEmpty$iv = declaration2.getTypeParameters();
        boolean $i$f$ifNotEmpty2 = false;
        Collection collection = $this$ifNotEmpty$iv;
        boolean bl7 = false;
        if (!collection.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d2 = (List)$this$ifNotEmpty$iv;
            boolean bl8 = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d2, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.1.1.INSTANCE, (int)60, null);
        }
        if (($this$ifNotEmpty$iv = declaration2.getExtensionReceiverParameter()) != null) {
            Object $i$f$ifNotEmpty2 = $this$ifNotEmpty$iv;
            boolean bl9 = false;
            bl7 = false;
            Object it = $i$f$ifNotEmpty2;
            boolean bl10 = false;
            nameBuilder.append(Intrinsics.stringPlus((String)"_r$", (Object)IrTypeUtilsKt.asString(((IrValueDeclaration)it).getType())));
        }
        $this$ifNotEmpty$iv = declaration2.getValueParameters();
        boolean $i$f$ifNotEmpty3 = false;
        Object object = $this$ifNotEmpty$iv;
        bl7 = false;
        if (!object.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d4 = (List)$this$ifNotEmpty$iv;
            boolean bl11 = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d4, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.3.1.INSTANCE, (int)60, null);
        }
        $this$ifNotEmpty$iv = declaration2.getReturnType();
        boolean bl12 = false;
        boolean bl13 = false;
        Object it = $this$ifNotEmpty$iv;
        boolean bl14 = false;
        if (IrTypeUtilsKt.getJsInlinedClass((IrType)it) != null || IrTypePredicatesKt.isUnit((IrType)it)) {
            nameBuilder.append(Intrinsics.stringPlus((String)"_ret$", (Object)IrTypeUtilsKt.asString((IrType)it)));
        }
        String string5 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"nameBuilder.toString()");
        String signature2 = string5;
        return new ParameterTypeBasedSignature(signature2, declarationName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name) {
        Collection<Character> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = name;
        char c = '\u0000';
        if (charSequence.length() == 0) {
            return "_";
        }
        c = StringsKt.first((CharSequence)name);
        boolean bl = false;
        boolean bl2 = false;
        char it = c;
        boolean bl3 = false;
        char first = NameSuggestionKt.isES5IdentifierStart(it) ? it : (char)'_';
        CharSequence charSequence2 = StringsKt.drop((String)name, (int)1);
        StringBuilder stringBuilder2 = new StringBuilder().append(first);
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var7_12 = $this$mapTo$iv$iv;
        for (int i = 0; i < var7_12.length(); ++i) {
            char it2;
            char item$iv$iv;
            char c2 = item$iv$iv = var7_12.charAt(i);
            collection = destination$iv$iv;
            boolean bl4 = false;
            Character c3 = Character.valueOf(NameSuggestionKt.isES5IdentifierPart(it2) ? it2 : (char)'_');
            collection.add(c3);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).toString();
    }

    public static final /* synthetic */ String access$mapToKey(Object declaration2) {
        return NameTablesKt.mapToKey(declaration2);
    }
}

