/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0010\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u0003\u00a8\u0006\t"}, d2={"erase", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asString", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "getJsInlinedClass", "backend.js"})
public final class IrTypeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String asString(@NotNull IrType $this$asString) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        IrType irType = $this$asString;
        if (irType instanceof IrErrorType) {
            string2 = "$ErrorType$";
        } else if (irType instanceof IrDynamicType) {
            string2 = "dynamic";
        } else if (irType instanceof IrSimpleType) {
            String string3;
            StringBuilder stringBuilder2 = new StringBuilder().append(IrTypeUtilsKt.asString(((IrSimpleType)$this$asString).getClassifier())).append(((IrSimpleType)$this$asString).getHasQuestionMark() ? "?" : "");
            Collection $this$ifNotEmpty$iv = ((IrSimpleType)$this$asString).getArguments();
            boolean $i$f$ifNotEmpty = false;
            Collection collection = $this$ifNotEmpty$iv;
            boolean bl = false;
            if (!collection.isEmpty()) {
                void $this$asString_u24lambda_u2d0;
                List list2 = (List)$this$ifNotEmpty$iv;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl2 = false;
                String string4 = CollectionsKt.joinToString$default((Iterable)((Iterable)$this$asString_u24lambda_u2d0), (CharSequence)",", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)asString.1.1.INSTANCE, (int)24, null);
                stringBuilder2 = stringBuilder3;
                string3 = string4;
            } else {
                string3 = null;
            }
            String string5 = string3;
            string2 = stringBuilder2.append(string5 == null ? "" : string5).toString();
        } else {
            String string6 = Intrinsics.stringPlus((String)"Unexpected kind of IrType: ", (Object)$this$asString.getClass().getTypeName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string6.toString());
        }
        return string2;
    }

    private static final String asString(IrTypeArgument $this$asString) {
        String string2;
        IrTypeArgument irTypeArgument = $this$asString;
        if (irTypeArgument instanceof IrStarProjection) {
            string2 = "*";
        } else if (irTypeArgument instanceof IrTypeProjection) {
            string2 = ((IrTypeProjection)$this$asString).getVariance().getLabel() + (((IrTypeProjection)$this$asString).getVariance() != Variance.INVARIANT ? " " : "") + IrTypeUtilsKt.asString(((IrTypeProjection)$this$asString).getType());
        } else {
            String string3 = Intrinsics.stringPlus((String)"Unexpected kind of IrTypeArgument: ", (Object)$this$asString.getClass().getSimpleName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return string2;
    }

    private static final String asString(IrClassifierSymbol $this$asString) {
        String string2;
        IrClassifierSymbol irClassifierSymbol = $this$asString;
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            string2 = ((IrTypeParameter)((IrTypeParameterSymbol)$this$asString).getOwner()).getName().asString();
        } else if (irClassifierSymbol instanceof IrClassSymbol) {
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrClassSymbol)$this$asString).getOwner());
            Intrinsics.checkNotNull((Object)fqName2);
            string2 = fqName2.asString();
        } else {
            String string3 = Intrinsics.stringPlus((String)"Unexpected kind of IrClassifierSymbol: ", (Object)$this$asString.getClass().getTypeName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String string4 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"when (this) {\n    is IrTypeParameterSymbol -> this.owner.name.asString()\n    is IrClassSymbol -> this.owner.fqNameWhenAvailable!!.asString()\n    else -> error(\"Unexpected kind of IrClassifierSymbol: \" + javaClass.typeName)\n}");
        return string4;
    }

    @Nullable
    public static final IrClass getJsInlinedClass(@NotNull IrType $this$getJsInlinedClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsInlinedClass, (String)"<this>");
        if ($this$getJsInlinedClass instanceof IrSimpleType) {
            IrClass irClass2 = IrTypeUtilsKt.erase($this$getJsInlinedClass);
            if (irClass2 == null) {
                return null;
            }
            IrClass erased = irClass2;
            if (erased.isInline()) {
                if (IrTypePredicatesKt.isMarkedNullable($this$getJsInlinedClass)) {
                    IrType fieldType = null;
                    IrClass fieldInlinedClass = erased;
                    while (true) {
                        if (IrTypePredicatesKt.isMarkedNullable(fieldType = InlineClassesKt.getInlineClassUnderlyingType(fieldInlinedClass))) {
                            return null;
                        }
                        IrClass irClass3 = IrTypeUtilsKt.getJsInlinedClass(fieldType);
                        if (irClass3 == null) break;
                        fieldInlinedClass = irClass3;
                    }
                }
                return erased;
            }
        }
        return null;
    }

    @Nullable
    public static final IrClass erase(@NotNull IrType type2) {
        IrClass irClass2;
        block4: {
            IrClassifierSymbol classifier2;
            IrClassifierSymbol irClassifierSymbol;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            IrType irType = type2;
            while (true) {
                IrType irType2;
                if ((irClassifierSymbol = (classifier2 = IrTypesKt.getClassifierOrFail(irType2 = irType))) instanceof IrClassSymbol) {
                    irClass2 = (IrClass)((IrClassSymbol)classifier2).getOwner();
                    break block4;
                }
                if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) break;
                irType = (IrType)CollectionsKt.first(((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes());
            }
            if (irClassifierSymbol instanceof IrScriptSymbol) {
                irClass2 = null;
            } else {
                boolean bl = false;
                throw (Throwable)new IllegalStateException(classifier2.toString());
            }
        }
        return irClass2;
    }

    public static final /* synthetic */ String access$asString(IrTypeArgument $receiver) {
        return IrTypeUtilsKt.asString($receiver);
    }
}

