/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeIntermediateDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeStubDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnexpectedTypeArgumentsError;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeHiddenCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeIllegalAnnotationError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeOperatorAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeMismatchError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedReferenceError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVariableExpectedError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeWrongNumberOfTypeArgumentsError;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010!\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\"*\u00020#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "collector", "Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "(Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;)V", "reportFirDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorLoop", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "getFactory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeSimpleDiagnostic;", "checkers"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    public ErrorNodeDiagnosticCollectorComponent(@NotNull AbstractDiagnosticCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        super(collector2);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorLoop, (String)"errorLoop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorLoop.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.reportFirDiagnostic(errorLoop.getDiagnostic(), source, this.getReporter());
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorTypeRef.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.reportFirDiagnostic(errorTypeRef.getDiagnostic(), source, this.getReporter());
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorNamedReference, (String)"errorNamedReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorNamedReference.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.ANNOTATION_ENTRY) && errorNamedReference.getDiagnostic() instanceof ConeUnresolvedNameError) {
            return;
        }
        this.reportFirDiagnostic(errorNamedReference.getDiagnostic(), source, this.getReporter());
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorExpression, (String)"errorExpression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorExpression.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.reportFirDiagnostic(errorExpression.getDiagnostic(), source, this.getReporter());
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorFunction, (String)"errorFunction");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorFunction.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.reportFirDiagnostic(errorFunction.getDiagnostic(), source, this.getReporter());
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorResolvedQualifier.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        this.reportFirDiagnostic(errorResolvedQualifier.getDiagnostic(), source, this.getReporter());
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, FirSourceElement source, DiagnosticReporter reporter) {
        FirDiagnostic firDiagnostic;
        Object object;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError)) {
            return;
        }
        ConeDiagnostic coneDiagnostic = diagnostic;
        if (coneDiagnostic instanceof ConeUnresolvedReferenceError) {
            String string2;
            Name name = ((ConeUnresolvedReferenceError)diagnostic).getName();
            object = name == null ? "<No name>" : ((string2 = name.asString()) == null ? "<No name>" : string2);
            firDiagnostic = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE().on(source, (String)object);
        } else if (coneDiagnostic instanceof ConeUnresolvedSymbolError) {
            FirDiagnosticFactory1<FirSourceElement, PsiElement, String> firDiagnosticFactory1 = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE();
            object = ((ConeUnresolvedSymbolError)diagnostic).getClassId().asString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diagnostic.classId.asString()");
            firDiagnostic = firDiagnosticFactory1.on(source, (String)object);
        } else if (coneDiagnostic instanceof ConeUnresolvedNameError) {
            FirDiagnosticFactory1<FirSourceElement, PsiElement, String> firDiagnosticFactory1 = FirErrors.INSTANCE.getUNRESOLVED_REFERENCE();
            object = ((ConeUnresolvedNameError)diagnostic).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diagnostic.name.asString()");
            firDiagnostic = firDiagnosticFactory1.on(source, (String)object);
        } else if (coneDiagnostic instanceof ConeHiddenCandidateError) {
            firDiagnostic = FirErrors.INSTANCE.getHIDDEN().on(source, ((ConeHiddenCandidateError)diagnostic).getCandidateSymbol());
        } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
            firDiagnostic = FirErrors.INSTANCE.getINAPPLICABLE_CANDIDATE().on(source, ((ConeInapplicableCandidateError)diagnostic).getCandidateSymbol());
        } else if (coneDiagnostic instanceof ConeAmbiguityError) {
            firDiagnostic = !CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability()) ? FirErrors.INSTANCE.getNONE_APPLICABLE().on(source, ((ConeAmbiguityError)diagnostic).getCandidates()) : FirErrors.INSTANCE.getAMBIGUITY().on(source, ((ConeAmbiguityError)diagnostic).getCandidates());
        } else if (coneDiagnostic instanceof ConeOperatorAmbiguityError) {
            firDiagnostic = FirErrors.INSTANCE.getASSIGN_OPERATOR_AMBIGUITY().on(source, ((ConeOperatorAmbiguityError)diagnostic).getCandidates());
        } else if (coneDiagnostic instanceof ConeVariableExpectedError) {
            firDiagnostic = FirErrors.INSTANCE.getVARIABLE_EXPECTED().on(source);
        } else if (coneDiagnostic instanceof ConeTypeMismatchError) {
            firDiagnostic = FirErrors.INSTANCE.getTYPE_MISMATCH().on(source, ((ConeTypeMismatchError)diagnostic).getExpectedType(), ((ConeTypeMismatchError)diagnostic).getActualType());
        } else if (coneDiagnostic instanceof ConeUnexpectedTypeArgumentsError) {
            FirDiagnosticFactory0<FirSourceElement, PsiElement> firDiagnosticFactory0 = FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED();
            Object $this$safeAs$iv = ((ConeUnexpectedTypeArgumentsError)diagnostic).getSource();
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof FirSourceElement)) {
                object2 = null;
            }
            firDiagnostic = firDiagnosticFactory0.on((FirSourceElement)((object = (FirSourceElement)object2) == null ? source : object));
        } else if (coneDiagnostic instanceof ConeIllegalAnnotationError) {
            FirDiagnosticFactory1<FirSourceElement, PsiElement, String> firDiagnosticFactory1 = FirErrors.INSTANCE.getNOT_AN_ANNOTATION_CLASS();
            object = ((ConeIllegalAnnotationError)diagnostic).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diagnostic.name.asString()");
            firDiagnostic = firDiagnosticFactory1.on(source, (String)object);
        } else if (coneDiagnostic instanceof ConeWrongNumberOfTypeArgumentsError) {
            firDiagnostic = FirErrors.INSTANCE.getWRONG_NUMBER_OF_TYPE_ARGUMENTS().on(source, ((ConeWrongNumberOfTypeArgumentsError)diagnostic).getDesiredCount(), ((ConeWrongNumberOfTypeArgumentsError)diagnostic).getType());
        } else if (coneDiagnostic instanceof ConeSimpleDiagnostic) {
            firDiagnostic = source.getKind() instanceof FirFakeSourceElementKind ? null : (((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SymbolNotFound ? (FirDiagnostic)FirErrors.INSTANCE.getUNRESOLVED_REFERENCE().on(source, "<No name>") : (FirDiagnostic)this.getFactory((ConeSimpleDiagnostic)diagnostic).on(source));
        } else if (coneDiagnostic instanceof ConeInstanceAccessBeforeSuperCall) {
            firDiagnostic = FirErrors.INSTANCE.getINSTANCE_ACCESS_BEFORE_SUPER_CALL().on(source, ((ConeInstanceAccessBeforeSuperCall)diagnostic).getTarget());
        } else if (coneDiagnostic instanceof ConeStubDiagnostic) {
            firDiagnostic = null;
        } else if (coneDiagnostic instanceof ConeIntermediateDiagnostic) {
            firDiagnostic = null;
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported diagnostic type: ", diagnostic.getClass()));
        }
        FirDiagnostic coneDiagnostic2 = firDiagnostic;
        reporter.report(coneDiagnostic2);
    }

    private final FirDiagnosticFactory0<FirSourceElement, ?> getFactory(ConeSimpleDiagnostic $this$getFactory) {
        FirDiagnosticFactory0<FirSourceElement, PsiElement> firDiagnosticFactory0;
        DiagnosticKind diagnosticKind = $this$getFactory.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[diagnosticKind.ordinal()];
        switch (n) {
            case 1: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getSYNTAX();
                break;
            }
            case 2: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getRETURN_NOT_ALLOWED();
                break;
            }
            case 3: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getUNRESOLVED_LABEL();
                break;
            }
            case 4: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getNO_THIS();
                break;
            }
            case 5: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getILLEGAL_CONST_EXPRESSION();
                break;
            }
            case 6: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getILLEGAL_UNDERSCORE();
                break;
            }
            case 7: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getDESERIALIZATION_ERROR();
                break;
            }
            case 8: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getINFERENCE_ERROR();
                break;
            }
            case 9: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getTYPE_PARAMETER_AS_SUPERTYPE();
                break;
            }
            case 10: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getENUM_AS_SUPERTYPE();
                break;
            }
            case 11: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getRECURSION_IN_SUPERTYPES();
                break;
            }
            case 12: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES();
                break;
            }
            case 13: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getERROR_FROM_JAVA_RESOLUTION();
                break;
            }
            case 14: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getSUPER_IS_NOT_AN_EXPRESSION();
                break;
            }
            case 15: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getEXPRESSION_REQUIRED();
                break;
            }
            case 16: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getBREAK_OR_CONTINUE_OUTSIDE_A_LOOP();
                break;
            }
            case 17: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getNOT_A_LOOP_LABEL();
                break;
            }
            case 18: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getVARIABLE_EXPECTED();
                break;
            }
            case 19: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getNO_TYPE_FOR_TYPE_PARAMETER();
                break;
            }
            case 20: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getUNKNOWN_CALLABLE_KIND();
                break;
            }
            case 21: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getILLEGAL_PROJECTION_USAGE();
                break;
            }
            case 22: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getMISSING_STDLIB_CLASS();
                break;
            }
            case 23: {
                firDiagnosticFactory0 = FirErrors.INSTANCE.getOTHER_ERROR();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported diagnostic kind: " + (Object)((Object)$this$getFactory.getKind()) + " at " + $this$getFactory.getClass());
            }
        }
        return firDiagnosticFactory0;
    }

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagnosticKind.values().length];
            nArray[DiagnosticKind.Syntax.ordinal()] = 1;
            nArray[DiagnosticKind.ReturnNotAllowed.ordinal()] = 2;
            nArray[DiagnosticKind.UnresolvedLabel.ordinal()] = 3;
            nArray[DiagnosticKind.NoThis.ordinal()] = 4;
            nArray[DiagnosticKind.IllegalConstExpression.ordinal()] = 5;
            nArray[DiagnosticKind.IllegalUnderscore.ordinal()] = 6;
            nArray[DiagnosticKind.DeserializationError.ordinal()] = 7;
            nArray[DiagnosticKind.InferenceError.ordinal()] = 8;
            nArray[DiagnosticKind.TypeParameterAsSupertype.ordinal()] = 9;
            nArray[DiagnosticKind.EnumAsSupertype.ordinal()] = 10;
            nArray[DiagnosticKind.RecursionInSupertypes.ordinal()] = 11;
            nArray[DiagnosticKind.RecursionInImplicitTypes.ordinal()] = 12;
            nArray[DiagnosticKind.Java.ordinal()] = 13;
            nArray[DiagnosticKind.SuperNotAllowed.ordinal()] = 14;
            nArray[DiagnosticKind.ExpressionRequired.ordinal()] = 15;
            nArray[DiagnosticKind.JumpOutsideLoop.ordinal()] = 16;
            nArray[DiagnosticKind.NotLoopLabel.ordinal()] = 17;
            nArray[DiagnosticKind.VariableExpected.ordinal()] = 18;
            nArray[DiagnosticKind.NoTypeForTypeParameter.ordinal()] = 19;
            nArray[DiagnosticKind.UnknownCallableKind.ordinal()] = 20;
            nArray[DiagnosticKind.IllegalProjectionUsage.ordinal()] = 21;
            nArray[DiagnosticKind.MissingStdlibClass.ordinal()] = 22;
            nArray[DiagnosticKind.Other.ordinal()] = 23;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

