/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicVerifier;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/MethodVerifier;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "checkPoint", "", "(Ljava/lang/String;)V", "transform", "", "internalClassName", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "backend"})
public final class MethodVerifier
extends MethodTransformer {
    @NotNull
    private final String checkPoint;

    public MethodVerifier(@NotNull String checkPoint) {
        Intrinsics.checkNotNullParameter((Object)checkPoint, (String)"checkPoint");
        this.checkPoint = checkPoint;
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        try {
            MethodTransformer.analyze(internalClassName, methodNode, new BasicVerifier());
        }
        catch (Throwable e) {
            throw new AssertionError(Intrinsics.stringPlus((String)this.checkPoint, (Object)": incorrect bytecode"), e);
        }
    }
}

