/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.ReceiverInfo;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPositionImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ReceiverConstraintPositionImpl;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentTypeMismatchDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedSubCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.NotNullTypeVariable;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u001aD\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a<\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0019"}, d2={"captureFromTypeParameterUpperBoundIfNeeded", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "argumentType", "expectedType", "checkExpressionArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "expressionArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ExpressionKotlinCallArgument;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "isReceiver", "", "convertedType", "checkSimpleArgument", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "receiverInfo", "Lorg/jetbrains/kotlin/resolve/calls/components/ReceiverInfo;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "checkSubCallArgument", "subCallArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/SubKotlinCallArgument;", "resolution"})
public final class SimpleArgumentsChecksKt {
    @NotNull
    public static final ResolvedAtom checkSimpleArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull SimpleKotlinCallArgument argument, @Nullable UnwrappedType expectedType2, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, @NotNull ReceiverInfo receiverInfo, @Nullable UnwrappedType convertedType, @Nullable InferenceSession inferenceSession) {
        ResolvedAtom resolvedAtom;
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        Intrinsics.checkNotNullParameter((Object)receiverInfo, (String)"receiverInfo");
        SimpleKotlinCallArgument simpleKotlinCallArgument = argument;
        if (simpleKotlinCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkExpressionArgument(csBuilder, (ExpressionKotlinCallArgument)argument, expectedType2, diagnosticsHolder, receiverInfo.isReceiver(), convertedType);
        } else if (simpleKotlinCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkSubCallArgument(csBuilder, (SubKotlinCallArgument)argument, expectedType2, diagnosticsHolder, receiverInfo, inferenceSession);
        } else {
            ArgumentsUtilsKt.unexpectedArgument(argument);
            throw null;
        }
        return resolvedAtom;
    }

    private static final ResolvedAtom checkExpressionArgument(ConstraintSystemBuilder csBuilder, ExpressionKotlinCallArgument expressionArgument, UnwrappedType expectedType2, KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver, UnwrappedType convertedType) {
        ConstraintPosition position;
        ResolvedExpressionAtom resolvedExpression = new ResolvedExpressionAtom(expressionArgument);
        if (expectedType2 == null) {
            return resolvedExpression;
        }
        UnwrappedType unwrappedType = convertedType;
        UnwrappedType argumentType = unwrappedType == null ? SimpleArgumentsChecksKt.captureFromTypeParameterUpperBoundIfNeeded(ArgumentsUtilsKt.getStableType(expressionArgument.getReceiver()), expectedType2) : unwrappedType;
        ConstraintPosition constraintPosition = position = isReceiver ? new ReceiverConstraintPositionImpl(expressionArgument) : new ArgumentConstraintPositionImpl(expressionArgument);
        if (expectedType2 instanceof NotNullTypeVariable && argumentType.isMarkedNullable()) {
            diagnosticsHolder.addDiagnostic(new ArgumentTypeMismatchDiagnostic(expectedType2, argumentType, expressionArgument));
        }
        if (expressionArgument.isSafeCall()) {
            UnwrappedType expectedNullableType = expectedType2.makeNullableAsSpecified(true);
            if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, SimpleArgumentsChecksKt.checkExpressionArgument$unstableSmartCastOrSubtypeError(csBuilder, expressionArgument, isReceiver, argumentType, ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedNullableType, position));
            }
            return resolvedExpression;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType2, position)) {
            if (!isReceiver) {
                ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, SimpleArgumentsChecksKt.checkExpressionArgument$unstableSmartCastOrSubtypeError(csBuilder, expressionArgument, isReceiver, argumentType, ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedType2, position));
                return resolvedExpression;
            }
            UnwrappedType unstableType = ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver());
            UnwrappedType expectedNullableType = expectedType2.makeNullableAsSpecified(true);
            if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, unstableType, expectedType2, position)) {
                diagnosticsHolder.addDiagnostic(UnstableSmartCast.Companion.invoke(expressionArgument, unstableType, isReceiver));
            } else if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                diagnosticsHolder.addDiagnostic(new UnsafeCallError(expressionArgument, false, 2, null));
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
            }
        }
        return resolvedExpression;
    }

    private static final UnwrappedType captureFromTypeParameterUpperBoundIfNeeded(UnwrappedType argumentType, UnwrappedType expectedType2) {
        TypeConstructor expectedTypeConstructor = FlexibleTypesKt.upperIfFlexible(expectedType2).getConstructor();
        if (FlexibleTypesKt.lowerIfFlexible(argumentType).getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            Object v1;
            block4: {
                Iterable $this$singleOrNull$iv = TypeUtilsKt.supertypes(FlexibleTypesKt.lowerIfFlexible(argumentType));
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl = false;
                    boolean bl2 = it.getConstructor().getDeclarationDescriptor() instanceof ClassifierDescriptorWithTypeParameters && NewKotlinTypeCheckerKt.hasSupertypeWithGivenTypeConstructor(it.unwrap(), expectedTypeConstructor);
                    if (!bl2) continue;
                    if (found$iv) {
                        v1 = null;
                        break block4;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            KotlinType chosenSupertype = v1;
            if (chosenSupertype != null) {
                UnwrappedType unwrappedType;
                UnwrappedType capturedType = NewCapturedTypeKt.captureFromExpression(chosenSupertype.unwrap());
                return capturedType != null && SpecialTypesKt.isDefinitelyNotNullType(argumentType) ? SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(capturedType, false, 1, null) : ((unwrappedType = capturedType) == null ? argumentType : unwrappedType);
            }
        }
        return argumentType;
    }

    private static final ResolvedAtom checkSubCallArgument(ConstraintSystemBuilder csBuilder, SubKotlinCallArgument subCallArgument, UnwrappedType expectedType2, KotlinDiagnosticsHolder diagnosticsHolder, ReceiverInfo receiverInfo, InferenceSession inferenceSession) {
        InferenceSession inferenceSession2;
        ResolvedSubCallArgument subCallResult = new ResolvedSubCallArgument(subCallArgument, receiverInfo.isReceiver() && Intrinsics.areEqual((Object)((inferenceSession2 = inferenceSession) == null ? null : Boolean.valueOf(inferenceSession2.resolveReceiverIndependently())), (Object)true));
        if (expectedType2 == null) {
            return subCallResult;
        }
        UnwrappedType expectedNullableType = expectedType2.makeNullableAsSpecified(true);
        ConstraintPosition position = receiverInfo.isReceiver() ? new ReceiverConstraintPositionImpl(subCallArgument) : new ArgumentConstraintPositionImpl(subCallArgument);
        UnwrappedType currentReturnType = ((NewTypeSubstitutor)csBuilder.buildCurrentSubstitutor()).safeSubstitute(subCallArgument.getReceiver().getReceiverValue().getType().unwrap());
        if (subCallArgument.isSafeCall()) {
            csBuilder.addSubtypeConstraint(currentReturnType, expectedNullableType, position);
            return subCallResult;
        }
        if (receiverInfo.isReceiver() && !ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedType2, position) && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedNullableType, position)) {
            if (receiverInfo.getShouldReportUnsafeCall()) {
                diagnosticsHolder.addDiagnostic(new UnsafeCallError(subCallArgument, receiverInfo.getReportUnsafeCallAsUnsafeImplicitInvoke()));
            }
            return subCallResult;
        }
        csBuilder.addSubtypeConstraint(currentReturnType, expectedType2, position);
        return subCallResult;
    }

    private static final KotlinCallDiagnostic checkExpressionArgument$unstableSmartCastOrSubtypeError(ConstraintSystemBuilder $csBuilder, ExpressionKotlinCallArgument $expressionArgument, boolean $isReceiver, UnwrappedType argumentType, UnwrappedType unstableType, UnwrappedType actualExpectedType, ConstraintPosition position) {
        if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($csBuilder, unstableType, actualExpectedType, position)) {
            return UnstableSmartCast.Companion.invoke($expressionArgument, unstableType, $isReceiver);
        }
        if (argumentType.isMarkedNullable()) {
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($csBuilder, argumentType, actualExpectedType, position)) {
                return null;
            }
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible($csBuilder, TypeUtilsKt.makeNotNullable(argumentType), actualExpectedType, position)) {
                return new ArgumentTypeMismatchDiagnostic(actualExpectedType, argumentType, $expressionArgument);
            }
        }
        $csBuilder.addSubtypeConstraint(argumentType, actualExpectedType, position);
        return null;
    }
}

