/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LocalClassGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateLocalClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateObjectLiteral", "ktObjectLiteral", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "ir.psi2ir"})
public final class LocalClassGenerator
extends StatementGeneratorExtension {
    public LocalClassGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public final IrStatement generateObjectLiteral(@NotNull KtObjectLiteralExpression ktObjectLiteral) {
        Intrinsics.checkNotNullParameter((Object)ktObjectLiteral, (String)"ktObjectLiteral");
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktObjectLiteral);
        int endOffset = PsiUtilsKt.getEndOffset(ktObjectLiteral);
        IrType objectLiteralType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, ktObjectLiteral));
        IrBlockImpl irBlock = new IrBlockImpl(startOffset, endOffset, objectLiteralType, IrStatementOrigin.OBJECT_LITERAL.INSTANCE);
        DeclarationGenerator declarationGenerator = new DeclarationGenerator(this.getStatementGenerator().getContext());
        KtObjectDeclaration ktObjectDeclaration = ktObjectLiteral.getObjectDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"ktObjectLiteral.objectDeclaration");
        IrClass irClass2 = declarationGenerator.generateClassOrObjectDeclaration(ktObjectDeclaration);
        irBlock.getStatements().add(irClass2);
        ClassConstructorDescriptor classConstructorDescriptor = irClass2.getDescriptor().getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Object literal should have a primary constructor: ", (Object)irClass2.getDescriptor()));
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = classConstructorDescriptor;
        ClassConstructorDescriptor objectConstructor = classConstructorDescriptor2;
        boolean bl = objectConstructor.getDispatchReceiverParameter() == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LocalClassGenerator$generateObjectLiteral$42 = false;
            String $i$a$-assert-LocalClassGenerator$generateObjectLiteral$42 = Intrinsics.stringPlus((String)"Object literal constructor should have no dispatch receiver parameter: ", (Object)objectConstructor);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LocalClassGenerator$generateObjectLiteral$42));
        }
        bl = objectConstructor.getExtensionReceiverParameter() == null;
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LocalClassGenerator$generateObjectLiteral$52 = false;
            String $i$a$-assert-LocalClassGenerator$generateObjectLiteral$52 = Intrinsics.stringPlus((String)"Object literal constructor should have no extension receiver parameter: ", (Object)objectConstructor);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LocalClassGenerator$generateObjectLiteral$52));
        }
        bl = objectConstructor.getValueParameters().size() == 0;
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"Object literal constructor should have no value parameters: ", (Object)objectConstructor);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        irBlock.getStatements().add(IrConstructorCallImpl.Companion.fromSymbolDescriptor(startOffset, endOffset, objectLiteralType, this.getContext().getSymbolTable().referenceConstructor(objectConstructor), IrStatementOrigin.OBJECT_LITERAL.INSTANCE));
        return irBlock;
    }

    @NotNull
    public final IrStatement generateLocalClass(@NotNull KtClassOrObject ktClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)ktClassOrObject, (String)"ktClassOrObject");
        return new DeclarationGenerator(this.getStatementGenerator().getContext()).generateClassOrObjectDeclaration(ktClassOrObject);
    }
}

