/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendException;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AnonymousInitializerGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionException;
import org.jetbrains.kotlin.psi2ir.generators.FunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.PropertyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ScriptGenerator;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u00101\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\u000e\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u0011J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J>\u00108\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u001e\u00109\u001a\u001a\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020<0:H\u0002J\n\u0010=\u001a\u00020>*\u00020?R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/Generator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "generateClassMemberDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateClassOrObjectDeclaration", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "generateEnumEntryDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "ktEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "generateFakeOverrideDeclaration", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "ktElement", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "generateFakeOverrideFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateFakeOverrideProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateGlobalTypeParametersDeclarations", "", "irTypeParametersOwner", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "from", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generateInitializerBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ktBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateMemberDeclaration", "generateScopedTypeParameterDeclarations", "generateSyntheticClassOrObject", "syntheticDeclaration", "generateTypeAliasDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "ktTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "generateTypeParameterDeclarations", "declareTypeParameter", "Lkotlin/Function3;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "ir.psi2ir"})
public final class DeclarationGenerator
implements Generator {
    @NotNull
    private final GeneratorContext context;
    @NotNull
    private final TypeTranslator typeTranslator;

    public DeclarationGenerator(@NotNull GeneratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.typeTranslator = this.getContext().getTypeTranslator();
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrType toIrType(@NotNull KotlinType $this$toIrType) {
        Intrinsics.checkNotNullParameter((Object)$this$toIrType, (String)"<this>");
        return this.typeTranslator.translateType($this$toIrType);
    }

    @Nullable
    public final IrDeclaration generateMemberDeclaration(@NotNull KtDeclaration ktDeclaration) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        try {
            IrDeclaration irDeclaration2;
            object = ktDeclaration;
            if (object instanceof KtNamedFunction) {
                irDeclaration2 = new FunctionGenerator(this).generateFunctionDeclaration((KtNamedFunction)ktDeclaration);
            } else if (object instanceof KtProperty) {
                irDeclaration2 = new PropertyGenerator(this).generatePropertyDeclaration((KtProperty)ktDeclaration);
            } else if (object instanceof KtClassOrObject) {
                irDeclaration2 = this.generateClassOrObjectDeclaration((KtPureClassOrObject)((Object)ktDeclaration));
            } else if (object instanceof KtTypeAlias) {
                irDeclaration2 = this.generateTypeAliasDeclaration((KtTypeAlias)ktDeclaration);
            } else if (object instanceof KtScript) {
                irDeclaration2 = new ScriptGenerator(this).generateScriptDeclaration((KtScript)ktDeclaration);
            } else {
                IrFactory irFactory = this.getContext().getIrFactory();
                int n = PsiUtilsKt.getStartOffsetSkippingComments(ktDeclaration);
                int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
                Generator generator2 = this;
                ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
                Intrinsics.checkNotNullExpressionValue(readOnlySlice, (String)"DECLARATION_TO_DESCRIPTOR");
                irDeclaration2 = irFactory.createErrorDeclaration(n, n2, GeneratorKt.getOrFail(generator2, readOnlySlice, ktDeclaration));
            }
            object = irDeclaration2;
        }
        catch (BackendException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!this.getContext().getConfiguration().getIgnoreErrors()) {
                if (e instanceof ErrorExpressionException) {
                    Throwable throwable = e.getCause();
                    CodegenUtil.reportBackendException(throwable == null ? e : throwable, "psi2ir", PsiDiagnosticUtils.atLocation(((ErrorExpressionException)e).getKtElement()), e.getMessage());
                    throw null;
                }
                Object object2 = ktDeclaration.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ktDeclaration.containingKtFile");
                KtFile psiFile = object2;
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                object2 = virtualFile2 == null ? null : virtualFile2.getPath();
                CodegenUtil.reportBackendException$default(e, "psi2ir", (String)(object2 == null ? psiFile.getName() : object2), null, 8, null);
                throw null;
            }
            IrFactory irFactory = this.getContext().getIrFactory();
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktDeclaration);
            int n3 = PsiUtilsKt.getEndOffset(ktDeclaration);
            Generator generator3 = this;
            ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
            Intrinsics.checkNotNullExpressionValue(readOnlySlice, (String)"DECLARATION_TO_DESCRIPTOR");
            object = irFactory.createErrorDeclaration(n, n3, GeneratorKt.getOrFail(generator3, readOnlySlice, ktDeclaration));
        }
        return object;
    }

    @NotNull
    public final IrClass generateSyntheticClassOrObject(@NotNull KtPureClassOrObject syntheticDeclaration) {
        Intrinsics.checkNotNullParameter((Object)syntheticDeclaration, (String)"syntheticDeclaration");
        return this.generateClassOrObjectDeclaration(syntheticDeclaration);
    }

    @Nullable
    public final IrDeclaration generateClassMemberDeclaration(@NotNull KtDeclaration ktDeclaration, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        return ktDeclaration2 instanceof KtAnonymousInitializer ? (IrDeclaration)new AnonymousInitializerGenerator(this).generateAnonymousInitializerDeclaration((KtAnonymousInitializer)ktDeclaration, irClass2) : (ktDeclaration2 instanceof KtSecondaryConstructor ? (IrDeclaration)new FunctionGenerator(this).generateSecondaryConstructor((KtSecondaryConstructor)ktDeclaration) : (ktDeclaration2 instanceof KtEnumEntry ? (IrDeclaration)this.generateEnumEntryDeclaration((KtEnumEntry)ktDeclaration) : this.generateMemberDeclaration(ktDeclaration)));
    }

    private final IrEnumEntry generateEnumEntryDeclaration(KtEnumEntry ktEnumEntry) {
        return new ClassGenerator(this).generateEnumEntry(ktEnumEntry);
    }

    @NotNull
    public final IrClass generateClassOrObjectDeclaration(@NotNull KtPureClassOrObject ktClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)ktClassOrObject, (String)"ktClassOrObject");
        return ClassGenerator.generateClass$default(new ClassGenerator(this), ktClassOrObject, null, 2, null);
    }

    private final IrTypeAlias generateTypeAliasDeclaration(KtTypeAlias ktTypeAlias) {
        Generator generator2 = this;
        WritableSlice<PsiElement, TypeAliasDescriptor> writableSlice = BindingContext.TYPE_ALIAS;
        Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"TYPE_ALIAS");
        writableSlice = GeneratorKt.getOrFail(generator2, writableSlice, ktTypeAlias);
        boolean bl = false;
        boolean bl2 = false;
        TypeAliasDescriptor $this$generateTypeAliasDeclaration_u24lambda_u2d1 = (TypeAliasDescriptor)((Object)writableSlice);
        boolean bl3 = false;
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        Intrinsics.checkNotNullExpressionValue((Object)$this$generateTypeAliasDeclaration_u24lambda_u2d1, (String)"this");
        IrTypeAlias irTypeAlias = symbolTable.declareTypeAlias($this$generateTypeAliasDeclaration_u24lambda_u2d1, (Function1<? super IrTypeAliasSymbol, ? extends IrTypeAlias>)((Function1)new Function1<IrTypeAliasSymbol, IrTypeAlias>(this, ktTypeAlias, $this$generateTypeAliasDeclaration_u24lambda_u2d1){
            final /* synthetic */ DeclarationGenerator this$0;
            final /* synthetic */ KtTypeAlias $ktTypeAlias;
            final /* synthetic */ TypeAliasDescriptor $this_with;
            {
                this.this$0 = $receiver;
                this.$ktTypeAlias = $ktTypeAlias;
                this.$this_with = $receiver2;
                super(1);
            }

            @NotNull
            public final IrTypeAlias invoke(@NotNull IrTypeAliasSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                IrFactory irFactory = this.this$0.getContext().getIrFactory();
                int n = PsiUtilsKt.getStartOffsetSkippingComments(this.$ktTypeAlias);
                int n2 = PsiUtilsKt.getEndOffset(this.$ktTypeAlias);
                Object object = this.$this_with.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
                Name name = object;
                object = this.$this_with.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visibility");
                return irFactory.createTypeAlias(n, n2, symbol2, name, (DescriptorVisibility)object, this.this$0.toIrType(this.$this_with.getExpandedType()), this.$this_with.isActual(), IrDeclarationOrigin.DEFINED.INSTANCE);
            }
        }));
        boolean bl4 = false;
        boolean bl5 = false;
        IrTypeAlias it = irTypeAlias;
        boolean bl6 = false;
        IrTypeParametersContainer irTypeParametersContainer = it;
        List<TypeParameterDescriptor> list2 = $this$generateTypeAliasDeclaration_u24lambda_u2d1.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"declaredTypeParameters");
        this.generateGlobalTypeParametersDeclarations(irTypeParametersContainer, list2);
        return irTypeAlias;
    }

    public final void generateGlobalTypeParametersDeclarations(@NotNull IrTypeParametersContainer irTypeParametersOwner, @NotNull List<? extends TypeParameterDescriptor> from) {
        Intrinsics.checkNotNullParameter((Object)irTypeParametersOwner, (String)"irTypeParametersOwner");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.generateTypeParameterDeclarations(irTypeParametersOwner, from, (Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter>)((Function3)new Function3<Integer, Integer, TypeParameterDescriptor, IrTypeParameter>(this){
            final /* synthetic */ DeclarationGenerator this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final IrTypeParameter invoke(int startOffset, int endOffset, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                return SymbolTable.declareGlobalTypeParameter$default(this.this$0.getContext().getSymbolTable(), startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, typeParameterDescriptor, null, 16, null);
            }
        }));
    }

    public final void generateScopedTypeParameterDeclarations(@NotNull IrTypeParametersContainer irTypeParametersOwner, @NotNull List<? extends TypeParameterDescriptor> from) {
        Intrinsics.checkNotNullParameter((Object)irTypeParametersOwner, (String)"irTypeParametersOwner");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.generateTypeParameterDeclarations(irTypeParametersOwner, from, (Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter>)((Function3)new Function3<Integer, Integer, TypeParameterDescriptor, IrTypeParameter>(this){
            final /* synthetic */ DeclarationGenerator this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final IrTypeParameter invoke(int startOffset, int endOffset, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                return SymbolTable.declareScopedTypeParameter$default(this.this$0.getContext().getSymbolTable(), startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, typeParameterDescriptor, null, 16, null);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTypeParameterDeclarations(IrTypeParametersContainer irTypeParametersOwner, List<? extends TypeParameterDescriptor> from, Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter> declareTypeParameter) {
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrTypeParametersContainer irTypeParametersContainer = irTypeParametersOwner;
        Iterable iterable = from;
        Collection collection = irTypeParametersContainer.getTypeParameters();
        IrDeclaration irDeclaration2 = irTypeParametersContainer;
        boolean $i$f$map2 = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            PsiElement ktTypeParameterDeclaration = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)typeParameterDescriptor);
            int startOffset = KotlinUtilsKt.getStartOffsetOrUndefined(ktTypeParameterDeclaration);
            int endOffset = KotlinUtilsKt.getEndOffsetOrUndefined(ktTypeParameterDeclaration);
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)declareTypeParameter.invoke((Object)startOffset, (Object)endOffset, (Object)typeParameterDescriptor);
            object.add(irTypeParameter2);
        }
        object = (List)destination$iv$iv;
        irDeclaration2.setTypeParameters(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        for (IrTypeParameter irTypeParameter3 : irTypeParametersOwner.getTypeParameters()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable<KotlinType> $i$f$map2 = irTypeParameter3.getDescriptor().getUpperBounds();
            Intrinsics.checkNotNullExpressionValue($i$f$map2, (String)"irTypeParameter.descriptor.upperBounds");
            $i$f$map2 = $i$f$map2;
            irDeclaration2 = irTypeParameter3;
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                KotlinType bl = (KotlinType)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                object = this.toIrType((KotlinType)it);
                collection.add(object);
            }
            collection = (List)destination$iv$iv2;
            ((IrTypeParameter)irDeclaration2).setSuperTypes((List<? extends IrType>)collection);
        }
    }

    @NotNull
    public final IrExpressionBody generateInitializerBody(@NotNull IrSymbol scopeOwnerSymbol, @NotNull KtExpression ktBody) {
        Intrinsics.checkNotNullParameter((Object)scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        Intrinsics.checkNotNullParameter((Object)ktBody, (String)"ktBody");
        return DeclarationGeneratorKt.createBodyGenerator(this, scopeOwnerSymbol).generateExpressionBody(ktBody);
    }

    @Nullable
    public final IrDeclaration generateFakeOverrideDeclaration(@NotNull CallableMemberDescriptor memberDescriptor, @NotNull KtPureElement ktElement) {
        IrDeclaration irDeclaration2;
        Intrinsics.checkNotNullParameter((Object)memberDescriptor, (String)"memberDescriptor");
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        boolean bl = memberDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"Fake override expected: ", (Object)memberDescriptor);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        CallableMemberDescriptor callableMemberDescriptor = memberDescriptor;
        if (callableMemberDescriptor instanceof FunctionDescriptor) {
            irDeclaration2 = this.generateFakeOverrideFunction((FunctionDescriptor)memberDescriptor, ktElement);
        } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
            irDeclaration2 = this.generateFakeOverrideProperty((PropertyDescriptor)memberDescriptor, ktElement);
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected member descriptor: ", (Object)memberDescriptor));
        }
        return irDeclaration2;
    }

    private final IrProperty generateFakeOverrideProperty(PropertyDescriptor propertyDescriptor, KtPureElement ktElement) {
        return new PropertyGenerator(this).generateFakeOverrideProperty(propertyDescriptor, ktElement);
    }

    private final IrSimpleFunction generateFakeOverrideFunction(FunctionDescriptor functionDescriptor, KtPureElement ktElement) {
        return new FunctionGenerator(this).generateFakeOverrideFunction(functionDescriptor, ktElement);
    }
}

