/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\r\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantVariableDeclarationElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "usages", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "analyze", "", "apply", "perform", "js.translator"})
public final class RedundantVariableDeclarationElimination {
    @NotNull
    private final JsStatement root;
    @NotNull
    private final Set<JsName> usages;
    private boolean hasChanges;

    public RedundantVariableDeclarationElimination(@NotNull JsStatement root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.root = root2;
        boolean bl = false;
        this.usages = new LinkedHashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantVariableDeclarationElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsName name = x.getName();
                if (name != null && x.getQualifier() == null) {
                    RedundantVariableDeclarationElimination redundantVariableDeclarationElimination = this.this$0;
                    Collection collection = RedundantVariableDeclarationElimination.access$getUsages$p(redundantVariableDeclarationElimination);
                    boolean bl = false;
                    collection.add(name);
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                RedundantVariableDeclarationElimination redundantVariableDeclarationElimination = this.this$0;
                Collection collection = RedundantVariableDeclarationElimination.access$getUsages$p(redundantVariableDeclarationElimination);
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                boolean bl = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                return false;
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantVariableDeclarationElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void endVisit(@NotNull JsVars x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    List<JsVars.JsVar> list2 = x.getVars();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"x.vars");
                    if (CollectionsKt.removeAll(list2, (Function1)((Function1)new Function1<JsVars.JsVar, Boolean>(this.this$0){
                        final /* synthetic */ RedundantVariableDeclarationElimination this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final boolean invoke(JsVars.JsVar it) {
                            return it.getInitExpression() == null && !RedundantVariableDeclarationElimination.access$getUsages$p(this.this$0).contains(it.getName());
                        }
                    }))) {
                        RedundantVariableDeclarationElimination.access$setHasChanges$p(this.this$0, true);
                    }
                    if (x.getVars().isEmpty()) {
                        ctx.removeMe();
                    }
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }
        }.accept((JsNode)this.root);
    }

    public static final /* synthetic */ Set access$getUsages$p(RedundantVariableDeclarationElimination $this) {
        return $this.usages;
    }

    public static final /* synthetic */ void access$setHasChanges$p(RedundantVariableDeclarationElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

