/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.Exportability;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddInternalParametersToConstructorPhase;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0)2\u0006\u0010*\u001a\u00020+J\f\u0010,\u001a\u00020-*\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "classExportability", "Lorg/jetbrains/kotlin/ir/backend/js/export/Exportability;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportClass", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "exportConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportType", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "exportTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "functionExportability", "generateExport", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "getExportedIdentifier", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "backend.js"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;

    public ExportModelGenerator(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExportedDeclaration> generateExport(@NotNull IrPackageFragment file2) {
        List list2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FqName namespaceFqName = file2.getFqName();
        Iterable $this$flatMap$iv = file2.getDeclarations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrDeclaration declaration2 = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object)this.exportDeclaration(declaration2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List exports = (List)destination$iv$iv;
        if (exports.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else if (namespaceFqName.isRoot()) {
            list2 = exports;
        } else {
            String string2 = namespaceFqName.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"namespaceFqName.toString()");
            list2 = CollectionsKt.listOf((Object)new ExportedNamespace(string2, exports));
        }
        return list2;
    }

    @NotNull
    public final ExportedModule generateExport(@NotNull Iterable<? extends IrModuleFragment> modules) {
        Iterable list$iv$iv;
        IrElementBase it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Object object = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        String string2 = object2;
        object = this.context.getConfiguration().get(JSConfigurationKeys.MODULE_KIND);
        Intrinsics.checkNotNull((Object)object);
        object2 = object;
        String string3 = object2;
        object2 = modules;
        List list2 = this.context.getExternalPackageFragment().values();
        String string4 = string3;
        String string5 = string2;
        boolean $i$f$flatMap = false;
        void var4_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        $this$flatMap$iv = CollectionsKt.plus(list2, (Iterable)list3);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.generateExport((IrPackageFragment)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list4 = list2 = (List)destination$iv$iv;
        String string6 = string4;
        String string7 = string5;
        return new ExportedModule(string7, (ModuleKind)((Object)string6), list4);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration2) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.access$getExportCandidate(declaration2);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportModelGeneratorKt.access$shouldDeclarationBeExported(candidate2, this.context)) {
            return null;
        }
        irDeclarationWithName = candidate2;
        if (irDeclarationWithName instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName instanceof IrField) {
            exportedDeclaration = null;
        } else {
            String string2 = Intrinsics.stringPlus((String)"Can't export declaration ", (Object)candidate2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return exportedDeclaration;
    }

    private final ExportedDeclaration exportFunction(IrSimpleFunction function2) {
        ExportedDeclaration exportedDeclaration;
        Exportability exportability = this.functionExportability(function2);
        if (exportability instanceof Exportability.NotNeeded) {
            exportedDeclaration = null;
        } else if (exportability instanceof Exportability.Prohibited) {
            exportedDeclaration = new ErrorDeclaration(((Exportability.Prohibited)exportability).getReason());
        } else if (exportability instanceof Exportability.Allowed) {
            Object object;
            IrTypeParameter it;
            Collection<ExportedParameter> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            IrDeclarationParent parent2 = function2.getParent();
            Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)function2.getExtensionReceiverParameter()), (Iterable)function2.getValueParameters());
            ExportedType exportedType = this.exportType(function2.getReturnType());
            String string2 = this.getExportedIdentifier(function2);
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = this.exportParameter((IrValueParameter)((Object)it));
                collection.add((ExportedParameter)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = function2.getTypeParameters();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IrTypeParameter)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string3 = it.getName().getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name.identifier");
                String string4 = string3;
                object.add(string4);
            }
            object = (List)destination$iv$iv;
            IrSimpleFunction irSimpleFunction = function2;
            boolean bl = parent2 instanceof IrClass && !IrUtilsKt.isInterface((IrClass)parent2) && function2.getModality() == Modality.ABSTRACT;
            boolean bl2 = IrFunctionKt.isStaticMethodOfClass(function2);
            boolean bl3 = parent2 instanceof IrClass;
            Object object2 = object;
            Collection<ExportedParameter> collection2 = collection;
            ExportedType exportedType2 = exportedType;
            String string5 = string2;
            exportedDeclaration = new ExportedFunction(string5, exportedType2, (List<ExportedParameter>)collection2, (List<String>)object2, bl3, bl2, bl, irSimpleFunction);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportedDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor2) {
        Collection<ExportedParameter> collection;
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        if (!constructor2.isPrimary()) {
            return null;
        }
        Iterable iterable = constructor2.getValueParameters();
        Collection collection2 = CollectionsKt.listOfNotNull((Object)constructor2.getExtensionReceiverParameter());
        boolean $i$f$filterNot = false;
        void var5_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_RESULT_TYPE_PARAMETER.INSTANCE || it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_INIT_BOX_PARAMETER.INSTANCE) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List allValueParameters = CollectionsKt.plus((Collection)collection2, (Iterable)list2);
        Iterable $this$map$iv = allValueParameters;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ExportedParameter exportedParameter = this.exportParameter(it);
            collection.add(exportedParameter);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        return new ExportedConstructor(list3);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter) {
        String string2 = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter.name.asString()");
        String parameterName = NameTablesKt.sanitizeName(string2);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(parameterName)) {
            parameterName = Intrinsics.stringPlus((String)"_", (Object)parameterName);
        }
        return new ExportedParameter(parameterName, this.exportType(parameter.getType()));
    }

    private final ExportedDeclaration exportProperty(IrProperty property2) {
        Object object = new IrSimpleFunction[]{property2.getGetter(), property2.getSetter()};
        for (IrSimpleFunction accessor : CollectionsKt.listOfNotNull((Object[])object)) {
            if (accessor.getExtensionReceiverParameter() != null) {
                return null;
            }
            if (!accessor.isFakeOverride()) continue;
            return null;
        }
        object = property2.getParent();
        IrClass parentClass = object instanceof IrClass ? (IrClass)object : null;
        String string2 = this.getExportedIdentifier(property2);
        object = property2.getGetter();
        Intrinsics.checkNotNull((Object)object);
        ExportedType exportedType = this.exportType(((IrFunction)object).getReturnType());
        object = parentClass;
        return new ExportedProperty(string2, exportedType, property2.isVar(), parentClass != null, false, Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(IrUtilsKt.isInterface((IrClass)object))), (Object)false) && property2.getModality() == Modality.ABSTRACT, property2.getGetter(), property2.getSetter());
    }

    private final Exportability classExportability(IrClass klass) {
        ClassKind classKind = klass.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[classKind.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return new Exportability.Prohibited("Class " + IrUtilsKt.getFqNameWhenAvailable(klass) + " with kind: " + (Object)((Object)klass.getKind()));
            }
        }
        if (klass.isInline()) {
            return new Exportability.Prohibited(Intrinsics.stringPlus((String)"Inline class ", (Object)IrUtilsKt.getFqNameWhenAvailable(klass)));
        }
        return Exportability.Allowed.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportClass(IrClass klass) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ExportedType exportedType;
        Object v0;
        Object $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        List typeParameters2;
        Object object;
        boolean bl;
        Collection collection;
        List nestedClasses2;
        List members;
        block19: {
            Iterable $this$mapTo$iv$iv2;
            Object object2;
            Exportability exportability = this.classExportability(klass);
            if (exportability instanceof Exportability.Prohibited) {
                String string2 = ((Exportability.Prohibited)exportability).getReason();
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            if (exportability instanceof Exportability.NotNeeded) {
                return null;
            }
            boolean bl3 = false;
            members = new ArrayList();
            boolean bl4 = false;
            nestedClasses2 = new ArrayList();
            for (IrDeclaration declaration2 : klass.getDeclarations()) {
                boolean bl5;
                Object ec2;
                Object candidate2;
                object2 = ExportModelGeneratorKt.access$getExportCandidate(declaration2);
                if (object2 == null || !ExportModelGeneratorKt.access$shouldDeclarationBeExported((IrDeclarationWithName)(candidate2 = object2), this.context)) continue;
                object2 = candidate2;
                if (object2 instanceof IrSimpleFunction) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, this.exportFunction((IrSimpleFunction)candidate2));
                    continue;
                }
                if (object2 instanceof IrConstructor) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, this.exportConstructor((IrConstructor)candidate2));
                    continue;
                }
                if (object2 instanceof IrProperty) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, this.exportProperty((IrProperty)candidate2));
                    continue;
                }
                if (object2 instanceof IrClass) {
                    ec2 = this.exportClass((IrClass)candidate2);
                    if (ec2 instanceof ExportedClass) {
                        nestedClasses2.add(ec2);
                        continue;
                    }
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, ec2);
                    continue;
                }
                if (object2 instanceof IrField) {
                    boolean ec2 = Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE) || ((IrField)candidate2).getCorrespondingPropertySymbol() != null;
                    bl5 = false;
                    if (!_Assertions.ENABLED || ec2) continue;
                    boolean $i$a$-assert-ExportModelGenerator$exportClass$22 = false;
                    String $i$a$-assert-ExportModelGenerator$exportClass$22 = Intrinsics.stringPlus((String)"Unexpected field without property ", (Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)candidate2));
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportClass$22));
                }
                ec2 = Intrinsics.stringPlus((String)"Can't export member declaration ", (Object)declaration2);
                bl5 = false;
                throw (Throwable)new IllegalStateException(ec2.toString());
            }
            Iterable $this$map$iv2 = klass.getTypeParameters();
            boolean $i$f$map = false;
            object2 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                object = it.getName().getIdentifier();
                collection.add(object);
            }
            typeParameters2 = (List)destination$iv$iv;
            $this$mapTo$iv$iv2 = klass.getSuperTypes();
            $i$f$firstOrNull = false;
            Iterator $i$f$mapTo22 = $this$firstOrNull$iv.iterator();
            while ($i$f$mapTo22.hasNext()) {
                Object element$iv = $i$f$mapTo22.next();
                IrType it = (IrType)element$iv;
                boolean bl6 = false;
                if (!(!ExportModelGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail(it)) && !IrTypePredicatesKt.isAny(it))) continue;
                v0 = element$iv;
                break block19;
            }
            v0 = null;
        }
        IrType $i$f$map = v0;
        if ($i$f$map == null) {
            exportedType = null;
        } else {
            $this$firstOrNull$iv = $i$f$map;
            $i$f$firstOrNull = false;
            boolean $i$f$mapTo22 = false;
            Object it = $this$firstOrNull$iv;
            boolean bl7 = false;
            ExportedType exportedType2 = this.exportType((IrType)it);
            bl = false;
            boolean bl8 = false;
            ExportedType it2 = exportedType2;
            boolean bl9 = false;
            exportedType = !(it2 instanceof ExportedType.ErrorType) ? exportedType2 : null;
        }
        ExportedType superType = exportedType;
        $this$firstOrNull$iv = klass.getSuperTypes();
        boolean $i$f$filter = false;
        void $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl10 = false;
            if (!ExportModelGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl11 = false;
            object = this.exportType(it);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExportedType it = (ExportedType)element$iv$iv;
            boolean bl12 = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superInterfaces = (List)destination$iv$iv;
        String name = this.getExportedIdentifier(klass);
        if (klass.getKind() == ClassKind.OBJECT) {
            ExportedType t = new ExportedType.InlineInterfaceType(CollectionsKt.plus((Collection)members, (Iterable)nestedClasses2));
            if (superType != null) {
                t = new ExportedType.IntersectionType(t, superType);
            }
            for (ExportedType superInterface : superInterfaces) {
                t = new ExportedType.IntersectionType(t, superInterface);
            }
            boolean bl13 = klass.getParent() instanceof IrClass;
            IrSimpleFunction irSimpleFunction = this.context.getMapping().getObjectToGetInstanceFunction().get((IrClass)((IrDeclaration)klass));
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            return new ExportedProperty(name, t, false, bl13, true, false, irSimpleFunction, null);
        }
        return new ExportedClass(name, IrUtilsKt.isInterface(klass), klass.getModality() == Modality.ABSTRACT, superType, superInterfaces, typeParameters2, members, nestedClasses2, klass);
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type2) {
        if (type2 instanceof IrTypeProjection) {
            return this.exportType(((IrTypeProjection)type2).getType());
        }
        if (type2 instanceof IrType) {
            return this.exportType((IrType)((Object)type2));
        }
        return new ExportedType.ErrorType(Intrinsics.stringPlus((String)"UnknownType ", (Object)RenderIrElementKt.render(type2)));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type2) {
        ExportedType exportedType;
        boolean isNullable;
        block10: {
            IrClassifierSymbol classifier2;
            block29: {
                Object object;
                Object object2;
                Object object3;
                block28: {
                    Object $this$map$iv;
                    block27: {
                        void $this$mapTo$iv$iv;
                        IrSimpleType nonNullType;
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block18: {
                                                            block17: {
                                                                block16: {
                                                                    block15: {
                                                                        block14: {
                                                                            block13: {
                                                                                block12: {
                                                                                    block11: {
                                                                                        block9: {
                                                                                            if (type2 instanceof IrDynamicType) {
                                                                                                return ExportedType.Primitive.Any.INSTANCE;
                                                                                            }
                                                                                            if (!(type2 instanceof IrSimpleType)) {
                                                                                                return new ExportedType.ErrorType(Intrinsics.stringPlus((String)"NonSimpleType ", (Object)RenderIrElementKt.render(type2)));
                                                                                            }
                                                                                            classifier2 = ((IrSimpleType)type2).getClassifier();
                                                                                            isNullable = ((IrSimpleType)type2).getHasQuestionMark();
                                                                                            nonNullType = (IrSimpleType)IrTypesKt.makeNotNull(type2);
                                                                                            if (!IrTypePredicatesKt.isBoolean(nonNullType)) break block9;
                                                                                            exportedType = ExportedType.Primitive.Boolean.INSTANCE;
                                                                                            break block10;
                                                                                        }
                                                                                        if (!IrTypePredicatesKt.isPrimitiveType$default(nonNullType, false, 1, null) || IrTypePredicatesKt.isLong(nonNullType) || IrTypePredicatesKt.isChar(nonNullType)) break block11;
                                                                                        exportedType = ExportedType.Primitive.Number.INSTANCE;
                                                                                        break block10;
                                                                                    }
                                                                                    if (!IrTypePredicatesKt.isByteArray(nonNullType)) break block12;
                                                                                    exportedType = ExportedType.Primitive.ByteArray.INSTANCE;
                                                                                    break block10;
                                                                                }
                                                                                if (!IrTypePredicatesKt.isShortArray(nonNullType)) break block13;
                                                                                exportedType = ExportedType.Primitive.ShortArray.INSTANCE;
                                                                                break block10;
                                                                            }
                                                                            if (!IrTypePredicatesKt.isIntArray(nonNullType)) break block14;
                                                                            exportedType = ExportedType.Primitive.IntArray.INSTANCE;
                                                                            break block10;
                                                                        }
                                                                        if (!IrTypePredicatesKt.isFloatArray(nonNullType)) break block15;
                                                                        exportedType = ExportedType.Primitive.FloatArray.INSTANCE;
                                                                        break block10;
                                                                    }
                                                                    if (!IrTypePredicatesKt.isDoubleArray(nonNullType)) break block16;
                                                                    exportedType = ExportedType.Primitive.DoubleArray.INSTANCE;
                                                                    break block10;
                                                                }
                                                                if (!IrTypePredicatesKt.isBooleanArray(nonNullType)) break block17;
                                                                exportedType = new ExportedType.ErrorType("BooleanArray");
                                                                break block10;
                                                            }
                                                            if (!IrTypePredicatesKt.isLongArray(nonNullType)) break block18;
                                                            exportedType = new ExportedType.ErrorType("LongArray");
                                                            break block10;
                                                        }
                                                        if (!IrTypePredicatesKt.isCharArray(nonNullType)) break block19;
                                                        exportedType = new ExportedType.ErrorType("CharArray");
                                                        break block10;
                                                    }
                                                    if (!IrTypePredicatesKt.isString(nonNullType)) break block20;
                                                    exportedType = ExportedType.Primitive.String.INSTANCE;
                                                    break block10;
                                                }
                                                if (!IrTypeUtilsKt.isThrowable(nonNullType)) break block21;
                                                exportedType = ExportedType.Primitive.Throwable.INSTANCE;
                                                break block10;
                                            }
                                            if (!IrTypePredicatesKt.isAny(nonNullType)) break block22;
                                            exportedType = ExportedType.Primitive.Any.INSTANCE;
                                            break block10;
                                        }
                                        if (!IrTypePredicatesKt.isUnit(nonNullType)) break block23;
                                        exportedType = ExportedType.Primitive.Unit.INSTANCE;
                                        break block10;
                                    }
                                    if (!IrTypePredicatesKt.isNothing(nonNullType)) break block24;
                                    exportedType = ExportedType.Primitive.Nothing.INSTANCE;
                                    break block10;
                                }
                                if (!IrTypePredicatesKt.isArray(nonNullType)) break block25;
                                exportedType = new ExportedType.Array(this.exportTypeArgument(nonNullType.getArguments().get(0)));
                                break block10;
                            }
                            if (!IrTypeUtilsKt.isSuspendFunction(nonNullType)) break block26;
                            exportedType = new ExportedType.ErrorType("Suspend functions are not supported");
                            break block10;
                        }
                        if (!IrTypeUtilsKt.isFunction(nonNullType)) break block27;
                        $this$map$iv = CollectionsKt.dropLast(nonNullType.getArguments(), (int)1);
                        boolean $i$f$map = false;
                        object3 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl = false;
                            object = this.exportTypeArgument((IrTypeArgument)it);
                            object2.add(object);
                        }
                        object2 = (List)destination$iv$iv;
                        ExportedType exportedType2 = this.exportTypeArgument((IrTypeArgument)CollectionsKt.last(nonNullType.getArguments()));
                        List list2 = object2;
                        exportedType = new ExportedType.Function(list2, exportedType2);
                        break block10;
                    }
                    if (!(classifier2 instanceof IrTypeParameterSymbol)) break block28;
                    $this$map$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"classifier.owner.name.identifier");
                    exportedType = new ExportedType.TypeParameter((String)$this$map$iv);
                    break block10;
                }
                if (!(classifier2 instanceof IrClassSymbol)) break block29;
                IrClass klass = (IrClass)((IrClassSymbol)classifier2).getOwner();
                FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(klass);
                Intrinsics.checkNotNull((Object)fqName2);
                object3 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"klass.fqNameWhenAvailable!!.asString()");
                Object name = object3;
                object3 = klass.getKind();
                int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object3).ordinal()];
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        exportedType = new ExportedType.ErrorType("Class " + (String)name + " with kind: " + (Object)((Object)klass.getKind()));
                        break block10;
                    }
                    case 4: {
                        exportedType = new ExportedType.TypeOf((String)name);
                        break block10;
                    }
                    case 5: 
                    case 6: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object item$iv$iv;
                        Iterable $i$f$mapTo = ((IrSimpleType)type2).getArguments();
                        object2 = name;
                        boolean $i$f$map = false;
                        item$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                            void it;
                            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv2;
                            object = destination$iv$iv;
                            boolean bl = false;
                            ExportedType exportedType3 = this.exportTypeArgument((IrTypeArgument)it);
                            object.add(exportedType3);
                        }
                        Object object4 = object = (List)destination$iv$iv;
                        Object object5 = object2;
                        exportedType = new ExportedType.ClassType((String)object5, (List<? extends ExportedType>)object4);
                        break block10;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            String string2 = Intrinsics.stringPlus((String)"Unexpected classifier ", (Object)classifier2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ExportedType exportedType4 = exportedType;
        return exportedType4.withNullability(isNullable);
    }

    private final String getExportedIdentifier(IrDeclarationWithName $this$getExportedIdentifier) {
        Name name = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        boolean bl2 = false;
        Name $this$getExportedIdentifier_u24lambda_u2d17 = name;
        boolean bl3 = false;
        if ($this$getExportedIdentifier_u24lambda_u2d17.isSpecial()) {
            String string2 = "Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration " + IrUtilsKt.getFqNameWhenAvailable($this$getExportedIdentifier);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = $this$getExportedIdentifier_u24lambda_u2d17.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"with(getJsNameOrKotlinName()) {\n            if (isSpecial)\n                error(\"Cannot export special name: ${name.asString()} for declaration $fqNameWhenAvailable\")\n            else identifier\n        }");
        return string3;
    }

    private final Exportability functionExportability(IrSimpleFunction function2) {
        if (function2.isInline()) {
            boolean bl;
            block16: {
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrTypeParameter it = (IrTypeParameter)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Exportability.Prohibited("Inline reified function");
            }
        }
        if (function2.isSuspend()) {
            return new Exportability.Prohibited("Suspend function");
        }
        if (function2.isFakeOverride()) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.BRIDGE_WITHOUT_STABLE_NAME.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.BRIDGE_WITH_STABLE_NAME.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.OBJECT_GET_INSTANCE_FUNCTION.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.JS_SHADOWED_EXPORT.INSTANCE)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (IrUtilsKt.isFakeOverriddenFromAny(function2)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String $i$f$any = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$any, (String)"function.name.asString()");
        String nameString = $i$f$any;
        if (StringsKt.endsWith$default((String)nameString, (String)"-impl", (boolean)false, (int)2, null)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (StringsKt.endsWith$default((String)nameString, (String)"$", (boolean)false, (int)2, null)) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = function2.getValueParameters();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        String string2 = it.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name.asString()");
                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"$mask", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Exportability.NotNeeded.INSTANCE;
            }
        }
        String name = this.getExportedIdentifier(function2);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(name)) {
            return new Exportability.Prohibited("Name is a reserved word");
        }
        return Exportability.Allowed.INSTANCE;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            nArray[ClassKind.ENUM_CLASS.ordinal()] = 2;
            nArray[ClassKind.ENUM_ENTRY.ordinal()] = 3;
            nArray[ClassKind.OBJECT.ordinal()] = 4;
            nArray[ClassKind.CLASS.ordinal()] = 5;
            nArray[ClassKind.INTERFACE.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

