/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.backend.ConversionTypeContext;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.references.impl.FirPropertyFromParameterResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.ConstructorProcessingKt;
import org.jetbrains.kotlin.fir.resolve.calls.SyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.DelegatedWrapperData;
import org.jetbrains.kotlin.fir.scopes.impl.FirDelegatedMemberScopeKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.AccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrElseBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhenImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000\u0080\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\b\u0010\b\u001a\u00020\tH\u0000\u001aS\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f*\u00020\r26\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0000\u00a2\u0006\u0002\u0010\u0015\u001a\"\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017\u001a2\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c0\u001f*\u00020\u00182\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u001a&\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c0\u001f*\u00020\u00182\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"\u001a8\u0010&\u001a\u00020'*\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010H\u0000\u001a>\u0010.\u001a\b\u0012\u0004\u0012\u0002000/*\u0002012\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0000\u001a6\u0010;\u001a\b\u0012\u0004\u0012\u0002000/*\u00020<2\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0000\u001a\u0012\u0010=\u001a\u0006\u0012\u0002\b\u00030>*\u0006\u0012\u0002\b\u00030?\u001a\u0016\u0010@\u001a\u00020-*\u0006\u0012\u0002\b\u0003032\u0006\u0010A\u001a\u00020B\u001a\u000e\u0010C\u001a\u0004\u0018\u00010D*\u00020EH\u0000\u001a$\u0010F\u001a\b\u0012\u0004\u0012\u0002H\u000b0G\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0?2\u0006\u0010H\u001a\u00020\u0006\u001a\u0014\u0010I\u001a\u0006\u0012\u0002\b\u00030>*\u0006\u0012\u0002\b\u00030JH\u0002\u001a(\u0010K\u001a\u00020L*\u0006\u0012\u0002\b\u00030M2\u0006\u00105\u001a\u0002062\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010P\u001a\u00020Q\u001a6\u0010R\u001a\u0004\u0018\u00010S*\u00020E2\u0006\u00105\u001a\u0002062\u0006\u0010N\u001a\u00020O2\u0006\u00109\u001a\u00020:2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010T\u001a\u00020\u0005\u001a\"\u0010R\u001a\u0004\u0018\u00010S*\u0006\u0012\u0002\b\u00030U2\u0006\u00109\u001a\u00020:2\u0006\u0010T\u001a\u00020\u0005H\u0002\u001a#\u0010V\u001a\u0006\u0012\u0002\b\u00030U*\u0006\u0012\u0002\b\u00030U2\f\b\u0002\u0010W\u001a\u0006\u0012\u0002\b\u00030UH\u0080\u0010\u001a\u0015\u0010X\u001a\u0006\u0012\u0002\b\u00030U*\u0006\u0012\u0002\b\u00030UH\u0080\u0010\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006Y"}, d2={"nameToOperationConventionOrigin", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "isSamType", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "createErrorType", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "convertWithOffsets", "T", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "f", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "startOffset", "endOffset", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/ir/IrElement;", "createSafeCallConstruction", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "receiverVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "receiverVariableSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "expressionOnNotNull", "createTemporaryVariable", "Lkotlin/Pair;", "receiverExpression", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "nameHint", "", "createTemporaryVariableForSafeCallConstruction", "declareThisReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "thisType", "thisOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "generateOverriddenAccessorSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "isGetter", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "generateOverriddenFunctionSymbols", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getIrConstKind", "Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "irOrigin", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "statementOrigin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "toIrConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "irType", "toIrConstKind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "toSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "typeContext", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeContext;", "toSymbolForCall", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "preferGetter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "unwrapCallRepresentative", "root", "unwrapSubstitutionAndIntersectionOverrides", "fir2ir"})
public final class ConversionUtilsKt {
    @NotNull
    private static final Map<Name, IrStatementOriginImpl> nameToOperationConventionOrigin;

    @NotNull
    public static final <T extends IrElement> T convertWithOffsets(@NotNull FirElement $this$convertWithOffsets, @NotNull Function2<? super Integer, ? super Integer, ? extends T> f) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$convertWithOffsets, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (FirSourceElementKt.getPsi($this$convertWithOffsets) instanceof PsiCompiledElement) {
            return (T)((IrElement)f.invoke((Object)-1, (Object)-1));
        }
        PsiElement psiElement = FirSourceElementKt.getPsi($this$convertWithOffsets);
        int startOffset = psiElement == null ? -1 : (n2 = PsiUtilsKt.getStartOffsetSkippingComments(psiElement));
        PsiElement psiElement2 = FirSourceElementKt.getPsi($this$convertWithOffsets);
        int endOffset = psiElement2 == null ? -1 : (n = PsiUtilsKt.getEndOffset(psiElement2));
        return (T)((IrElement)f.invoke((Object)startOffset, (Object)endOffset));
    }

    @NotNull
    public static final IrErrorType createErrorType() {
        return new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
    }

    @NotNull
    public static final IrClassifierSymbol toSymbol(@NotNull FirClassifierSymbol<?> $this$toSymbol, @NotNull FirSession session2, @NotNull Fir2IrClassifierStorage classifierStorage, @NotNull ConversionTypeContext typeContext2) {
        IrClassifierSymbol irClassifierSymbol;
        Intrinsics.checkNotNullParameter($this$toSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)classifierStorage, (String)"classifierStorage");
        Intrinsics.checkNotNullParameter((Object)typeContext2, (String)"typeContext");
        FirClassifierSymbol<?> firClassifierSymbol = $this$toSymbol;
        if (firClassifierSymbol instanceof FirTypeParameterSymbol) {
            irClassifierSymbol = classifierStorage.getIrTypeParameterSymbol((FirTypeParameterSymbol)$this$toSymbol, typeContext2);
        } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
            ConeKotlinType coneKotlinType;
            FirTypeAlias typeAlias = (FirTypeAlias)((FirTypeAliasSymbol)$this$toSymbol).getFir();
            FirTypeRef $this$coneType$iv = typeAlias.getExpandedTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = null;
            }
            if ((coneKotlinType = coneKotlinType2) == null) {
                String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
            FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeType.getLookupTag(), session2);
            Intrinsics.checkNotNull(firClassLikeSymbol);
            irClassifierSymbol = ConversionUtilsKt.toSymbol$default(firClassLikeSymbol, session2, classifierStorage, null, 4, null);
        } else if (firClassifierSymbol instanceof FirClassSymbol) {
            irClassifierSymbol = classifierStorage.getIrClassSymbol((FirClassSymbol)$this$toSymbol);
        } else {
            String string3 = Intrinsics.stringPlus((String)"Unknown symbol: ", $this$toSymbol);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return irClassifierSymbol;
    }

    public static /* synthetic */ IrClassifierSymbol toSymbol$default(FirClassifierSymbol firClassifierSymbol, FirSession firSession, Fir2IrClassifierStorage fir2IrClassifierStorage, ConversionTypeContext conversionTypeContext, int n, Object object) {
        if ((n & 4) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        return ConversionUtilsKt.toSymbol(firClassifierSymbol, firSession, fir2IrClassifierStorage, conversionTypeContext);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final IrSymbol toSymbolForCall(@NotNull FirReference $this$toSymbolForCall, @NotNull FirSession session2, @NotNull Fir2IrClassifierStorage classifierStorage, @NotNull Fir2IrDeclarationStorage declarationStorage, @NotNull Fir2IrConversionScope conversionScope, boolean preferGetter) {
        IrBindableSymbol irBindableSymbol;
        IrSymbol irSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$toSymbolForCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)classifierStorage, (String)"classifierStorage");
        Intrinsics.checkNotNullParameter((Object)declarationStorage, (String)"declarationStorage");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        FirReference firReference = $this$toSymbolForCall;
        if (firReference instanceof FirResolvedNamedReference) {
            AbstractFirBasedSymbol<?> resolvedSymbol = ((FirResolvedNamedReference)$this$toSymbolForCall).getResolvedSymbol();
            if (resolvedSymbol instanceof FirCallableSymbol) {
                irSymbol = ConversionUtilsKt.toSymbolForCall(ConversionUtilsKt.unwrapCallRepresentative$default((FirCallableSymbol)resolvedSymbol, null, 1, null), declarationStorage, preferGetter);
                return irSymbol;
            }
            if (resolvedSymbol instanceof FirClassifierSymbol) {
                irSymbol = ConversionUtilsKt.toSymbol$default((FirClassifierSymbol)resolvedSymbol, session2, classifierStorage, null, 4, null);
                return irSymbol;
            }
            String string2 = Intrinsics.stringPlus((String)"Unknown symbol: ", resolvedSymbol);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (!(firReference instanceof FirThisReference)) {
            return null;
        }
        AbstractFirBasedSymbol<?> boundSymbol = ((FirThisReference)$this$toSymbolForCall).getBoundSymbol();
        if (boundSymbol instanceof FirClassSymbol) {
            IrValueParameter irValueParameter = ((IrClass)classifierStorage.getIrClassSymbol((FirClassSymbol)boundSymbol).getOwner()).getThisReceiver();
            irBindableSymbol = irValueParameter == null ? null : irValueParameter.getSymbol();
        } else if (boundSymbol instanceof FirFunctionSymbol) {
            IrValueParameter irValueParameter = declarationStorage.getIrFunctionSymbol((FirFunctionSymbol)boundSymbol).getOwner().getExtensionReceiverParameter();
            irBindableSymbol = irValueParameter == null ? null : irValueParameter.getSymbol();
        } else if (boundSymbol instanceof FirPropertySymbol) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            IrSymbolOwner irSymbolOwner = declarationStorage.getIrPropertySymbol((FirPropertySymbol)boundSymbol).getOwner();
            IrProperty property2 = irSymbolOwner instanceof IrProperty ? (IrProperty)irSymbolOwner : null;
            irSymbolOwner = property2;
            if (irSymbolOwner == null) {
                irSimpleFunctionSymbol = null;
            } else {
                IrSymbolOwner irSymbolOwner2 = irSymbolOwner;
                boolean bl = false;
                boolean bl2 = false;
                IrSymbolOwner it = irSymbolOwner2;
                boolean bl3 = false;
                IrSimpleFunction irSimpleFunction = conversionScope.parentAccessorOfPropertyFromStack((IrProperty)it);
                irSimpleFunctionSymbol = irSimpleFunction == null ? null : irSimpleFunction.getSymbol();
            }
            irBindableSymbol = irSimpleFunctionSymbol;
        } else {
            irBindableSymbol = null;
        }
        irSymbol = irBindableSymbol;
        return irSymbol;
    }

    public static /* synthetic */ IrSymbol toSymbolForCall$default(FirReference firReference, FirSession firSession, Fir2IrClassifierStorage fir2IrClassifierStorage, Fir2IrDeclarationStorage fir2IrDeclarationStorage, Fir2IrConversionScope fir2IrConversionScope, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return ConversionUtilsKt.toSymbolForCall(firReference, firSession, fir2IrClassifierStorage, fir2IrDeclarationStorage, fir2IrConversionScope, bl);
    }

    private static final IrSymbol toSymbolForCall(FirCallableSymbol<?> $this$toSymbolForCall, Fir2IrDeclarationStorage declarationStorage, boolean preferGetter) {
        IrSymbol irSymbol;
        FirCallableSymbol<?> firCallableSymbol = $this$toSymbolForCall;
        if (firCallableSymbol instanceof FirFunctionSymbol) {
            irSymbol = declarationStorage.getIrFunctionSymbol((FirFunctionSymbol)$this$toSymbolForCall);
        } else if (firCallableSymbol instanceof SyntheticPropertySymbol) {
            IrSymbol irSymbol2;
            FirSyntheticProperty firSyntheticProperty;
            Object object = ((SyntheticPropertySymbol)$this$toSymbolForCall).getFir();
            FirSyntheticProperty firSyntheticProperty2 = firSyntheticProperty = object instanceof FirSyntheticProperty ? (FirSyntheticProperty)object : null;
            if (firSyntheticProperty == null) {
                irSymbol2 = null;
            } else {
                FirNamedFunctionSymbol firNamedFunctionSymbol;
                object = firSyntheticProperty;
                boolean bl = false;
                boolean bl2 = false;
                Object syntheticProperty = object;
                boolean bl3 = false;
                if (preferGetter) {
                    firNamedFunctionSymbol = ((FirSyntheticProperty)syntheticProperty).getGetter().getDelegate().getSymbol();
                } else {
                    FirSimpleFunction firSimpleFunction;
                    FirNamedFunctionSymbol firNamedFunctionSymbol2;
                    FirSyntheticPropertyAccessor firSyntheticPropertyAccessor = ((FirSyntheticProperty)syntheticProperty).getSetter();
                    FirNamedFunctionSymbol firNamedFunctionSymbol3 = firSyntheticPropertyAccessor == null ? null : (firNamedFunctionSymbol2 = (firSimpleFunction = firSyntheticPropertyAccessor.getDelegate()) == null ? null : firSimpleFunction.getSymbol());
                    if (firNamedFunctionSymbol2 == null) {
                        throw new AssertionError((Object)"Written synthetic property must have a setter");
                    }
                    firNamedFunctionSymbol = firNamedFunctionSymbol2;
                }
                FirNamedFunctionSymbol delegateSymbol = firNamedFunctionSymbol;
                irSymbol2 = ConversionUtilsKt.toSymbolForCall(ConversionUtilsKt.unwrapCallRepresentative$default(delegateSymbol, null, 1, null), declarationStorage, preferGetter);
            }
            IrSymbol irSymbol3 = irSymbol2;
            irSymbol = irSymbol3 == null ? declarationStorage.getIrPropertySymbol((FirPropertySymbol)$this$toSymbolForCall) : irSymbol3;
        } else {
            irSymbol = firCallableSymbol instanceof FirPropertySymbol ? declarationStorage.getIrPropertySymbol((FirPropertySymbol)$this$toSymbolForCall) : (firCallableSymbol instanceof FirFieldSymbol ? declarationStorage.getIrFieldSymbol((FirFieldSymbol)$this$toSymbolForCall) : (firCallableSymbol instanceof FirBackingFieldSymbol ? declarationStorage.getIrBackingFieldSymbol((FirVariableSymbol)$this$toSymbolForCall) : (firCallableSymbol instanceof FirDelegateFieldSymbol ? declarationStorage.getIrBackingFieldSymbol((FirVariableSymbol)$this$toSymbolForCall) : (firCallableSymbol instanceof FirVariableSymbol ? declarationStorage.getIrValueSymbol((FirVariableSymbol)$this$toSymbolForCall) : null))));
        }
        return irSymbol;
    }

    @NotNull
    public static final IrConstKind<?> getIrConstKind(@NotNull FirConstExpression<?> $this$getIrConstKind) {
        IrConstKind<?> irConstKind;
        Intrinsics.checkNotNullParameter($this$getIrConstKind, (String)"<this>");
        ConstantValueKind<?> constantValueKind = $this$getIrConstKind.getKind();
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            FirTypeRef $this$coneTypeUnsafe$iv = $this$getIrConstKind.getTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType");
            }
            ConeIntegerLiteralType type2 = (ConeIntegerLiteralType)((ConeKotlinType)((ConeIntegerLiteralType)coneKotlinType));
            ConstantValueKind<?> constantValueKind2 = FirTypeUtilsKt.toConstKind(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
            Intrinsics.checkNotNull(constantValueKind2);
            irConstKind = ConversionUtilsKt.toIrConstKind(constantValueKind2);
        } else {
            irConstKind = ConversionUtilsKt.toIrConstKind($this$getIrConstKind.getKind());
        }
        return irConstKind;
    }

    @NotNull
    public static final <T> IrConst<T> toIrConst(@NotNull FirConstExpression<T> $this$toIrConst, @NotNull IrType irType) {
        Intrinsics.checkNotNullParameter($this$toIrConst, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        return (IrConst)ConversionUtilsKt.convertWithOffsets($this$toIrConst, (Function2)new Function2<Integer, Integer, IrConstImpl<T>>($this$toIrConst, irType){
            final /* synthetic */ FirConstExpression<T> $this_toIrConst;
            final /* synthetic */ IrType $irType;
            {
                this.$this_toIrConst = $receiver;
                this.$irType = $irType;
                super(2);
            }

            @NotNull
            public final IrConstImpl<T> invoke(int startOffset, int endOffset) {
                Number number;
                Long l;
                IrConstKind<?> kind = ConversionUtilsKt.getIrConstKind(this.$this_toIrConst);
                Object object = this.$this_toIrConst.getValue();
                Long l2 = l = object instanceof Long ? (Long)object : null;
                if (l == null) {
                    number = null;
                } else {
                    object = l;
                    boolean bl = false;
                    boolean bl2 = false;
                    long it = ((Number)object).longValue();
                    boolean bl3 = false;
                    IrConstKind<?> irConstKind = kind;
                    number = Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Byte.INSTANCE) ? (Number)Byte.valueOf((byte)it) : (Number)(Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Short.INSTANCE) ? (Number)Short.valueOf((short)it) : (Number)(Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Int.INSTANCE) ? (Number)Integer.valueOf((int)it) : (Number)(Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Float.INSTANCE) ? (Number)Float.valueOf(it) : (Number)(Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Double.INSTANCE) ? (Number)Double.valueOf(it) : (Number)Long.valueOf(it)))));
                }
                Byte by = number;
                Byte value2 = by == null ? (Byte)this.$this_toIrConst.getValue() : by;
                return new IrConstImpl<Object>(startOffset, endOffset, this.$irType, (IrConstKind<Object>)kind, value2);
            }
        });
    }

    private static final IrConstKind<?> toIrConstKind(ConstantValueKind<?> $this$toIrConstKind) {
        IrConstKind irConstKind;
        ConstantValueKind<?> constantValueKind = $this$toIrConstKind;
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
            irConstKind = IrConstKind.Null.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            irConstKind = IrConstKind.Boolean.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            irConstKind = IrConstKind.Char.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            irConstKind = IrConstKind.Byte.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            irConstKind = IrConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            irConstKind = IrConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            irConstKind = IrConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            irConstKind = IrConstKind.Byte.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            irConstKind = IrConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            irConstKind = IrConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            irConstKind = IrConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            irConstKind = IrConstKind.String.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            irConstKind = IrConstKind.Float.INSTANCE;
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            irConstKind = IrConstKind.Double.INSTANCE;
        } else {
            if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE) ? true : Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
                throw new IllegalArgumentException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return irConstKind;
    }

    @NotNull
    public static final FirCallableSymbol<?> unwrapSubstitutionAndIntersectionOverrides(@NotNull FirCallableSymbol<?> $this$unwrapSubstitutionAndIntersectionOverrides) {
        FirCallableSymbol<?> firCallableSymbol;
        Intrinsics.checkNotNullParameter($this$unwrapSubstitutionAndIntersectionOverrides, (String)"<this>");
        FirCallableSymbol<Object> firCallableSymbol2 = $this$unwrapSubstitutionAndIntersectionOverrides;
        while (true) {
            FirCallableSymbol baseForIntersectionOverride;
            FirCallableSymbol originalForSubstitutionOverride;
            FirCallableSymbol<?> $this$originalForSubstitutionOverride$iv = firCallableSymbol = firCallableSymbol2;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
            boolean $i$f$getOriginalForSubstitutionOverride2 = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            FirCallableSymbol firCallableSymbol3 = originalForSubstitutionOverride = firCallableDeclaration == null ? null : firCallableDeclaration.getSymbol();
            if (originalForSubstitutionOverride != null) {
                firCallableSymbol2 = originalForSubstitutionOverride;
                continue;
            }
            FirCallableSymbol<?> $this$baseForIntersectionOverride$iv = firCallableSymbol;
            boolean $i$f$getBaseForIntersectionOverride = false;
            FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv = (FirCallableDeclaration)$this$baseForIntersectionOverride$iv.getFir();
            boolean $i$f$getBaseForIntersectionOverride2 = false;
            FirCallableDeclaration firCallableDeclaration2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv) : null;
            FirCallableSymbol firCallableSymbol4 = baseForIntersectionOverride = firCallableDeclaration2 == null ? null : firCallableDeclaration2.getSymbol();
            if (baseForIntersectionOverride == null) break;
            firCallableSymbol2 = baseForIntersectionOverride;
        }
        return firCallableSymbol;
    }

    @NotNull
    public static final FirCallableSymbol<?> unwrapCallRepresentative(@NotNull FirCallableSymbol<?> $this$unwrapCallRepresentative, @NotNull FirCallableSymbol<?> root2) {
        Intrinsics.checkNotNullParameter($this$unwrapCallRepresentative, (String)"<this>");
        Intrinsics.checkNotNullParameter(root2, (String)"root");
        FirCallableSymbol<FirConstructor> firCallableSymbol = $this$unwrapCallRepresentative;
        FirCallableSymbol<FirConstructor> firCallableSymbol2 = root2;
        while (true) {
            FirCallableSymbol firCallableSymbol3;
            FirCallableSymbol firCallableSymbol4;
            FirCallableDeclaration firCallableDeclaration;
            FirCallableMemberDeclaration<FirConstructor> originalForTypeAlias;
            FirCallableSymbol<FirConstructor> firCallableSymbol5 = firCallableSymbol;
            FirCallableSymbol<FirConstructor> firCallableSymbol6 = firCallableSymbol2;
            FirCallableDeclaration fir = (FirCallableDeclaration)firCallableSymbol5.getFir();
            if (fir instanceof FirConstructor && (originalForTypeAlias = ConstructorProcessingKt.getOriginalConstructorIfTypeAlias((FirConstructor)fir)) != null) {
                firCallableSymbol = ((FirConstructor)originalForTypeAlias).getSymbol();
                firCallableSymbol2 = firCallableSymbol5;
                continue;
            }
            if (ClassMembersKt.isIntersectionOverride(fir)) {
                if (fir instanceof FirCallableMemberDeclaration && ((FirCallableMemberDeclaration)fir).getDispatchReceiverType() instanceof ConeIntersectionType) {
                    FirCallableDeclaration $this$baseForIntersectionOverride$iv = fir;
                    boolean $i$f$getBaseForIntersectionOverride = false;
                    originalForTypeAlias = (FirCallableMemberDeclaration)(ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv) : null);
                    Intrinsics.checkNotNull((Object)originalForTypeAlias);
                    firCallableSymbol = originalForTypeAlias.getSymbol();
                    firCallableSymbol2 = firCallableSymbol5;
                    continue;
                }
                return firCallableSymbol5;
            }
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv = fir;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv) : null;
            if (firCallableDeclaration == null) {
                firCallableSymbol4 = null;
            } else {
                FirCallableDeclaration firCallableDeclaration3 = firCallableDeclaration;
                boolean bl = false;
                boolean bl2 = false;
                FirCallableDeclaration it = firCallableDeclaration3;
                boolean bl3 = false;
                FirCallableDeclaration firCallableDeclaration4 = Intrinsics.areEqual((Object)ClassMembersKt.containingClass(it), (Object)ClassMembersKt.containingClass(firCallableSymbol6)) ? firCallableDeclaration3 : null;
                firCallableSymbol4 = firCallableSymbol3 = firCallableDeclaration4 == null ? null : firCallableDeclaration4.getSymbol();
            }
            if (firCallableSymbol3 == null) {
                return firCallableSymbol5;
            }
            FirCallableSymbol overriddenSymbol = firCallableSymbol3;
            firCallableSymbol = overriddenSymbol;
            firCallableSymbol2 = firCallableSymbol5;
        }
    }

    public static /* synthetic */ FirCallableSymbol unwrapCallRepresentative$default(FirCallableSymbol firCallableSymbol, FirCallableSymbol firCallableSymbol2, int n, Object object) {
        if ((n & 1) != 0) {
            firCallableSymbol2 = firCallableSymbol;
        }
        return ConversionUtilsKt.unwrapCallRepresentative(firCallableSymbol, firCallableSymbol2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IrSimpleFunctionSymbol> generateOverriddenFunctionSymbols(@NotNull FirSimpleFunction $this$generateOverriddenFunctionSymbols, @NotNull FirClass<?> containingClass, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        void $this$processDirectlyOverriddenFunctions$iv;
        Intrinsics.checkNotNullParameter((Object)$this$generateOverriddenFunctionSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter(containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)declarationStorage, (String)"declarationStorage");
        FirTypeScope scope2 = KotlinScopeProviderKt.unsubstitutedScope(containingClass, session2, scopeSession, true);
        scope2.processFunctionsByName($this$generateOverriddenFunctionSymbols.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)generateOverriddenFunctionSymbols.1.INSTANCE));
        boolean bl = false;
        Set overriddenSet = new LinkedHashSet();
        FirTypeScope firTypeScope = scope2;
        FirNamedFunctionSymbol functionSymbol$iv = $this$generateOverriddenFunctionSymbols.getSymbol();
        boolean $i$f$processDirectlyOverriddenFunctions = false;
        $this$processDirectlyOverriddenFunctions$iv.processDirectOverriddenFunctionsWithBaseScope(functionSymbol$iv, (Function2<? super FirNamedFunctionSymbol, ? super FirTypeScope, ? extends ProcessorAction>)((Function2)new Function2<FirNamedFunctionSymbol, FirTypeScope, ProcessorAction>(declarationStorage, overriddenSet){
            final /* synthetic */ Fir2IrDeclarationStorage $declarationStorage$inlined;
            final /* synthetic */ Set $overriddenSet$inlined;
            {
                this.$declarationStorage$inlined = fir2IrDeclarationStorage;
                this.$overriddenSet$inlined = set;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol overridden, @NotNull FirTypeScope $noName_1) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                FirNamedFunctionSymbol it = overridden;
                boolean bl = false;
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)it.getFir();
                boolean $i$f$getVisibility2 = false;
                if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                    processorAction = ProcessorAction.NEXT;
                } else {
                    void $this$unwrapFakeOverrides$iv;
                    FirCallableSymbol $i$f$getVisibility2 = it;
                    Fir2IrDeclarationStorage fir2IrDeclarationStorage = this.$declarationStorage$inlined;
                    boolean $i$f$unwrapFakeOverrides = false;
                    FirCallableDeclaration $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
                    boolean $i$f$unwrapFakeOverrides2 = false;
                    FirCallableDeclaration current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
                    while (true) {
                        FirCallableDeclaration<F> next$iv$iv;
                        FirCallableDeclaration<F> firCallableDeclaration;
                        FirCallableDeclaration<F> firCallableDeclaration2;
                        FirCallableDeclaration<F> firCallableDeclaration3;
                        FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
                        boolean $i$f$originalIfFakeOverride = false;
                        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        boolean $i$f$getOriginalForSubstitutionOverride = false;
                        FirCallableDeclaration<F> firCallableDeclaration4 = firCallableDeclaration3 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                        if (firCallableDeclaration3 == null) {
                            FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                            boolean $i$f$getBaseForIntersectionOverride = false;
                            firCallableDeclaration2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                        } else {
                            firCallableDeclaration2 = firCallableDeclaration = firCallableDeclaration3;
                        }
                        if (firCallableDeclaration == null) break;
                        current$iv$iv = next$iv$iv = firCallableDeclaration;
                    }
                    FirCallableSymbol<F> firCallableSymbol = current$iv$iv.getSymbol();
                    if (firCallableSymbol == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
                    }
                    FirCallableSymbol firCallableSymbol2 = (FirNamedFunctionSymbol)firCallableSymbol;
                    IrFunctionSymbol overridden2 = fir2IrDeclarationStorage.getIrFunctionSymbol((FirFunctionSymbol)firCallableSymbol2);
                    Collection collection = this.$overriddenSet$inlined;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)overridden2;
                    boolean bl2 = false;
                    collection.add(irSimpleFunctionSymbol);
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        return CollectionsKt.toList((Iterable)overriddenSet);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IrSimpleFunctionSymbol> generateOverriddenAccessorSymbols(@NotNull FirProperty $this$generateOverriddenAccessorSymbols, @NotNull FirClass<?> containingClass, boolean isGetter, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        void $this$processDirectlyOverriddenProperties$iv;
        Intrinsics.checkNotNullParameter((Object)$this$generateOverriddenAccessorSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter(containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)declarationStorage, (String)"declarationStorage");
        FirTypeScope scope2 = KotlinScopeProviderKt.unsubstitutedScope(containingClass, session2, scopeSession, true);
        scope2.processPropertiesByName($this$generateOverriddenAccessorSymbols.getName(), generateOverriddenAccessorSymbols.1.INSTANCE);
        boolean bl = false;
        Set overriddenSet = new LinkedHashSet();
        FirTypeScope firTypeScope = scope2;
        FirPropertySymbol propertySymbol$iv = $this$generateOverriddenAccessorSymbols.getSymbol();
        boolean $i$f$processDirectlyOverriddenProperties = false;
        $this$processDirectlyOverriddenProperties$iv.processDirectOverriddenPropertiesWithBaseScope(propertySymbol$iv, (Function2<? super FirPropertySymbol, ? super FirTypeScope, ? extends ProcessorAction>)((Function2)new Function2<FirPropertySymbol, FirTypeScope, ProcessorAction>(declarationStorage, isGetter, overriddenSet, containingClass){
            final /* synthetic */ Fir2IrDeclarationStorage $declarationStorage$inlined;
            final /* synthetic */ boolean $isGetter$inlined;
            final /* synthetic */ Set $overriddenSet$inlined;
            final /* synthetic */ FirClass $containingClass$inlined;
            {
                this.$declarationStorage$inlined = fir2IrDeclarationStorage;
                this.$isGetter$inlined = bl;
                this.$overriddenSet$inlined = set;
                this.$containingClass$inlined = firClass;
                super(2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final ProcessorAction invoke(@NotNull FirPropertySymbol overridden, @NotNull FirTypeScope $noName_1) {
                IrSimpleFunctionSymbol overriddenAccessor;
                Object object;
                FirCallableSymbol<F> firCallableSymbol;
                void $this$unwrapFakeOverrides$iv;
                FirProperty $i$f$getVisibility2;
                FirProperty firProperty;
                ProcessorAction processorAction;
                FirPropertySymbol it;
                block14: {
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                        it = overridden;
                        boolean bl = false;
                        if (it instanceof FirAccessorSymbol) break block13;
                        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)it.getFir();
                        boolean $i$f$getVisibility2 = false;
                        if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) break block14;
                    }
                    processorAction = ProcessorAction.NEXT;
                    return processorAction;
                }
                DelegatedWrapperData<FirCallableDeclaration> delegatedWrapperData = FirDelegatedMemberScopeKt.getDelegatedWrapperData((FirCallableDeclaration)it.getFir());
                if (delegatedWrapperData == null) {
                    firProperty = null;
                } else {
                    DelegatedWrapperData<FirCallableDeclaration> delegatedWrapperData2 = delegatedWrapperData;
                    boolean bl = false;
                    boolean bl2 = false;
                    DelegatedWrapperData<FirCallableDeclaration> it2 = delegatedWrapperData2;
                    boolean bl3 = false;
                    DelegatedWrapperData<FirCallableDeclaration> delegatedWrapperData3 = Intrinsics.areEqual((Object)it2.getContainingClass(), (Object)this.$containingClass$inlined.getSymbol().toLookupTag()) ? delegatedWrapperData2 : null;
                    firProperty = $i$f$getVisibility2 = delegatedWrapperData3 == null ? null : (FirProperty)delegatedWrapperData3.getWrapped();
                }
                FirPropertySymbol unwrapped2 = $i$f$getVisibility2 == null ? it : ((delegatedWrapperData = $i$f$getVisibility2.getSymbol()) == null ? it : delegatedWrapperData);
                delegatedWrapperData = unwrapped2;
                Fir2IrDeclarationStorage fir2IrDeclarationStorage = this.$declarationStorage$inlined;
                boolean $i$f$unwrapFakeOverrides = false;
                FirCallableDeclaration $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
                boolean $i$f$unwrapFakeOverrides2 = false;
                FirCallableDeclaration current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
                while (true) {
                    FirCallableDeclaration<F> next$iv$iv;
                    FirCallableDeclaration<F> firCallableDeclaration;
                    FirCallableDeclaration<F> firCallableDeclaration2;
                    FirCallableDeclaration<F> firCallableDeclaration3;
                    FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
                    boolean $i$f$originalIfFakeOverride = false;
                    FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getOriginalForSubstitutionOverride = false;
                    FirCallableDeclaration<F> firCallableDeclaration4 = firCallableDeclaration3 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                    if (firCallableDeclaration3 == null) {
                        FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        boolean $i$f$getBaseForIntersectionOverride = false;
                        firCallableDeclaration2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                    } else {
                        firCallableDeclaration2 = firCallableDeclaration = firCallableDeclaration3;
                    }
                    if (firCallableDeclaration == null) {
                        firCallableSymbol = current$iv$iv.getSymbol();
                        if (firCallableSymbol == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                        }
                        break;
                    }
                    current$iv$iv = next$iv$iv = firCallableDeclaration;
                }
                FirCallableSymbol firCallableSymbol2 = (FirPropertySymbol)firCallableSymbol;
                IrPropertySymbol overriddenProperty = (IrPropertySymbol)fir2IrDeclarationStorage.getIrPropertySymbol((FirPropertySymbol)firCallableSymbol2);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.$isGetter$inlined ? ((object = ((IrProperty)overriddenProperty.getOwner()).getGetter()) == null ? null : ((IrSimpleFunction)object).getSymbol()) : (overriddenAccessor = (object = ((IrProperty)overriddenProperty.getOwner()).getSetter()) == null ? null : ((IrSimpleFunction)object).getSymbol());
                if (overriddenAccessor != null) {
                    object = this.$overriddenSet$inlined;
                    boolean bl = false;
                    object.add(overriddenAccessor);
                }
                processorAction = ProcessorAction.NEXT;
                return processorAction;
            }
        }));
        return CollectionsKt.toList((Iterable)overriddenSet);
    }

    @Nullable
    public static final IrStatementOrigin statementOrigin(@NotNull FirReference $this$statementOrigin) {
        IrStatementOrigin irStatementOrigin;
        Intrinsics.checkNotNullParameter((Object)$this$statementOrigin, (String)"<this>");
        FirReference firReference = $this$statementOrigin;
        if (firReference instanceof FirPropertyFromParameterResolvedNamedReference) {
            irStatementOrigin = IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE;
        } else if (firReference instanceof FirResolvedNamedReference) {
            FirSourceElement firSourceElement;
            AbstractFirBasedSymbol<?> symbol2 = ((FirResolvedNamedReference)$this$statementOrigin).getResolvedSymbol();
            IrStatementOriginImpl irStatementOriginImpl = (symbol2 instanceof AccessorSymbol ? true : symbol2 instanceof SyntheticPropertySymbol) ? (IrStatementOriginImpl)IrStatementOrigin.GET_PROPERTY.INSTANCE : (symbol2 instanceof FirNamedFunctionSymbol ? (ResolveUtilsKt.isInvoke(((FirNamedFunctionSymbol)symbol2).getCallableId()) ? (IrStatementOriginImpl)IrStatementOrigin.INVOKE.INSTANCE : (Intrinsics.areEqual((Object)((firSourceElement = $this$statementOrigin.getSource()) == null ? null : firSourceElement.getElementType()), (Object)KtNodeTypes.FOR) && ResolveUtilsKt.isIteratorNext(((FirNamedFunctionSymbol)symbol2).getCallableId()) ? (IrStatementOriginImpl)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE : (Intrinsics.areEqual((Object)((firSourceElement = $this$statementOrigin.getSource()) == null ? null : firSourceElement.getElementType()), (Object)KtNodeTypes.FOR) && ResolveUtilsKt.isIteratorHasNext(((FirNamedFunctionSymbol)symbol2).getCallableId()) ? (IrStatementOriginImpl)IrStatementOrigin.FOR_LOOP_HAS_NEXT.INSTANCE : (Intrinsics.areEqual((Object)((firSourceElement = $this$statementOrigin.getSource()) == null ? null : firSourceElement.getElementType()), (Object)KtNodeTypes.FOR) && ResolveUtilsKt.isIterator(((FirNamedFunctionSymbol)symbol2).getCallableId()) ? (IrStatementOriginImpl)IrStatementOrigin.FOR_LOOP_ITERATOR.INSTANCE : (Intrinsics.areEqual((Object)((firSourceElement = $this$statementOrigin.getSource()) == null ? null : firSourceElement.getElementType()), (Object)KtNodeTypes.OPERATION_REFERENCE) ? nameToOperationConventionOrigin.get(((FirNamedFunctionSymbol)symbol2).getCallableId().getCallableName()) : null))))) : null);
            irStatementOrigin = irStatementOriginImpl;
        } else {
            irStatementOrigin = null;
        }
        return irStatementOrigin;
    }

    @NotNull
    public static final IrValueParameter declareThisReceiverParameter(@NotNull IrDeclarationParent $this$declareThisReceiverParameter, @NotNull SymbolTable symbolTable, @NotNull IrType thisType, @NotNull IrDeclarationOrigin thisOrigin, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$declareThisReceiverParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)thisType, (String)"thisType");
        Intrinsics.checkNotNullParameter((Object)thisOrigin, (String)"thisOrigin");
        IrFactory irFactory = symbolTable.getIrFactory();
        IrValueParameterSymbol irValueParameterSymbol = new IrValueParameterSymbolImpl(null, 1, null);
        Object object = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"special(\"<this>\")");
        object = irFactory.createValueParameter(startOffset, endOffset, thisOrigin, irValueParameterSymbol, (Name)object, -1, thisType, null, false, false, false, false);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$declareThisReceiverParameter_u24lambda_u2d6 = object;
        boolean bl3 = false;
        $this$declareThisReceiverParameter_u24lambda_u2d6.setParent($this$declareThisReceiverParameter);
        return object;
    }

    public static /* synthetic */ IrValueParameter declareThisReceiverParameter$default(IrDeclarationParent irDeclarationParent, SymbolTable symbolTable, IrType irType, IrDeclarationOrigin irDeclarationOrigin, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = irDeclarationParent.getStartOffset();
        }
        if ((n3 & 0x10) != 0) {
            n2 = irDeclarationParent.getEndOffset();
        }
        return ConversionUtilsKt.declareThisReceiverParameter(irDeclarationParent, symbolTable, irType, irDeclarationOrigin, n, n2);
    }

    @NotNull
    public static final IrDeclarationOrigin irOrigin(@NotNull FirClass<?> $this$irOrigin, @NotNull FirProvider firProvider) {
        Intrinsics.checkNotNullParameter($this$irOrigin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firProvider, (String)"firProvider");
        return firProvider.getFirClassifierContainerFileIfAny((FirClassLikeSymbol)$this$irOrigin.getSymbol()) != null ? (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE : (Intrinsics.areEqual((Object)$this$irOrigin.getOrigin(), (Object)FirDeclarationOrigin.Java.INSTANCE) ? (IrDeclarationOrigin)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE : (IrDeclarationOrigin)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE);
    }

    public static final boolean isSamType(@NotNull IrType $this$isSamType) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isSamType, (String)"<this>");
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isSamType);
            if (irClassSymbol == null) {
                return false;
            }
            IrClassSymbol irClass2 = irClassSymbol;
            if (((IrClass)irClass2.getOwner()).getKind() != ClassKind.INTERFACE) {
                return false;
            }
            Sequence<IrSimpleFunctionSymbol> $this$singleOrNull$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl = false;
                if (!(((IrSimpleFunction)it.getOwner()).getModality() == Modality.ABSTRACT)) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrSimpleFunctionSymbol am = v0;
        return am != null;
    }

    @NotNull
    public static final IrExpression createSafeCallConstruction(@NotNull Fir2IrComponents $this$createSafeCallConstruction, @NotNull IrVariable receiverVariable, @NotNull IrValueSymbol receiverVariableSymbol, @NotNull IrExpression expressionOnNotNull) {
        Intrinsics.checkNotNullParameter((Object)$this$createSafeCallConstruction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiverVariable, (String)"receiverVariable");
        Intrinsics.checkNotNullParameter((Object)receiverVariableSymbol, (String)"receiverVariableSymbol");
        Intrinsics.checkNotNullParameter((Object)expressionOnNotNull, (String)"expressionOnNotNull");
        int startOffset = expressionOnNotNull.getStartOffset();
        int endOffset = expressionOnNotNull.getEndOffset();
        IrType resultType = IrTypesKt.makeNullable(expressionOnNotNull.getType());
        IrBlockImpl irBlockImpl = new IrBlockImpl(startOffset, endOffset, resultType, IrStatementOrigin.SAFE_CALL.INSTANCE);
        boolean bl = false;
        boolean bl2 = false;
        IrBlockImpl $this$createSafeCallConstruction_u24lambda_u2d10 = irBlockImpl;
        boolean bl3 = false;
        IrBlockImpl irBlockImpl2 = $this$createSafeCallConstruction_u24lambda_u2d10;
        Collection collection = irBlockImpl2.getStatements();
        boolean bl4 = false;
        collection.add(receiverVariable);
        irBlockImpl2 = $this$createSafeCallConstruction_u24lambda_u2d10;
        collection = irBlockImpl2.getStatements();
        IrWhenImpl irWhenImpl = new IrWhenImpl(startOffset, endOffset, resultType, null, 8, null);
        boolean bl5 = false;
        boolean bl6 = false;
        IrWhenImpl $this$createSafeCallConstruction_u24lambda_u2d10_u24lambda_u2d9 = irWhenImpl;
        boolean bl7 = false;
        Object object = $this$createSafeCallConstruction.getIrBuiltIns().getBooleanType();
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = $this$createSafeCallConstruction.getIrBuiltIns().getEqeqSymbol();
        IrStatementOrigin.EQEQ eQEQ = IrStatementOrigin.EQEQ.INSTANCE;
        object = new IrCallImpl(startOffset, endOffset, (IrType)object, irSimpleFunctionSymbol, 0, 2, eQEQ, null, 128, null);
        boolean bl8 = false;
        boolean bl9 = false;
        Object $this$createSafeCallConstruction_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8 = object;
        boolean bl10 = false;
        ((IrFunctionAccessExpression)$this$createSafeCallConstruction_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8).putValueArgument(0, new IrGetValueImpl(startOffset, endOffset, receiverVariableSymbol, null, 8, null));
        ((IrFunctionAccessExpression)$this$createSafeCallConstruction_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8).putValueArgument(1, IrConstImpl.Companion.constNull(startOffset, endOffset, $this$createSafeCallConstruction.getIrBuiltIns().getNothingNType()));
        Object condition = object;
        object = $this$createSafeCallConstruction_u24lambda_u2d10_u24lambda_u2d9;
        Collection collection2 = ((IrWhenImpl)object).getBranches();
        IrBranch irBranch = new IrBranchImpl((IrExpression)condition, IrConstImpl.Companion.constNull(startOffset, endOffset, $this$createSafeCallConstruction.getIrBuiltIns().getNothingNType()));
        boolean bl11 = false;
        collection2.add(irBranch);
        object = $this$createSafeCallConstruction_u24lambda_u2d10_u24lambda_u2d9;
        collection2 = ((IrWhenImpl)object).getBranches();
        irBranch = new IrElseBranchImpl(IrConstImpl.Companion.boolean(startOffset, endOffset, $this$createSafeCallConstruction.getIrBuiltIns().getBooleanType(), true), expressionOnNotNull);
        bl11 = false;
        collection2.add(irBranch);
        bl5 = false;
        collection.add(irWhenImpl);
        return irBlockImpl;
    }

    @NotNull
    public static final Pair<IrVariable, IrValueSymbol> createTemporaryVariable(@NotNull Fir2IrComponents $this$createTemporaryVariable, @NotNull IrExpression receiverExpression, @NotNull Fir2IrConversionScope conversionScope, @Nullable String nameHint) {
        Intrinsics.checkNotNullParameter((Object)$this$createTemporaryVariable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiverExpression, (String)"receiverExpression");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        IrVariable irVariable2 = $this$createTemporaryVariable.getDeclarationStorage().declareTemporaryVariable(receiverExpression, nameHint);
        boolean bl = false;
        boolean bl2 = false;
        IrVariable $this$createTemporaryVariable_u24lambda_u2d11 = irVariable2;
        boolean bl3 = false;
        $this$createTemporaryVariable_u24lambda_u2d11.setParent(conversionScope.parentFromStack());
        IrVariable receiverVariable = irVariable2;
        IrVariableSymbol variableSymbol = receiverVariable.getSymbol();
        return new Pair((Object)receiverVariable, (Object)variableSymbol);
    }

    public static /* synthetic */ Pair createTemporaryVariable$default(Fir2IrComponents fir2IrComponents, IrExpression irExpression, Fir2IrConversionScope fir2IrConversionScope, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return ConversionUtilsKt.createTemporaryVariable(fir2IrComponents, irExpression, fir2IrConversionScope, string2);
    }

    @NotNull
    public static final Pair<IrVariable, IrValueSymbol> createTemporaryVariableForSafeCallConstruction(@NotNull Fir2IrComponents $this$createTemporaryVariableForSafeCallConstruction, @NotNull IrExpression receiverExpression, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)$this$createTemporaryVariableForSafeCallConstruction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiverExpression, (String)"receiverExpression");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        return ConversionUtilsKt.createTemporaryVariable($this$createTemporaryVariableForSafeCallConstruction, receiverExpression, conversionScope, "safe_receiver");
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OperatorNameConventions.PLUS, (Object)IrStatementOrigin.PLUS.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.MINUS, (Object)IrStatementOrigin.MINUS.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.TIMES, (Object)IrStatementOrigin.MUL.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.DIV, (Object)IrStatementOrigin.DIV.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.MOD, (Object)IrStatementOrigin.PERC.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.REM, (Object)IrStatementOrigin.PERC.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.RANGE_TO, (Object)IrStatementOrigin.RANGE.INSTANCE)};
        nameToOperationConventionOrigin = MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

