/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.SourceElementPositioningStrategies;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u0016*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003:\u0001\u0016B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "lightTreeStrategy", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "psiStrategy", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "(Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;)V", "getLightTreeStrategy", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "getPsiStrategy", "()Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "isValid", "", "element", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "markDiagnostic", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "diagnostic", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "Companion", "checkers"})
public class SourceElementPositioningStrategy<E extends PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LightTreePositioningStrategy lightTreeStrategy;
    @NotNull
    private final PositioningStrategy<E> psiStrategy;
    @NotNull
    private static final SourceElementPositioningStrategy<PsiElement> DEFAULT = SourceElementPositioningStrategies.INSTANCE.getDEFAULT();

    public SourceElementPositioningStrategy(@NotNull LightTreePositioningStrategy lightTreeStrategy, @NotNull PositioningStrategy<? super E> psiStrategy) {
        Intrinsics.checkNotNullParameter((Object)lightTreeStrategy, (String)"lightTreeStrategy");
        Intrinsics.checkNotNullParameter(psiStrategy, (String)"psiStrategy");
        this.lightTreeStrategy = lightTreeStrategy;
        this.psiStrategy = psiStrategy;
    }

    @NotNull
    public final LightTreePositioningStrategy getLightTreeStrategy() {
        return this.lightTreeStrategy;
    }

    @NotNull
    public final PositioningStrategy<E> getPsiStrategy() {
        return this.psiStrategy;
    }

    @NotNull
    public final List<TextRange> markDiagnostic(@NotNull FirDiagnostic<?> diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        Object element = diagnostic.getElement();
        if (element instanceof FirPsiSourceElement) {
            return this.psiStrategy.mark(((FirPsiSourceElement)element).getPsi());
        }
        return this.lightTreeStrategy.mark(((FirSourceElement)element).getLighterASTNode(), ((FirSourceElement)element).getStartOffset(), ((FirSourceElement)element).getEndOffset(), ((FirSourceElement)element).getTreeStructure());
    }

    public final boolean isValid(@NotNull FirSourceElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof FirPsiSourceElement) {
            return this.psiStrategy.isValid(((FirPsiSourceElement)element).getPsi());
        }
        return this.lightTreeStrategy.isValid(element.getLighterASTNode(), element.getTreeStructure());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getDEFAULT", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SourceElementPositioningStrategy<PsiElement> getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

