/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusOwner;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageHandler;
import org.jetbrains.kotlin.com.intellij.util.messages.SimpleMessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.CompositeMessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.JobQueue;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusConnectionImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageDeliveryListener;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;

@ApiStatus.Internal
public class MessageBusImpl
implements MessageBus {
    protected static final Logger LOG = Logger.getInstance(MessageBusImpl.class);
    private static final Object NA = new Object();
    protected final ThreadLocal<JobQueue> myMessageQueue;
    protected final int[] myOrder;
    protected final ConcurrentMap<Topic<?>, Object> publisherCache;
    protected final Collection<MessageHandlerHolder> mySubscribers;
    protected final Map<Topic<?>, List<Object>> subscriberCache;
    @Nullable
    protected final CompositeMessageBus myParentBus;
    protected final RootBus myRootBus;
    protected final MessageBusOwner owner;
    private int disposeState;
    private Disposable myConnectionDisposable;
    protected MessageDeliveryListener messageDeliveryListener;

    MessageBusImpl(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        this.myMessageQueue = ThreadLocal.withInitial(JobQueue::new);
        this.publisherCache = new ConcurrentHashMap();
        this.mySubscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
        this.subscriberCache = new ConcurrentHashMap();
        this.myConnectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.myOrder = ArrayUtil.EMPTY_INT_ARRAY;
        this.myRootBus = (RootBus)this;
        this.myParentBus = null;
    }

    public final String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ")";
    }

    @Override
    @NotNull
    public final MessageBusConnection connect() {
        return this.connect(this.myConnectionDisposable);
    }

    @Override
    @NotNull
    public final MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.mySubscribers.add(connection);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.mySubscribers.add(connection);
        SimpleMessageBusConnectionImpl simpleMessageBusConnectionImpl = connection;
        if (simpleMessageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        return simpleMessageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        this.checkNotDisposed();
        Object object = this.publisherCache.computeIfAbsent(topic, this::createPublisherInvocationHandler);
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        return (L)object;
    }

    @NotNull
    private Object createPublisherInvocationHandler(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        Class<?> listenerClass = topic.getListenerClass();
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)this.createPublisher(topic, topic.getBroadcastDirection()));
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    protected MessagePublisher createPublisher(@NotNull Topic<?> topic, Topic.BroadcastDirection direction) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new ToParentMessagePublisher(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
        }
        LOG.warn("Broadcast direction TO_CHILDREN  is not allowed for module level message bus. Please change to NONE or TO_PARENT");
        return new MessagePublisher(topic, this);
    }

    protected static List<Throwable> executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, Object[] args, @NotNull List<Object> handlers2, @Nullable JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        if (method == null) {
            MessageBusImpl.$$$reportNull$$$0(12);
        }
        if (handlers2 == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        if (jobQueue == null) {
            for (Object handler2 : handlers2) {
                exceptions = MessageBusImpl.invokeListener(method, args, handler2, topic, messageDeliveryListener, exceptions);
            }
        } else {
            jobQueue.queue.offerLast(new Message(topic, method, args, handlers2));
        }
        return exceptions;
    }

    @Override
    public void dispose() {
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        this.disposeState = 2;
        this.disposeChildren();
        if (this.myConnectionDisposable != null) {
            Disposer.dispose(this.myConnectionDisposable);
        }
        JobQueue jobs = this.myMessageQueue.get();
        this.myMessageQueue.remove();
        if (!jobs.queue.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        if (this.myParentBus == null) {
            this.myRootBus.myWaitingBuses.remove();
        } else {
            this.myParentBus.onChildBusDisposed(this);
        }
    }

    protected void disposeChildren() {
    }

    public final boolean isDisposed() {
        return this.disposeState == 2 || this.owner.isDisposed();
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    protected void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result2, boolean subscribeLazyListeners) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        for (MessageHandlerHolder subscriber : this.mySubscribers) {
            subscriber.collectHandlers(topic, result2);
        }
    }

    @NotNull
    protected List<Object> computeSubscribers(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        this.doComputeSubscribers(topic, result2, true);
        List<Object> list2 = result2.isEmpty() ? Collections.emptyList() : result2;
        if (list2 == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        return list2;
    }

    private void jobRemoved(@NotNull JobQueue jobQueue) {
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        if (jobQueue.current == null && jobQueue.queue.isEmpty()) {
            this.myRootBus.myWaitingBuses.get().remove(this);
        }
    }

    private static void pumpMessages(@NotNull Set<MessageBusImpl> waitingBuses) {
        if (waitingBuses == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(waitingBuses.size());
        for (MessageBusImpl bus : waitingBuses) {
            if (bus.isDisposed()) {
                waitingBuses.remove(bus);
                LOG.error("Accessing disposed message bus " + bus);
                continue;
            }
            liveBuses.add(bus);
        }
        if (!liveBuses.isEmpty()) {
            MessageBusImpl.pumpWaitingBuses(liveBuses);
        }
    }

    private static void pumpWaitingBuses(@NotNull List<MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl bus : buses) {
            if (bus.isDisposed()) continue;
            JobQueue jobQueue = bus.myMessageQueue.get();
            Message job = jobQueue.current;
            if (job != null) {
                exceptions = bus.deliverMessage(job, jobQueue, bus.messageDeliveryListener, exceptions);
            }
            while ((job = jobQueue.queue.pollFirst()) != null) {
                exceptions = bus.deliverMessage(job, jobQueue, bus.messageDeliveryListener, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    private List<Throwable> deliverMessage(@NotNull Message job, @NotNull JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (job == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        jobQueue.current = job;
        List<Object> handlers2 = job.handlers;
        int index2 = job.currentHandlerIndex;
        int size = handlers2.size();
        int lastIndex = size - 1;
        while (index2 < size) {
            if (index2 == lastIndex) {
                jobQueue.current = null;
                this.jobRemoved(jobQueue);
            }
            ++job.currentHandlerIndex;
            exceptions = MessageBusImpl.invokeListener(job.listenerMethod, job.args, handlers2.get(index2), job.topic, messageDeliveryListener, exceptions);
            if (++index2 == job.currentHandlerIndex) continue;
            return exceptions;
        }
        return exceptions;
    }

    protected boolean hasChildren() {
        return false;
    }

    final void notifyOnSubscription(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while ((parentBus = parentBus.myParentBus) != null) {
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren()) {
            this.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    protected void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
    }

    protected void removeEmptyConnectionsRecursively() {
        this.mySubscribers.removeIf(MessageHandlerHolder::isDisposed);
    }

    boolean notifyConnectionTerminated(Object[] topicAndHandlerPairs) {
        if (this.disposeState != 0) {
            return false;
        }
        this.myRootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImpl.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    private static boolean clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, @NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        boolean isChildClearingNeeded = false;
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Topic.BroadcastDirection direction;
            Topic topic = (Topic)topicAndHandlerPairs[i];
            if (bus.subscriberCache.remove(topic) != null) {
                bus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if ((direction = topic.getBroadcastDirection()) != Topic.BroadcastDirection.TO_CHILDREN) continue;
            MessageBusImpl parentBus = bus;
            while ((parentBus = parentBus.myParentBus) != null) {
                if (parentBus.subscriberCache.remove(topic) == null) continue;
                parentBus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if (!bus.hasChildren()) continue;
            isChildClearingNeeded = true;
        }
        return isChildClearingNeeded;
    }

    protected void clearSubscriberCache(Object[] topicAndHandlerPairs) {
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            this.subscriberCache.remove(topicAndHandlerPairs[i]);
        }
    }

    final void deliverImmediately(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        if (this.owner.isDisposed()) {
            return;
        }
        JobQueue jobQueue = this.myMessageQueue.get();
        Deque<Message> jobs = jobQueue.queue;
        if (jobs.isEmpty()) {
            return;
        }
        SmartList<Message> newJobs = null;
        Iterator<Message> jobIterator = jobs.iterator();
        while (jobIterator.hasNext()) {
            Message filteredJob;
            Message job = jobIterator.next();
            SmartList<Object> connectionHandlers = null;
            Iterator<Object> handlerIterator = job.handlers.iterator();
            while (handlerIterator.hasNext()) {
                Object handler2 = handlerIterator.next();
                if (!connection.isMyHandler(job.topic, handler2)) continue;
                handlerIterator.remove();
                if (connectionHandlers == null) {
                    connectionHandlers = new SmartList<Object>();
                }
                connectionHandlers.add(handler2);
            }
            if (connectionHandlers == null) continue;
            if (job.handlers.isEmpty()) {
                jobIterator.remove();
                filteredJob = job;
                job.handlers.addAll(connectionHandlers);
            } else {
                filteredJob = new Message(job.topic, job.listenerMethod, job.args, (List<Object>)connectionHandlers);
            }
            if (newJobs == null) {
                newJobs = new SmartList<Message>();
            }
            newJobs.add(filteredJob);
        }
        if (newJobs == null) {
            return;
        }
        for (int i = newJobs.size() - 1; i >= 0; --i) {
            jobs.addFirst((Message)newJobs.get(i));
        }
        List<Throwable> exceptions = null;
        for (Message job : newJobs) {
            jobs.removeFirstOccurrence(job);
            exceptions = this.deliverMessage(job, jobQueue, this.messageDeliveryListener, exceptions);
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    private static List<Throwable> invokeListener(@NotNull Method method, Object[] args, @NotNull Object handler2, @NotNull Topic<?> topic, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (method == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        try {
            if (handler2 instanceof MessageHandler) {
                ((MessageHandler)handler2).handle(method, args);
            } else if (messageDeliveryListener == null) {
                method.invoke(handler2, args);
            } else {
                long startTime = System.nanoTime();
                method.invoke(handler2, args);
                messageDeliveryListener.messageDelivered(topic, method.getName(), handler2, System.nanoTime() - startTime);
            }
        }
        catch (Throwable e) {
            exceptions = EventDispatcher.handleException(e, exceptions);
        }
        return exceptions;
    }

    private void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler2) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(35);
        }
        JobQueue jobQueue = this.myMessageQueue.get();
        if (!jobQueue.queue.isEmpty() && jobQueue.queue.removeIf(job -> job.topic == topic && job.handlers.removeIf(it -> it == handler2) && job.handlers.isEmpty())) {
            this.jobRemoved(jobQueue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobQueue";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitingBuses";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleConnect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPublisherInvocationHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSubscribers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPublisherInvocationHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPublisher";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeOrAddToQueue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doComputeSubscribers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeSubscribers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "jobRemoved";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "pumpMessages";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deliverMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscriptionToTopicToChildren";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeChildConnectionsRecursively";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCache";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCacheOnConnectionTerminated";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deliverImmediately";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "invokeListener";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "disconnectPluginConnections";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeDisposedHandlers";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RootBus
    extends CompositeMessageBus {
        private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
        private final AtomicInteger emptyConnectionCounter;
        final ThreadLocal<SortedSet<MessageBusImpl>> myWaitingBuses;

        RootBus(@NotNull MessageBusOwner owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.compactionFutureRef = new AtomicReference();
            this.emptyConnectionCounter = new AtomicInteger();
            this.myWaitingBuses = ThreadLocal.withInitial(() -> new TreeSet((bus1, bus2) -> ArrayUtil.lexicographicCompare(bus1.myOrder, bus2.myOrder)));
        }

        void scheduleEmptyConnectionRemoving() {
            CompletableFuture<Void> future;
            int counter = this.emptyConnectionCounter.incrementAndGet();
            if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
                return;
            }
            CompletableFuture<?> oldFuture = this.compactionFutureRef.get();
            if (oldFuture == null && !this.compactionFutureRef.compareAndSet(null, future = CompletableFuture.runAsync(() -> {
                this.removeEmptyConnectionsRecursively();
                this.compactionFutureRef.set(null);
            }, AppExecutorUtil.getAppExecutorService()))) {
                future.cancel(false);
            }
        }

        @Override
        public void dispose() {
            CompletableFuture compactionFuture = this.compactionFutureRef.getAndSet(null);
            if (compactionFuture != null) {
                compactionFuture.cancel(false);
            }
            super.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    protected static final class ToParentMessagePublisher
    extends MessagePublisher
    implements InvocationHandler {
        ToParentMessagePublisher(@NotNull Topic<?> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(1);
            }
            super(topic, bus);
        }

        @Override
        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            if (method == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(2);
            }
            List<Throwable> exceptions = null;
            MessageBusImpl parentBus = this.bus;
            boolean hasHandlers = false;
            do {
                List handlers2;
                if ((handlers2 = parentBus.subscriberCache.computeIfAbsent(this.topic, parentBus::computeSubscribers)).isEmpty()) continue;
                hasHandlers = true;
                exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers2, jobQueue, this.bus.messageDeliveryListener, exceptions);
            } while ((parentBus = parentBus.myParentBus) != null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$ToParentMessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MessagePublisher
    implements InvocationHandler {
        @NotNull
        protected final Topic<?> topic;
        @NotNull
        protected final MessageBusImpl bus;

        MessagePublisher(@NotNull Topic<?> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                MessagePublisher.$$$reportNull$$$0(1);
            }
            this.topic = topic;
            this.bus = bus;
        }

        @Override
        public final Object invoke(Object proxy2, Method method, Object[] args) {
            JobQueue jobQueue;
            Set busQueue;
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy2, args, method.getName());
            }
            this.bus.checkNotDisposed();
            boolean isImmediateDelivery = this.topic.isImmediateDelivery();
            if (isImmediateDelivery) {
                busQueue = null;
                jobQueue = null;
            } else {
                busQueue = this.bus.myRootBus.myWaitingBuses.get();
                jobQueue = this.bus.myMessageQueue.get();
                MessageBusImpl.pumpMessages(busQueue);
            }
            if (this.publish(method, args, jobQueue) && !isImmediateDelivery) {
                busQueue.add(this.bus);
                MessageBusImpl.pumpMessages(busQueue);
            }
            return NA;
        }

        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(2);
            }
            List handlers2 = this.bus.subscriberCache.computeIfAbsent(this.topic, this.bus::computeSubscribers);
            if (handlers2.isEmpty()) {
                return false;
            }
            List<Throwable> exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers2, jobQueue, this.bus.messageDeliveryListener, null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$MessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface MessageHandlerHolder {
        public void collectHandlers(@NotNull Topic<?> var1, @NotNull List<Object> var2);

        public boolean isDisposed();
    }
}

