/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics.factories;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u001eB\u0017\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJD\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00020\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory;", "name", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)V", "withExplicitDefinitionOnly", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Z)V", "getName", "()Ljava/lang/String;", "privateName", "getWithExplicitDefinitionOnly", "()Z", "createDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/ParametrizedDiagnostic;", "kotlin.jvm.PlatformType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "Companion", "frontend"})
public final class DebugInfoDiagnosticFactory1
extends DiagnosticFactory1<PsiElement, String>
implements DebugInfoDiagnosticFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String privateName;
    private final boolean withExplicitDefinitionOnly;
    @NotNull
    private static final DebugInfoDiagnosticFactory1 EXPRESSION_TYPE = Companion.create("EXPRESSION_TYPE", Severity.INFO, true);
    @NotNull
    private static final DebugInfoDiagnosticFactory1 CALL = Companion.create("CALL", Severity.INFO, true);

    @Override
    @NotNull
    public String getName() {
        return Intrinsics.stringPlus((String)"DEBUG_INFO_", (Object)this.privateName);
    }

    @Override
    public boolean getWithExplicitDefinitionOnly() {
        return this.withExplicitDefinitionOnly;
    }

    @Override
    @NotNull
    public ParametrizedDiagnostic<PsiElement> createDiagnostic(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, @Nullable DataFlowValueFactory dataFlowValueFactory, @Nullable LanguageVersionSettings languageVersionSettings, @Nullable ModuleDescriptorImpl moduleDescriptor) {
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        String string2 = this.privateName;
        if (Intrinsics.areEqual((Object)string2, (Object)DebugInfoDiagnosticFactory1.EXPRESSION_TYPE.privateName)) {
            object = CheckerTestUtil.INSTANCE.getTypeInfo(expression2, bindingContext, dataFlowValueFactory, languageVersionSettings, moduleDescriptor);
            KotlinType type2 = (KotlinType)object.component1();
            Set dataFlowTypes = (Set)object.component2();
            parametrizedDiagnostic = this.on((PsiElement)expression2, Renderers.INSTANCE.renderExpressionType(type2, dataFlowTypes));
        } else if (Intrinsics.areEqual((Object)string2, (Object)DebugInfoDiagnosticFactory1.CALL.privateName)) {
            object = CheckerTestUtil.INSTANCE.getCallDebugInfo(expression2, bindingContext);
            FqNameUnsafe fqName2 = (FqNameUnsafe)object.component1();
            String typeCall = (String)object.component2();
            parametrizedDiagnostic = this.on((PsiElement)expression2, Renderers.INSTANCE.renderCallInfo(fqName2, typeCall));
        } else {
            throw new NotImplementedError("Creation diagnostic '" + this.getName() + "' isn't supported.");
        }
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic2 = parametrizedDiagnostic;
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, (String)"when (privateName) {\n        EXPRESSION_TYPE.privateName -> {\n            val (type, dataFlowTypes) = CheckerTestUtil.getTypeInfo(\n                expression,\n                bindingContext,\n                dataFlowValueFactory,\n                languageVersionSettings,\n                moduleDescriptor\n            )\n\n            this.on(expression, Renderers.renderExpressionType(type, dataFlowTypes))\n        }\n        CALL.privateName -> {\n            val (fqName, typeCall) = CheckerTestUtil.getCallDebugInfo(expression, bindingContext)\n            this.on(expression, Renderers.renderCallInfo(fqName, typeCall))\n        }\n        else -> throw NotImplementedError(\"Creation diagnostic '$name' isn't supported.\")\n    }");
        return parametrizedDiagnostic2;
    }

    private DebugInfoDiagnosticFactory1(String name, Severity severity) {
        super(severity, PositioningStrategies.DEFAULT);
        this.privateName = name;
        this.withExplicitDefinitionOnly = false;
    }

    private DebugInfoDiagnosticFactory1(String name, Severity severity, boolean withExplicitDefinitionOnly) {
        super(severity, PositioningStrategies.DEFAULT);
        this.privateName = name;
        this.withExplicitDefinitionOnly = withExplicitDefinitionOnly;
    }

    public /* synthetic */ DebugInfoDiagnosticFactory1(String name, Severity severity, DefaultConstructorMarker $constructor_marker) {
        this(name, severity);
    }

    public /* synthetic */ DebugInfoDiagnosticFactory1(String name, Severity severity, boolean withExplicitDefinitionOnly, DefaultConstructorMarker $constructor_marker) {
        this(name, severity, withExplicitDefinitionOnly);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1$Companion;", "", "()V", "CALL", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "getCALL", "()Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "EXPRESSION_TYPE", "getEXPRESSION_TYPE", "create", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "withExplicitDefinitionOnly", "", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 getEXPRESSION_TYPE() {
            return EXPRESSION_TYPE;
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 getCALL() {
            return CALL;
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 create(@NotNull String name, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return new DebugInfoDiagnosticFactory1(name, severity, null);
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 create(@NotNull String name, @NotNull Severity severity, boolean withExplicitDefinitionOnly) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return new DebugInfoDiagnosticFactory1(name, severity, withExplicitDefinitionOnly, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

