/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmBaseCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000b\u001a\u00020\f*\u00020\rJ\f\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\rJ\n\u0010\u000f\u001a\u00020\f*\u00020\rJ\n\u0010\u0010\u001a\u00020\f*\u00020\rJ\f\u0010\u0011\u001a\u0004\u0018\u00010\f*\u00020\rJ\n\u0010\u0012\u001a\u00020\f*\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmBaseCodegenContext;", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmBaseCodegenContext;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;)V", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmBaseCodegenContext;", "toBoxedInlineClassType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toWasmBlockResultType", "toWasmFieldType", "toWasmGcRefType", "toWasmResultType", "toWasmValueType", "backend.wasm"})
public final class WasmTypeTransformer {
    @NotNull
    private final WasmBaseCodegenContext context;
    @NotNull
    private final IrBuiltIns builtIns;

    public WasmTypeTransformer(@NotNull WasmBaseCodegenContext context2, @NotNull IrBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        this.context = context2;
        this.builtIns = builtIns;
    }

    @NotNull
    public final WasmBaseCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @Nullable
    public final WasmType toWasmResultType(@NotNull IrType $this$toWasmResultType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmResultType, (String)"<this>");
        IrType irType = $this$toWasmResultType;
        return (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getUnitType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType())) ? null : this.toWasmValueType($this$toWasmResultType);
    }

    @Nullable
    public final WasmType toWasmBlockResultType(@NotNull IrType $this$toWasmBlockResultType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmBlockResultType, (String)"<this>");
        IrType irType = $this$toWasmBlockResultType;
        return Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getUnitType()) ? null : (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType()) ? (WasmType)WasmUnreachableType.INSTANCE : this.toWasmValueType($this$toWasmBlockResultType));
    }

    @NotNull
    public final WasmType toWasmGcRefType(@NotNull IrType $this$toWasmGcRefType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmGcRefType, (String)"<this>");
        IrClass irClass2 = TypeTransformerKt.getErasedUpperBound($this$toWasmGcRefType);
        IrClassSymbol irClassSymbol = irClass2 == null ? null : irClass2.getSymbol();
        return new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceGcType(irClassSymbol == null ? this.builtIns.getAnyClass() : irClassSymbol)));
    }

    @NotNull
    public final WasmType toBoxedInlineClassType(@NotNull IrType $this$toBoxedInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$toBoxedInlineClassType, (String)"<this>");
        return this.toWasmGcRefType($this$toBoxedInlineClassType);
    }

    @NotNull
    public final WasmType toWasmFieldType(@NotNull IrType $this$toWasmFieldType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmFieldType, (String)"<this>");
        IrType irType = $this$toWasmFieldType;
        return (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType())) ? (WasmType)WasmI8.INSTANCE : ((Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getCharType())) ? (WasmType)WasmI16.INSTANCE : this.toWasmValueType($this$toWasmFieldType));
    }

    @NotNull
    public final WasmType toWasmValueType(@NotNull IrType $this$toWasmValueType) {
        WasmType wasmType;
        Intrinsics.checkNotNullParameter((Object)$this$toWasmValueType, (String)"<this>");
        IrType irType = $this$toWasmValueType;
        if ((((Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getIntType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getCharType())) {
            wasmType = WasmI32.INSTANCE;
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getLongType())) {
            wasmType = WasmI64.INSTANCE;
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getFloatType())) {
            wasmType = WasmF32.INSTANCE;
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getDoubleType())) {
            wasmType = WasmF64.INSTANCE;
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getStringType())) {
            wasmType = WasmExternRef.INSTANCE;
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingNType())) {
            wasmType = WasmExternRef.INSTANCE;
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType())) {
            wasmType = WasmExternRef.INSTANCE;
        } else {
            IrClass klass = IrTypesKt.getClass($this$toWasmValueType);
            IrClass ic = this.context.getBackendContext().getInlineClassesUtils().getInlinedClass($this$toWasmValueType);
            wasmType = klass != null && AnnotationsKt.hasWasmForeignAnnotation(klass) ? (WasmType)WasmExternRef.INSTANCE : (ic != null ? this.toWasmValueType(InlineClassesKt.getInlineClassUnderlyingType(ic)) : this.toWasmGcRefType($this$toWasmValueType));
        }
        return wasmType;
    }
}

